/*	PXL2APOLLO -- TeX PXL Font to Augmented Apollo Font Converter	     */
/*									     */
/*	Copyright (C) 1987 by Leonard N. Zubkoff, All Rights Reserved	     */
/*									     */
/*	This software is provided free and without any warranty.	     */
/*	Permission to copy for any purpose is hereby granted so		     */
/*	long as this copyright notice remains intact.			     */
/*									     */
/*	Revision:	 1-Jun-88 09:41:37				     */


#define begin	    {
#define end	    }
#define then
#define do
#define hidden	    static
#define visible
#define procedure   void


#include <stdio.h>
#include <strings.h>


#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/ms.ins.c"
#include "/sys/ins/smdu.ins.c"


#define FontBitmapWidth	    224


hidden char
	*PXLFileName,
	*FontFilePointer;


hidden long
	FontFileLength;

struct PXL_Header
    begin
	long PXLID1;
    end;
	

struct PXL_Trailer
    begin
	long CheckSum;
	long Magnification;
	long DesignSize;
	long DirectoryPointer;
	long PXLID2;
    end;


struct PXL_CharacterEntry
    begin
	short PixelWidth;
	short PixelHeight;
	short Xoffset;
	short Yoffset;
	long RasterAddress;
	long TFMwidth;
    end;


struct AAF_Trailer
    begin
	long TFMwidth[128];
	struct PXL_Trailer PXL_TrailerCopy;
    end;


hidden struct PXL_Header
	PXL_FileHeader;


hidden struct PXL_Trailer
	PXL_FileTrailer;


hidden struct PXL_CharacterEntry
	PXL_FontDirectory[128];


hidden gpr_$bitmap_desc_t
	FontBitmap,
	CharacterBitmaps[128];


hidden gpr_$attribute_desc_t
	FontAttributeBlock;

hidden procedure FatalError(Message)
	char *Message;
    begin
	if (*PXLFileName != '\0') then
	    fprintf(stderr,"pxl2apollo: %s - %s\n",PXLFileName,Message);
	else fprintf(stderr,"pxl2apollo: %s\n",Message);
	exit(1);
    end


hidden procedure LoadRasters(PXLStream)
    begin
	int Character;
	for (Character=0; Character<128; Character++) do
	    if (PXL_FontDirectory[Character].RasterAddress != 0) then
		begin
		    gpr_$offset_t CharacterBitmapSize;
		    status_$t Status;
		    static short Buffer[64];
		    short *CharacterBitmapPointer, CharacterLineWidth;
		    int Words, Halfwords, Row, i;
		    fseek(PXLStream,
			  4*PXL_FontDirectory[Character].RasterAddress,0);
		    if (PXL_FontDirectory[Character].PixelWidth == 0
			|| PXL_FontDirectory[Character].PixelHeight == 0) then
			    continue;
		    CharacterBitmapSize.x_size =
			PXL_FontDirectory[Character].PixelWidth;
		    CharacterBitmapSize.y_size =
			PXL_FontDirectory[Character].PixelHeight;
		    gpr_$allocate_bitmap(CharacterBitmapSize,0,
					 FontAttributeBlock,
					 CharacterBitmaps[Character],Status);
		    if (Status.all != status_$ok) then pfm_$error_trap(Status);
		    gpr_$inq_bitmap_pointer(CharacterBitmaps[Character],
					    CharacterBitmapPointer,
					    CharacterLineWidth,Status);
		    if (Status.all != status_$ok) then pfm_$error_trap(Status);
		    Halfwords = 1+((CharacterBitmapSize.x_size-1)>>4);
		    Words = 1+((Halfwords-1)>>1);
		    for (Row=0; Row<CharacterBitmapSize.y_size; Row++) do
			begin
			    register short *Pointer = Buffer;
			    fread(Buffer,4,Words,PXLStream);
			    for (i=0; i<Halfwords; i++) do
				*CharacterBitmapPointer++ = *Pointer++;
			    CharacterBitmapPointer += CharacterLineWidth-Halfwords;
			end;
		end;
    end

hidden procedure CreateFont()
    begin
	smd_$font_table_t *FontTable = (smd_$font_table_t *) FontFilePointer;
	gpr_$window_t SourceWindow;
	gpr_$position_t DestinationOrigin;
	status_$t Status;
	int FontCharacterCount = 0, MaxHeight = 0, MaxWidth = 0;
	int MaxRight = 0, MaxUp = 0, MaxDown = 0, MaxHeightRow = 0;
	int Xposition = 0, Yposition = 0, Character;
	short *FontBitmapPointer, *Pointer, FontLineWidth, Row, i;
	struct AAF_Trailer *TrailerPointer;
	for (Character=0; Character<128; Character++) do
	    if (PXL_FontDirectory[Character].RasterAddress != 0) then
		begin
		    /* The rounding is emperically determined. */
		    int Width = (PXL_FontDirectory[Character].TFMwidth
				 *(PXL_FileTrailer.Magnification/1000.0)
				 *123.0/4736286.72);
		    int PixelWidth = PXL_FontDirectory[Character].PixelWidth;
		    int PixelHeight = PXL_FontDirectory[Character].PixelHeight;
		    int Xoffset = PXL_FontDirectory[Character].Xoffset;
		    int Yoffset = PXL_FontDirectory[Character].Yoffset;
		    int Left = Xoffset;
		    int Right = PixelWidth-Xoffset;
		    int Up = Yoffset;
		    int Down = PixelHeight-Yoffset;
		    FontCharacterCount++;
		    if (Xposition+PixelWidth > FontBitmapWidth) then
			begin
			    Xposition = 0;
			    Yposition += MaxHeightRow;
			    MaxHeightRow = 0;
			end;
		    FontTable->index_table[Character] = FontCharacterCount;
		    FontTable->desc_table[FontCharacterCount-1].left = Left;
		    FontTable->desc_table[FontCharacterCount-1].right = Right;
		    FontTable->desc_table[FontCharacterCount-1].up = Up;
		    FontTable->desc_table[FontCharacterCount-1].down = Down;
		    FontTable->desc_table[FontCharacterCount-1].width = Width;
		    FontTable->desc_table[FontCharacterCount-1].x_pos = Xposition;
		    FontTable->desc_table[FontCharacterCount-1].y_pos = Yposition;
		    if (Right > MaxRight) then MaxRight = Right;
		    if (Up > MaxUp) then MaxUp = Up;
		    if (Down > MaxDown) then MaxDown = Down;
		    if (PixelHeight > MaxHeight) then MaxHeight = PixelHeight;
		    if (Width > MaxWidth) then MaxWidth = Width;
		    if (PixelHeight > MaxHeightRow) then MaxHeightRow = PixelHeight;
		    if (PixelWidth == 0 || PixelHeight == 0) then continue;
		    SourceWindow.window_base.x_coord = 0;
		    SourceWindow.window_base.y_coord = 0;
		    SourceWindow.window_size.x_size = PixelWidth;
		    SourceWindow.window_size.y_size = PixelHeight;
		    DestinationOrigin.x_coord = Xposition;
		    DestinationOrigin.y_coord = Yposition;
		    gpr_$pixel_blt(CharacterBitmaps[Character],SourceWindow,
				   DestinationOrigin,Status);
		    if (Status.all != status_$ok) then pfm_$error_trap(Status);
		    Xposition += PixelWidth;
		end

	    else FontTable->index_table[Character] = 0;
	FontTable->version = 1;
	FontTable->image_offset = sizeof(smd_$font_table_t);
	FontTable->chars_in_font = FontCharacterCount;
	FontTable->raster_lines = Yposition+(Xposition > 0 ? MaxHeightRow : 0);
	FontTable->image_size = FontTable->raster_lines*FontBitmapWidth/8;
	FontTable->max_height = MaxHeight;
	FontTable->max_width = MaxWidth;
	FontTable->v_spacing = 3;
	FontTable->h_spacing = 1;
	FontTable->space_size = MaxWidth/3;
	FontTable->max_right = MaxRight;
	FontTable->max_up = MaxUp;
	FontTable->max_down = MaxDown;
	gpr_$inq_bitmap_pointer(FontBitmap,FontBitmapPointer,
				FontLineWidth,Status);
	if (Status.all != status_$ok) then pfm_$error_trap(Status);
	Pointer = (short *) (FontFilePointer+sizeof(smd_$font_table_t));
	for (Row=0; Row<FontTable->raster_lines; Row++) do
	    begin
		for (i=0; i<FontBitmapWidth/16; i++) do
		    *Pointer++ = *FontBitmapPointer++;
		FontBitmapPointer += FontLineWidth-(FontBitmapWidth/16);
	    end;
	FontFileLength = FontTable->image_offset+FontTable->image_size;
	TrailerPointer =
	    (struct AAF_Trailer *) (((char *) FontFilePointer)+FontFileLength);
	for (Character=0; Character<128; Character++) do
	    TrailerPointer->TFMwidth[Character] =
		PXL_FontDirectory[Character].TFMwidth;
	TrailerPointer->PXL_TrailerCopy = PXL_FileTrailer;
	TrailerPointer->PXL_TrailerCopy.DirectoryPointer = 0;
	FontFileLength += sizeof(struct AAF_Trailer);
    end


hidden procedure ProcessFile(PXLStream)
	FILE *PXLStream;
    begin
	static gpr_$offset_t FontBitmapSize = { FontBitmapWidth, gpr_$max_y_size };
	status_$t Status;
	gpr_$init(gpr_$no_display,0,FontBitmapSize,0,FontBitmap,Status);
	if (Status.all != status_$ok) then pfm_$error_trap(Status);
	FontAttributeBlock = gpr_$attribute_block(FontBitmap,Status);
	if (Status.all != status_$ok) then pfm_$error_trap(Status);
	fread(&PXL_FileHeader,sizeof(PXL_FileHeader),1,PXLStream);
	if (PXL_FileHeader.PXLID1 != 1001) then
	    FatalError("invalid pxl file");
	fseek(PXLStream,-sizeof(PXL_FontDirectory)-sizeof(PXL_FileTrailer),2);
	fread(PXL_FontDirectory,sizeof(PXL_FontDirectory),1,PXLStream);
	fread(&PXL_FileTrailer,sizeof(PXL_FileTrailer),1,PXLStream);
	if (PXL_FileTrailer.PXLID2 != 1001) then
	    FatalError("invalid pxl file");
	LoadRasters(PXLStream);
	CreateFont();
	gpr_$terminate(true,Status);
    end

visible int main(ArgCount,ArgVector,Environment)
	int ArgCount;
	char *ArgVector[], *Environment[];
    begin
	FILE *PXLStream;
	char FontFileName[256], *LastSlash;
	ios_$id_t StreamID;
	extern uid_$t unstruct_$uid;
	status_$t Status;
	int CurrentArg;
	if (ArgCount < 2) then
	    begin
		fprintf(stderr,"Usage: pxl2apollo {filename}*\n");
		exit(1);
	    end;
	for (CurrentArg=1; CurrentArg<ArgCount; CurrentArg++) do
	    begin
		PXLFileName = ArgVector[CurrentArg];
		if ((LastSlash = rindex(PXLFileName,'/')) != NULL) then
		    begin
			LastSlash++;
			strcpy(FontFileName,LastSlash);
		    end
		else strcpy(FontFileName,PXLFileName);
		FontFileName[strlen(FontFileName)-3] = 'a';
		FontFileName[strlen(FontFileName)-2] = 'a';
		FontFileName[strlen(FontFileName)-1] = 'f';
		printf("pxl2apollo: %s ==> %s\n",PXLFileName,FontFileName);
		if ((PXLStream = fopen(PXLFileName,"r")) == NULL) then
		    begin
			fprintf(stderr,"pxl2apollo: %s - cannot open for input\n",
				PXLFileName);
			continue;
		    end;
		ios_$create(*FontFileName,(short)strlen(FontFileName),
			    unstruct_$uid,ios_$recreate_mode,ios_$write_opt,
			    StreamID,Status);
		if (Status.all != status_$ok) then
		    begin
			fprintf(stderr,"pxl2apollo: %s - cannot create file\n",
				FontFileName);
			fclose(PXLStream);
			continue;
		    end;
		ios_$close(StreamID,Status);
		FontFilePointer =
		    ms_$mapl(*FontFileName,(short)strlen(FontFileName),
			     0L,0x40000L,ms_$nr_xor_1w,ms_$wr,ms_$extend,
			     FontFileLength,Status);
		if (Status.all != status_$ok) then
		    begin
			fprintf(stderr,"pxl2apollo: %s - cannot map file\n",
				FontFileName);
			fclose(PXLStream);
			continue;
		    end;
		ProcessFile(PXLStream);
		fclose(PXLStream);
		ms_$truncate(FontFilePointer,FontFileLength,Status);
		if (Status.all != status_$ok) then pfm_$error_trap(Status);
		ms_$unmap(FontFilePointer,0x40000L,Status);
		if (Status.all != status_$ok) then pfm_$error_trap(Status);
	    end;
	return 0;
    end
