#include <qframe.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qheader.h>
#include <qmessagebox.h>
#include <qclipboard.h>
#include <qtimer.h>
#include <qpopmenu.h>
#include "MyLV.h"
#include "EditMask.h"




void MyLVI::paintCell(QPainter *p, const QColorGroup & cg, int column, int width, int alignment){
 this->QListViewItem::paintCell(p,cg,column,width,alignment);
 p->setPen(gray);
 for (int i=0;i<height();i++)
  if (i & 2) p->drawPoint(width-1,i);
 for (int i=0;i<width;i++)
  if (i & 2) p->drawPoint(i,height()-1);
}

MyLVI::MyLVI(Record e,MyLV *parent, const char *name, const char* x0=0, const char* x1=0, const char* x2=0,const char* x3=0, const char* x4=0, const char* x5=0, const char* x6=0):QListViewItem(parent,name,x0,x1,x2,x3,x4,x5,x6)
{
 r=e;
}

MyLV::MyLV(QWidget *parent, const char *name): QListView(parent,name){
 disconnect(this->header(),SIGNAL(sectionClicked( int )),this,SLOT(changeSortColumn( int )));
 connect(this->header(),SIGNAL(sectionClicked(int)),this,SLOT(mchangeSortColumn(int)));
 ti=new QTimer(this);
 connect(ti,SIGNAL(timeout()),SLOT(make_vis()));
}

void MyLV::writeClipBoard(QListViewItem* i=0){
QClipboard *cb=QApplication::clipboard();
 QString x;
 bool b=true;
 x="\\cite{";
 if (i) x+=RecordHeap(((MyLVI*)i)->r)[0]; else {
  for (i=firstChild();i!=0;i=i->nextSibling())
   if (isSelected(i)) {
    if (!b) x+=",";
    x+=RecordHeap(((MyLVI*)i)->r)[0];
    b=false;
   }
 }
 x+="}";
 cb->setText(x);
}
void MyLV::mchangeSortColumn(int i){
 setSorting(i,TRUE);
 ti->start(10,TRUE);
}

void MyLV::make_vis(){
 QListViewItem *ci=currentItem();
 setSelected(ci,1);
 ensureItemVisible(ci);
 triggerUpdate();
}

void MyLV::clearSelections(){
 for (QListViewItem *i=firstChild();i!=0;i=i->nextSibling())
  setSelected(i,FALSE);
}

void MyLV::menuhandler1(){
 if (isMultiSelection()) writeClipBoard();
  else writeClipBoard(currentItem());
}

void MyLV::menuhandler2(){
 QString x;
// QFile in(getenv("HOME")+QString("/.lyxpipe.out"));
 QFile out(getenv("HOME")+QString("/.lyxpipe.in"));
 if (!out.exists()) {
  QMessageBox::message("Note","Lyxserver does not seem to exist!");
  return;
 } 
 bool b=true;
 if (!isMultiSelection()) x=RecordHeap(((MyLVI*)currentItem())->r)[0];
  else
  for (QListViewItem *i=firstChild();i!=0;i=i->nextSibling())
   if (isSelected(i)) {
    if (!b) x+=",";
    x+=RecordHeap(((MyLVI*)i)->r)[0];
    b=false;
   }
 x="LYXCMD:qbibman:citation-insert:"+x+"\n";
 out.open(IO_WriteOnly);
 out.writeBlock(x,x.length());
 out.close();
}

void MyLV::mousePressEvent(QMouseEvent *e){
 if (e->button() & MidButton) return;
 if (e->button() & LeftButton) {
  if (e->state() & ControlButton){
   if (!isMultiSelection()) setMultiSelection(TRUE);
  } else {
   setMultiSelection(FALSE);
   clearSelections();
  } 
  QListView::mousePressEvent(e);
 } else {              //right button
  QPopupMenu *menu=new QPopupMenu();
  menu->insertItem("Put selected items using \"\\cite{}\" into clipboard",this,SLOT(menuhandler1()));
  menu->insertItem("Insert Citation into Lyx-Document",this,SLOT(menuhandler2()));
  menu->exec(QCursor::pos());
 }
}

void MyLV::keyPressEvent(QKeyEvent *e){
 QListViewItem *c=NULL;
 this->QListView::keyPressEvent(e); //handle default keypresses
 switch (e->key()){
  case Key_Insert   : newItem(); e->accept();break;
  case Key_Delete   : deleteItem();e->accept();break;
  case Key_Home     : setCurrentItem(firstChild());setSelected(firstChild(),1);
  		      ensureItemVisible(firstChild());e->accept();break;
  case Key_End      : 
  	for (QListViewItem *i=firstChild();i!=0;i=i->nextSibling())
	 c=i;
	setCurrentItem(c);setSelected(c,1);ensureItemVisible(c);e->accept();break;
  case Key_Up       : 
  case Key_Down     : if (isMultiSelection()) {
  			setMultiSelection(FALSE);
			clearSelections();
			setSelected(currentItem(),TRUE);
			break;
		       }
  default : e->ignore();
 }
}

void MyLV::newItem(){
 if (((ApplicationWindow*)parent())->fw) return;  //avoid add in findwindow
 Record r=new_record(6,4); 
 EditMask em((ApplicationWindow*)parent(),NULL,r);
 if (em.exec()) {
  db_add_record( ((ApplicationWindow*)parent())->db,r);
  QListViewItem *i=((ApplicationWindow*)parent())->addEntry(r);
  ((ApplicationWindow*)parent())->edited=1;
  ((ApplicationWindow*)parent())->lv->setCurrentItem(i);
  ti->start(10,TRUE);
 }
}

void MyLV::deleteItem(){
int c=0;
 if (isMultiSelection()){
 for (QListViewItem *i=firstChild();i!=0;i=i->nextSibling())
  if (isSelected(i)) c++;
 if (!QMessageBox::warning(this,"Warning","Do you really want to delete all currently selected entries?","Yes","No",NULL,1)) {
 for (QListViewItem *i=firstChild();i!=0;i=i->nextSibling())
  if (isSelected(i)) deleteItem((MyLVI*) i);
 }
 } else deleteItem((MyLVI*)currentItem());
}

void MyLV::deleteItem(MyLVI *i){
  ApplicationWindow *maw=((ApplicationWindow*)(qApp->mainWidget()));
 if (!i) return;
 if (!isMultiSelection()) if (QMessageBox::warning(this,"Warning","Do you really want to delete this entry?","Yes","No",NULL,1)) return; 
 delete_record(maw->db,i->r);
 delete i;
 triggerUpdate();
 ApplicationWindow *aw=(ApplicationWindow*)parent();
 aw->edited=1;
 if (aw->fw) {
  maw->edited=1;
  for (QListViewItem *j=maw->lv->firstChild();j;j=j->nextSibling())
   if (i->r==((MyLVI*)j)->r) {
    ((MyLVI*)j)->~MyLVI();
    break;
   }
  maw->lv->triggerUpdate(); 
  maw->statusBar()->message("Entry deleted");
 }
}
