import acsync.rpc

import os
import sys

import xbmc
import xbmcaddon


def main():
    rpc = acsync.rpc.RPC(xbmc)

    addon_id = sys.argv[1]
    userdata_path = xbmc.translatePath("special://profile")
    token_path = os.path.join(
        userdata_path, "addon_data", addon_id, "device.key")

    try:
        os.remove(token_path)
    except OSError as e:
        if os.path.isfile(token_path):
            xbmc.log('Device key could not be removed: %s' %
                     token_path, level=xbmc.WARN)
            raise e

    xbmc.executebuiltin("StopScript('%s')" % addon_id)
    xbmc.executebuiltin("EnableAddon('%s')" % addon_id)
    xbmc.executebuiltin("RunAddon)('%s')" % addon_id)
    rpc.set_addon_state(addon_id, False)
    rpc.set_addon_state(addon_id, True)


if __name__ == '__main__':
    main()
