import urllib2
import httplib
import contextlib
import ssl


class SyncCheck(object):
    def __init__(self, config, logger, state, xbmc):
        self.config = config
        self.logger = logger
        self.state = state
        self.xbmc = xbmc

    def is_unlocked(self):
        try:
            url = self.config.get('UPDATE_CHECK_URL') + self.state.device_token
            user_agent = self.xbmc.getUserAgent() or self.xbmc.getInfoLabel(
                "System.BuildVersion") + " (Windows NT 6.1;WOW64;Win64;x64;)"

            request = urllib2.Request(url)
            request.add_header("Content-Type", 'application/graphql')
            request.add_header("User-Agent", user_agent)
            request.get_method = lambda: "GET"

            if self.config.get('ALLOW_INSECURE_CONNECTION') == "true":
                context = ssl._create_unverified_context()
            else:
                context = ssl.create_default_context()

            context.options = (ssl.OP_NO_TLSv1 | ssl.OP_NO_TLSv1_1 |
                               ssl.OP_NO_COMPRESSION | ssl.PROTOCOL_TLSv1_2)
            handler = urllib2.HTTPSHandler(context=context)
            urllib2.build_opener(handler)

            try:
                with contextlib.closing(urllib2.urlopen(request, context=context)) as connection:
                    status_code = connection.getcode()
                    if status_code == 304:
                        self.logger.notice("Web -> Local: Locked.")
                        return 0
                    elif status_code == 204:
                        self.logger.notice("Web -> Local: Unlocked.")
                        return 1
            except urllib2.URLError as e:
                if hasattr(e, 'reason') and hasattr(e.reason, 'errno'):
                    if e.reason.errno == 304:
                        self.logger.notice("Web -> Local: Locked.")
                        return 0
                    elif e.reason.errno == 204:
                        self.logger.notice("Web -> Local: Unlocked.")
                        return 1
                    else:
                        self.logger.error(
                            "We failed to reach the update server.")
                        self.logger.error("Reason: %s" % str(e.reason))
                elif hasattr(e, 'code'):
                    self.logger.error(
                        "The server couldn\'t fulfill the request.")
                raise
            except httplib.BadStatusLine:
                self.logger.error("The update server is probably down :-(")
                raise
            except httplib.HTTPException:
                self.logger.error(
                    "Encountered exception accessing HTTP server: %s" % e)
                raise
            except Exception:
                import traceback
                self.logger.error("Generic exception while connecting: %s" %
                                  traceback.format_exc())
                raise
        except Exception as e:
            self.logger.error(str(e))
            self.logger.error("An issue appeared while checking for updates")
            raise
