import os


class State(object):
    def __init__(self, addon, config, xbmcaddon):

        self.addon = addon
        self.config = config
        self.xbmcaddon = xbmcaddon

        """The current state of shared variables"""
        self.addon_run_interval = self.config.get("ACTIVE_INTERVAL")
        self.addon_connect_interval = self.config.get('CONNECT_INTERVAL')
        self.device_token = self.get_token()
        self.installed_addons_hash = None
        self.timestamp_last_run = None
        self.timestamp_last_connect_attempt = None
        self.updated_needed = False
        self.log_verbose = None
        self.force_sync = None
        self.load()

    def load(self):
        self.log_verbose = self.xbmcaddon.Addon().getSetting("log_verbose") == "true"
        self.force_sync = self.xbmcaddon.Addon().getSetting("force_sync") == "true"

    def set_force_sync(self, value):
        self.force_sync = (value == "true")
        self.xbmcaddon.Addon().setSetting(id='force_sync', value=value)

    def get_token(self):
        file_path = self.addon.token_path

        try:
            if os.stat(file_path).st_size >= 6:
                fh = open(file_path, "r")
                return fh.readline()
        except OSError:
            return None
