import json


class RPC(object):

    def __init__(self, xbmc):
        self.xbmc = xbmc

    def rpc_call(self, **kwargs):
        call_dict = {}
        call_dict['id'] = '1'
        call_dict['jsonrpc'] = '2.0'

        call_dict['method'] = kwargs.pop('method')
        call_dict['params'] = kwargs

        call_json = json.dumps(call_dict)
        result_json = self.xbmc.executeJSONRPC(call_json)
        result_json = result_json.decode('utf-8')  # is stil still needed?
        result_dict = json.loads(result_json)
        return result_dict

    def get_installed_addons(self):
        result_dict = self.rpc_call(method='Addons.GetAddons', properties=[
            'version', 'name', 'path', 'dependencies'])

        return result_dict

    def set_addon_state(self, aid, enabled):
        enabled = type(enabled) == type(True) or enabled == "true"

        if self.xbmc.getCondVisibility("System.HasAddon(%s)" % aid) and enabled:
            return
        elif not self.xbmc.getCondVisibility("System.HasAddon(%s)" % aid) and not enabled:
            return

        else:
            self.rpc_call(method='Addons.SetAddonEnabled',
                          addonid=aid, enabled=enabled)
            return
