### What does Addons.Center Sync do?

This addon uses the API of Addons.Center to sync your Kodi with the website. No more, no less.

### What does Addons.Center do?

[Addons.Center](https://addons.center/) allows you to manage your addons
in Kodi using your phone, tablet or PC. In doing so, it offers you a whole new
experience of exploring and managing Kodi addons. It combines the advantages of
popular 'super repositories' with the power of self control. Putting you back
at the center of your own multimedia system.

### Installation

1. Download the zip ([download it here](../../zipball/master))
2. Install **Addons.center Sync** by zip. Go to _Settings_ > _Add-ons_ > _Install from zip file_ > Choose the just downloaded zip
3. Follow the instructions to [pair with Addons.Center](https://manage.addons.center/pair)

or

If you are a developer, you might install the dev version:

1. Clone this repository into a folder called **addons.center.sync** inside your Kodi **addons** folder
2. Start Kodi (or restart if its already running)
3. Follow the instructions to [pair with Addons.Center](https://manage.addons.center/pair)

### Problems?

#### "I found something that doesn't work"

- Search the issues on github to see if it has already been reported, if so add your information there.
- If not, create a new issue and provide as much data about your system as possible, a logfile will also be needed.

#### Creating logfiles

- Go to _Settings_ > _Add-ons_ > _Services_ > _Addons.Center Sync_ > _Configure_ and enable `Verbose logging`
- If the addon is running, the location of the **Addons.Center Sync**  logfile is displayed in a toast.
-  If the addon is not running, you can find the location of the **Addons.Center Sync** logfile written in your Kodi logfile.
- Check the [Kodi documentation](http://kodi.wiki/view/Log_file) if you don't know where your Kodi logfile can be found.

#### Invoke full sync via settings

- Go to _Settings_ > _Add-ons_ > _Services_ > _Addons.Center Sync_ > _Configure_ and enable `Force sync (only once)`

#### Repair with Addons.Center

- Go to _Settings_ > _Add-ons_ > _Services_ > _Addons.Center Sync_ > _Configure_ and select `Repair with Addons.Center`

### Contribute

#### Pull requests

- Always welcome!
