import hashlib

import acsync.addon
import acsync.monitor
import acsync.config
import acsync.graphql
import acsync.interval
import acsync.logger
import acsync.main
import acsync.notify
import acsync.package_manager
import acsync.state
import acsync.sync_check
import acsync.rpc
import acsync.download

import xbmc
import xbmcaddon
import xbmcgui


def main():

    rpc = acsync.rpc.RPC(xbmc)
    addon = acsync.addon.Addon(xbmc, xbmcaddon)
    config = acsync.config.Config(addon)
    state = acsync.state.State(addon, config, xbmcaddon)
    monitor = acsync.monitor.Monitor(state)
    notify = acsync.notify.Notify(addon, xbmc, xbmcgui)
    logger = acsync.logger.Logger(addon, notify, state, xbmc)
    interval = acsync.interval.Interval(config, logger, state, xbmc)
    graphql = acsync.graphql.Graphql(
        addon, config, interval, logger, notify, rpc, state, xbmc, xbmcgui)
    download = acsync.download.Download(logger, xbmc, xbmcgui)
    sync_check = acsync.sync_check.SyncCheck(config, logger, state, xbmc)
    pkg_man = acsync.package_manager.PackageManager(
        addon, download, graphql, logger, rpc, xbmc)

    logger.notice("""

        ========================= %s (%s) v%s =========================

            For help visit https://manage.addons.center/help or send an email 
            to addon@addons.center with the %s log attached.

            Log Path:............: %s
            User Data Path:......: %s
            Install Path:........: %s
            Temporary File Path..: %s
            Device Token Hash: ..: %s
            Kodi Version:........: %s

    """ % (addon.name, addon.id, addon.version,
           addon.id,
           addon.log_path,
           addon.user_data_path,
           addon.install_path,
           addon.temp_path,
           hashlib.sha256(state.device_token)
           .hexdigest() if state.device_token else "none",
           xbmc.getInfoLabel('System.BuildVersion')
           ))

    if not state.timestamp_last_run:
        state.timestamp_last_run = 0

    if not state.timestamp_last_connect_attempt:
        state.timestamp_last_connect_attempt = 0

    if state.device_token:
        logger.notice("Device paired. Let's sync some!")
        instance = acsync.main.Main(
            addon, config, graphql, interval, logger, monitor,
            notify, pkg_man, rpc, state, sync_check, xbmc, xbmcaddon)
        instance.loop()
    else:
        logger.notice("Device not paired. Start pairing proces...")
        graphql.pair_device()
        instance = acsync.main.Main(
            addon, config, graphql, interval, logger, monitor,
            notify, pkg_man, rpc, state, sync_check, xbmc, xbmcaddon)
        instance.loop()


if __name__ == '__main__':
    try:
        main()
    except:
        try:
            ADDON_NAME = xbmcaddon.Addon().getAddonInfo('name')
            xbmc.log("Could not start %s" % ADDON_NAME, level=xbmc.LOGFATAL)
            raise
        except:
            xbmc.log("Addon stopped as it was disabled", level=xbmc.LOGNOTICE)
