from datetime import datetime
import time


class Interval(object):
    """There are two distinct intervals: one depends on the activity in Kodi the
    other is depending on succesfull syncs.
    """

    def __init__(self, config, logger, state, xbmc):
        self.state = state
        self.config = config
        self.logger = logger
        self.xbmc = xbmc

        self.hibernate_threshold = self.config.get('HIBERNATE_THRESHOLD')
        self.inactive_threshold = self.config.get('INACTIVE_THRESHOLD')
        self.connect_interval = self.config.get('CONNECT_INTERVAL')
        self.max_connect_interval = self.config.get('MAX_CONNECT_INTERVAL')
        self.hibernation_interval = self.config.get('HIBERNATION_INTERVAL')
        self.sleep_interval = self.config.get('SLEEP_INTERVAL')
        self.active_interval = self.config.get('ACTIVE_INTERVAL')

    def log(self):
        try:
            self.logger.debug("Addon run threshold: " +
                              datetime.fromtimestamp(
                                  self.state.timestamp_last_run +
                                  (self.state.addon_run_interval * 60)
                              )
                              .strftime("%H:%M:%S"))

            self.logger.debug("Connect threshold: " +
                              datetime.fromtimestamp(
                                  self.state.timestamp_last_connect_attempt +
                                  (self.state.addon_connect_interval * 60)
                              )
                              .strftime("%H:%M:%S"))
        except Exception:
            pass

    def double_connect_interval(self):
        self.state.addon_connect_interval = self.state.addon_connect_interval * 2

        if self.state.addon_connect_interval < self.max_connect_interval:
            self.logger.debug("Double connect interval to %s minutes (max: %s min)" %
                              (self.state.addon_connect_interval, self.max_connect_interval))
        else:
            self.state.addon_connect_interval = self.max_connect_interval
            self.logger.debug(
                "Using maximum connect interval of %s min" % self.max_connect_interval)

    def reset_connect_interval(self):
        default_connect_interval = self.config.get('CONNECT_INTERVAL')
        if self.state.addon_connect_interval is not default_connect_interval:
            self.state.addon_connect_interval = default_connect_interval
            self.logger.debug("Reset connect interval to %s minutes" %
                              self.state.addon_connect_interval)

    def set_timestamp_last_run(self):
        self.state.timestamp_last_run = time.time()

    def set_timestamp_last_connect_attempt(self):
        self.state.timestamp_last_connect_attempt = time.time()

    def set_run_interval(self):
        idle_seconds = self.xbmc.getGlobalIdleTime() or 1
        idle_minutes = idle_seconds / 60

        if idle_minutes > self.hibernate_threshold:
            if self.state.addon_run_interval != self.hibernation_interval:
                self.state.addon_run_interval = self.hibernation_interval
                self.logger.debug("Kodi is hibernating. Changed interval to %s hours" %
                                  int(round(self.state.addon_run_interval / 60)))

        elif self.inactive_threshold <= idle_minutes <= self.hibernate_threshold:
            if self.state.addon_run_interval != self.sleep_interval:
                self.state.addon_run_interval = self.sleep_interval
                self.logger.debug("Kodi is sleeping. Changed interval to %s minutes" %
                                  int(round(self.state.addon_run_interval)))

        elif self.xbmc.Player().isPlayingVideo():
            if self.state.addon_run_interval != self.sleep_interval:
                self.state.addon_run_interval = self.sleep_interval
                self.logger.debug("Kodi is playing a video. Changed interval to %s minutes" %
                                  int(round(self.state.addon_run_interval)))

        elif self.xbmc.getCondVisibility("system.screensaveractive"):
            if self.state.addon_run_interval != self.sleep_interval:
                self.state.addon_run_interval = self.sleep_interval
                self.logger.debug("Kodi screensaver is activate. Changed interval to %s minutes" %
                                  int(round(self.state.addon_run_interval)))

        elif self.state.addon_run_interval != self.active_interval:
            self.state.addon_run_interval = self.active_interval
            self.logger.debug("Kodi is awake. Changed interval to %s minutes" %
                              self.state.addon_run_interval)
