# define Python user-defined exceptions
class ConnectionError(Exception):
    """Base class for other connection exceptions"""


class RemoteOfflineError(ConnectionError):
    """Raised when the remote side is offline"""


class UndefinedConnectionError(ConnectionError):
    """Raised when the server cant fulfill the request"""


class ServerError(ConnectionError):
    """Raised when the server cant fulfill the request"""
