import urllib2


class Download(object):

    def __init__(self, logger, xbmc, xbmcgui):
        self.logger = logger
        self.xbmcgui = xbmcgui
        self.user_agent = xbmc.getUserAgent() or xbmc.getInfoLabel(
            "System.BuildVersion") + " (Windows NT 6.1;WOW64;Win64;x64;)"

    def download(self, url, dest, visible=True):
        try:
            if visible:
                progress_dialog = self.xbmcgui.DialogProgress()
                progress_dialog.create("Umbrella Addon Manager", "Downloading")
            self.logger.debug("Download from " + url)

            request = urllib2.Request(url, headers={
                "Accept": "application/zip, application/octet-stream",
                'User-Agent': self.user_agent})

            real_url = urllib2.urlopen(request).geturl()
            if url != real_url:
                self.logger.debug("Redirected to " + real_url)

            request = urllib2.Request(url, headers={
                "Accept": "application/zip, application/octet-stream",
                'User-Agent': self.user_agent})

            response = urllib2.urlopen(request)

            fh = open(dest, "w")
            fh.write(response.read())
            fh.close()

            if visible:
                progress_dialog.close()

            return dest
        except:
            self.logger.warning("Failed to download from " + url)
            raise

    def _pbhook(self, numblocks, blocksize, filesize, url=None, progress_dialog=None):
        try:
            percent = min((numblocks*blocksize*100)/filesize, 100)
            progress_dialog.update(percent)
        except Exception:
            percent = 100
            progress_dialog.update(percent)
        if progress_dialog.iscanceled():
            # need to get this part working
            self.logger.debug("Download canceled")
            progress_dialog.close()
