import os
import json

CONFIG_FILES = [
    'config.default.json',
    'config.local.json',
    'config.overrides.json'
]


class Config(object):

    def __init__(self, addon):
        """Return a Config object with environment value *env*"""

        self.config = None
        self.addon = addon
        self.load()

    def load(self):
        self.parse_configs(CONFIG_FILES)

    def parse_configs(self, config_files):

        new_config = {}

        for conf_file in config_files:
            path = os.path.join(self.addon.install_path,
                                conf_file)

            if not os.path.isfile(path):
                continue

            try:
                with open(path, 'r') as fp:
                    conf_obj = json.load(fp)
                    new_config.update(conf_obj)
            except:
                print "Could not parse config file: %s" % path
                pass

        if new_config == {}:
            raise ValueError("Config is empty. Are there config files at %s ?" % self.addon.install_path)

        self.config = new_config

    def get(self, key):
        try:
            return self.config[key]
        except:
            return False

    def __str__(self):
        return json.dumps(self.config, sort_keys=True, indent=4)
