import os
import sys


class Addon(object):
    """
    Attributes:
        name: A string representing the addon's name.
        id: A string representing the addon's id.
        version: A string representing the version of the addon.
        user_data_path: A string representing the path of the addon user data at the filesystem
        install_path: A string representing the path where addons are installed at the filesystem
        token_path: A string representing the path of the token file at the filesystem
        temp_path: A string representing the path of the temporary files folder at the filesystem
        log_path: A string representing the path of the addon folder at the filesystem
    """

    def __init__(self, xbmc, xbmcaddon):
        """Return an Addon object"""
        self.name = xbmcaddon.Addon().getAddonInfo('name')
        self.id = xbmcaddon.Addon().getAddonInfo('id')
        self.version = xbmcaddon.Addon().getAddonInfo('version')
        self.user_data_path = os.path.join(xbmc.translatePath(
            'special://home/userdata/addon_data/'), self.id)
        self.install_path = os.path.join(xbmc.translatePath(
            'special://home/addons/'), self.id)
        self.token_path = os.path.join(
            self.user_data_path, "device.key")
        self.temp_path = os.path.join(xbmc.translatePath(
            'special://temp/'), self.id)
        self.log_path = os.path.join(xbmc.translatePath(
            'special://logpath/'), self.id + '.log')

        if sys.version_info[0] < 3:
            self.user_data_path = self.user_data_path.decode("utf-8")
            self.install_path = self.install_path.decode("utf-8")
            self.token_path = self.token_path.decode("utf-8")
            self.temp_path = self.temp_path.decode("utf-8")
            self.log_path = self.log_path.decode("utf-8")
