#!/usr/bin/python
# -*- coding: utf-8 -*-

# *  Copyright (C) 2016 TDW

import xbmc, xbmcgui, xbmcplugin, xbmcaddon, os, urllib, urllib2, time, codecs, httplib
import tvfeed

PLUGIN_NAME   = 'tvfeed'
siteUrl = 'tvfeed.in'
httpSiteUrl = 'https://' + siteUrl
handle = int(sys.argv[1])
addon = xbmcaddon.Addon(id='plugin.video.tvfeed')
__settings__ = xbmcaddon.Addon(id='plugin.video.tvfeed')
xbmcplugin.setContent(int(sys.argv[1]), 'movies')

icon  = os.path.join( addon.getAddonInfo('path'), 'icon.png')
dbDir = __settings__.getSetting("DBDirectory")
if dbDir =='': dbDir = addon.getAddonInfo('path')
LstDir = addon.getAddonInfo('path')

#======================== стандартные функции ==========================
def fs_enc(path):
	sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
	return path.decode('utf-8').encode(sys_enc)

def fs_dec(path):
	sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
	return path.decode(sys_enc).encode('utf-8')

def fs(s):return s.decode('windows-1251').encode('utf-8')
def win(s):return s.decode('utf-8').encode('windows-1251')
def ru(x):return unicode(x,'utf8', 'ignore')
def xt(x):return xbmc.translatePath(x)
def rt(x):#('&#39;','’'), ('&#145;','‘')
	L=[('&amp;',"&"),('&#133;','…'),('&#38;','&'),('&#34;','"'), ('&#39;','"'), ('&#145;','"'), ('&#146;','"'), ('&#147;','“'), ('&#148;','”'), ('&#149;','•'), ('&#150;','–'), ('&#151;','—'), ('&#152;','?'), ('&#153;','™'), ('&#154;','s'), ('&#155;','›'), ('&#156;','?'), ('&#157;',''), ('&#158;','z'), ('&#159;','Y'), ('&#160;',''), ('&#161;','?'), ('&#162;','?'), ('&#163;','?'), ('&#164;','¤'), ('&#165;','?'), ('&#166;','¦'), ('&#167;','§'), ('&#168;','?'), ('&#169;','©'), ('&#170;','?'), ('&#171;','«'), ('&#172;','¬'), ('&#173;',''), ('&#174;','®'), ('&#175;','?'), ('&#176;','°'), ('&#177;','±'), ('&#178;','?'), ('&#179;','?'), ('&#180;','?'), ('&#181;','µ'), ('&#182;','¶'), ('&#183;','·'), ('&#184;','?'), ('&#185;','?'), ('&#186;','?'), ('&#187;','»'), ('&#188;','?'), ('&#189;','?'), ('&#190;','?'), ('&#191;','?'), ('&#192;','A'), ('&#193;','A'), ('&#194;','A'), ('&#195;','A'), ('&#196;','A'), ('&#197;','A'), ('&#198;','?'), ('&#199;','C'), ('&#200;','E'), ('&#201;','E'), ('&#202;','E'), ('&#203;','E'), ('&#204;','I'), ('&#205;','I'), ('&#206;','I'), ('&#207;','I'), ('&#208;','?'), ('&#209;','N'), ('&#210;','O'), ('&#211;','O'), ('&#212;','O'), ('&#213;','O'), ('&#214;','O'), ('&#215;','?'), ('&#216;','O'), ('&#217;','U'), ('&#218;','U'), ('&#219;','U'), ('&#220;','U'), ('&#221;','Y'), ('&#222;','?'), ('&#223;','?'), ('&#224;','a'), ('&#225;','a'), ('&#226;','a'), ('&#227;','a'), ('&#228;','a'), ('&#229;','a'), ('&#230;','?'), ('&#231;','c'), ('&#232;','e'), ('&#233;','e'), ('&#234;','e'), ('&#235;','e'), ('&#236;','i'), ('&#237;','i'), ('&#238;','i'), ('&#239;','i'), ('&#240;','?'), ('&#241;','n'), ('&#242;','o'), ('&#243;','o'), ('&#244;','o'), ('&#245;','o'), ('&#246;','o'), ('&#247;','?'), ('&#248;','o'), ('&#249;','u'), ('&#250;','u'), ('&#251;','u'), ('&#252;','u'), ('&#253;','y'), ('&#254;','?'), ('&#255;','y'), ('&laquo;','"'), ('&raquo;','"'), ('&nbsp;',' ')]
	for i in L:
		x=x.replace(i[0], i[1])
	return x

def lower(s):
	try:s=s.decode('utf-8')
	except: pass
	try:s=s.decode('windows-1251')
	except: pass
	s=s.lower().encode('utf-8')
	return s

def mid(s, n):
	try:s=s.decode('utf-8')
	except: pass
	try:s=s.decode('windows-1251')
	except: pass
	s=s.center(n)
	try:s=s.encode('utf-8')
	except: pass
	return s

def mids(s, n):
	l="                                              "
	s=l[:n-len(s)]+s+l[:n-len(s)]
	return s

def FC(s, color="FFFFFF00"):
	s="[COLOR "+color+"]"+s+"[/COLOR]"
	return s

def mfindal(http, ss, es):
	L=[]
	while http.find(es)>0:
		s=http.find(ss)
		e=http.find(es)
		i=http[s:e]
		L.append(i)
		http=http[e+2:]
	return L

def mfind(t,s,e):
	r=t[t.find(s)+len(s):]
	r2=r[:r.find(e)]
	return r2

def debug(s):
	fl = open(ru(os.path.join( addon.getAddonInfo('path'),"test.txt")), "wb")
	fl.write(s)
	fl.close()

def deb_print(s):
	if __settings__.getSetting("DebMod")=='true': print s

def inputbox():
	skbd = xbmc.Keyboard()
	skbd.setHeading('Поиск:')
	skbd.doModal()
	if skbd.isConfirmed():
		SearchStr = skbd.getText()
		return SearchStr
	else:
		return ""

def showMessage(heading, message, times = 3000):
	xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, "%s")'%(heading, message, times, icon))

#====================== подготовка данных для интерфейса ================
#'https://tvfeed.in/serial/'
#'https://tvfeed.in/serial/newest/'
#'https://tvfeed.in/serial/popular/'
#'https://tvfeed.in/serial/recommended/'
#'https://tvfeed.in/genre/'
#'https://tvfeed.in/collection/'
#============================== основная часть ============================


def GET(url,Referer = 'http://www.KinoPoisk.ru/'):
	deb_print ('KP GET '+url)
	try:
		req = urllib2.Request(url)
		req.add_header('User-Agent', 'Opera/10.60 (X11; openSUSE 11.3/Linux i686; U; ru) Presto/2.6.30 Version/10.60')
		req.add_header('Accept', '*/*')
		req.add_header('Accept-Language', 'ru,en;q=0.9')
		req.add_header('Referer', Referer)
		response = urllib2.urlopen(req)
		link=response.read()
		response.close()
		return link
	except:
		return ''
		''''
		import requests
		s = requests.session()
		r=s.get(url).text
		rd=r.encode('windows-1251')
		return rd
		'''

def GETjson(url,Referer = 'https://plus.kinopoisk.ru'):
		deb_print ('KP GETjson '+url)
		
		req = urllib2.Request(url)
		req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36 OPR/46.0.2597.39')
		req.add_header('Accept', 'text/html, application/xml, application/xhtml+xml, */*')
		req.add_header('Accept-Language', 'ru-RU,ru;q=0.8,en-US;q=0.6,en;q=0.4')
		req.add_header('Referer', Referer)
		req.add_header('X-Requested-With', 'XMLHttpRequest')
		response = urllib2.urlopen(req)
		link=response.read()
		response.close()
		return link

def GET2(url, Referer= 'https://plus.kinopoisk.ru'):
	try:
		import requests
		try:
			s = requests.session()
			r=s.get(url, timeout=(0.5, 3), verify=False).text#0.00001
		except:
			print 'requests: timeout'
			r=''
		#r=r.encode('windows-1251')
		return r
	except:
		return ''

def GETtorr(target):
	try:
			req = urllib2.Request(url = target)
			req.add_header('User-Agent', 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1) ; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729; .NET4.0C)')
			resp = urllib2.urlopen(req)
			return resp.read()
	except Exception, e:
			print 'HTTP ERROR ' + str(e)
			return None

def get_params():
	param=[]
	paramstring=sys.argv[2]
	if len(paramstring)>=2:
		params=sys.argv[2]
		cleanedparams=params.replace('?','')
		if (params[len(params)-1]=='/'):
			params=params[0:len(params)-2]
		pairsofparams=cleanedparams.split('&')
		param={}
		for i in range(len(pairsofparams)):
			splitparams={}
			splitparams=pairsofparams[i].split('=')
			if (len(splitparams))==2:
				param[splitparams[0]]=splitparams[1]
	return param



import sqlite3 as db
db_name = os.path.join( dbDir, "move_info.db" )
c = db.connect(database=db_name)
cu = c.cursor()
def add_to_db(n, item):
		deb_print ('KP add_to_db '+n)
		item=item.replace("'","XXCC").replace('"',"XXDD")
		err=0
		tor_id="n"+n.replace('-','')
		print tor_id
		litm=str(len(item))
		try:
			cu.execute("CREATE TABLE "+tor_id+" (db_item VARCHAR("+litm+"), i VARCHAR(1));")
			c.commit()
			deb_print ('KP add_to_db CREATE TABLE '+tor_id)
		except: 
			err=1
			print "Ошибка БД"+ n
		if err==0:
			cu.execute('INSERT INTO '+tor_id+' (db_item, i) VALUES ("'+item+'", "1");')
			c.commit()
			deb_print ('KP add_to_db INSERT INTO '+tor_id)
			#c.close()

def get_inf_db(n):
		deb_print ('KP get_inf_db '+n)
		tor_id="n"+n.replace('-','')
		cu.execute(str('SELECT db_item FROM '+tor_id+';'))
		c.commit()
		deb_print ('KP get_inf_db SELECT '+tor_id)
		Linfo = cu.fetchall()
		info=Linfo[0][0].replace("XXCC","'").replace("XXDD",'"')
		deb_print ('KP get_inf_db return_info OK')
		return info

def rem_inf_db(n):
		deb_print ('KP rem_inf_db '+n)
		tor_id="n"+n.replace('-','')
		try:
			cu.execute("DROP TABLE "+tor_id+";")
			c.commit()
			deb_print ('KP rem_inf_db DROP TABLE '+n)
		except: pass


def update_info(id):
	rem_inf_db(id)
	xbmc.executebuiltin('Container.Refresh')


def get_labels(info):
	Linf=['genre', 'year', 'rating', 'cast', 'director', 'plot', 'title', 'originaltitle', 'studio']
	Labels={}
	for inf in Linf:
		try:Labels[inf] = info[inf]
		except: pass
	try:Labels['duration'] = str(int(info['duration'])*60)
	except: pass
	return Labels


def AddItem(Title = "", mode = "", id='0', url='', total=100, icon=icon):
			if id !='0' and mode!="Play":
				try:    info=get_info(id)
				except: info={}
				try:    cover = info["cover"]
				except: cover = icon
				try:    fanart = info["fanart"]
				except: fanart = ''
			else:
				cover = icon
				fanart = ''
				info={'id':id}
			listitem = xbmcgui.ListItem(Title, iconImage=cover, thumbnailImage=cover)
			listitem.setInfo(type = "Video", infoLabels = get_labels(info))
			try: listitem.setArt({ 'poster': cover, 'fanart' : fanart, 'thumb': cover, 'icon': cover})
			except: pass
			listitem.setProperty('fanart_image', fanart)
			
			purl = sys.argv[0] + '?mode='+mode+'&id='+id
			if url !="": purl = purl +'&url='+urllib.quote_plus(url)
			
			try:type=info["type"]
			except:type=''
			if mode=="Play":
				listitem.setProperty('IsPlayable', 'true')
				#purl = sys.argv[0] + '?mode=Autoplay&id='+id
				xbmcplugin.addDirectoryItem(handle, purl, listitem, False, total)
			else:
				xbmcplugin.addDirectoryItem(handle, purl, listitem, True, total)

def AddEpisode(Title = "", mode = "", info={}, url='', total=100):
			id=info['id']
			ep=info['episode']
			try:    cover = info["cover"]
			except: cover = ''
			if cover == '' or 'no-series-image' in cover or 'tvmazecdn' in cover: #                          tvmazecdn ВРЕМЕННО ОТКЛЮЧЕНО !!!
				cover=get_info(id)['fanart']
				
			fanart = cover
			
			listitem = xbmcgui.ListItem(Title, iconImage=cover, thumbnailImage=cover)
			listitem.setInfo(type = "Video", infoLabels = info)
			try: listitem.setArt({ 'poster': cover, 'fanart' : cover, 'thumb': cover, 'icon': cover})
			except: pass
			listitem.setProperty('fanart_image', fanart)
			
			purl = sys.argv[0] + '?mode='+mode+'&id='+ep
			if url !="": purl = purl +'&url='+urllib.quote_plus(url)
			
			try:type=info["type"]
			except:type=''
			xbmcplugin.addDirectoryItem(handle, purl, listitem, True, total)

def AddPerson(info):
		try:PL=eval(__settings__.getSetting("PersonLst"))
		except: PL=[]
		if info not in PL: 
			PL.append(info)
			__settings__.setSetting(id="PersonLst", value=repr(PL))

def RemovePerson(info):
		try:PL=eval(__settings__.getSetting("PersonLst"))
		except: PL=[]
		NL=[]
		for i in PL:
				if i!=info: NL.append(i)
		__settings__.setSetting(id="PersonLst", value=repr(NL))

def PersonList():
		try:PL=eval(__settings__.getSetting("PersonLst"))
		except: PL=[]
		for i in PL:
			id = i['id']
			AddItem(i["title"], "PersonFilm", id, '',len(PL))

def Person():
	pass

def get_info(ID):
	try:
			info=eval(xt(get_inf_db(ID)))
			deb_print ('KP get_info ОК')
			return info
	except:
			#if __settings__.getSetting("LocalMod")=='true': return {"title": ID, "originaltitle":ID, "rating":0, "cover":icon, "type":'', "id":ID}
			try:    
				info = tvfeed.get_info('https://tvfeed.in/serial/'+ID+'/')
				print info
			except: return {"title": ID, "originaltitle":ID, "rating":0, "cover":icon, "type":'', "id":ID}
			try:
				print "ADD: " + ID
				add_to_db(ID, repr(info))
			except:
				print "ERR: " + ID
				#print repr(info)
			deb_print ('return info')
			return info

def mont2num(dt):
	L1=[' января ',' февраля ',' марта ',' апреля ',' мая ',' июня ',' июля ',' августа ',' сентября ',' октября ',' ноября ',' декабря ']
	L2=['.01.','.02.','.03.','.04.','.05.','.06.','.07.','.08.','.09.','.10.','.11.','.12.']
	for i in range (0,12):
		dt=dt.replace(L1[i], L2[i])
	return dt

#==============  Menu  ====================
def Root():
	#get_all_serials()
	#AddItem("Поиск", "Search")
	AddItem("Все сериалы", "Serials")
	AddItem("Популярные", "Popular")
	AddItem("Новинки", "New")
	AddItem("Жанры", "Genres")
	AddItem("Подборки", "TopLists")
	AddItem("Рекомендуем", "Recommend")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

def Search():
	SrcNavi(inputbox())

def get_all_serials():
	LL=[]
	for i in range(1,38):
		print i
		url='https://tvfeed.in/serial/newest/?page='+str(i)
		L=tvfeed.get_list(url)
		for curl in L:
			id=get_id(curl)
			LL.append(id)
			#print id
			#info=get_info(id)
	
	item=repr(LL)
	rem_inf_db('tvfeed')
	add_to_db('tvfeed', item)

def Serials():
	L=eval(get_inf_db('tvfeed'))
	#n=0
	for id in L:
		#n+=1
		#if n>650: return
		info=get_info(id)
		
		AddItem(info['title'], "Episodes", id, '', len(L))

def Genres():
	L=tvfeed.get_genres_list()
	for info in L:
		AddItem(info['title'], "Genre", '0', 'https://tvfeed.in'+info['url']+'serial/', len(L), 'https://tvfeed.in'+info['cover'])

def TopLists():
	L=tvfeed.get_collection()
	for info in L:
		AddItem(info['title'], "Genre", '0', 'https://tvfeed.in'+info['url']+'serial/', len(L), 'https://tvfeed.in'+info['cover'])

def PersonSearch():
	PS=inputbox()
	#link='https://www.kinopoisk.ru/index.php?first=no&what=&kp_query='+urllib.quote(PS)
	link='https://www.kinopoisk.ru/s/type/people/list/1/find/'+urllib.quote(PS)+'/?force-version=touch'
	#print link
	http = GET (link, 'https://www.kinopoisk.ru/?force-version=touch')
	#debug (http)
	ss='<p class="name">'
	es='<span class="year">'
	l1=mfindal(http,ss,es)
	for i in l1:
			#print i
			id=mfind(i, '/name/', '/sr').replace('/name/','')
			nm=fs(mfind(i, 'type="person">', '</a>').replace('type="person">',''))
			#print id+' '+nm
			if len(nm)>0 and len(id)>0 :AddItem(xt(nm), "PersonFilm", id,'', len(l1))
	#debug (http)

def Navigator(url):
	Ls=eval(get_inf_db('tvfeed'))
	upd=False
	
	L=tvfeed.get_list(url)
	for curl in L:
		id=get_id(curl)
		if id not in Ls: 
			Ls.append(id)
			upd=True
		info=get_info(id)
		AddItem(info['title'], "Episodes", id, '', len(L))
	
	if upd:
		item=repr(Ls)
		rem_inf_db('tvfeed')
		add_to_db('tvfeed', item)


def Top():
	L=tvfeed.get_top()
	for curl in L:
		id=get_id(curl)
		info=get_info(id)
		AddItem(info['title'], "Episodes", id, '', len(L))

def Episodes(id):
	url='https://tvfeed.in/serial/'+id+'/series/'
	L=tvfeed.get_episodes(url)
	s=0
	for info in L:
		curl=info['url']
		info['id']=get_id(curl)
		season=info['season']
		if s!=int(season) and __settings__.getSetting("season")=='true': AddItem('[COLOR FF22FF22] '+season+' сезон[/COLOR]', "off", '0', '', len(L))
		s=int(season)
		title=info['season']+'x'+info['episode']+"  "+info['title']#+"      "+info['date']
		AddEpisode(title, "Quality", info, 'https://tvfeed.in'+curl, len(L))

def Quality(url, ep):
	L=tvfeed.get_quality(url)
	for info in L:
		L2=info['quality']
		img='https://tvfeed.in'+info['cover']
		id=get_id(url)
		for q in L2:
			if 'SD' in q: curl='https://tvfeed.in'+info['url']+'external/?q=sd'
			if 'HD' in q: curl='https://tvfeed.in'+info['url']+'external/?q=hd'
			AddItem(info['title']+" "+q, "Play", ep, curl, len(L), img)

def Play(url, ep, id=''):
	progressBar = xbmcgui.DialogProgress()
	progressBar.create('ACE Stream', 'Запуск')
	ASE_start()
	
	as_url=tvfeed.get_stream(url, ep)
	if url!='':
		json=eval(GET(as_url).replace('null','"null"'))["response"]
		progressBar.update(0, 'ACE Stream', 'Контент найден', "")
		stat_url=json["stat_url"]
		stop_url=json["command_url"]+'?method=stop'
		url=json["playback_url"]
		
		progressBar.update(0, 'ACE Stream', 'Подключение', "")
		while not xbmc.abortRequested:
			xbmc.sleep(500)
			j=eval(GET(stat_url).replace('null','"null"'))["response"]
			print j
			if j=={}:
				pass
				progressBar.update(0, 'ACE Stream', 'Ожидание', "")
			else:
				status=j['status']
				if status=='dl': break
				try:
					download=j['downloaded']
					progress=j['total_progress']
					seeds=j['peers']
					speed=j['speed_down']
					progressBar.update(progress*10, xt('Предварительная буферизация: '+str(download/1024/1024)+" MB"), "Сиды: "+str(seeds), "Скорость: "+str(speed)+' Kbit/s')
				except: pass
			if progressBar.iscanceled():
				progressBar.update(0)
				progressBar.close()
				GET(stop_url)
				return
		
		progressBar.update(0)
		progressBar.close()

		item = xbmcgui.ListItem(path=url)
		xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
		#xbmc.Player().play(url)
		xbmc.sleep(1000)
		
		while not xbmc.abortRequested and xbmc.Player().isPlaying():
						xbmc.sleep(500)
		GET(stop_url)
	else:
		showMessage('TVFeed','Поток не найден')

def get_id(url):
	return mfind(url,'serial/','/')

def Torrents(id, additm=True):
	offlist=[]
	if __settings__.getSetting("Serv1")=='false': offlist.append('rutor')
	if __settings__.getSetting("Serv2")=='false': offlist.append('fasttor')
	if __settings__.getSetting("Serv3")=='false': offlist.append('freebfg')
	if __settings__.getSetting("Serv4")=='false': offlist.append('torrentino')
	if __settings__.getSetting("Serv5")=='false': offlist.append('fileek')
	info=get_info(id)
	sys.path.append(os.path.join(addon.getAddonInfo('path'),"src"))
	ld=os.listdir(os.path.join(addon.getAddonInfo('path'),"src"))
	L2=[]
	Lz=[]
	for i in ld:
		off = True
		for sr in offlist:
			if sr in i: off = False
		if i[-3:]=='.py' and off: 
			exec ("import "+i[:-3]+"; skp="+i[:-3]+".Tracker()")
			try:
				exec ("import "+i[:-3]+"; skp="+i[:-3]+".Tracker()")
				L = skp.Search(info)
			except: L=[]
			for D in L:
				url = D['url']
				try:    tor_title=D['title'].encode('utf-8').replace("«",'').replace("»",'').replace('"', '')
				except: tor_title=D['title'].replace("«",'').replace("»",'').replace('"', '')
				deb_print (lower(tor_title))
				ru_title=xt(info['title']).replace("«",'').replace("»",'').replace('"', '')
				deb_print (lower(ru_title))
				en_title=info['originaltitle'].replace("«",'').replace("»",'').replace('"', '')
				year=str(info['year'])
				year2=str(int(info['year'])+1)
				#if 1==1:
				if (lower(ru_title) in lower(tor_title) or ru_title in tor_title) and (year in tor_title or year2 in tor_title or info['type']!=''):
					deb_print ('Название соответствует')
					size = D['size']
					if 'MB' in size and '.' in size: size=size[:size.find('.')]
					size = size.replace('GB','').replace('MB','').strip()
					if size not in Lz or __settings__.getSetting("CutSize") == 'false':
						Lz.append(size)
						Z=D['size']
						if 'GB' in Z and Z.find('.') == 2: Z=Z[:3]+Z[4:]
						title=xt(mid(Z, 10))+" | "+xt(mids(D['sids'], 6))+" | "+xt(D['title'])
						title=get_label(xt(D['title']))+" "+title
						if additm:
							if __settings__.getSetting("SortLst") == 'true' and info['type']=='':
								pr=fnd(D)
								#ratio=str(get_rang(D))+" "
								if pr: title=FC(title, 'FEFFFFFF')
								else:  title=FC(title.replace("[COLOR F", "[COLOR 7"), 'FF777777')
							AddItem(title, "OpenTorrent", id, url)
						L2.append(D)
				#print D
	return L2
def get_label(text):
	text=lower(text)#.lower()
	#print text
	if 'трейлер'  in text: return FC('[ Трейл.]',    'FF999999')
	if ' кпк'     in text: return FC('[   КПК  ]',   'FFF8888F')
	if 'telesyn'  in text: return FC('[    TS    ]', 'FFFF2222')
	if 'telecin'  in text: return FC('[    TS    ]', 'FFFF2222')
	if 'camrip'   in text: return FC('[    TS    ]', 'FFFF2222')
	if ' ts'      in text: return FC('[    TS    ]', 'FFFF2222')
	if 'dvdscr'   in text: return FC('[    Scr   ]', 'FFFF2222')
	if ' 3d'      in text: return FC('[    3D    ]', 'FC45FF45')
	if '720'      in text: return FC('[  720p  ]',   'FBFFFF55')
	if '1080'     in text: return FC('[ 1080p ]',    'FAFF9535')
	if 'blu-ray'  in text: return FC('[  BRay  ]',   'FF5555FF')
	if 'bdremux'  in text: return FC('[    BD    ]', 'FF5555FF')
	if ' 4k'      in text: return FC('[    4K    ]', 'FF5555FF')
	if 'bdrip'    in text: return FC('[ BDRip ]',    'FE98FF98')
	if 'drip'     in text: return FC('[ BDRip ]',    'FE98FF98')
	if 'hdrip'    in text: return FC('[ HDRip ]',    'FE98FF98')
	if 'webrip'   in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'WEB'      in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'web-dl'   in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'hdtv'     in text: return FC('[ HDTV ]',     'FEFFFF88')
	if 'tvrip'    in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'satrip'   in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'dvb '     in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'dvdrip'   in text: return FC('[DVDRip]',     'FE88FFFF')
	if 'dvd5'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'xdvd'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd-5'    in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd-9'    in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd9'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	return FC('[   ????  ]', 'FFFFFFFF')



def SetViewMode(n):
	if n>0:
		xbmc.executebuiltin("Container.SetViewMode(0)")
		for i in range(1,n):
			xbmc.executebuiltin("Container.NextViewMode")





def ASE_start():
	srv='127.0.0.1'#__settings__.getSetting("p2p_serv")
	prt='6878'#__settings__.getSetting("p2p_port")
	lnk='http://'+srv+':'+prt+'/webui/api/service?method=get_version&format=jsonp&callback=mycallback'#getstream?id='+CID
	pDialog = xbmcgui.DialogProgressBG()
	resp=GET(lnk)
	if resp != '':
		return False
	else:
		#showMessage('Пазл ТВ', 'Запуск Ace Stream')
		pDialog.create('TVFeed', 'Запуск Ace Stream ...')
		pDialog.update(0, message='Запуск Ace Stream ...')
		start_linux()
		start_windows()
		for i in range (0,10):
			pDialog.update(i*10, message='Запуск Ace Stream ...')
			xbmc.sleep(1500)
			resp=GET(lnk)
			if resp != '':
				pDialog.close()
				return True
		pDialog.close()
		return False

def start_linux():
        import subprocess
        try:
            subprocess.Popen(['acestreamengine', '--client-console'])
        except:
            try:
                subprocess.Popen('acestreamengine-client-console')
            except: 
                try:
                    xbmc.executebuiltin('XBMC.StartAndroidActivity("org.acestream.media")')
                    xbmc.sleep(2000)
                    xbmc.executebuiltin('XBMC.StartAndroidActivity("org.xbmc.kodi")')
                except:
                    return False
        return True
    
def start_windows():
        try:
            import _winreg
            try:
                t = _winreg.OpenKey(_winreg.HKEY_CURRENT_USER, r'Software\AceStream')
            except:
                t = _winreg.OpenKey(_winreg.HKEY_CURRENT_USER, r'Software\TorrentStream')
            path = _winreg.QueryValueEx(t, r'EnginePath')[0]
            os.startfile(path)
            return True
        except:
            return False


try:    mode = urllib.unquote_plus(get_params()["mode"])
except: mode = None
try:    url = urllib.unquote_plus(get_params()["url"])
except: url = None
try:    info = eval(urllib.unquote_plus(get_params()["info"]))
except: info = {}
try:    id = str(get_params()["id"])
except: id = '0'
try:    ind = int(get_params()["ind"])
except: ind = 0


if mode == None:
	Root()

if mode == "Search":
	Search()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)


if mode == "Serials":
	Serials()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Genres":
	Genres()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Genre":
	Navigator(url)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Popular":
	Top()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "New":
	Navigator('https://tvfeed.in/serial/newest/')
	#Navigator('https://tvfeed.in/serial/newest/?page=2')
	#Navigator('https://tvfeed.in/serial/newest/?page=3')
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "Recommend":
	Navigator('https://tvfeed.in/serial/recommended/')
	Navigator('https://tvfeed.in/serial/recommended/?page=2')
	Navigator('https://tvfeed.in/serial/recommended/?page=3')
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewSerial")))

if mode == "TopLists":
	TopLists()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)


if mode == "Episodes":
	xbmcplugin.setContent(int(sys.argv[1]), 'episodes')
	Episodes(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)
	#xbmc.sleep(300)
	SetViewMode(int(__settings__.getSetting("ViewEpisode")))

if mode == "Quality":
	Quality(url, id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Play":
	Play(url, id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)







if mode == "Future":
	Navigator("Future")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Recomend":
	Navigator("Recomend")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "PersonFilm":
	Navigator("PersonFilm")#+PeID
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Person":
	Person()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "PersonList":
	AddItem("[ Поиск ]", "PersonSearch")
	PersonList()
	xbmcplugin.addSortMethod(int(sys.argv[1]), xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "PersonSearch": 
	PersonSearch()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "AddPerson": 
	AddPerson(info)

if mode == "RemovePerson": 
	RemovePerson(info)
	xbmc.executebuiltin("Container.Refresh()")

if mode == "SelCat":
	import SelectBox
	SelectBox.run("CatList")

if mode == "SelGenre":
	import SelectBox
	SelectBox.run("GenreList")

if mode == "SelCantry":
	import SelectBox
	SelectBox.run("CantryList")
	
if mode == "SelYear":
	sel = xbmcgui.Dialog()
	r = sel.select("Десятилетие:", Year)
	__settings__.setSetting(id="YearList", value=Year[r])

if mode == "SelOld":
	sel = xbmcgui.Dialog()
	r = sel.select("Возраст:", Old)
	__settings__.setSetting(id="OldList", value=Old[r])

if mode == "SelSort":
	sel = xbmcgui.Dialog()
	r = sel.select("Десятилетие:", Sort)
	__settings__.setSetting(id="SortList", value=Sort[r])

if mode == "SelRating":
	sel = xbmcgui.Dialog()
	r = sel.select("Десятилетие:", Rating)
	__settings__.setSetting(id="RatingList", value=Rating[r])

if mode == "Torrents" or mode == "Torrents2":
	Torrents(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	xbmc.sleep(300)
	SetViewMode()
	#xbmc.executebuiltin("Container.SetViewMode(51)")

if mode == "OpenTorrent":
	OpenTorrent(url, id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)


if mode == "PlayTorrent":
	progressBar = xbmcgui.DialogProgress()
	progressBar.create('Кинопоиск', 'Запуск сохраненного файла')
	cancel=False
	for i in range (0,5):
		progressBar.update(20*i, '', '[B]Нажмите "Отмена" для выбора качества[/B]')
		xbmc.sleep(600)
		if progressBar.iscanceled():
					progressBar.update(0)
					cancel=True
					break
	progressBar.close()
	if cancel: 
		xbmc.executebuiltin('ActivateWindow(10025,"plugin://plugin.video.KinoPoisk.ru/?mode=Torrents&id='+id+'", return)')
		xbmc.executebuiltin("Container.Refresh()")
	else: play(url, ind, id)

if mode == "PlayTorrent2":
	play(url, ind, id)

if mode == "play_url2": #совместимость с 1.0
	url = urllib.unquote_plus(get_params()["torr_url"])
	play(url, ind, id)

if mode == "Add2List":
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	if id not in L:
		L.append(id)
		__settings__.setSetting("W_list", repr(L))

if mode == "RemItem":
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	L.remove(id)
	__settings__.setSetting("W_list", repr(L))
	xbmc.executebuiltin("Container.Refresh()")

if mode == "Wish_list":
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	for id in L:
		info=get_info(str(id))
		rus=info["title"]
		AddItem(rus, 'Wish', id)
	xbmcplugin.endOfDirectory(handle)

if mode == "Wish":
	Torrents(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	xbmc.sleep(300)
	SetViewMode()
	#xbmc.executebuiltin("Container.SetViewMode(51)")

if mode == "update_info":
	update_info(id)

if mode == "TopLists":
	TopLists()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "OpenTopList":
	SrcNavi("OpenTopList")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "PlayTrailer":
	trailer=get_trailer(id)
	if trailer!='':
		info=get_info(str(id))
		cover=info['cover']
		title=info['title']
		listitem = xbmcgui.ListItem("trailer", path=trailer,iconImage=cover, thumbnailImage=cover)
		listitem.setInfo(type = "Video", infoLabels = get_labels(info))
		xbmc.Player().play(trailer, listitem)
		xbmcplugin.endOfDirectory(handle, False, False)

if mode == "Save_strm":
	if __settings__.getSetting("NFO2")=='true': save_film_nfo(id)
	save_strm (url, 0, id)

if mode == "check":
	check()

if mode == "Review":
	review(id)

if mode == "Autoplay":
	autoplay(id)

c.close()
#print (get_info_kinodb('375'))