# -*- coding: utf-8 -*-
import libMediathek
import xbmc
import xbmcplugin
import xbmcgui
import json
import urllib2
LIVE_streams = [
	['ARD Livestream','http://ndr_events-lh.akamaihd.net/i/ndrevent_1@119220/master.m3u8'],
	#['ZDF','http://zdf1314-lh.akamaihd.net/i/de14_v1@392878/master.m3u8?dw=0'],
]
ZDF_HLS_streams = [
	['ZDF','http://zdf1314-lh.akamaihd.net/i/de14_v1@392878/master.m3u8?dw=0'],
	['Olympia 1','http://zdf0304-lh.akamaihd.net/i/de03_v1@392855/master.m3u8?dw=0'],
	['Olympia 2','http://zdf0304-lh.akamaihd.net/i/de04_v1@392856/master.m3u8?dw=0'],
	['Olympia 3','http://zdf0506-lh.akamaihd.net/i/de05_v1@392857/master.m3u8?dw=0'],
	['Olympia 4','http://zdf0506-lh.akamaihd.net/i/de06_v1@392858/master.m3u8?dw=0'],
	['Olympia 5','http://zdf0708-lh.akamaihd.net/i/de07_v1@392868/master.m3u8?dw=0'],
	['Olympia 6','http://zdf0708-lh.akamaihd.net/i/de08_v1@392869/master.m3u8?dw=0'],
]
ARD_HLS_streams = [
	['ZDF','http://zdf1314-lh.akamaihd.net/i/de14_v1@392878/master.m3u8?dw=0'],
	['Olympia 1','http://ndr_spezial-lh.akamaihd.net/i/spezial_1@119227/master.m3u8'],
	['Olympia 2','http://ndr_spezial-lh.akamaihd.net/i/spezial_2@119228/master.m3u8'],
	['Olympia 3','http://ndr_spezial-lh.akamaihd.net/i/spezial_3@119229/master.m3u8'],
	['Olympia 4','http://ndr_spezial-lh.akamaihd.net/i/spezial_4@119230/master.m3u8'],
	['Olympia 5','http://ndr_spezial-lh.akamaihd.net/i/spezial_5@384495/master.m3u8'],
	['Olympia 6','http://ndr_spezial-lh.akamaihd.net/i/spezial_6@364638/master.m3u8'],
]
ARD_DASH_streams = [
	['ZDF','http://zdf1314-lh.akamaihd.net/i/de14_v1@392878/master.m3u8?dw=0'],
	['Olympia 1','http://ndrspezial.edgesuite.net/dash/live/923078/ndrspezial_1/spezial_1.mpd'],
	['Olympia 2','http://ndrspezial.edgesuite.net/dash/live/923079/ndrspezial_2/spezial_2.mpd'],
	['Olympia 3','http://ndrspezial.edgesuite.net/dash/live/254139/ndrspezial_3/spezial_3.mpd'],
	['Olympia 4','http://ndrspezial.edgesuite.net/dash/live/923081/ndrspezial_4/spezial_4.mpd'],
	['Olympia 5','http://ndrspezial.edgesuite.net/dash/live/926240/ndrspezial_5/spezial_5.mpd'],
	['Olympia 6','http://ndrspezial.edgesuite.net/dash/live/926241/ndrspezial_6/spezial_6.mpd'],
]
def main():
	xbmc.log('main')
	response = getUrl('http://rio.zdf.de/feeds/epgchannels/time/')
	j = json.loads(response)
	j1 = j["epgchannels"]["data"]
	for name,url in LIVE_streams:
		libMediathek.addEntry({'name':name,'url':url,'mode':'play','type':'video'})
	streamtype = xbmcplugin.getSetting(int(sys.argv[1]), 'streamtype')
	xbmc.log(str(streamtype))
	if streamtype == '0':
		streams = ARD_HLS_streams
	if streamtype == '1':
		streams = ARD_DASH_streams
	if streamtype == '2':
		streams = ZDF_HLS_streams
	for name,url in streams:
		added = False
		for entry in j1:
			if entry['station'] == name.lower().replace(' ',''):
				added = True
				dict = {}
				xbmc.log(str(entry))
				if name == 'ZDF':
					name += ' Livestream'
				if 'title' in entry: dict['name'] = name + ' - ' + entry['title']
				if 'thumbnails' in entry: dict['thumb'] = entry['thumbnails'][0]['url'].replace('//','http://')
				if 'text' in entry: dict['plot'] = entry['text'].replace('<br />','\n')
				if 'presenter' in entry and entry['presenter'] != None: 
					if not 'plot' in dict:
						dict['plot'] = 'Kommentator: ' + entry['presenter']
					else:
						dict['plot'] += '\n\nKommentator: ' + entry['presenter']
				dict['url'] = url
				dict['mode'] = 'play'
				dict['type'] = 'video'
				xbmc.log(str(dict))
				libMediathek.addEntry(dict)
		if not added:
			libMediathek.addEntry({'name':name,'url':url,'mode':'play','type':'video'})
def play():
	url = params['url']
	listitem = xbmcgui.ListItem(path=url)
	if url.endswith('.mpd'):
		#listitem.setProperty('inputstreamaddon', 'Input Stream')
		listitem.setProperty('inputstreamaddon', 'inputstream.mpd')
	xbmcplugin.setResolvedUrl(pluginhandle, True, listitem)


modes = {
'main': main,
'play': play
}	
def list():	
	global params
	params = libMediathek.get_params()
	global pluginhandle
	pluginhandle = int(sys.argv[1])
	
	if not params.has_key('mode'):
		main()
	else:
		modes.get(params['mode'],main)()
	
	xbmcplugin.endOfDirectory(int(sys.argv[1]))	
	
def getUrl(url):
    xbmc.log(url)
    req = urllib2.Request(url)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; rv:25.0) Gecko/20100101 Firefox/25.0')
    response = urllib2.urlopen(req)
    link = response.read()
    response.close()
    return link

list()