#!/usr/bin/python
# -*- coding: utf-8 -*-

import xbmc, xbmcgui, xbmcaddon, xbmcplugin
import os,sys
import time
import re
import threading
import NicoVideo

screen_width = None
screen_height = None

ACTION_PREVIOUS_MENU = 10 # ･･････ Backキー/MENUキー
ACTION_PARENT_DIR = 9 # ･･････ Bボタン
ACTION_PARENT_DIR_Remote = 39 # ･･････ Back
ACTION_Right_ThumbStick = 265 # 右アナログスティック
ACTION_SHOW_GUI = 18  #X Button
ACTION_MOVE_LEFT = 1 # ･･････ 左移動キー
ACTION_MOVE_RIGHT = 2 # ･･････ 右移動キー
ACTION_MOVE_UP = 3 # ･･････ 上移動キー
ACTION_MOVE_DOWN = 4 # ･･････ 下移動キー
ACTION_SELECT_ITEM = 7 # ･･････ Aボタン
ACTION_HIGHLIGHT_ITEM = 8
ACTION_SHOW_INFO = 11

__settings__ = xbmcaddon.Addon(id='plugin.video.nico')

root_dir = __settings__.getAddonInfo('path')
#root_dir = os.getcwd().replace(";","")
image_dir = os.path.join(root_dir,"Image")
nico_py = os.path.join(root_dir,'NicoCommentView.py')

__settings__ = xbmcaddon.Addon(id='plugin.video.nico')

try: Emulating = xbmcgui.Emulating
except: Emulating = False

class NicoAlert(xbmcgui.WindowDialog):

	closeStop = False
	count = 0.0
	executeScript = False
	loaderImage = None

	def __init__(self):
		global screen_width,screen_height
		if Emulating: xbmcgui.WindowDialog.__init__(self)
#		self.setCoordinateResolution(5) #RES_HDTV_720p
		screen_width = 1280
		screen_height = 720

	def setLiveAlert(self,live_id,title,description,imageFile,alertTime,comment_view,nicoVideo):
		self.scaleX = (screen_width / float(640))
		self.scaleY = (screen_height / float(480))
		self.live_id = live_id
		if imageFile == None or not os.path.exists(imageFile):
			imageFile = os.path.join(image_dir,'noimage.jpg')
		else:
			self.alertTime = alertTime
		self.nicoVideo = nicoVideo
		self.imageFile = imageFile
		self.title = title
		self.description = description

		if imageFile == None or not os.path.exists(imageFile):
			imageFile = os.path.join(image_dir,'noimage.jpg')

		self.live_id = live_id
		self.alertTime = alertTime
		self.comment_view = comment_view
		self.nicoVideo = nicoVideo

		self.alertThumb = xbmcgui.ControlImage(int(2*self.scaleX),int(screen_height-27*self.scaleY),int(26*self.scaleX),int(26*self.scaleY), self.imageFile)
		self.alertLabel1 = xbmcgui.ControlTextBox(int(35*self.scaleX),int(screen_height-32*self.scaleY),int(screen_width-65*self.scaleX),int(50*self.scaleY),'font12_title',"0xFFFFFFFF")
		self.alertLabel2 = xbmcgui.ControlTextBox(int(35*self.scaleX),int(screen_height-18*self.scaleY),int(screen_width-65*self.scaleX),int(50*self.scaleY),'font12_title',"0xFFFFFFFF")
		self.alertButton = xbmcgui.ControlButton(int(614 * self.scaleX),int(455*self.scaleY),int(22*self.scaleX),int(22*self.scaleY), r""
													,focusTexture=os.path.join(image_dir,'back-noforcus.png'),noFocusTexture =os.path.join(image_dir,'back-forcus.png')
													)
		self.loaderImage = None
		self.closeThread = threading.Thread(target=self.viewAlert2,args=())
		self.closeThread.setDaemon(True)
		self.closeThread.start()

	def viewAlert1(self):
		self.alertImage = xbmcgui.ControlImage(0, int(screen_height-17*2*self.scaleY),int(screen_width),int(35*self.scaleY), os.path.join(image_dir,'alert-bg.png'))
		self.addControl(self.alertImage)
		self.addControl(self.alertThumb)
		self.addControl(self.alertLabel1)
		self.addControl(self.alertLabel2)
		self.alertLabel1.setText(self.title)
		self.alertLabel2.setText(self.description)
		self.addControl(self.alertButton)
		self.setFocus(self.alertButton)

		while self.closeStop or self.count < self.alertTime :
			time.sleep(0.1)
			if self.count < self.alertTime:
				self.count += 0.1

		self.alertThumb.setVisible(False)
		self.alertLabel1.setVisible(False)
		self.alertLabel2.setVisible(False)
		if self.loaderImage == None:
			self.alertButton.setVisible(False)
		else:
			self.loaderImage.setVisible(False)
		self.alertImage.setVisible(False)

		if self.executeScript:
			time.sleep(10.0)

		self.state = -1 #success
		self.close() #exit

	def viewAlert2(self):
		self.alertImage = xbmcgui.ControlImage(0, int(screen_height),int(screen_width),int(35*self.scaleY), os.path.join(image_dir,'alert-bg.png'))
		self.addControl(self.alertImage)

		for i in range(16):
			self.alertImage.setPosition(0, int(screen_height-(i+1)*2*self.scaleY))
			time.sleep(0.05)

		self.addControl(self.alertThumb)
		self.addControl(self.alertLabel1)
		self.addControl(self.alertLabel2)
		self.alertLabel1.setText(self.title)
		self.alertLabel2.setText(self.description)
		self.addControl(self.alertButton)
		self.setFocus(self.alertButton)

		while self.closeStop or self.count < self.alertTime :
			time.sleep(0.5)
			if self.count < self.alertTime:
				self.count += 0.5

#		self.alertButton.setVisible(False)
		self.alertButton.setPosition(0, int(screen_height + 100))
		self.alertThumb.setVisible(False)
		self.alertLabel1.setVisible(False)
		self.alertLabel2.setVisible(False)

		for i in range(16, 0, -1):
			self.alertImage.setPosition(0, int(screen_height-(i+1)*2*self.scaleY))
			time.sleep(0.05)
		self.alertImage.setVisible(False)

		if self.executeScript:
			time.sleep(10.0)

		self.state = -1 #success
		self.close() #exit

	def onAction(self, action):
#		if action == ACTION_PREVIOUS_MENU or action == ACTION_PARENT_DIR or action == ACTION_MOVE_DOWN:
		if action == ACTION_MOVE_DOWN:
			self.closeStop = False
			self.count = self.alertTime
			return None
		elif action == ACTION_MOVE_UP :
			self.setFocus(self.alertButton)
	def onControl(self, control):
		'''決定キーを押した時の処理'''
		if control == self.alertButton:
			self.closeStop = True
			if not xbmcgui.Dialog().yesno("確認", self.title ,"の放送に移動します。移動してもよろしいですか？"):
				self.closeStop = False
				return None
#			self.alertButton.setVisible(False)
			self.alertButton.setPosition(0, int(screen_height + 100))
			if self.loaderImage == None:
				self.loaderImage = xbmcgui.ControlImage(int(616 * self.scaleX),int(458*self.scaleY),int(16*self.scaleX),int(16*self.scaleY), os.path.join(image_dir,'loader.gif'))
				self.addControl(self.loaderImage)
			else:
				self.loaderImage.setVisible(True)

			try:
				if self.live_id == None:
					time.sleep(5.0)
					xbmcgui.Dialog().ok("","test")
					self.closeStop = False
					return None
				self.nicoVideo.video_id = self.live_id
				retryCount = 3
				while 0 < retryCount:
					body = self.nicoVideo.apiGetPlayerStatus()
					if re.compile('<getplayerstatus ').search(body):
						break
					time.sleep(3.0)
					retryCount -= 1
					body = None
				if body == None:
					xbmcgui.Dialog().ok("エラー","放送情報の取得に失敗しました")
					print "NicoAlert apiGetPlayerStatus Error"
					return None
				result = self.nicoVideo.setGetplayerstatus(getplayerstatus=body)
				if result:
					if NicoVideo.GETPLAYERSTATUS_ERROR_MESSAGE.get(result):
						xbmcgui.Dialog().ok("エラー",NicoVideo.GETPLAYERSTATUS_ERROR_MESSAGE.get(result))
					else:
						xbmcgui.Dialog().ok("エラー","エラーコード:%s が発生しました" % result)
						print "NicoAlert setGetplayerstatus Error:" + result
					return None
				playurl = self.nicoVideo.getLiveVideoUrl()
				if self.nicoVideo.ms_addr == None or self.nicoVideo.ms_port == None or self.nicoVideo.ms_thread == None:
					return None
				while xbmc.Player().isPlaying():
					xbmc.Player().stop()
					time.sleep(0.5)
				xbmc.Player(xbmc.PLAYER_CORE_DVDPLAYER).play(playurl)
				if xbmc.Player().isPlaying():
					self.executeScript = True
					self.closeStop = False
					self.count = self.alertTime
					if self.comment_view:
						xbmc.executebuiltin("XBMC.RunScript(%s,%s,%s,%s,%s)" % (nico_py, self.nicoVideo.ms_addr, self.nicoVideo.ms_port, self.nicoVideo.ms_thread, self.nicoVideo.video_id))
			finally:
#				self.closeStop = False
#				self.alertButton.setVisible(True)
				self.alertButton.setPosition(int(614 * self.scaleX),int(455*self.scaleY))
				self.loaderImage.setVisible(False)
