#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sgmllib
import urllib
import urllib2
import re

class Twitter:
	'''Twitter'''

	def __init__(self):
		self.tweet_ptn = re.compile('<span class="entry-content">(.*)</span>')
		self.icon_ptn = re.compile('<img .*src="(.*profile_images/.*[png|PNG])"')

	def getTweet(self, user, page=1):
		try:
			open = urllib2.urlopen('http://twitter.com/%s?page=%s' % (user,page))
		except:
			return None
		buf = open.read()
		resultList = list()
		for m in self.tweet_ptn.finditer(buf):
			resultList.append(m.group(1))
		return resultList

	def getIcon(self, user):
		try:
			open = urllib2.urlopen('http://twitter.com/%s' % (user))
		except:
			return None
		buf = open.read()
		m = self.icon_ptn.search(buf)
		url = m.group(1)
		return url



DEF_headers = {'User-Agent':'Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2',
	'Accept': '*/*',
	'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
	'Accept-Charset': 'UTF-8,*',
	'Connection': 'keep-alive',
	'Keep-Alive': '300'}

class Stripper(sgmllib.SGMLParser):
	def __init__(self):
		sgmllib.SGMLParser.__init__(self)

	def strip(self, html):
		self.theString = ""
		self.feed(html)
		self.close()
		return self.theString

	def handle_data(self, data):
		self.theString += data

# Twitterのつぶやきを扱うためのクラス
class TwitterSearch:

	def __init__(self):
		pass

	def getTwitterSearch(self, userid, keyword, page):
		query = 'query=http%3A//nico.ms/'
		if userid != None:
			query += '+user:%s' %userid

		if keyword != None:
			query +=  '+%s' % urllib.quote_plus(keyword)
		url = "http://yats-data.com/yats/search?%s&lang=ja&page=%s" % (query , str(page))
		try:
			open = urllib2.urlopen(url)
		except:
			return None
		body = open.read()
#		print body
		return self.parceTwitterSearch(body)

	def parceTwitterSearch(self, body):
		counts = 0
		counts_m = re.compile('<span class="counts">.*<strong>>([0-9]*)</strong>').search(body)
		if counts_m:
			counts = int(counts_m.group(1))

		stripper = Stripper()

		info_re_str = r'(?s)<span class="user">.*?<a .*?>(.*?)</a>.*?<abbr.*?>(.*?)</abbr>.*?<div class="status entry-title"><span.*?>(.*?)</span></div>'
		link_re_str = r'href="http://nico.ms/(.*?)"'
		userid_list = []
		date_list = []
		regist_sm_num = []
		title_list = []
		info_re = re.compile(info_re_str)
		link_re = re.compile(link_re_str)
		for m in info_re.finditer(body):
			userid = m.group(1)
			dateStr = m.group(2)
			title = m.group(3)
			title_rep = stripper.strip(title)
			for m2 in link_re.finditer(title):
				userid_list.append(userid)
				date_list.append(dateStr)
				title_list.append(title_rep)
				regist_sm_num.append(m2.group(1))

		return counts,userid_list,date_list,regist_sm_num,title_list


if '__main__' == __name__:
	twitter = Twitter()
#	resultList = twitter.getTweet('nico_ran')
#	if list:
#		for result in resultList:
#			after = re.sub("<(\"[^\"]*\"|'[^']*'|[^'\">])*>", r'', result)
#			print after
	print twitter.getIcon('nico_ran')

#	open = urllib2.urlopen('http://bit.ly/eKNZSq')
#	buf = open.read()
#	print buf