#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
import time
import httplib

DEF_headers = {'User-Agent':'Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2',
	'Accept': '*/*',
	'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
	'Accept-Charset': 'UTF-8,*',
	'Connection': 'keep-alive',
	'Keep-Alive': '300'}

# マイリストランキング(http://nico.tgd.jp)の情報を扱うためのクラス
class NiconicoFarm:

	def __init__(self):
		pass

	def getHTML(self, url):
		try:
			url = re.compile('^http://nico.tgd.jp(.+)$').match(url).group(1)
		except:
			print u'nico.tgdのURLではありません'
			return None
		conn=httplib.HTTPConnection('nico.tgd.jp', 80)
		rs = self.retryingAccess(conn, ('GET', url, '', DEF_headers))
		body = rs.read()
		rs.close()
		conn.close()
		return body


	def getAverageMylist(self, cate, page):
		url = "http://nico.tgd.jp/mylist/?c="+str(cate)+"&s=average_mylist&start="+str(page*50)
		return self.parceAverageMylist(self.getHTML(url))

	def parceAverageMylist(self, body):
		#info_re_str = r'<a href="http://nico.tgd.jp/mylist/detail/\?id=([0-9]*)">(.*)</a></b> \(([0-9]*)\)\s*.*\s*<tr><td>カテゴリ</td><th width="120">(.*)</th></tr>\s*<tr><td>編集者</td><th>(.*)</th></tr>\s*.*\s*.*\s*.*\s.*\s*.*\s*.*\s*.*\s*.*\s*<tr><td>平均再生数</td><th width="70">(.*)</th></tr>\s*<tr><td>平均コメ数</td><th>(.*)</th></tr>\s*<tr><td>平均マイリス数</td><th>(.*)</th></tr>\s*.*\s*.*\s*.*\s*.*\s*<tr><td>全再生数</td><th width="80">(.*)</th></tr>\s*<tr><td>全コメ数</td><th>(.*)</th></tr>\s*<tr><td>全マイリス数</td><th>(.*)</th></tr>\s*.*\s*.*\s*.*\s*.*\s*<tr><td>コメ率</td><th width="80">(.*)</th></tr>\s*<tr><td>マイリス率</td><th>(.*)</th></tr>'
		info_re_str = r'<a href="http://nico.tgd.jp/mylist/detail/\?id=([0-9]*)">(.*)</a></b> \(([0-9]*)\)\s*.*\s*<tr><td>.*</td><th width="120">(.*)</th></tr>\s*<tr><td>.*</td><th>(.*)</th></tr>\s*.*\s*.*\s*.*\s.*\s*.*\s*.*\s*.*\s*.*\s*<tr><td>.*</td><th width="70">(.*)</th></tr>\s*<tr><td>.*</td><th>(.*)</th></tr>\s*<tr><td>.*</td><th>(.*)</th></tr>\s*.*\s*.*\s*.*\s*.*\s*<tr><td>.*</td><th width="80">(.*)</th></tr>\s*<tr><td>.*</td><th>(.*)</th></tr>\s*<tr><td>.*</td><th>(.*)</th></tr>\s*.*\s*.*\s*.*\s*.*\s*<tr><td>.*</td><th width="80">(.*)</th></tr>\s*<tr><td>.*</td><th>(.*)</th></tr>'
		mylist_list = []
		regist_sm_num = []
		# タイトル,カテゴリ,編集者
		tce_list = []
		# 平均再生数,平均コメ数,平均マイリス数
		num_average_list = []
		# 全再生数,全コメ数,全マイリス数
		num_total_list = []
		# コメ率,マイリス率
		num_rate_list = []
		info_re = re.compile(info_re_str)
		for m in info_re.finditer(body):
			mylist_list.append(m.group(1))
			regist_sm_num.append(m.group(2))
			tce_list.append([m.group(3),m.group(4),m.group(5)])
			num_average_list.append([m.group(6),m.group(7),m.group(8)])
#			num_total_list.append([m.group(9),m.group(10),m.group(12)])
#			num_rate_list.append([m.group(13),m.group(14)])

		return mylist_list,regist_sm_num,tce_list,num_average_list,num_total_list,num_rate_list

	def retryingAccess(self, conn, request_args, retry=2, wait=5):
		rs = None
		while 0<retry:
			try:
				method, path, body, headers = request_args
				conn.request(method, path, body, headers)
				rs = conn.getresponse()
				break
			except Exception, e:
				print e
				print 'getresponse failed. waiting for %d seconds..' % wait
				time.sleep(wait)
				conn.close()
				retry -= 1

		return rs