#!/usr/bin/python
# -*- coding: utf-8 -*-

import xbmc, xbmcgui, xbmcaddon, xbmcplugin
import os,sys
import time, random
import re
import threading
import math
import urllib
#import gc,codecs,thread

import NicoVideo
import NicoAlert
import Chikuwachan

ACTION_PREVIOUS_MENU = 10 # ･･････ Backキー/MENUキー
ACTION_PARENT_DIR = 9 # ･･････ Bボタン
ACTION_PARENT_DIR_Remote = 39 # ･･････ Back
ACTION_Right_ThumbStick = 265 # 右アナログスティック
ACTION_SHOW_GUI = 18  #X Button
ACTION_MOVE_LEFT = 1 # ･･････ 左移動キー
ACTION_MOVE_RIGHT = 2 # ･･････ 右移動キー
ACTION_MOVE_UP = 3 # ･･････ 上移動キー
ACTION_MOVE_DOWN = 4 # ･･････ 下移動キー
ACTION_SELECT_ITEM = 7 # ･･････ Aボタン
ACTION_HIGHLIGHT_ITEM = 8
ACTION_SHOW_INFO = 11

FONT_PREFIX = "nico_font_"
MOST_SMALL_FONT = "nico_font_24"
MOST_SMALL_FONT_SIZE = 24;

# コマンド
COMMAND_naka = 'naka[ "]' # 動画を普通に右から左へ文字が流れる（普通）
COMMAND_ue = 'ue[ "]' # コメントが画面上部中央に表示される
COMMAND_shita = 'shita[ "]' # コメントが画面下部中央に表示される

COMMAND_big = "big" # コメントの文字サイズが大きくなる
COMMAND_medium = "medium" # コメントの文字サイズが普通になる（普通）
COMMAND_small = "small" # コメントの文字サイズが小さくなる

COMMAND_niconicowhite = "niconicowhite" # コメントの文字色がニコニコホワイト(#CCCC99)になる
COMMAND_white2 = "white2" #
COMMAND_truered = "truered" # コメントの文字色がトゥルーレッド(#CC0033)になる
COMMAND_red2 = "red2" #
COMMAND_passionorange = "passionorange" # コメントの文字色がパッションオレンジ(#FF6600)になる
COMMAND_orange2 = "orange2" #
COMMAND_madyellow = "madyellow" # コメントの文字色がマッドイエロー(#999900)になる
COMMAND_yellow2 = "yellow2" #
COMMAND_elementalgreen = "elementalgreen" # コメントの文字色がエレメンタルグリーン(#00CC66)になる
COMMAND_green2 = "green2" #
COMMAND_marineblue = "marineblue" # コメントの文字色がマリンブルー(#33FFFC)になる
COMMAND_blue2 = "blue2" #
COMMAND_nobleviolet = "nobleviolet" # コメントの文字色がノーブルバイオレット(#6633CC)になる
COMMAND_purple2 = "purple2" #

COMMAND_white2_color = "0xFFCCCC99"# ニコニコホワイト
COMMAND_red2_color = "0xFFCC0033" # トゥルーレッド
COMMAND_orange2_color = "0xFFFF6600" # パッションオレンジ
COMMAND_yellow2_color = "0xFF999900" # マッドイエロー
COMMAND_green2_color = "0xFF00CC66" # エレメンタルグリーン
COMMAND_blue2_color = "0xFF33FFFC" # マリンブルー
COMMAND_purple2_color = "0xFF6633CC" # ノーブルバイオレット

COMMAND_white = "white" # コメントの文字色が白色になる
COMMAND_red = "red" # コメントの文字色が赤色になる
COMMAND_pink = "pink" # コメントの文字色が桃色になる
COMMAND_orange = "orange" # コメントの文字色が橙色になる
COMMAND_yellow = "yellow" # コメントの文字色が黄色になる
COMMAND_green = "green" # コメントの文字色が緑色になる
COMMAND_cyan = "cyan" # コメントの文字色が水色になる
COMMAND_blue = "blue" # コメントの文字色が青色になる
COMMAND_purple = "purple" # コメントの文字色が紫色になる
COMMAND_black = "black" # コメントの文字色が黒色になる

COMMAND_white_color = "0xFFFFFFFF"# 白色
COMMAND_red_color = "0xFFFF0000" # 赤色
COMMAND_pink_color = "0xFFFF8080" # 桃色
COMMAND_orange_color = "0xFFFFCC00" # 橙色
COMMAND_yellow_color = "0xFFFFFF00" # 黄色
COMMAND_green_color = "0xFF00FF00" # 緑色
COMMAND_cyan_color = "0xFF00FFFF" # 水色
COMMAND_blue_color = "0xFF0000FF" # 青色
COMMAND_purple_color = "0xFFC000FF" # 紫色
COMMAND_black_color = "0xFF000000" # 黒色

colors={}
colors[COMMAND_niconicowhite] = COMMAND_white2_color
colors[COMMAND_white2] = COMMAND_white2_color
colors[COMMAND_truered] = COMMAND_red2_color
colors[COMMAND_red2] = COMMAND_red2_color
colors[COMMAND_passionorange] = COMMAND_orange2_color
colors[COMMAND_orange2] = COMMAND_orange2_color
colors[COMMAND_madyellow] = COMMAND_yellow2_color
colors[COMMAND_yellow2] = COMMAND_yellow2_color
colors[COMMAND_elementalgreen] = COMMAND_green2_color
colors[COMMAND_green2] = COMMAND_green2_color
colors[COMMAND_marineblue] = COMMAND_blue2_color
colors[COMMAND_blue2] = COMMAND_blue2_color
colors[COMMAND_nobleviolet] = COMMAND_purple2_color
colors[COMMAND_purple2] = COMMAND_purple2_color
colors[COMMAND_white] = COMMAND_white_color
colors[COMMAND_red] = COMMAND_red_color
colors[COMMAND_pink] = COMMAND_pink_color
colors[COMMAND_orange] = COMMAND_orange_color
colors[COMMAND_yellow] = COMMAND_yellow_color
colors[COMMAND_green] = COMMAND_green_color
colors[COMMAND_cyan] = COMMAND_cyan_color
colors[COMMAND_blue] = COMMAND_blue_color
colors[COMMAND_purple] = COMMAND_purple_color
colors[COMMAND_black] = COMMAND_black_color

DEF_COLORS = ["0xFFFFFFFF","0xFF000000","0xFFFF0000","0xFF00FF00","0xFF0000FF","0xFF808080"] # 表示色配列

# 画面上を流れるコメントはvposより1秒前に右側から表示(vpos=100ms)
TIME_LAG = 100

#コメント表示位置の定数
Y_POSI_UE = 1
Y_POSI_SHITA = 2

__settings__ = xbmcaddon.Addon(id='plugin.video.nico')

base_cache_path = os.path.join( xbmc.translatePath( "special://masterprofile/" ), "addon_data", os.path.basename( __settings__.getAddonInfo('path') ) )
root_dir = __settings__.getAddonInfo('path')
#root_dir = os.getcwd().replace(";","")
stream_dir = os.path.join(base_cache_path,'stream')
debug_dir = os.path.join(base_cache_path,'debug')
image_dir = os.path.join(root_dir,"Image")

chicon_dir = os.path.join(base_cache_path,'chicon')
coicon_dir = os.path.join(base_cache_path,'coicon')
lvtbn_dir = os.path.join(base_cache_path,'lvthumb')

nico_py = os.path.join(root_dir,'NicoCommentView.py')

screen_width = None
screen_height = None

playerPause = False
arg1 = None
if (__name__ == "__main__"):
	if (1 < len(sys.argv)):
		arg1 = sys.argv[1].strip()
		playerPause = arg1 == "pause"

def sortArrayTop(x,y):
	return x[0]-y[0]


def searchArrayPosition(array,tagetValue,arrayIndex):
	''' 与えられた値の配列の位置を検索 '''

	high = len(array)
	low = 0
	mid = 0
	if tagetValue < array[0][arrayIndex]:
		return low
	if array[high-1][arrayIndex] < tagetValue:
		return high
	while(True):
		mid = (low + high) / 2
		arrayValue = array[mid][arrayIndex]
		if(tagetValue == arrayValue):
			return mid
		elif(arrayValue < tagetValue):
			low = mid + 1
			if low == high:
				return low
		else:
			high = mid - 1
			if low == high:
				return high

class ThumbInfoData:
	pass

try: Emulating = xbmcgui.Emulating
except: Emulating = False


class NicoCommentViewer(xbmcgui.WindowDialog):

	running = True
	lock = threading.RLock()

	view_width = None
	view_height = None

	comment_view_width = None

	#コメント[(ラベル,時間[time,vpos],コメントの長さ,コメントの移動,フォントサイズ)]
	nakaRowList = []
	ueRowList = []
	shitaRowList = []
	danmakuRowList = []
	otherRowList = []

	chatList = []
	comment_count = 0
	count_label = None

	showInfoView = False
	showCommentView = True

	commentReplaceList = None
	ngword_count = 0
	ng_filter_mode = True

	playingFile = None
	low_check = False
	thumbinfoData = None

	start = 0
	seek_time = []
	seek_name = []

	#シーク処理
	playerSeekCount = 0
	playerSeekTimeUnit = None

	#コメント表示時間調整
	commentAdjustUnit = 0
	commentAdjustTime = 0

	watchTourStreaming = False
	namaStreaming = False
	rtmpStreaming = False
	videoStreaming = False

	# ニコ生関連
	playerStatus = None
	enq_bg = None
	enq_bg_Visible = False
	enq_label = []
	enqArray = []

	ms_addr = None
	ms_port = None
	ms_thread = None

	# getplayerstatus
	ps_watch_count = 0
	ps_comment_count = 0
	ps_room_label = None
	ps_room_seetno = None

	active_count = None

	updatePlayerstatus_count = 0

	ngword_ptn = None
	ng_user_list = None
	infoDialog = None

	nicoVideo = None
	view_comment_user = False

	#alert
#	niconama_alert = False
#	niconama_alert_official = True
#	alertHistoryList = []
#	nicoAlert = None

	niconamaCommentXmlFile = None

	server_time = None
	isTimeShift = False

	watchPlayer = None

	margin_bottom = 0

	def __init__(self):
		global MOST_SMALL_FONT,MOST_SMALL_FONT_SIZE,screen_width,screen_height

		self.__dbg__ = __settings__.getSetting( "debug" ) == "true"

		self.other_time = int(float(__settings__.getSetting("other_comment_view_time")))/10
		self.other_comment_max_rows = int(float(__settings__.getSetting("other_comment_max_rows")))
		self.playerstatus_update_interval = float(__settings__.getSetting("playerstatus_update_interval"))/1000
		self.view_hb_ifseetno = __settings__.getSetting("view_hb_ifseetno") == "true"
		self.colorIndex = int(__settings__.getSetting("default_view_color"))
		self.disconnect_auto_close = __settings__.getSetting("disconnect_auto_close") == "true"
		self.show_active_count = __settings__.getSetting("show_active_count") == "true"

		self.big_font_size = int(float(__settings__.getSetting("big_font_size")))
		self.midium_font_size = int(float(__settings__.getSetting("midium_font_size")))
		self.small_font_size = int(float(__settings__.getSetting("small_font_size")))

#		self.setCoordinateResolution(5) #RES_HDTV_720p
		screen_width = 1280
		screen_height = 720

#		screen_width = self.getWidth()
#		screen_height = self.getHeight()

		self.scaleX = (float(screen_width)  / float(640))
		self.scaleY = (float(screen_height) / float(480))

		#alert
#		self.niconama_alert_official = __settings__.getSetting("niconama_alert_official") == "true"
#		self.niconama_alert_view_time = float(__settings__.getSetting("niconama_alert_view_time"))/1000
#		self.niconama_alert = __settings__.getSetting( "niconama_alert" ) == "true"

		ng_user = __settings__.getSetting("ng_user")
		if ng_user != '':
			list = ng_user.split(',')
			self.ng_user_list = {}
			for user_id in list:
				self.ng_user_list[user_id] = 1

		ng_word = __settings__.getSetting("ng_word")
		if not ng_word:
			self.ngword_ptn = re.compile(ng_word)

		if 3 < len(sys.argv):
			# ニコ生
			self.margin_bottom_size = 16
			self.margin_bottom = self.margin_bottom_size

			self.ms_addr = sys.argv[1]
			self.ms_port = int(sys.argv[2])
			self.ms_thread = sys.argv[3]
			if 5 < len(sys.argv):
				# 巡回視聴
				self.watchTourStreaming = True
				self.rtmp_url = sys.argv[5]
				self.rtmp_ticket = sys.argv[6]
				self.cruise_bg = xbmcgui.ControlImage(0,0,screen_width,screen_height,os.path.join(image_dir,'cruise_bg.gif'))
				self.cruise_bg.setVisible(True)
				self.cruise_bg_visible = True
				self.addControl(self.cruise_bg)
				self.tourTitle = sys.argv[6]
			self.showInfoView = __settings__.getSetting("live_show_info") == "true"


		self.view_width = screen_width
		self.view_height = int(screen_height - 3 * self.scaleY)

		if self.__dbg__: print "Width,Height: %s,%s" % (self.getWidth(),self.getHeight())
		if self.__dbg__: print "scaleX,scaleY: %s,%s" % (self.scaleX,self.scaleY)

		self.comment_view_width = int(self.view_width + self.view_width / 10)

		comment_view_time = int(float(__settings__.getSetting("comment_view_time")))/10
		self.naka_time = comment_view_time +  int(comment_view_time/10)
		self.ue_shita_time = comment_view_time - TIME_LAG

		self.big_font_size = 0
		self.midiumFontSize = 0
		self.smallFontSize = 0
		if self.big_font_size > 0:
			self.bigFontSize = self.big_font_size
		if self.midium_font_size > 0:
			self.midiumFontSize = self.midium_font_size
		if self.small_font_size > 0:
			self.smallFontSize = self.small_font_size


#		self.user_agent = "None"
		try:
			self.user_agent = xbmc.getUserAgent()
		except :
			self.user_agent = "None"
		print "print UA "+self.user_agent

		#初期値の設定
#		if 1680 < self.view_width:
		if self.user_agent != "None":
			if self.big_font_size == 0: self.bigFontSize = 80
			if self.midiumFontSize == 0: self.midiumFontSize = 60
			if self.smallFontSize == 0: self.smallFontSize = 40
			self.adustCommentWidth = 10
		else:
			if self.big_font_size == 0: self.bigFontSize = 60
			if self.midiumFontSize == 0: self.midiumFontSize = 40
			if self.smallFontSize == 0: self.smallFontSize = 30
			self.adustCommentWidth = 8

#		self.bigFontSize = 100
#		self.midiumFontSize = 80
#		self.smallFontSize = 60
#		self.adustCommentWidth = 10
		print "Font(%s,%s,%s,%s)" %(self.bigFontSize,self.midiumFontSize,self.smallFontSize,self.adustCommentWidth)

		self.bigFont = FONT_PREFIX + str(self.bigFontSize)
		self.midiumFont = FONT_PREFIX + str(self.midiumFontSize)
		self.smallFont = FONT_PREFIX + str(self.smallFontSize)

		self.commentLineHeight = self.bigFontSize + 5
		row_len = int(self.view_height // self.commentLineHeight)

		# 字幕数カウンター
		if self.ms_addr:
			MOST_SMALL_FONT = "font10"#FONT_PREFIX + str(self.smallFontSize)
			MOST_SMALL_FONT_SIZE = 12
			self.count_label = xbmcgui.ControlLabel(screen_width/2-(MOST_SMALL_FONT_SIZE*14),screen_height - self.margin_bottom_size,self.bigFontSize*20,100,"",MOST_SMALL_FONT,DEF_COLORS[self.colorIndex])
		else:
			MOST_SMALL_FONT = "nico_font_18"#FONT_PREFIX + str(self.smallFontSize)
			MOST_SMALL_FONT_SIZE = 18
			self.count_label = xbmcgui.ControlLabel(1,1,self.bigFontSize*20,100,"",MOST_SMALL_FONT,DEF_COLORS[self.colorIndex])

		self.count_label.setLabel("[コメント開始中]")
		self.addControl(self.count_label)

		for i in range(row_len):
			list  = []
			self.nakaRowList.append(list)

		for i in range(row_len+1):
			list = []
			self.ueRowList.append(list)

		for i in range(row_len+1):
			list = []
			self.shitaRowList.append(list)

##		test_label1 = xbmcgui.ControlFadeLabel(24,self.commentLineHeight,300,50,self.bigFont ,COMMAND_red_color)
##		test_label2 = xbmcgui.ControlFadeLabel(24,self.commentLineHeight*2,300,50,self.midiumFont,COMMAND_red_color)
##		test_label3 = xbmcgui.ControlFadeLabel(24,self.commentLineHeight*3,300,50,self.smallFont,COMMAND_red_color)
##
##		self.addControl(test_label1)
##		self.addControl(test_label2)
##		self.addControl(test_label3)
##
##		test_label1.addLabel("あいうえお 字幕")
##		test_label2.addLabel("あいうえお 字幕")
##		test_label3.addLabel("あいうえお 字幕")

##		test_label4 = xbmcgui.ControlFadeLabel(self.view_width-self.commentLineHeight,0,300,50,MOST_SMALL_FONT ,COMMAND_red_color)
##		test_label5 = xbmcgui.ControlFadeLabel(0,self.view_height-self.commentLineHeight,300,50,MOST_SMALL_FONT,COMMAND_red_color)
##		self.addControl(test_label4)
##		self.addControl(test_label5)
##		test_label4.addLabel("X")
##		test_label5.addLabel("Y")

		if self.watchTourStreaming:
			self.playingFile = self.tourTitle
		else:
			if xbmc.Player().isPlaying():
				self.playingFile = xbmc.Player().getPlayingFile()
				if self.__dbg__: print "NicoCommentViewer PlayingFile: "+self.playingFile
			else:
				return None
		self.hiddenStartTextThread = threading.Thread(target=self.commentStart,args=())
		self.hiddenStartTextThread.setDaemon(True)
		self.hiddenStartTextThread.start()

#		while xbmc.Player().isPlaying() or self.watchTourStreaming:
#			time.sleep(1.0)

	def commentStart(self):
		if self.watchTourStreaming or 0 <= re.compile(' live=true').search(self.playingFile):
			if self.watchTourStreaming  or re.search(sys.argv[4], self.playingFile) != None:
				self.namaStreaming = True
				self.rtmpStreaming = True
				self.videoStreaming = True
				self.initNicoVideoSettings()
				self.nicoVideo.video_id = sys.argv[4]
				self.nama_start()
			else:
				print "PlayingFile not in agreement: "+sys.argv[4]
		else:
			if self.playingFile != None and os.path.exists(self.playingFile[:-4] + "[ThumbInfo].xml"):
				self.readThumbInfoStart(self.playingFile[:-4] + "[ThumbInfo].xml")
#			if 0 < self.start:
#				if xbmcgui.Dialog().yesno("確認", "動画の開始時間が設定されています。開始時間に移動しますか？"):
#					xbmc.Player().seekTime(self.start/100)

			self.Play_Total_Time = xbmc.Player().getTotalTime() * 100
			if re.compile('rtmp://.*').search(self.playingFile):
				self.rtmpStreaming = True
				self.videoStreaming = True
				ps = None
				filePath = os.path.join(stream_dir, "getplayerstatus.xml")
				if os.path.exists(filePath):
					file = open(filePath, 'r')
					ps = file.read()
					file.close()
				if ps:
					self.parcePlayerStatus(ps)

				xmlFile = os.path.join(stream_dir, "Comment.xml")
			elif re.compile('http://.*').search(self.playingFile) or self.playingFile[len(self.playingFile)-5:] == "Cache":
				self.videoStreaming = True
				xmlFile = os.path.join(stream_dir, "Comment.xml")
			else:
				# 低画質判定処理
				if 9 < len(self.playingFile):
					self.low_check = (self.playingFile[-9:-4] == "[low]")
					if self.low_check:
						self.playingFile = self.playingFile[:-9]+".flv"
				xmlFile = self.playingFile[:-3] + "xml"
				xmlFile = unicode(xmlFile,"utf-8")
			if os.path.exists(xmlFile):
				if(self.nico_XML_parse(xmlFile) == None):
					xbmcgui.Dialog().ok("エラー","コメントファイルの読み込みに失敗しました")
				else:
					self.xml_start()
			else:
				if self.__dbg__: print "not exists comment file = %s" % xmlFile
				xbmcgui.Dialog().ok("エラー","コメントファイルが見つかりませんでした\n%s" % xmlFile)


		if self.__dbg__: print "end commentStart"
		self.closeNicoCommentView()

	def setShowCount(self):
		if 0<self.commentAdjustUnit:
			if self.commentAdjustTime < 0:
				t = self.commentAdjustTime/100 * -1
				self.count_label.setLabel("(コメント開始時間の調整：%s分%s秒(vpos%s) / 単位：%s秒)" % (int(math.floor(t/60)),t%60,self.commentAdjustTime,self.commentAdjustUnit/100))
			else:
				t = self.commentAdjustTime/100
				self.count_label.setLabel("(コメント開始時間の調整：%s分%s秒(vpos+%s) / 単位：%s秒)" % (int(math.floor(t/60)),t%60,self.commentAdjustTime,self.commentAdjustUnit/100))
		else:
			if self.namaStreaming:
				if self.ps_room_label or self.ps_room_seetno:
					zaseki = "座席表：%s - %s番" % (self.ps_room_label,self.ps_room_seetno)
				else:
					zaseki = "座席表：-"
				if self.ng_filter_mode:
					if self.show_active_count and self.active_count != None:
						self.count_label.setLabel("来場者：%s   コメ：%s   アク：%s   %s" % (self.ps_watch_count,self.ps_comment_count,self.active_count,zaseki))
					else:
						self.count_label.setLabel("来場者：%s   コメ：%s   %s" % (self.ps_watch_count,self.ps_comment_count,zaseki))
				else:
					if self.show_active_count and self.active_count != None:
						self.count_label.setLabel("来場者：%s   コメ：%s   アク：%s   NG：%d   %s" % (self.ps_watch_count,self.ps_comment_count,self.active_count,self.ngword_count,zaseki))
					else:
						self.count_label.setLabel("来場者：%s   コメ：%s   NG：%d   %s" % (self.ps_watch_count,self.ps_comment_count,self.ngword_count,zaseki))
			else:
				if self.ng_filter_mode:
					self.count_label.setLabel("(コメ：%d/%d)" % (self.comment_count,len(self.chatList)))
				else:
					self.count_label.setLabel("(コメ：%d/%d | NG：%d)" % (self.comment_count,len(self.chatList),self.ngword_count))


	def onAction(self, action):
#		buttonCode =  action.getButtonCode()
#		print "buttonCode="+str(buttonCode)
#		print "action="+str(action)
#		for i in range(10000):
#			if i == action:
#				print "action=%s" % (i)
#				break

		if action == ACTION_MOVE_LEFT:
			if 0<self.commentAdjustUnit:
				self.commentAdjustTime -= self.commentAdjustUnit
				self.setShowCount()
				self.playerSeekCount = 2
			else:
				if xbmc.Player().isPlaying():
					if 0 < self.playerSeekTimeUnit:
						Play_Time = xbmc.Player().getTime()
						setTime = Play_Time - self.playerSeekTimeUnit
						if setTime < 0:
							setTime = 0
						xbmc.Player().seekTime(setTime)
						self.playerSeekCount = 2

		if action == ACTION_MOVE_RIGHT:
			if 0<self.commentAdjustUnit:
				self.commentAdjustTime += self.commentAdjustUnit
				self.setShowCount()
				self.playerSeekCount = 2
			else:
				if xbmc.Player().isPlaying():
					if 0 < self.playerSeekTimeUnit:
						Play_Time = xbmc.Player().getTime()
						setTime = Play_Time + self.playerSeekTimeUnit
						xbmc.Player().seekTime(setTime)
						self.playerSeekCount = 2

		if action == ACTION_MOVE_UP:
			if 0<self.commentAdjustUnit:
				if self.commentAdjustUnit == 100:
					self.commentAdjustUnit = 1000
				elif self.commentAdjustUnit == 1000:
					self.commentAdjustUnit = 6000
				else:
					self.commentAdjustUnit = 6000
				self.setShowCount()
			else:
				seek = False
				if 0 < self.start:
					if xbmcgui.Dialog().yesno("確認", "動画の開始時間(開始 %ss)が設定されています。\r\n開始時間に移動しますか？"  % (self.start/100)):
						xbmc.Player().seekTime(self.start/100)
						seek = True
				if 0 < len(self.seek_time):
					if xbmcgui.Dialog().yesno("確認", "動画情報にシーク時間が設定されています。\r\nシークしますか？" ):
						if len(self.seek_time) == len(self.seek_name):
							choose_List = self.seek_name
						else:
							choose_List = self.seek_time
						select_dialog = xbmcgui.Dialog().select("シーク位置",choose_List)
						if 0<=select_dialog:
							xbmc.Player().seekTime(int(self.seek_time[select_dialog]))
							seek = True
				if seek == False:
					self.showInfo()
#				self.colorIndex = (self.colorIndex + 1) % len(DEF_COLORS)

		if action == ACTION_MOVE_DOWN:
			if 0<self.commentAdjustUnit:
				if self.commentAdjustUnit == 6000:
					self.commentAdjustUnit = 1000
				elif self.commentAdjustUnit == 1000:
					self.commentAdjustUnit = 100
				else:
					self.commentAdjustUnit = 100
				self.setShowCount()
			else:
				if self.enq_bg_Visible:
					if self.enq_bg_Visible:
						self.enq_bg_Visible = False
						self.enq_bg.setVisible(False)
						for label in self.enq_label:
							label.setLabel("")
							label.setVisible(False)
				else:
					if self.showInfoView and self.showCommentView:
						self.setShowSetting(False, False)
					elif self.showCommentView:
						self.setShowSetting(True, True)
					else:
						self.setShowSetting(False, True)

		# PreviousNenu（リモコンのMenuボタン等）か コントローラの右側のアナログスティックが押されたの処理
		if action == ACTION_PREVIOUS_MENU or action == ACTION_Right_ThumbStick or action == ACTION_SELECT_ITEM:
			if 0<self.commentAdjustUnit:
				choose_List = ["コメントの開始時間調整を終了する","コメント開始時間を初期化する","シーク単位を１秒に設定する","シーク単位を１０秒に設定する","シーク単位を６０秒に設定する","動画再生を終了する","スクリプトを終了する","スクリプトを再起動する",]
				select_dialog = xbmcgui.Dialog().select("メニュー - コメントの位置時間調整",choose_List)
				if select_dialog == 0:
					self.commentAdjustUnit = 0

					if self.showInfoView and self.showCommentView:
						self.setShowCount()
					elif self.showCommentView:
						self.count_label.setLabel("")
					else:
						self.count_label.setLabel("(非表示)")
				elif select_dialog == 1:
					self.commentAdjustTime = 0
					self.setShowCount()
				elif select_dialog == 2:
					self.commentAdjustUnit = 100
				elif select_dialog == 3:
					self.commentAdjustUnit = 1000
				elif select_dialog == 4:
					self.commentAdjustUnit = 6000
				if select_dialog == 5:
					xbmc.Player().stop()
					self.closeNicoCommentView()
				if select_dialog == 6:
					self.closeNicoCommentView()
				elif select_dialog == 7:
					if self.niconamaCommentXmlFile:
						self.niconamaCommentXmlFile.close()
						self.niconamaCommentXmlFile = None
					if self.watchTourStreaming:
						xbmc.executebuiltin("XBMC.RunScript(%s,%s,%s,%s,%s,%s,%s)" % (sys.argv[0], sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5], sys.argv[6]))
					elif self.namaStreaming:
						xbmc.executebuiltin("XBMC.RunScript(%s,%s,%s,%s,%s)" % (sys.argv[0], sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4]))
					else:
						xbmc.executebuiltin("XBMC.RunScript(%s)" % (sys.argv[0]))
					self.closeNicoCommentView()
			else:
				choose_List = ["動画再生を終了する","スクリプトを終了する","スクリプトを再起動する","コメントを表示する","コメントとカウントを表示する","コメントを非表示にする","コメント開始時間を調整する","コメントの一覧を表示する","詳細情報を表示する","設定画面を表示する"]

#				if self.view_comment_user:
#					choose_List.append("ユーザー名をコメントに表示しない")
#				else:
#					choose_List.append("ユーザー名をコメントに表示する")
				choose_List.append("マイページを確認する")

				if self.rtmpStreaming:
					if self.show_active_count:
						choose_List.append("アクティブ人数を表示しない")
					else:
						choose_List.append("アクティブ人数を表示する")

				if self.nicoVideo and self.rtmpStreaming and self.playerStatus != None and self.playerStatus["default_community"] != None:
					info = self.nicoVideo.getCommunityInfo(self.playerStatus["default_community"])
					if info['motion_form']:
						choose_List.append("コミュニティに参加する")
					else:
						choose_List.append("コミュニティを退会する")
#							choose_List.append("%s->%s" % (self.playerStatus["id"],info['lv_id']))

				if self.playerStatus:
					select_dialog = xbmcgui.Dialog().select("メニュー : %s" % self.playerStatus["id"],choose_List)
				else:
					select_dialog = xbmcgui.Dialog().select("メニュー",choose_List)

				if select_dialog == 0:
					self.closeNicoCommentView()
					xbmc.Player().stop()
				if select_dialog == 1:
					self.closeNicoCommentView()
				elif select_dialog == 2:
					if self.watchTourStreaming:
						xbmc.executebuiltin("XBMC.RunScript(%s,%s,%s,%s,%s,%s,%s)" % (nico_py, sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5], sys.argv[6]))
					elif self.namaStreaming:
						xbmc.executebuiltin("XBMC.RunScript(%s,%s,%s,%s,%s)" % (nico_py, sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4]))
					else:
						xbmc.executebuiltin("XBMC.RunScript(%s)" % (nico_py))
					self.closeNicoCommentView()
				if select_dialog == 3:
					self.setShowSetting(False, True)
				if select_dialog == 4:
					self.setShowSetting(True, True)
				if select_dialog == 5:
					self.setShowSetting(False, False)
				elif select_dialog == 6:
					self.commentAdjustUnit = 100
					self.setShowCount()
				elif select_dialog == 7:
					list = []
					if self.namaStreaming:
						for chat in self.chatList[::-1]:
							list.append("%s:%s" %(chat[1],chat[4]))
					else:
						for chat in self.chatList:
							list.append("%s:%s" %(chat[1],chat[4]))
					i = xbmcgui.Dialog().select("コメント一覧",list)
					if 0 <= i:
						i = xbmcgui.Dialog().select("メニュー",["NGユーザーに追加する","NGワードに追加・編集する"])
						if i == 0:
							user_id = self.chatList[i][4]
							if self.ng_user_list != None and self.ng_user_list.get(user_id):
								xbmcgui.Dialog().ok("","既にNGユーザーに登録されています")
								return None
							else:
								ng_user = __settings__.getSetting("ng_user")
								if ng_user != '':
									ng_user = ng_user + "," + user_id
								else:
									ng_user = user_id
								__settings__.setSetting(id="ng_user", value=ng_user)
								list = ng_user.split(',')
								self.ng_user_list = {}
								for user_id in list:
									self.ng_user_list[user_id] = 1

							xbmcgui.Dialog().ok("","%sをNGユーザーに追加しました" % user_id )
						elif i == 1:
							comment = self.chatList[i][1]
							keyboard = xbmc.Keyboard(__settings__.getSetting("ng_word") + "|" + comment, "NGワードの登録")
							keyboard.setHiddenInput(False)
							keyboard.doModal()

							if keyboard.isConfirmed():
								ng_word = keyboard.getText()
								__settings__.setSetting(id="ng_word", value=ng_word)

							if not ng_word:
								self.ngword_ptn = re.compile(ng_word)
								xbmcgui.Dialog().ok("","NGワードを更新しました")
							else:
								return None
				elif select_dialog == 8:
					self.showInfo()
				elif select_dialog == 9:
					self.setOption()

#				elif select_dialog == 10:
#					self.view_comment_user = not self.view_comment_user
				elif select_dialog == 10:
					if self.nicoVideo == None:
						self.initNicoVideoSettings()
					choose_List2 = []
					checkList = []

					#旧取得方法
#					liveArray = self.nicoVideo.getMyParticipateLive()
#					start = math.floor(time.time())
#					timelineArray = self.nicoVideo.getTimeline(start,start + 60*30)
#					for r in timelineArray:
#						if r['status'] == 'onair' and r['category'] == 'official':
#							checkList.append([r['live_id'],r['title']])
#							choose_List2.append("公式：" +r['title'])
#					for r in liveArray:
#						checkList.append([r['guid'],r['community_title']])
##						checkList.append([r['community_id'],r['community_title']])
#						choose_List2.append(r['community_title'] + "：" +r['title'])

					sectionArray = self.nicoVideo.getSpLiveData()
					officialArray = sectionArray[0]
					liveArray = sectionArray[2]
					popularArray = sectionArray[3]

					for data in officialArray:
						title_name = '公式：%s  (視聴者：%s | コメ：%s | %s)[%s]' % (data['title'],data['view'],data['comment'],data['start_time'],data['live_id'])
						checkList.append([data['live_id'],data['title']])
						choose_List2.append(title_name)

					for data in liveArray:
						title_name = '%s  (視聴者：%s | コメ：%s | %s)[%s]' % (data['title'],data['view'],data['comment'],data['start_time'],data['live_id'])
						checkList.append([data['live_id'],data['title']])
						choose_List2.append(title_name)

					for data in popularArray:
						title_name = '人気：%s  (視聴者：%s | コメ：%s | %s)[%s]' % (data['title'],data['view'],data['comment'],data['start_time'],data['live_id'])
						checkList.append([data['live_id'],data['title']])
						choose_List2.append(title_name)

					if len(checkList) == 0:
						xbmcgui.Dialog().ok("","放送されている番組はありませんでした")
					else:
						select_dialog2 = xbmcgui.Dialog().select("放送されている番組",choose_List2)
						if 0<=select_dialog2:
							if xbmcgui.Dialog().yesno("確認", checkList[select_dialog2][1] ,"の放送に移動します。移動してもよろしいですか？"):
								self.nicoVideo.video_id = checkList[select_dialog2][0]
								retryCount = 3
								while 0 < retryCount:
									body = self.nicoVideo.apiGetPlayerStatus()
									if re.compile('<getplayerstatus ').search(body):
										break
									time.sleep(3.0)
									retryCount -= 1
									body = None
								if body == None:
									xbmcgui.Dialog().ok("エラー","放送情報の取得に失敗しました")
									return None
								if self.__dbg__: print body
								result = self.nicoVideo.setGetplayerstatus(getplayerstatus=body)
								if result:
									if result == 'comingsoon':
										xbmcgui.Dialog().ok("エラー","まだ配信が開始されていません")
									elif result == 'closed':
										xbmcgui.Dialog().ok("エラー","配信が終了しています")
									elif result == 'require_community_member':
										xbmcgui.Dialog().ok("エラー","	コミュニティ限定放送です")
									elif result == 'notlogin':
										xbmcgui.Dialog().ok("エラー","ログインしていません")
									elif result == 'invalid_thread':
										xbmcgui.Dialog().ok("エラー","放送が見つかりませんでした")
									elif result == 'invalid_v1':
										xbmcgui.Dialog().ok("エラー","放送が見つかりませんでした")
									elif result == 'unknown':
										xbmcgui.Dialog().ok("エラー","不明なエラーが発生しました")
									elif result == 'maintenance':
										xbmcgui.Dialog().ok("エラー","メンテナンス中です")
									elif result == 'server_error':
										xbmcgui.Dialog().ok("エラー","サーバエラーが発生しました")
									elif result == 'DELETED':
										xbmcgui.Dialog().ok("エラー","削除済みの番組です")
									elif result == 'full':
										xbmcgui.Dialog().ok("エラー","満員(放送中)です")
									elif result == 'permission_denied':
										xbmcgui.Dialog().ok("エラー","許可されていないアクセスです")
									elif result == 'not_permitted':
										xbmcgui.Dialog().ok("エラー","終了した放送です")
									elif result == 'access_locked':
										xbmcgui.Dialog().ok("エラー","許可されていないアクセスです")
									elif result == 'tsarchive':
										xbmcgui.Dialog().ok("エラー","有料放送です")
									elif result == 'usertimeshift':
										xbmcgui.Dialog().ok("エラー","コミュニティ限定のタイムシフトです")
									return None

								playurl = self.nicoVideo.getLiveVideoUrl()
								xbmc.Player(xbmc.PLAYER_CORE_DVDPLAYER).play(playurl)
								if xbmc.Player().isPlaying():
									xbmc.executebuiltin("XBMC.RunScript(%s,%s,%s,%s,%s)" % (sys.argv[0], self.nicoVideo.ms_addr, self.nicoVideo.ms_port, self.nicoVideo.ms_thread, self.nicoVideo.video_id))
								self.closeNicoCommentView()
				elif select_dialog == 11:
					self.show_active_count = not self.show_active_count
					if not self.show_active_count:
						self.active_count = None
						self.setShowCount()
				elif select_dialog == 12:
					if info['motion_form']:
						self.nicoVideo.motionCommunity(self.playerStatus["default_community"])
						xbmcgui.Dialog().ok("","コニュニティに参加しました")
					else:
						if xbmcgui.Dialog().yesno("確認","本当に退会してもよろしいですか？"):
							self.nicoVideo.leaveCommunity(self.playerStatus["default_community"])
							xbmcgui.Dialog().ok("","コニュニティを退会しました")

		# Xボタン押下時の処理
		if action == ACTION_SHOW_GUI:
			self.setOption()


	def parcePlayerStatus(self, body):

		id_m = re.compile('<id>(.*)</id>').search(body)
		if id_m:
			self.playerStatus = {}
			self.playerStatus["id"] =  id_m.group(1)

			title_m = re.compile('<title>(.*)</title>').search(body)
			if title_m: self.playerStatus["title"] =  title_m.group(1)
			else: self.playerStatus["title"] = None

			description_m = re.compile('<description>(.*)</description>').search(body)
			if description_m: self.playerStatus["description"] =  description_m.group(1)
			else: self.playerStatus["description"] = None

			watch_count_m = re.compile('<watch_count>(.*)</watch_count>').search(body)
			if watch_count_m: self.playerStatus["watch_count"] =  watch_count_m.group(1)
			else: self.playerStatus["watch_count"] = None

			comment_count_m = re.compile('<comment_count>(.*)</comment_count>').search(body)
			if comment_count_m: self.playerStatus["comment_count"] =  comment_count_m.group(1)
			else: self.playerStatus["comment_count"] = None

			room_label_m = re.compile('<room_label>(.*)</room_label>').search(body)
			if room_label_m: self.playerStatus["room_label"] =  room_label_m.group(1)
			else: self.playerStatus["room_label"] = None

			room_seetno_m = re.compile('<room_seetno>(.*)</room_seetno>').search(body)
			if room_seetno_m: self.playerStatus["room_seetno"] =  room_seetno_m.group(1)
			else: self.playerStatus["room_seetno"] = None

			default_community_m = re.compile('<default_community>(co[0-9]+)</default_community>').search(body)
			if default_community_m: self.playerStatus["default_community"] =  default_community_m.group(1)
			else: self.playerStatus["default_community"] = None
		else:
			if self.__dbg__: print "parcePlayerStatus error: %s" % body

	def showInfo(self):
		if self.rtmpStreaming:
			if self.namaStreaming and self.playerStatus == None:
				ps = self.nicoVideo.apiGetPlayerStatus()
				self.parcePlayerStatus(ps)

#			if self.watchPlayer == None:
			self.watchPlayer = self.nicoVideo.getWatchPlayer(self.nicoVideo.video_id)

			if self.watchPlayer == None:
				if self.playerStatus == None:
					s1 = ""
					s3 = ""
					s4 = ""
				else:
					if self.show_active_count and self.active_count != None:
						s1 = "(来場者：%s | コメ：%s | アク：%s)" % (self.ps_watch_count,self.ps_comment_count,self.active_count)
					else:
						s1 = "(来場者：%s | コメ：%s)" % (self.ps_watch_count,self.ps_comment_count)
					s3 = self.playerStatus["title"]
					s4 = self.playerStatus["description"]
			else:
				if self.show_active_count and self.active_count != None:
					s1 = "(来場者：%s | コメ：%s | アク：%s | 投稿：%s)" % (self.ps_watch_count,self.ps_comment_count,self.active_count,self.watchPlayer["postedAt"])
				else:
					s1 = "(来場者：%s | コメ：%s | 投稿：%s)" % (self.ps_watch_count,self.ps_comment_count,self.watchPlayer["postedAt"])
				s3 = self.watchPlayer["title"]
				s4 = re.sub(r'(\r\n)+','\r\n',self.watchPlayer["description"])

			if self.playerStatus == None:
				s2 = ""
			else:
				s2 = "座席表：%s - %s番 (%s)" % (self.ps_room_label,self.ps_room_seetno,self.playerStatus["id"])

			s5 = ""
		else:
			# タイトル、タグ、コメントを表示・非表示
			if self.thumbinfoData == None:
				if self.videoStreaming:
					if os.path.exists(os.path.join(stream_dir,"ThumbInfo.xml")):
						self.readThumbInfo(os.path.join(stream_dir,"ThumbInfo.xml"))
				else:
					if self.playingFile != None and os.path.exists(self.playingFile[:-4] + "[ThumbInfo].xml"):
						self.readThumbInfo(self.playingFile[:-4] + "[ThumbInfo].xml")
			if self.thumbinfoData == None:
				xbmcgui.Dialog().ok("","詳細情報(ThumbInfo.xml)が見つかりませんでした")
				return None

			if 0 == self.commentAdjustTime:
				s1 = "( 再生：%s | コメント：%s | マイリスト：%s )" % (self.thumbinfoData.get('view_counter'),self.thumbinfoData.get('comment_num'),self.thumbinfoData.get('mylist_counter'))
			else:
				s1 = "( 再生：%s | コメント：%s | マイリスト：%s )  コメント調整：%s" % (self.thumbinfoData.get('view_counter'),self.thumbinfoData.get('comment_num'),self.thumbinfoData.get('mylist_counter'),self.commentAdjustTime)
			s2 = self.thumbinfoData.get('first_retrieve')
			s3 = self.thumbinfoData.get('title')
			s4 = self.thumbinfoData.get('description')
			s5 = self.thumbinfoData.get("tag")


		self.infoDialog = InfoDialog()
		self.infoDialog.setTextLabel(s1,s2,s3,s4,s5)
		self.infoDialog.doModal()
		self.infoDialog.close()

	def setShowSetting(self,showInfoView,showCommentView):
		if showInfoView and showCommentView:
			if self.__dbg__: self.ng_filter_mode = not self.ng_filter_mode
			if self.ms_addr: self.margin_bottom = self.margin_bottom_size
			self.setShowCount()
		elif showCommentView:
			if self.ms_addr: self.margin_bottom = 0
			self.count_label.setLabel("")
		else:
			if self.enq_bg_Visible:
				self.enq_bg_Visible = False
				self.enq_bg.setVisible(False)
				for label in self.enq_label:
					label.setLabel("")
					label.setVisible(False)
			self.count_label.setLabel("(非表示)")

		self.showInfoView = showInfoView
		self.showCommentView = showCommentView

	def setOption(self):
		global screen_width,screen_height
		__settings__.openSettings()

		self.__dbg__ = __settings__.getSetting( "debug" ) == "true"

		comment_view_time = int(float(__settings__.getSetting("comment_view_time")))/10
		self.naka_time = comment_view_time +  int(comment_view_time/10)
		self.ue_shita_time = comment_view_time - TIME_LAG

		self.other_time = int(float(__settings__.getSetting("other_comment_view_time")))/10
		self.other_comment_max_rows = int(float(__settings__.getSetting("other_comment_max_rows")))
		self.playerstatus_update_interval = float(__settings__.getSetting("playerstatus_update_interval"))/1000
		self.view_hb_ifseetno = __settings__.getSetting("view_hb_ifseetno") == "true"
		self.disconnect_auto_close = __settings__.getSetting("disconnect_auto_close") == "true"
		self.show_active_count = __settings__.getSetting("show_active_count") == "true"

		#alert
#		self.niconama_alert_official = __settings__.getSetting("niconama_alert_official") == "true"
#		self.niconama_alert = __settings__.getSetting("niconama_alert") == "true"
#		self.niconama_alert_view_time = float(__settings__.getSetting("niconama_alert_view_time"))/1000
#
#		if self.niconama_alert and self.alertThread == None:
#			self.alertThread = threading.Thread(target=self.alert,args=())
#			self.alertThread.setDaemon(True)
#			self.alertThread.start()

		self.colorIndex = int(__settings__.getSetting("default_view_color"))
		label = self.count_label
		if self.ms_addr:
			self.count_label = xbmcgui.ControlLabel(screen_width/2-(MOST_SMALL_FONT_SIZE*14),screen_height - self.margin_bottom_size,self.bigFontSize*20,100,"",MOST_SMALL_FONT,DEF_COLORS[self.colorIndex])
		else:
			self.count_label = xbmcgui.ControlLabel(1,1,self.bigFontSize*20,100,"",MOST_SMALL_FONT,DEF_COLORS[self.colorIndex])
		self.addControl(self.count_label)
		label.setLabel("")
		del label
		if self.showInfoView: self.setShowCount()

		ng_user = __settings__.getSetting("ng_user")
		if ng_user != '':
			list = ng_user.split(',')
			self.ng_user_list = {}
			for user_id in list:
				self.ng_user_list[user_id] = 1
		else:
			self.ng_user_list = None

		ng_word = __settings__.getSetting("ng_word")
		if not ng_word:
			self.ngword_ptn = re.compile(ng_word)
		else:
			self.ngword_ptn = None


	def parceThumbInfo(self,body):
		''' 動画情報を解析します '''

		data = {}
		video_id_m = re.compile('<video_id>(.*)</video_id>').search(body)
		if video_id_m: data['video_id'] = video_id_m.group(1)
		else: data["video_id"] = None

		title_m = re.compile('<title>(.*)</title>').search(body)
		if title_m: data['title'] = title_m.group(1)
		else: data["title"] = None

		description_m = re.compile('<description>(.*)</description>').search(body)
		if description_m: data['description'] = description_m.group(1)
		else: data["description"] = None

		first_retrieve_m = re.compile('<first_retrieve>(.*)</first_retrieve>').search(body)
		if first_retrieve_m: data['first_retrieve'] = first_retrieve_m.group(1)
		else: data["first_retrieve"] = None

		length_m = re.compile('<length>(.*)</length>').search(body)
		if length_m: data['length'] = length_m.group(1)
		else: data["length"] = None

		movie_type_m = re.compile('<movie_type>(.*)</movie_type>').search(body)
		if movie_type_m: data['movie_type'] = movie_type_m.group(1)
		else: data["movie_type"] = None

		size_high_m = re.compile('<size_high>(.*)</size_high>').search(body)
		if size_high_m: data['size_high'] = size_high_m.group(1)
		else: data["size_high"] = None

		size_low_m = re.compile('<size_low>(.*)</size_low>').search(body)
		if size_low_m: data['size_low'] = size_low_m.group(1)
		else: data["size_low"] = None

		view_counter_m = re.compile('<view_counter>(.*)</view_counter>').search(body)
		if view_counter_m: data['view_counter'] = view_counter_m.group(1)
		else: data["view_counter"] = None

		comment_num_m = re.compile('<comment_num>(.*)</comment_num>').search(body)
		if comment_num_m: data['comment_num'] = comment_num_m.group(1)
		else: data["comment_num"] = None

		mylist_counter_m = re.compile('<mylist_counter>(.*)</mylist_counter>').search(body)
		if mylist_counter_m: data['mylist_counter'] = mylist_counter_m.group(1)
		else: data["mylist_counter"] = None

		last_res_body_m = re.compile('<last_res_body>(.*)</last_res_body>').search(body)
		if last_res_body_m: data['last_res_body'] = last_res_body_m.group(1)
		else: data["last_res_body"] = None

		thumb_type_m = re.compile('<thumb_type>(.*)</thumb_type>').search(body)
		if thumb_type_m: data['thumb_type'] = thumb_type_m.group(1)
		else: data["thumb_type"] = None

		embeddable_m = re.compile('<embeddable>(.*)</embeddable>').search(body)
		if embeddable_m: data['embeddable'] = embeddable_m.group(1)
		else: data["embeddable"] = None

		tagLockArray = []
		p1 = re.compile('<tag lock="[0-9]*">(.*)</tag>')
		for m in p1.finditer(body):
			tagLockArray.append(m.group(1))
		data['tagLockArray'] = tagLockArray

		tagArray = []
		p2 = re.compile('<tag>(.*)</tag>')
		for m in p2.finditer(body):
			tagArray.append(m.group(1))
		data['tagArray'] = tagArray

#		# 動画開始位置
#		start_m = re.compile('<start>(.*)</start>').search(body)
#		if start_m:
#			data['start'] = start_m.group(1)
#
#		else:
#			data["start"] = 0
#
#		# コメント位置調整
#		vpos_start_m = re.compile('<vpos_start>(.*)</vpos_start>').search(body)
#		if vpos_start_m:
#			data['vpos_start'] = vpos_start_m.group(1)
#			self.commentAdjustTime = data['vpos_start']
#		else:
#			data["vpos_start"] = 0

		return data


	def readThumbInfo(self,filepath):
		'''ThumbInfoから動画情報の読み込み'''

		dataFile = open(filepath, 'r')
		thumbinfoXml = dataFile.read()
		dataFile.close();

		self.thumbinfoData = self.parceThumbInfo(thumbinfoXml)

		tag_list = []
		tag = ""
		tagLockArray = self.thumbinfoData.get('tagLockArray')
		if 0 < len(tagLockArray):
			tag += "タグロック："
			for i in range(len(tagLockArray)):
				tag += tagLockArray[i] + ","
				tag_list.append(tagLockArray[i])
			tag += "\r\n"

		tagArray = self.thumbinfoData.get('tagArray')
		if 0 < len(tagArray):
			tag += "タグ："
			for i in range(len(tagArray)):
				tag += tagArray[i] + ","
				tag_list.append(tagArray[i])
		if tag != "":
			tag = tag[0:-1]
		self.thumbinfoData["tag"] = tag

	def readThumbInfoStart(self,filepath):
		'''ThumbInfoから開始時に使用する動画情報の読み込み'''

		dataFile = open(filepath, 'r')
		thumbinfoXml = dataFile.read()
		dataFile.close();

		self.parceThumbInfoStart(thumbinfoXml)

	def parceThumbInfoStart(self,body):
		''' 開始時に使用する動画情報を解析します '''
		# 動画開始位置
		start_m = re.compile('<start>(.*)</start>').search(body)
		if start_m:
			self.start = int(start_m.group(1))

		# シーク位置
		seek_m = re.compile('<seek_time>(.*)</seek_time>').search(body)
		if seek_m:
			s = seek_m.group(1)
			self.seek_time = s.split(",")

			seek_m = re.compile('<seek_name>(.*)</seek_name>').search(body)
			if seek_m:
				s = seek_m.group(1)
				self.seek_name = s.split(",")

		# コメント位置調整
		vpos_start_m = re.compile('<vpos_start>(.*)</vpos_start>').search(body)
		if vpos_start_m:
			self.commentAdjustTime = int(vpos_start_m.group(1))

	def getCommentColor(self,command):
		tcolor = None
		# プレミアム会員専用コマンド
		if 0 <= command.find(COMMAND_niconicowhite) or 0 <= command.find(COMMAND_white2):
			tcolor = COMMAND_white2_color
		elif 0 <= command.find(COMMAND_truered) or 0 <= command.find(COMMAND_red2):
			tcolor = COMMAND_red2_color
		elif 0 <= command.find(COMMAND_passionorange) or 0 <= command.find(COMMAND_orange2):
			tcolor = COMMAND_orange2_color
		elif 0 <= command.find(COMMAND_madyellow) or 0 <= command.find(COMMAND_yellow2):
			tcolor = COMMAND_yellow2_color
		elif 0 <= command.find(COMMAND_elementalgreen) or 0 <= command.find(COMMAND_green2):
			tcolor = COMMAND_green2_color
		elif 0 <= command.find(COMMAND_marineblue) or 0 <= command.find(COMMAND_blue2):
			tcolor = COMMAND_blue2_color
		elif 0 <= command.find(COMMAND_nobleviolet) or 0 <= command.find(COMMAND_purple2):
			tcolor = COMMAND_purple2_color
		# 色コマンド
		elif 0 <= command.find(COMMAND_white):
			tcolor = COMMAND_white_color
		elif 0 <= command.find(COMMAND_red):
			tcolor = COMMAND_red_color
		elif 0 <= command.find(COMMAND_pink):
			tcolor = COMMAND_pink_color
		elif 0 <= command.find(COMMAND_orange):
			tcolor = COMMAND_orange_color
		elif 0 <= command.find(COMMAND_yellow):
			tcolor = COMMAND_yellow_color
		elif 0 <= command.find(COMMAND_green):
			tcolor = COMMAND_green_color
		elif 0 <= command.find(COMMAND_cyan):
			tcolor = COMMAND_cyan_color
		elif 0 <= command.find(COMMAND_blue):
			tcolor = COMMAND_blue_color
		elif 0 <= command.find(COMMAND_purple):
			tcolor = COMMAND_purple_color
		elif 0 <= command.find(COMMAND_black):
			tcolor = COMMAND_black_color
		elif 0 <= command.find("#"):
			for color_str in self.color_pat.finditer(command):
				color_param = color_str.group(1)
				tcolor = "0xFF"+color_param
		return tcolor

	def nico_XML_parse(self,nico_xml_file):
		''' コメントXMLを解析します '''
		Ly_dat = open("%s" % nico_xml_file,"r").read()

		self.isTimeShift = Ly_dat.startswith("<thread ")
		server_time_m = re.compile(r'server_time="(.*?(?="))"').search(Ly_dat)
		if server_time_m: self.server_time = int(server_time_m.group(1))

#		xml_y_posi_list = []
		p = re.compile(r'(?s)(<chat .+?>.*?</chat>)')
		for m in p.finditer(Ly_dat):
			chat = m.group(1)
			#削除コメントの除去(deleted)
			chat = re.sub('<chat .*deleted="[0-9]".*/>','',chat)
			chat_data = self.chatdata(chat)
			if chat_data:
				self.chatList.append(chat_data)
		self.chatList.sort(sortArrayTop)
		del Ly_dat
		return True

	chat_pat = re.compile(r'(?s)<chat (.+?)>(.*?)</chat>')
	vpos_pat = re.compile(r'vpos="(.*?(?="))"')
	date_pat = re.compile(r'date="(.*?(?="))"')
	userid_pat = re.compile(r'user_id="(.*?(?="))"')
	mail_pat = re.compile(r'mail=(".*?(?=")")')
	name_pat = re.compile(r'name="(.*?(?="))"')
	ue_pat = re.compile(r'ue[ "]')
	shita_pat = re.compile(r'shita[ "]')
	sage184_pat = re.compile('184|sage')
	color_pat = re.compile(r'#\s*([0-9a-fA-F]+)')
	lf_pat = re.compile(r'(.*)\n')
	premium_pat = re.compile(r'premium="([0-9]+)"')
	anonymity_pat = re.compile(r'anonymity="([0-9]+)"')

	tagList = [['&lt;','<'],['&gt;','>'],['&amp;','&'],['&quot;','"']]

	def chatdata(self,chat):
		m = self.chat_pat.search(chat)
		if m:
			date_s = None
			command = None
			userid_t = None
			tcolor = None
			tfont = None
			yposi = None
			vpos = None
			comment = None
			ng = False
			comment_len = 0
			lfcount = 0
			premium = None
			anonymity = None
			name = None
			try:
				params = m.group(1)
				comment = m.group(2)

				vpos_m = self.vpos_pat.search(params)
				date_m = self.date_pat.search(params)
				userid_m = self.userid_pat.search(params)
				mail_m = self.mail_pat.search(params)
				name_m = self.name_pat.search(params)
				premium_m = self.premium_pat.search(params)
				anonymity_m = self.anonymity_pat.search(params)
				if vpos_m:
					vpos = int(vpos_m.group(1))
				if date_m:
					date_s = int(date_m.group(1))
				if userid_m:
					userid_t = userid_m.group(1)
				if premium_m:
					premium = int(premium_m.group(1))
				if anonymity_m:
					anonymity = int(anonymity_m.group(1))

#				if self.isTimeShift and self.server_time and date_s:
##					print "testa=%s,%s,%s" %(vpos,self.server_time,date_s)
#					print "test=%s" %(int((self.server_time - date_s) / 10))
#					vpos -= int((self.server_time - date_s) / 10)
##					print "testb=%s" % (vpos)
#					if vpos < 0:
#						vpos = 0

				# 改行数の確認とコメントの速度調整
				for m in self.lf_pat.finditer(comment):
					lfcount += 1
					l = len(m.group(1).decode('utf8'))
					if comment_len < l:
						comment_len = l

				comment_dec = comment.decode('utf8')
				if 1 < premium:
					comment = self.tag_ptn.sub('',comment)

				if 0 == comment_len:
					comment_len = len(comment_dec)
				else:
					if self.__dbg__: print 'LF comment: %s,%d' % (comment, comment_len)

#				print comment_len,comment_dec.encode('utf8')

				if mail_m:
					mail = mail_m.group(1)
					command = re.sub(self.sage184_pat,'',mail)

				if name_m:
					name = name_m.group(1)

				# コメントタグフィルター
#				for i,before_after in enumerate(self.tagList):
				for before_after in self.tagList:
					if 0<=comment.find(before_after[0]):
						comment = comment.replace(before_after[0],before_after[1])

				# コメントフィルター(文字列部分を置換)
				if self.commentReplaceList != None:
#					for i,before_after in enumerate(self.commentReplaceList):
					for before_after in self.commentReplaceList:
						if 0<=comment.find(before_after[0]):
							comment = comment.replace(before_after[0],before_after[1])

				# コマンド解析
				if command != None and command != '""':
					tcolor = self.getCommentColor(command)

					# 上下位置コマンド
					if self.ue_pat.search(params):
						yposi = Y_POSI_UE
					elif self.shita_pat.search(params):
						yposi = Y_POSI_SHITA

					# フォントコマンド
					if 0 < lfcount:
						#print "lfcount=", lfcount
##						if 0 <= command.find(COMMAND_big):
##							tfont = self.smallFont
##						elif 0 <= command.find(COMMAND_small):
##							tfont = self.smallFont
##						elif 0 <= command.find(COMMAND_medium):
##							tfont = self.smallFont
						tfont = self.smallFont
					else:
						if 0 <= command.find(COMMAND_big):
							tfont = self.bigFont
						elif 0 <= command.find(COMMAND_small):
							tfont = self.smallFont
						elif 0 <= command.find(COMMAND_medium):
							pass

					if yposi != None:
						if tfont == self.bigFont:
							# 文字列長画面内表示調整
							if self.view_width < comment_len * self.midiumFontSize:
								tfont = self.smallFont
#								print "COMMAND_big -> COMMAND_small: %s" % print
							elif self.view_width < comment_len * self.bigFontSize:
								tfont = self.midiumFont
#								print "COMMAND_big -> COMMAND_medium: %s" % print
						elif tfont == None :
							# 文字列長画面内表示調整
							if self.view_width < comment_len * self.midiumFontSize:
								tfont = self.smallFont
#								print "COMMAND_medium -> COMMAND_small: %s" % print
				if yposi == None:
					# 中コメントのタイムラグ補正
					vpos -= TIME_LAG
				if self.__dbg__ and 1<premium: print 'Premium chat: %s,%s,%s,%s' % (premium,command,comment,name)
				return [vpos, comment, [tcolor, tfont, yposi], date_s , userid_t, ng, lfcount, comment_len, premium, anonymity, name]
			except Exception, e:
				print "error chatdata: %s" % e
				print "%s" % chat
		else:
			return None

	cruisePlayThread = None
	cruise_play = None
	cruisePlayRetryCount = 0
	def cruisePlay(self):
		'''ニコ生クルーズの再生処理'''
		self.cruisePlayRetryCount = 3
		while 0<self.cruisePlayRetryCount:
			playlist = xbmc.PlayList(xbmc.PLAYLIST_VIDEO)
			playlist.clear()
			playlist.add(self.cruise_play)
			xbmc.Player(xbmc.PLAYER_CORE_DVDPLAYER).play(playlist)
#			xbmc.Player(xbmc.PLAYER_CORE_DVDPLAYER).play(self.cruise_play)
			if xbmc.Player().isPlaying():
				self.cruisePlayRetryCount = 0
			else:
				self.cruisePlayRetryCount -= 1
				print "play retry count=%s" % (self.cruisePlayRetryCount)
				time.sleep(3)
		self.cruisePlayThread = None

	tag_ptn = re.compile(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>')
	koukoku_ptn = re.compile(r'<u>【.*】(.*)</u>')
	dq_ptn = re.compile(r'"(.+)"')
	bsp_ptn = re.compile(r'/press (.+?) (.+?) (.+?) @ (.+)')
	play_ptn = re.compile(r'rtmp:(.*) ')
	play_ptn2 = re.compile(r'/play (.*[0-9]+) ')
	crpanel_end_ptn = re.compile(r'message=(.*)&vid=(.*)&.*=(.*)')
	crpanel_start_ptn = re.compile(r'date=(.*)&title=(.*)&vid=(.*)')
	perm_ptn = re.compile('放送開始：(.*)タグ：(.*)タイトル：(.*)')
	vote_ptn = re.compile(r'([0-9]+)')
	entyou_ptn = re.compile("延長アンケート")
	next_ptn = re.compile('秒で次の放送へ出航します')

	telop_ptn = re.compile(r'/telop (.+?) (.+?)')

	def setCommentPosition(self,comment,command_array,vpos,user_id, lfcount, comment_len, premium, name):
		''' コメントの表示位置を計算し設定します'''

		disp_index = None
		y_posi = None
		x_posi = None
		tfont = None

		# フォントカラー
		tcolor = command_array[0]

		# フォントタイプ
		font_size = None
		if 1 < premium:
			tfont = self.smallFont
			font_size = self.smallFontSize
		elif command_array[1] == None:
			tfont = self.midiumFont
			font_size = self.midiumFontSize
		elif command_array[1] == self.bigFont:
			tfont = self.bigFont
			font_size = self.bigFontSize
		else:
			tfont = self.smallFont
			font_size = self.smallFontSize

		if 1 < premium:
			#運営特殊コメント
			if comment.startswith('/chukei '):
				comment = comment[13]
				premium = 0
				tfont = self.midiumFont
				font_size = self.midiumFontSize

		if premium == 2 or premium == 3 or premium == 6 or premium == 7:
			comment_len = len(comment)
			perm = False
			# 一定時間表示コメント
			if comment.startswith('/perm '):
				comment = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>','',comment)
				vpos += 30000
				for i,before_after in enumerate(self.tagList):
					if 0<=comment.find(before_after[0]):
						comment = comment.replace(before_after[0],before_after[1])
				comment = self.tag_ptn.sub('',comment)
				perm_m = self.perm_ptn.search(comment)
				if perm_m:
					date = perm_m.group(1)
					tag = perm_m.group(2)
					title = perm_m.group(3)
					comment = tag + title +" " + date
				comment = "☆ " + comment[6:]
				# 既にある場合は上書き
				if 0 < len(self.otherRowList) and self.otherRowList[0][7]:
					self.otherRowList[0][1]  = vpos
					self.otherRowList[0][0].setLabel(comment)
					return None
				perm = True

			# バックステージパス
			elif comment.startswith('/press '):
				bsp_m = self.bsp_ptn.search(comment)
				if bsp_m:
					color = bsp_m.group(2)
					tcolor = self.getCommentColor(color)
					comment = "%s: %s" % (bsp_m.group(4),bsp_m.group(3))

			# 一定時間表示コメントを消去
			elif comment.startswith('/cls') or comment.startswith('/clear'):
				if 0 < len(self.otherRowList) and self.otherRowList[0][7]:
					for i in range(len(self.otherRowList)):
						data = self.otherRowList[i]
						if data == None:
							continue
						if i==0:
							data[0].setVisible(False)
							data[1] = 0
						else:
							data[6] -= 1
							data[0].setPosition(8, int(screen_height - (data[6]+1) * self.smallFontSize - data[6] * 2))
				return None

			elif premium == 2:
				# 放送終了
				if comment.startswith('/disconnect'):
					if self.disconnect_auto_close:
						self.closeThread = threading.Thread(target=self.closePlayer,args=(1,))
						self.closeThread.setDaemon(True)
						self.closeThread.start()
#						comment += " *3秒後に自動終了します"
				else:
					dq_m = self.dq_ptn.search(comment)
					if dq_m:
						comment = "運営: "+dq_m.group(1)
					elif comment.startswith('/info '):
						comment = "運営: " + self.tag_ptn.sub('',comment[9:])
					else:
						comment = "運営: " + self.tag_ptn.sub('',comment)

			elif premium == 3 or premium == 6 or premium == 7:
				# 放送終了
				if premium == 3 and comment.startswith('/disconnect'):
					if self.disconnect_auto_close:
						self.closeThread = threading.Thread(target=self.closePlayer,args=(1,))
						self.closeThread.setDaemon(True)
						self.closeThread.start()
#						comment += " *3秒後に自動終了します"

				# テロップ
				elif premium == 3 and comment.startswith('/telop '):
					if comment.startswith('/telop off'):
						comment = "テロップ終了"
					else:
						telop_m = self.telop_ptn.search(comment)
						if telop_m:
							g1 = telop_m.group(1)
							g2 = telop_m.group(2)
							comment = "テロップ: " + self.tag_ptn.sub('',g2)

				# 入室
				elif premium == 3 and comment.startswith('/hb ifseetno '):
					if self.view_hb_ifseetno:
						comment = "座席番号 %s にプレミアム会員が入室" % comment[13:]
					else:
						return None

				# 広告
				elif comment.startswith('/koukoku '):
					koukoku_m = self.koukoku_ptn.search(comment)
					if koukoku_m:
						koukoku = koukoku_m.group(1)
					else:
						koukoku = comment[9:]
					comment = "広告: "+ koukoku

				elif comment.startswith('/coupon '):
					return None
				elif comment.startswith('/uadpoint '):
					return None

				# アンケート
				elif comment.startswith('/vote '):
					if self.enq_bg == None:
						self.enq_bg = xbmcgui.ControlImage(self.midiumFontSize*2,self.midiumFontSize*3-10,screen_width-self.midiumFontSize*3,self.midiumFontSize*10+40 + 3*10,os.path.join(image_dir,'enquete.png'))
						self.enq_bg.setVisible(False)
						self.addControl(self.enq_bg)

						label = xbmcgui.ControlLabel(self.midiumFontSize*3,self.midiumFontSize*(1+2),screen_width-self.midiumFontSize*6,100,"",self.midiumFont,DEF_COLORS[0])
						self.enq_label.append(label)
						label.setVisible(False)
						self.addControl(label)

						for i in range(1,11):
							label = xbmcgui.ControlLabel(self.midiumFontSize*3,self.midiumFontSize*(i+1+2) + ((i-1)*3) + 8,screen_width-self.midiumFontSize*6,100,"",self.midiumFont,DEF_COLORS[0])
							label.setVisible(False)
							self.enq_label.append(label)
							self.addControl(label)

					if comment.startswith('/vote start "'):
						for i in range(len(self.enq_label)):
							self.enq_label[i].setLabel("")
							self.enq_label[i].setVisible(False)
						self.enq_bg_Visible = True
						self.enq_bg.setVisible(True)
						vote_ptn = re.compile(r'\"(.*?)\"')
						noStr = ["","①","②","③","④","⑤","⑥","⑦","⑧","⑨"]
						for i,m in enumerate(vote_ptn.finditer(comment)):
							self.enqArray.append(m.group(1))
							self.enq_label[i].setVisible(True)
							self.enq_label[i].setLabel(noStr[i] + " " + m.group(1))
						comment = "アンケート:" + comment[12:]

					elif comment.startswith('/vote start '):
						self.enq_bg_Visible = True
						self.enq_bg.setVisible(True)
						noStr = ["","①","②","③","④","⑤","⑥","⑦","⑧","⑨"]
						for i,elem in enumerate(comment[12:].split(' ')):
							self.enqArray.append(elem)
							self.enq_label[i].setVisible(True)
							self.enq_label[i].setLabel(noStr[i] + " " + self.tag_ptn.sub('',elem))
						comment = "アンケート:" +comment[12:]

					elif comment.startswith('/vote stop'):
						self.enq_bg_Visible = False
						self.enq_bg.setVisible(False)
						self.enqArray = []
						for i in range(len(self.enq_label)):
							self.enq_label[i].setLabel("")
							self.enq_label[i].setVisible(False)
						return None

					elif comment.startswith('/vote showresult text_per'):
						s = "アンケート: 結果"
						per = []
						for i,m in enumerate(self.vote_ptn.finditer(comment[27:])):
							per.append(int(m.group(1))/10.0)
						for i,p in enumerate(per):
							s += ' '+str(p)+'％'
							if i < len(self.enqArray)-1:
								self.enq_label[i+1].setLabel(self.enqArray[i+1] + "  "+str(p)+"％")
						comment = s

					elif comment.startswith('/vote showresult per '):
						s = "アンケート: 結果"
						per = []
						for i,m in enumerate(self.vote_ptn.finditer(comment[21:])):
							per.append(int(m.group(1))/10.0)
						noStr = ["①","②","③","④","⑤","⑥","⑦","⑧","⑨"]
						for i,p in enumerate(per):
							s += ' '+str(p)+'％'
							if i < len(self.enqArray)-1:
								self.enq_label[i+1].setLabel(noStr[i] + " " + self.enqArray[i+1] + "  " + str(p) + "％")
						comment = s

				# 動画の再生
				elif self.watchTourStreaming and comment.startswith('/play '):
					if xbmc.Player().isPlaying():
						xbmc.Player().stop()
					if self.tourTitle == 'ニコ生クルーズ':
						play_m = self.play_ptn.search(comment)
						if play_m:
							contents_str = play_m.group(1)
							params = contents_str.split(",")
							liveid = params[1]

							playurl = '%s/%s ' % (self.rtmp_url,liveid)
	#						playurl+= 'timeout=5000 '
							playurl+= 'subscribe=%s ' % contents_str
							playurl+= 'conn=S:%s ' % self.rtmp_ticket
							playurl+= 'live=true'

							self.cruise_play = playurl
							if self.cruisePlayThread == None:
								self.cruisePlayThread = threading.Thread(target=self.cruisePlay,args=())
								self.cruisePlayThread.setDaemon(True)
								self.cruisePlayThread.start()
							print "playurl="+playurl
					else:
						play_m = self.play_ptn2.search(comment)
						if play_m:
							liveid = play_m.group(1)

							playurl = '%s/%s ' % (self.rtmp_url,liveid)
	#						playurl+= 'timeout=5000 '
							playurl+= 'conn=S:%s ' % self.rtmp_ticket
							playurl+= 'live=true'

							self.cruise_play = playurl
							if self.cruisePlayThread == None:
								self.cruisePlayThread = threading.Thread(target=self.cruisePlay,args=())
								self.cruisePlayThread.setDaemon(True)
								self.cruisePlayThread.start()
						print "playurl="+playurl
					return None

				# 動画の停止
				elif self.watchTourStreaming and comment.startswith('/stop'):
					if xbmc.Player().isPlaying():
						xbmc.Player().stop()
					self.cruise_bg.setVisible(True)
					self.cruise_bg_visible = True
					time.sleep(1.0)
					return None

				# パネル
				elif comment.startswith('/panel clear'):
					if self.enq_bg != None:
						self.enq_bg_Visible = False
						self.enq_bg.setVisible(False)
						self.enqArray = []
						for i in range(len(self.enq_label)):
							self.enq_label[i].setLabel("")
							self.enq_label[i].setVisible(False)
					return None
				elif comment.startswith('/crpanel '):
					if comment[0:14] == '/crpanel start':
						comment = urllib.unquote(comment)
						crpanel_start_m = self.crpanel_start_ptn.search(comment)
						if crpanel_start_m:
							date = crpanel_start_m.group(1)
							title = crpanel_start_m.group(2)
							vid = crpanel_start_m.group(3)
							comment = title + " "+date+"["+vid+"]"
					elif comment.startswith('/crpanel end'):
						comment = urllib.unquote(comment)
						crpanel_end_m = self.crpanel_end_ptn.search(comment)
						if crpanel_end_m:
							message = crpanel_end_m.group(1)
							vid = crpanel_end_m.group(2)
							coid = crpanel_end_m.group(3)
							comment = message + " " + vid + " " + coid

				# コメントモード
				elif comment.startswith('/commentmode '):
					return None
				else:
					if self.watchTourStreaming:
						if self.entyou_ptn.search(comment):
							return None
						if self.next_ptn.search(comment):
							return None
					else:
						comment = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>','',comment)
						dq_m = self.dq_ptn.search(comment)
						if dq_m:
							comment = dq_m.group(1)
#							comment = "放送主: "+dq_m.group(1)
						elif comment[0:6] == '/info ':
							if name:
								comment = "★" + name + ": " + self.tag_ptn.sub('',comment[9:])
							else:
								comment = "運営: " + self.tag_ptn.sub('',comment[9:])
						else:
							if name:
								comment = "★" + name + ": " + self.tag_ptn.sub('',comment)
#							else:
#								comment = "運営: " + self.tag_ptn.sub('',comment)

			if 0 < len(self.otherRowList) and self.otherRowList[0][7]:
				disp_index = 1
			else:
				disp_index = 0

			for i in range(disp_index,len(self.otherRowList)):
				data = self.otherRowList[i]
				if data == None:
					continue
				data[6] += 1
				if self.other_comment_max_rows < data[6]:
					data[0].setVisible(False)
					continue
				data[0].setPosition(int(3 * self.scaleX), int(self.view_height - (data[6]+1) * self.smallFontSize - data[6] * 8 - 8 - self.margin_bottom))

			x_posi = 3 * self.scaleX
			y_posi = self.view_height - (disp_index + 1) * self.smallFontSize - 8 - self.margin_bottom

		elif command_array[2] == None:
			idou = float(comment_len * font_size + self.comment_view_width) / self.naka_time

			# 空または最も表示時間が古い列を検索
			self.lock.acquire()
			for i in range(len(self.nakaRowList)):
				list_size = len(self.nakaRowList[i])
				if list_size == 0 : # 列のコメント判定
					disp_index = i
					break
				else:
					pop_comment_idou = (vpos - self.nakaRowList[i][list_size-1][1][1]) * self.nakaRowList[i][list_size-1][3]
					pop_comment_width = (self.nakaRowList[i][list_size-1][4] * self.nakaRowList[i][list_size-1][2])
					# 前方の文字列の移動速度が対象のコメントよりも速い場合の当たり判定
					if idou <= self.nakaRowList[i][list_size-1][3]:
#						print "High speed: %s < %s" % (pop_comment_width,pop_comment_idou)
						if pop_comment_width + font_size * 2 < pop_comment_idou:
							disp_index = i
							break
					# 前方の文字列の移動速度が対象のコメントよりも遅い場合の当たり判定
					else:
						empty_width = pop_comment_idou - pop_comment_width
						idou_diff = idou - self.nakaRowList[i][list_size-1][3]
#						print "Low speed: %s < %s" % (idou_diff * self.naka_time,empty_width)
						if idou_diff * self.naka_time + font_size * 2 < empty_width :
							disp_index = i
							break
			self.lock.release()
			# 弾幕
			if disp_index == None :#and len(self.danmakuRowList) < len(self.nakaRowList):
				disp_index = -1
				y_posi = random.randint(2,self.view_height-self.commentLineHeight)
			if disp_index == None:
				return False
			if y_posi == None:
				y_posi = disp_index * self.commentLineHeight + 2
			x_posi = self.view_width

		else:
			# 上下位置コマンド
			overlap_count = 0

			if command_array[2] == Y_POSI_UE:
				# 同一ユーザーが同一時刻に改行付コメントを入れている場合は、同じY軸上にコメントを設定する
				# 改行が入っていない場合は軸を一つずらす
				if 0 < lfcount:
					for i in range(len(self.ueRowList)):
						if len(self.ueRowList[i]) != 0 and self.ueRowList[i][0][2] == user_id and self.ueRowList[i][0][1] == vpos:
							disp_index = i
							overlap_count = len(self.ueRowList[i])
##							lastIndex = len(self.ueRowList[i])-1
##							if len(self.ueRowList[i][lastIndex][3][0]) == len(comment):
##								overlap_count = self.ueRowList[i][lastIndex][4] + 1
##								print overlap_count,comment
							#print "ue 2=",disp_index,",",comment
							break
				else:
					for i in range(len(self.ueRowList)-1):
						if len(self.ueRowList[i]) != 0 and self.ueRowList[i][0][2] == user_id and self.ueRowList[i][0][1] == vpos:
							if len(self.ueRowList[i+1]) == 0:
								disp_index = i + 1
								#print "ue 1=",disp_index,",",comment
								break

				if disp_index == None:
					for i in range(len(self.ueRowList)):
						if len(self.ueRowList[i]) == 0:
							disp_index = i
							#print "ue 3=",disp_index,",",comment
							break
				if disp_index == None:
					#print "ue 4=",disp_index,",",comment
					return False

				y_posi = disp_index * self.commentLineHeight + 2 + self.margin_bottom

			else :
				correct_value = 0
				if 0 < lfcount:
					for i in range(len(self.shitaRowList)):
						if len(self.shitaRowList[i]) != 0 and self.shitaRowList[i][0][2] == user_id and self.shitaRowList[i][0][1] == vpos:
							disp_index = i
							overlap_count = len(self.shitaRowList[i])
##							lastIndex = len(self.shitaRowList[i])-1
##							if len(self.shitaRowList[i][lastIndex][3][0]) == len(comment):
##								overlap_count = self.shitaRowList[i][lastIndex][4] + 1
##								print overlap_count,comment
							#print "shita 2=",disp_index,",",comment
							break
				else:
					for i in range(len(self.shitaRowList)-1):
						if len(self.shitaRowList[i]) != 0 and self.shitaRowList[i][0][2] == user_id and self.shitaRowList[i][0][1] == vpos:
							if len(self.shitaRowList[i+1]) == 0:
								disp_index = i + 1
								#print "shita 1=",disp_index,",",comment
								break

				if disp_index == None:
					for i in range(len(self.shitaRowList)):
						if len(self.shitaRowList[i]) == 0:
							if i * self.commentLineHeight < lfcount * font_size:
								correct_value = i * self.commentLineHeight - lfcount * font_size
							disp_index = i
							#print "shita 3=",disp_index,",",comment
							break

				if disp_index == None:
					#print "shita 4=",disp_index,",",comment
					return False
				y_posi = self.view_height - (disp_index+1) * self.commentLineHeight + correct_value

			x_posi = int((self.view_width - int(comment_len * (font_size - font_size / self.adustCommentWidth))) / 2) - overlap_count * 8
			if x_posi < 2:
				x_posi = 2

		if tcolor == None: tcolor = DEF_COLORS[0]
		comment_label = xbmcgui.ControlLabel(int(x_posi),int(y_posi),5000,200,'',tfont,tcolor)
		self.addControl(comment_label)

		if premium == 2 or premium == 3 or premium == 6 or premium == 7:
			comment_label.setVisible(True)
			comment_label.setLabel(comment)
			self.lock.acquire()
			if(perm):
				self.otherRowList.insert(0,[comment_label,vpos,user_id,comment,0,False,disp_index,perm])
			else:
				self.otherRowList.append([comment_label,vpos,user_id,comment,0,False,disp_index,perm])
			self.lock.release()
		elif command_array[2] == None:
			comment_label.setLabel(comment)
			self.lock.acquire()
			t = time.time() * 100
			if disp_index == -1:
				self.danmakuRowList.append([comment_label,[t,vpos],comment_len,idou,font_size,y_posi])
			else:
				self.nakaRowList[disp_index].append([comment_label,[t,vpos],comment_len,idou,font_size,y_posi])
			self.lock.release()
		elif command_array[2] == Y_POSI_UE:
			comment_label.setVisible(False)
			comment_label.setLabel(comment)
			self.lock.acquire()
			self.ueRowList[disp_index].append([comment_label,vpos,user_id,comment,overlap_count,False])
			self.lock.release()
		elif command_array[2] == Y_POSI_SHITA:
			comment_label.setVisible(False)
			comment_label.setLabel(comment)
			self.lock.acquire()
			self.shitaRowList[disp_index].append([comment_label,vpos,user_id,comment,overlap_count,False])
			self.lock.release()
		return True

	def commentOperation(self):
		''' 字幕（中以外）の処理 '''

		while xbmc.Player().isPlaying() or self.watchTourStreaming:
			try:
				try:
					if self.playerSeekCount:
						# 上コメント
						for i in range(len(self.ueRowList)):
							list_size = len(self.ueRowList[i])
							if list_size == 0:
								continue
							for j in range(list_size-1,-1,-1):
								label = self.ueRowList[i][j][0]
								label.setVisible(False)
								self.ueRowList[i].pop(j)
								del label
						# 下コメント
						for i in range(len(self.shitaRowList)):
							list_size = len(self.shitaRowList[i])
							if list_size == 0:
								continue
							for j in range(list_size-1,-1,-1):
								label = self.shitaRowList[i][j][0]
								label.setVisible(False)
								self.shitaRowList[i].pop(j)
								del label
						# その他コメント
						other_len = len(self.otherRowList)
						for i in range(other_len-1,-1,-1):
							label = self.otherRowList[i][0]
							label.setVisible(False)
							self.otherRowList.pop(i)
							del label

						while self.playerSeekCount:
							time.sleep(0.5)
				except Exception, e:
					print "error commentOperation seek: %s" % e

				if  self.rtmpStreaming:
					Play_Time = time.time() * 100
				else:
					Play_Time = int(xbmc.Player().getTime() * 100)

				# 上コメント
				try:
					for i in range(len(self.ueRowList)):
						list_size = len(self.ueRowList[i])
						if list_size == 0:
							continue
						for j in range(list_size-1,-1,-1):
							passedTime = Play_Time - self.ueRowList[i][j][1]
							if self.ue_shita_time < passedTime or not self.showCommentView:
								label = self.ueRowList[i][j][0]
								label.setVisible(False)
								self.lock.acquire()
								self.ueRowList[i].pop(j)
								self.lock.release()
								del label
							elif not self.ueRowList[i][j][5] and -100 <= passedTime:
								label = self.ueRowList[i][j][0]
								self.ueRowList[i][j][5] = True
								label.setVisible(True)
				except Exception, e:
					print "error commentOperation ue: %s" % e
				# 下コメント
				try:
					for i in range(len(self.shitaRowList)):
						list_size = len(self.shitaRowList[i])
						if list_size == 0:
							continue
						for j in range(list_size-1,-1,-1):
							passedTime = Play_Time - self.shitaRowList[i][j][1]
							if self.ue_shita_time < passedTime or not self.showCommentView:
								label = self.shitaRowList[i][j][0]
								label.setVisible(False)
								self.lock.acquire()
								self.shitaRowList[i].pop(j)
								self.lock.release()
								del label
							elif not self.shitaRowList[i][j][5] and -100 <= passedTime:
								label = self.shitaRowList[i][j][0]
								self.shitaRowList[i][j][5] = True
								label.setVisible(True)
				except Exception, e:
					print "error commentOperation shita: %s" % e
				# その他コメント
				try:
					other_len = len(self.otherRowList)
					if 0 < other_len:
						for i in range(other_len-1,-1,-1):
							data = self.otherRowList[i]
#							if data[1] < 0:
#								continue
							passedTime = Play_Time - data[1]
							if self.other_time < passedTime or not self.showCommentView:
								self.lock.acquire()
								label = data[0]
								label.setVisible(False)
								self.otherRowList.pop(i)
								self.lock.release()
								del label

				except Exception, e:
					print "error commentOperation other: %s,%s" % (e,other_len)
				time.sleep(0.1)
			except Exception, e:
				print "error commentOperation: %s" % e
		if self.__dbg__: print "end commentOperation"

	def nakaCommentOperation(self):
		''' 字幕（中）の処理 '''

		previous_time = 0
		addTime = 0
		while xbmc.Player().isPlaying() or self.watchTourStreaming:
			try:
				if self.playerSeekCount:
					# 中コメント
					for i in range(len(self.nakaRowList)):
						list_size = len(self.nakaRowList[i])
						if list_size == 0:
							continue
						for j in range(list_size-1,-1,-1):
							label = self.nakaRowList[i][j][0]
							label.setVisible(False)
							self.nakaRowList[i].pop(j)
							del label
					# 弾幕コメント
					danmaku_len = len(self.danmakuRowList)
					for i in range(danmaku_len-1,-1,-1):
						label = self.danmakuRowList[i][0]
						label.setVisible(False)
						self.danmakuRowList.pop(i)
						del label
					while self.playerSeekCount:
						time.sleep(0.2)
					previous_time = 0
					continue

				if self.rtmpStreaming:
					player_time = time.time() * 100
				else:
					player_time = int(xbmc.Player().getTime() * 100)
					if previous_time == player_time:
						addTime += 1
						if 10 < addTime:
							while previous_time == player_time:
								player_time = int(xbmc.Player().getTime() * 100)
								time.sleep(0.01)
							t = time.time() * 100
							for i in range(len(self.nakaRowList)):
								list_size = len(self.nakaRowList[i])
								if list_size == 0:
									continue
								for j in range(list_size-1,-1,-1):
									self.nakaRowList[i][j][1][0] = t - (player_time - self.nakaRowList[i][j][1][1])
							danmaku_len = len(self.danmakuRowList)
							for i in range(danmaku_len-1,-1,-1):
								self.danmakuRowList[i][1][0] = t - (player_time - self.danmakuRowList[i][1][1])
							addTime = 0
					else:
						previous_time = player_time
						addTime = 0
					player_time = time.time() * 100

				# 中コメント
				try:
					for i in range(len(self.nakaRowList)):
						list_size = len(self.nakaRowList[i])
						if list_size == 0:
							continue
						for j in range(list_size-1,-1,-1):
							passedTime = player_time - self.nakaRowList[i][j][1][0]
							label = self.nakaRowList[i][j][0]
							if self.naka_time < passedTime or not self.showCommentView:
								label.setVisible(False)
								self.lock.acquire()
								self.nakaRowList[i].pop(j)
								self.lock.release()
								del label
							elif 0 <= passedTime:
								label.setPosition(int(self.comment_view_width - passedTime * self.nakaRowList[i][j][3]), self.nakaRowList[i][j][5])
				except Exception, e:
					print "error nakaCommentOperation naka: %s" % e
				# 弾幕コメント
				try:
					danmaku_len = len(self.danmakuRowList)
					for i in range(danmaku_len-1,-1,-1):
						passedTime = player_time - self.danmakuRowList[i][1][0]
						label = self.danmakuRowList[i][0]
						if self.naka_time < passedTime or not self.showCommentView:
							label.setVisible(False)
							self.lock.acquire()
							self.danmakuRowList.pop(i)
							self.lock.release()
							del label
						elif 0 <= passedTime:
							label.setPosition(int(self.view_width - passedTime * self.danmakuRowList[i][3]), self.danmakuRowList[i][5])
				except Exception, e:
					print "error nakaCommentOperation danmaku: %s" % e

				time.sleep(0.01)
			except Exception, e:
				print "error nakaCommentOperation: %s" % e
		if self.__dbg__: print "end nakaCommentOperation"

	def closePlayer(self, t):
		'''動画再生を終了します'''
		if self.__dbg__: print "end closePlayer"
		if 0 < t:time.sleep(t)
		self.closeNicoCommentView()
		xbmc.Player().stop()

	def initNicoVideoSettings(self):
		self.nicoVideo = NicoVideo.NicoVideo()
		self.nicoVideo.mailAddress = __settings__.getSetting("mailaddress")
		self.nicoVideo.passWord = __settings__.getSetting("password")
		self.nicoVideo.force_overwrite = True
		self.nicoVideo.save_message_xml = True
		self.nicoVideo.process_list = False
		self.nicoVideo.list_url = ''
		self.nicoVideo.root_dir = base_cache_path
		self.nicoVideo.loadCookie()
		if not self.nicoVideo.isLogin():
			if not self.nicoVideo.loginNicoVideo():
				print "エラー","ニコニコ動画へのログインに失敗しました。"

	def updatePlayerstatus(self):
		''' playerstatusを取得し、情報を更新します '''
		chikuran = Chikuwachan.ChikuwachanRanking()

		count_pat = re.compile(r'<watch_count>([0-9]+)</watch_count>.*<comment_count>([0-9]+)</comment_count>.*<room_label>(.*)</room_label>.*<room_seetno>([0-9]+)</room_seetno>')
		while self.running:
			if self.showInfoView:
				if self.__dbg__: print "start update playerstatus"
				ps = self.nicoVideo.apiGetPlayerStatus()
				if self.playerStatus == None:
					self.parcePlayerStatus(ps)
					if self.playerStatus == None:
						time.sleep(3.0)
						continue;

					self.ps_watch_count = int(self.playerStatus["watch_count"])
					self.ps_comment_count = int(self.playerStatus["comment_count"])
					self.ps_room_label = self.playerStatus["room_label"]
					self.ps_room_seetno = self.playerStatus["room_seetno"]
				else:
					ps_m = count_pat.search(ps)
					if ps_m:
						self.ps_watch_count = int(ps_m.group(1))
						self.ps_comment_count = int(ps_m.group(2))
						self.ps_room_label = ps_m.group(3)
						self.ps_room_seetno = ps_m.group(4)
					else:
						if self.__dbg__: print "apiGetPlayerStatus error:%s" %  ps

				if self.show_active_count and self.playerStatus and self.updatePlayerstatus_count % 6 == 0:
					if self.__dbg__: print "start getLiveRanking"
					try:
						#resultArray = chikuran.getAllRanking(page=1, category='', search=self.playerStatus['id'], sort='')
						resultArray = chikuran.getLiveRanking(self.playerStatus['id'])
						if resultArray == None:
							# アクティブ人数の取得に失敗
							if self.__dbg__: print "active = none"
						else:
							active_count = None
							for result in resultArray:
								if result['live_id'] == self.playerStatus['id']:
									active_count = resultArray[0]['value1']
									break
							if self.__dbg__: print "active = %s" % active_count
							self.active_count = active_count
					except Exception, e:
						print "error chikuran: %s" % e
						self.active_count = None
					if self.__dbg__: print "end getLiveRanking"
				self.setShowCount()
				if self.__dbg__: print "end update playerstatus (%s,%s,%s)" % (self.ps_watch_count,self.ps_comment_count,self.active_count)

				time.sleep(self.playerstatus_update_interval)
				self.updatePlayerstatus_count += 1
			time.sleep(10.0)
		if self.__dbg__: print "end updatePlayerstatus"

	def hiddenStartText(self):
		time.sleep(1.0)
		self.count_label.setLabel("")

	def xml_start(self):
		''' コメント表示開始 '''

		random.seed()

		self.hiddenStartTextThread = threading.Thread(target=self.hiddenStartText,args=())
		self.hiddenStartTextThread.setDaemon(True)
		self.hiddenStartTextThread.start()

		self.commentOperation = threading.Thread(target=self.commentOperation,args=())
		self.commentOperation.setDaemon(True)
		self.commentOperation.start()

		self.nakaCommentOperation = threading.Thread(target=self.nakaCommentOperation,args=())
		self.nakaCommentOperation.setDaemon(True)
		self.nakaCommentOperation.start()

		self.playerSeekTimeUnit = 30
#		self.playerSeekTimeUnit = int(xbmc.Player().getTotalTime() / 20)

#		if self.playerStatus:
#			self.commentAdjustTime = int(self.playerStatus["open_time"]) - int(self.playerStatus["start_time"])
#			if self.__dbg__: print "commentAdjustTime=" + str(self.commentAdjustTime)

		commentLen = len(self.chatList)
		if playerPause:
			xbmc.Player().pause()
			if self.__dbg__: print "xml_start pause"

		while self.running and (xbmc.Player().isPlaying() or self.watchTourStreaming):
			try:
				# シーク中のループ処理
				while 0 < self.playerSeekCount:
					self.playerSeekCount -= 1
					time.sleep(0.2)
				# 現在のコメント位置を検索
				startIndex = searchArrayPosition(self.chatList,int(xbmc.Player().getTime() * 100 - self.commentAdjustTime),0)
				self.comment_count = startIndex

				for i in range(startIndex,commentLen):
					if self.showInfoView: self.setShowCount()
					chat = self.chatList[i]
					vpos = chat[0] + self.commentAdjustTime
					comment = chat[1]
					command_array = chat[2]
#					date_str = chat[3]
					user_id = chat[4]

					if self.ngword_ptn:
						if self.ngword_ptn.search(comment):
							self.ngword_count += 1
							if self.__dbg__:
								print "NG Word: %s, %s" % (user_id,comment)
								comment = "(NGC)" + comment
							if self.ng_filter_mode: continue
					if self.ng_user_list:
						if self.ng_user_list.get(user_id):
							self.ngword_count += 1
							if self.__dbg__:
								print "NG User: %s, %s" % (user_id,comment)
								comment = "(NGU)" + comment
							if self.ng_filter_mode: continue

					Play_Time = int(xbmc.Player().getTime() * 100)
					if command_array[2] != None:
						if vpos + self.ue_shita_time < Play_Time:
							self.comment_count += 1
							continue
					else:
						if vpos + self.naka_time < Play_Time:
							self.comment_count += 1
							continue
					while Play_Time <= vpos:
						if 0 < self.playerSeekCount:
							break
						Play_Time = int(xbmc.Player().getTime() * 100)
						time.sleep(0.02)
					else:
						if self.showCommentView:
							self.comment_count += 1
							premium = chat[8]
#							if command_array[2] or premium == 2 or premium == 3 or premium == 6 or premium == 7:
#								if vpos - TIME_LAG - 100 <= Play_Time:
#									vpos = Play_Time + 100
#							else:
#								if self.rtmpStreaming:
#									vpos = time.time() * 100
							try:
								if self.view_comment_user:
									comment = user_id + "「" + comment + "」"
								self.setCommentPosition(comment,command_array,vpos,user_id,chat[6],chat[7],premium,chat[10])
							except Exception, e:
								print "error setCommentPosition: %s,%s" % (e,comment)
						else:
							self.comment_count += 1
							continue
					if 0 < self.playerSeekCount:
						break
				if self.showInfoView:
					self.setShowCount()
			except Exception, e:
				print "error xml_start: %s" % e
		if self.__dbg__: print "end xml_start"

	def getNamaComment(self):
		import socket
#		import struct

		commentStartPlayerTime = 0
		self.niconamaCommentXmlFile = None
		disconnect = False
		if self.__dbg__: self.niconamaCommentXmlFile = open(os.path.join(debug_dir,"%s.xml" % self.nicoVideo.video_id), 'wb')
		try:
			while self.running and (xbmc.Player().isPlaying() or self.watchTourStreaming):
				if self.watchTourStreaming:
					retryCount = 3
				else:
					retryCount = 1
				if self.__dbg__: print "Connect to ms server. %s, %s, %s" % (self.ms_addr,self.ms_port,self.ms_thread)
				try:
					sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
					sock.connect((self.ms_addr, self.ms_port))
#					sock.setsockopt(socket.SOL_SOCKET, socket.SO_RCVTIMEO, struct.pack('2L', 3, 0))
					xml = '<thread thread="%s" version="20061206" res_from="-1"/>\0' % self.ms_thread
					sock.send(xml)
#					sock.send(struct.pack('b',0))
					data = sock.recv(2048)
					data = re.sub(chr(0), " ", data)
					if self.niconamaCommentXmlFile: self.niconamaCommentXmlFile.write(data)

					beforeChat = [0]
					while self.running and 0 <= retryCount:
						data = sock.recv(2048)[:-1]
						data = re.sub(chr(0), " ", data)
						try:
#							if self.__dbg__ and 'premium=' in data: print data
							if self.niconamaCommentXmlFile: self.niconamaCommentXmlFile.write(data)

							#コメントの一部しか取得できなかった場合の対応予定部分

							chat = self.chatdata(data)
							if  self.watchTourStreaming:
								retryCount = 3
								Play_Time = time.time()*100
								chat[0] = Play_Time + 50
							else:
								if chat[0] == None:
									chat[0] = 0
								else:
									if commentStartPlayerTime == 0:
										commentStartPlayerTime = chat[0] - int(xbmc.Player().getTime() * 100)
									chat[0] = chat[0] - commentStartPlayerTime
							# vposが前後する場合の対策
							if chat[0] < beforeChat[0]:
								if self.__dbg__: print "vpos change: %s -> %s" % (beforeChat[0],chat[0])
								beforeChat[0] = chat[0]
							beforeChat = chat
							self.chatList.append(chat)

							if self.disconnect_auto_close:
								if chat[8] == 3 and chat[1].startswith('/disconnect'):
									if self.__dbg__: print "/disconnect"
									disconnect = True
									break
						except Exception, e:
							print "getNamaComment error (retry=%s): %s, %s" % (retryCount,str(e),data)
							retryCount -= 1
				except Exception, e:
					print "getNamaComment error: %s" % (e)
				sock.close()
				if disconnect:
					break

				if self.running and (xbmc.Player().isPlaying() or self.watchTourStreaming):
					body = self.nicoVideo.apiGetPlayerStatus()
					if not re.compile('<getplayerstatus ').search(body):
						print "getNamaComment retry error: %s" % body
						break
					result = self.nicoVideo.setGetplayerstatus(getplayerstatus=body)
					if result:
						print "getNamaComment retry error: %s" % body
						break
					self.ms_addr = self.nicoVideo.ms_addr
					self.ms_port = self.nicoVideo.ms_port
					self.ms_thread = self.nicoVideo.ms_thread
		finally:
			if self.niconamaCommentXmlFile: self.niconamaCommentXmlFile.close()
		if self.__dbg__: print "end getNamaComment"

	def nama_start(self):
		''' コメント表示開始 '''

		self.count_label.setLabel("")
		random.seed()

		if not self.watchTourStreaming:
			self.updatePlayerstatusThread = threading.Thread(target=self.updatePlayerstatus,args=())
			self.updatePlayerstatusThread.setDaemon(True)
			self.updatePlayerstatusThread.start()

		self.getNamaComment = threading.Thread(target=self.getNamaComment,args=())
		self.getNamaComment.setDaemon(True)
		self.getNamaComment.start()

		self.commentOperation = threading.Thread(target=self.commentOperation,args=())
		self.commentOperation.setDaemon(True)
		self.commentOperation.start()

		self.nakaCommentOperation = threading.Thread(target=self.nakaCommentOperation,args=())
		self.nakaCommentOperation.setDaemon(True)
		self.nakaCommentOperation.start()

		self.playerSeekTimeUnit = 0
		i=0
		while self.running and (xbmc.Player().isPlaying() or self.watchTourStreaming):
			try:
				# シーク中のループ処理
				while 0 < self.playerSeekCount:
					self.playerSeekCount -= 1
					time.sleep(0.2)

				if self.watchTourStreaming:
					if xbmc.Player().isPlaying():
						if self.cruise_bg_visible:
							self.cruise_bg_visible = False
							self.cruise_bg.setVisible(False)
					else:
						if not self.cruise_bg_visible:
							self.cruise_bg_visible = True
							self.cruise_bg.setVisible(True)
				if i == len(self.chatList):
					time.sleep(0.1)
					continue
				self.comment_count += 1
				chat = self.chatList[i]

				comment = chat[1]
				command_array = chat[2]
#						date_str = chat[3]
				user_id = chat[4]

				if self.ngword_ptn:
					if self.ngword_ptn.search(comment):
						self.ngword_count += 1
						if self.__dbg__:
							print "NG Word: %s, %s" % (user_id,comment)
							comment = "(NGC)" + comment
						if self.ng_filter_mode: continue
				if self.ng_user_list:
					if self.ng_user_list.get(user_id):
						self.ngword_count += 1
						if self.__dbg__:
							print "NG User: %s, %s" % (user_id,comment)
							comment = "(NGU)" + comment
						if self.ng_filter_mode: continue

				if self.watchTourStreaming:
					try:
						vpos = time.time() * 100 + 100
						self.setCommentPosition(comment,command_array,vpos,user_id,chat[6],chat[7],chat[8],chat[10])
					except Exception, e:
						print "error setCommentPosition: %s,%s" % (e,comment)
				else:
					vpos = chat[0] + self.commentAdjustTime
					Play_Time = int(xbmc.Player().getTime() * 100)
					if self.showCommentView:
						while Play_Time <= chat[0] + self.commentAdjustTime:
							if 0 < self.playerSeekCount:
								break
							Play_Time = int(xbmc.Player().getTime() * 100)
							vpos = chat[0] + self.commentAdjustTime
							time.sleep(0.1)
						else:
							try:
								vpos = time.time() * 100 + self.commentAdjustTime
								if self.view_comment_user:
									comment = user_id + "「" + comment + "」"
								self.setCommentPosition(comment,command_array,vpos,user_id,chat[6],chat[7],chat[8],chat[10])
							except Exception, e:
								print "error setCommentPosition: %s,%s" % (e,comment)
				i += 1
			except Exception, e:
				print "error nama_start: %s" % e
		if self.__dbg__: print "end nama_start"

	def closeNicoCommentView(self):
		if self.__dbg__: print "closeNicoCommentView"
		self.running = False
		if self.infoDialog: self.infoDialog.close()
		self.close()

class InfoDialog(xbmcgui.WindowDialog):

	def __init__(self):
		if Emulating: xbmcgui.WindowDialog.__init__(self)
		self.addControl(xbmcgui.ControlImage(0,0,screen_width,screen_height, os.path.join(image_dir,'enquete.png')))

	def setTextLabel(self,s1,s2,s3,s4,s5):
		smallFont = 'nico_font_24'
		smallFontSize = 24
		scaleX = ( float(screen_width)  / float(640) )
		scaleY = ( float(screen_height) / float(480) )
		self.label1 = xbmcgui.ControlTextBox(int(8*scaleX),int(10*scaleY),int((screen_width-20)),int(smallFontSize*2*scaleY),smallFont,DEF_COLORS[0])
		self.label2 = xbmcgui.ControlTextBox(int(8*scaleX),int((10+(smallFontSize+10)*1)*scaleY),int((screen_width-20)),int(smallFontSize*2*scaleY),smallFont,DEF_COLORS[0])
		self.label3 = xbmcgui.ControlTextBox(int(8*scaleX),int((10+(smallFontSize+10)*2)*scaleY),int((screen_width-20)),int(smallFontSize*2*scaleY),smallFont,DEF_COLORS[0])
		self.label4 = xbmcgui.ControlTextBox(int(8*scaleX),int((10+(smallFontSize+10)*3)*scaleY),int((screen_width-20)),int(smallFontSize*16*scaleY),smallFont,DEF_COLORS[0])
		self.addControl(self.label1)
		self.addControl(self.label2)
		self.addControl(self.label3)
		self.addControl(self.label4)

		self.label1.setText(s1)
		self.label2.setText(s2)
		self.label3.setText(s3)
		self.label4.setText(s4 + '\r\n\r\n' + s5)

	def onAction(self, action):
		if action == ACTION_PREVIOUS_MENU or action == ACTION_PARENT_DIR or action == ACTION_MOVE_DOWN:
			self.state = -1 #success
			self.close() #exit
		elif action == ACTION_MOVE_UP :
			pass

	def onControl(self, control):
		self.setFocus(control)

print "NicoCommentView argv: %s" % (repr(sys.argv))
if xbmc.Player().isPlaying() or 5 < len(sys.argv):
	viewer = NicoCommentViewer()
	viewer.doModal()
	del viewer

