#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, sys
import urllib
import socket
import re ,time
import cgi
import urllib2
import math

import httplib
from httplib import HTTPConnection, HTTPS_PORT
import ssl


NICO_VIDEO_TYPE = {
	"v" : "flv",
	"m" : "mp4",
	"s" : "swf",
}
NICO_VIDEO_DEFAULT_EXT = "flv"
kb = 1024

CHANNEL_CATEGORY = [ 'テレビ/メディア', 'お笑い/映画/音楽', 'スポーツ', 'アーティスト/タレント', '生活', '政治', 'アニメ/特撮', 'ゲーム', 'バラエティ', 'グラビア']

GETPLAYERSTATUS_ERROR_MESSAGE = {'comingsoon':'まだ配信が開始されていません',
						 'closed':'配信が終了しています',
						 'require_community_member':'コミュニティ限定の放送です',
						 'notlogin':'ログインしていません',
						 'invalid_thread':'放送が見つかりませんでした',
						 'invalid_v1':'放送が見つかりませんでした',
						 'unknown_error':'不明なエラーが発生しました(1)',
						 'unknown':'不明なエラーが発生しました(2)',
						 'maintenance':'メンテナンス中です',
						 'server_error':'サーバエラーが発生しました',
						 'DELETED':'削除済みの番組です',
						 'full':'満員(放送中)です',
						 'permission_denied':'許可されていないアクセスです',
						 'not_permitted':'終了した放送です',
						 'access_locked':'許可されていないアクセスです',
						 'tsarchive':'有料放送です',
						 'usertimeshift':'コミュニティ限定のタイムシフトです',
						 'noauth':'有料生放送です',
						 }

def tr_all(str, remove_list, replace):
	for rem in remove_list:
		str = str.replace(rem, replace)
	return str

def regulate_filename(str):
	global code
	code = 'utf-8'
	str = str.encode(code, 'ignore')
	#print str
	return tr_all(str, '\\/:?*', '_').replace('..', '_')

class ThumbInfoData:
			pass
class NicoVideo:
	mailAddress = None
	passWord = None
	force_overwrite = True
	save_message_xml = True
	process_list = False
	list_url = ''
	maxCommentNum = 1000
	video_id = None
	root_dir = None

	View_JPtitle = None
#	View_Comment = None
#	View_Keywords = None
#	Contribute_Day = None
	View_Length = None


	#getflv
	thread_id = None
#	l = None
#	url = None
#	link = None
#	ms = None
	user_id = None
	is_premium = None
	nickname = None
	time = None
	done = None
	needs_key = None
	optional_thread_id = None

	getthreadkeyArray = None

	economyMode = False

	low_check = None
	cache_file_size = None

	User_Agent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4'

#	block_size = kb * 10 # 10kb
	block_size = kb * 100 # 100kb

	def __init__(self):
		self.nico_conn = None
		self.nico_secure_conn = None
		self.nico_account_conn = None
		self.channel_conn = None
		self.flv_conn = None
		self.message_conn = None
		self.user_session = ''
		self.nicohistory = ''
		self.nicosid = ''
		self.user_session_secure = ''
		self.headers = {}

		#now we override the one in httplib
#		httplib.HTTPSConnection = HTTPSConnection
		# ssl_version corrections are done


	def establishConnectionChannel(self):
		"""nicovideoドメインの接続"""
		if self.channel_conn:
			self.channel_conn.close()
		try:
#			self.channel_conn = httplib.HTTPConnection('ch.nicovideo.jp', 80)
			self.channel_conn = httplib.HTTPSConnection('ch.nicovideo.jp')
			self.headers = {'User-Agent':'	Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4',
				'Accept': '*/*',
				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
				'Accept-Charset': 'UTF-8,*',
				'Connection': 'keep-alive',
				'Keep-Alive': '300',
				'Cookie': '; '.join([ self.nicosid, self.user_session, self.user_session_secure])}
		except socket.error, e:
			print 'Socket error', e[0]
		except Exception, e:
			print 'error: %s' % e

	def establishConnection(self):
		"""nicovideoドメインの接続"""
		if self.nico_conn:
			self.nico_conn.close()
		try:
#			self.nico_conn = httplib.HTTPConnection('www.nicovideo.jp', 80)
			self.nico_conn = httplib.HTTPSConnection('www.nicovideo.jp')
			self.headers = {'User-Agent':self.User_Agent,
				'Accept': '*/*',
				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
				'Accept-Charset': 'UTF-8,*',
				'Connection': 'keep-alive',
				'Keep-Alive': '300',
				'Cookie': '; '.join([ self.nicosid, self.user_session, self.user_session_secure])}
		except socket.error, e:
			print 'Socket error', e[0]
		except Exception, e:
			print 'error: %s' % e

	def establishSecureConnection(self):
		"""https接続"""
		if self.nico_secure_conn:
			self.nico_secure_conn.close()
		try:
			self.nico_secure_conn = httplib.HTTPSConnection('secure.nicovideo.jp')
			self.headers = {'User-Agent':self.User_Agent,
				'Accept': '*/*',
				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
				'Accept-Charset': 'UTF-8,*',
				'Connection': 'keep-alive',
				'Keep-Alive': '300',
				'Cookie': '; '.join([ self.nicosid, self.user_session, self.user_session_secure])}
		except socket.error, e:
			print 'Socket error', e[0]
		except Exception, e:
			print 'error: %s' % e


	def establishAccountConnection(self):
		"""https接続"""
		if self.nico_account_conn:
			self.nico_account_conn.close()
		try:
			self.nico_account_conn = httplib.HTTPSConnection('account.nicovideo.jp')
			self.headers = {'User-Agent':self.User_Agent,
				'Accept': '*/*',
				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
				'Accept-Charset': 'UTF-8,*',
				'Connection': 'keep-alive',
				'Keep-Alive': '300',
#				'Cookie': '; '.join([self.user_session, self.nicohistory])}
				'Cookie': '; '.join([ self.nicosid, self.user_session, self.user_session_secure])}
#				'Cookie': '; '.join(['_ga=','nicorepo_filter=all', self.nicosid, 'optimizelyBuckets={}','optimizelyEndUserId=','optimizelySegments={}', self.user_session, self.user_session_secure])}
		except socket.error, e:
			print 'Socket error', e[0]
		except Exception, e:
			print 'error: %s' % e

	def establishFLVConnection(self, server):
		"""FLVを取得するサーバに接続"""
		if self.flv_conn:
			self.flv_conn.close()
		try:
			self.flv_conn = httplib.HTTPConnection(server, 80)
		except socket.error, e:
			print 'Socket error', e[0]
		except Exception, e:
			print 'error: %s' % e

	def establishMessageConnection(self, server, port=80):
		"""コメントサーバに接続"""
		if self.message_conn:
			self.message_conn.close()
		try:
			self.message_conn = httplib.HTTPConnection('%s.nicovideo.jp' % server, port)
		except socket.error, e:
			print 'Socket error', e[0]
		except Exception, e:
			print 'error: %s' % e


	def retryingAccess(self, conn, request_args, retry=2, wait=5):
		rs = None
		while retry>0:
			try:
				method, path, body, headers = request_args
				conn.request(method, path, body, headers)
				rs = conn.getresponse()
				break
			except Exception, e:
				print e
				print 'getresponse failed. waiting for %d seconds..' % wait
				retry -= 1
#				if retry<=0:
#					raise e

				time.sleep(wait)
				conn.close()
#				self.loginNicoVideo()

		return rs

	def getCookiePath(self):
		"""クッキーのパス取得"""
		cookie_file = os.path.join(self.root_dir, "cookie.txt")
		return cookie_file

	def refreshCookie(self, response):
		"""クッキー再設定"""
#		print self.root_dir
		try:
			cookie = response.getheader('Set-Cookie')
			if(cookie == None):
				print 'Set-Cookie=None'
			else:
				print 'Set-Cookie=' + cookie
			if cookie:
				# nicosid
				search_obj = re.compile('(nicosid=[^;]*);?').search(cookie)
				if search_obj:
					self.nicosid = search_obj.group(1)

				# user_session
				search_obj = re.compile('(user_session=(?!deleted)[^;]*);?').search(cookie)
				if search_obj:
					self.user_session = search_obj.group(1)

				# nicohistory
				search_obj = re.compile('(nicohistory=[^;]*);?').search(cookie)
				if search_obj:
					self.nicohistory = search_obj.group(1)

				# user_session_secure
				search_obj = re.compile('(user_session_secure=(?!deleted)[^;]*);?').search(cookie)
				if search_obj:
					self.user_session_secure = search_obj.group(1)

				# save
#				self.headers['Cookie'] = '; '.join([self.nicosid, self.user_session, self.nicohistory])
				self.headers['Cookie'] = '; '.join([self.nicosid, self.user_session,self.user_session_secure])
				fo = open(os.path.join(self.root_dir, "cookie.txt"), 'wb')
#				fo.write(self.user_session)
				fo.write(self.headers['Cookie'])
				fo.close()
		except Exception, e:
			print 'refreshCookie error: %s' % e

	def loadCookie(self):
		"""クッキー読み込み"""
		cookie_file = os.path.join(self.root_dir, "cookie.txt")

		if os.access(cookie_file, os.F_OK):
			cookie = file(cookie_file,'rb').read()

			# nicosid
			search_obj = re.compile('(nicosid=[^;]*);?').search(cookie)
			if search_obj:
				self.nicosid = search_obj.group(1)
			# user_session
			search_obj = re.compile('(user_session=(?!deleted)[^;]*);?').search(cookie)
			if search_obj:
				self.user_session = search_obj.group(1)

			# user_session_secure
			search_obj = re.compile('(user_session_secure=(?!deleted)[^;]*);?').search(cookie)
			if search_obj:
				self.user_session_secure = search_obj.group(1)

#			self.user_session = cookie
#			self.headers['Cookie'] = self.user_session
			self.headers['Cookie'] = cookie

	def isLogin(self):
		"""トップページにアクセスしてログインしているか確認"""
		self.establishConnection()
		if self.mailAddress == '' or  self.passWord == '':
			return True

		rs = self.retryingAccess(self.nico_conn, ('GET', '/my/top', '', self.headers))
		self.refreshCookie(rs)
		# 確認
		body = rs.read()
#		print body
		rs.close()
		if rs.status == 302:
			print 'Login 0'
			return False
		else:
			# print 'Login 1', self.headers['Cookie']
			return True

	def loginNicoVideo(self):
		"""ニコニコ動画ログイン"""
		self.establishConnection()
		self.establishAccountConnection()
		post_dict = {
#					'next_url': '',
			'submit': '',
#			'mail': self.mailAddress,
			'mail_tel': self.mailAddress,
			'password': self.passWord,
			}
		self.headers['Referer'] = 'https://account.nicovideo.jp/login?site=niconico&time=&hash_key=&next_url='
		if self.mailAddress == '' or  self.passWord == '':
			print 'not login user'
			return False
		headers = self.headers.copy()
		del(headers['Cookie'])
		headers['Content-type'] = 'application/x-www-form-urlencoded';
		rs = self.retryingAccess(self.nico_account_conn, ('POST', '/api/v1/login?show_button_twitter=1&site=niconico&show_button_facebook=1&mail_or_tel=1', urllib.urlencode(post_dict), headers))
		# クッキー保存
		self.refreshCookie(rs)
		if not rs:
			return False
		rs.read() # 捨てないとログインできない
		rs.close()

		return self.isLogin()


	def getWatchVideoID(self):
		""" wacthページにアクセスするためのvideoidを取得します """

		if(self.video_id[0:2] == "nm"):
			urlparam = self.video_id + "?as3=1";
		elif(self.economyMode):
			urlparam = self.video_id + "?eco=1"
		else:
			urlparam = self.video_id

		try:
#			redirect_conn = httplib.HTTPConnection('flapi.nicovideo.jp', 80)
			redirect_conn = httplib.HTTPSConnection('flapi.nicovideo.jp')
			self.headers = {'User-Agent':self.User_Agent,
				'Accept': '*/*',
				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
				'Accept-Charset': 'UTF-8,*',
				'Connection': 'keep-alive',
				'Keep-Alive': '300',
				'Cookie': '; '.join([self.user_session, self.nicohistory])}

			rs = self.retryingAccess(redirect_conn, ('GET', '/api/getflv/%s' % urlparam, '', self.headers))
			body = rs.read()
#			print body
			watch_video_id = re.compile('thread_id=([0-9]+)').search(body).group(1)
			return watch_video_id
		finally:
			if redirect_conn:
				redirect_conn.close()
			if rs:
				rs.close()

		return self.video_id

	def retrieveVideoID(self):
		""" watchページからタイトルとvを得る"""
		self.establishConnection()

		if(self.video_id[0:2] == "nm"):
			urlparam = self.video_id + "?as3=1";
		elif(self.economyMode):
			urlparam = self.video_id + "?eco=1"
		else:
			urlparam = self.video_id

		#エラー403が返ってくるので停止
#		rs = self.retryingAccess(self.nico_conn, ('GET', '/watch/%s' % urlparam, '', self.headers))
		rs = self.retryingAccess(self.nico_conn, ('GET', '/watch/%s' % urlparam, '',{}))
		self.refreshCookie(rs)

#		print 'http://www.nicovideo.jp/watch/%s' % urlparam
		body = rs.read()
#		print body
		rs.close()

		if rs.status!=200:
			print >> sys.stderr, u'Error: HTTP not OK'
			return False

#		p = re.compile(r'<div .*?id="watchAPIDataContainer".*?>(.*)</div>').search(body)
#		if(p == None):
		p = re.compile(r'<div .*?id="js-initial-watch-data"(.*)</div>').search(body)

		if(p != None):
			watchAPIDataContainer = p.group(1)
			watchAPIDataContainer = unicode(watchAPIDataContainer.decode('unicode-escape')).encode('utf-8')

			watchAPIDataContainer = watchAPIDataContainer.replace('&quot;','"')
			watchAPIDataContainer = watchAPIDataContainer.replace('&#039;',"'")
			watchAPIDataContainer = watchAPIDataContainer.replace('&lt;','<')
			watchAPIDataContainer = watchAPIDataContainer.replace('&gt;','>')
			watchAPIDataContainer = watchAPIDataContainer.replace('&amp;',"&")

#			print watchAPIDataContainer

			# タイトル取得
			title_p = re.compile('"title":"(.*?)"').search(watchAPIDataContainer)
			if(title_p != None):
				self.View_JPtitle = title_p.group(1)

#			# 登録タグ取得
#			View_key = re.compile(r'name="keywords".*content="(.*?)"').search(body)
#			if(View_key != None):
#				self.View_Keywords = View_key.group(1)

			# 動画の長さ
#			View_Len = re.compile(r'"length":([0-9]+)').search(watchAPIDataContainer)
#			if(View_Len != None):
#				self.View_Length = int(View_Len.group(1))
			duration = re.compile(r'"duration":([0-9]+)').search(watchAPIDataContainer)
			if(duration != None):
				self.View_Length = int(duration.group(1))
			length_seconds = re.compile(r'"length_seconds":([0-9]+)').search(watchAPIDataContainer)
			if(length_seconds != None):
				self.View_Length = int(length_seconds.group(1))
		else:
			# タイトル取得
			title_p = re.compile('<title>(.*?)</title>').search(body)
			if(title_p != None):
				title = title_p.group(1)
				self.View_JPtitle =  unicode(title.decode('unicode-escape')).encode('utf-8')
			else:
				title_p = re.compile('class="VideoTitle">(.*?)</>').search(body)
				if(title_p != None):
					title = title_p.group(1)
					self.View_JPtitle =  unicode(title.decode('unicode-escape')).encode('utf-8')

#		try:
#			# v, ts取得
##			m = re.compile(r'nicoplayer\.swf\?ts=(\d+)').search(body)
##			self.video_ts = int(m.group(1))
#			m = re.compile(r'flashVars.nicoplayer_version\s*=\s*"(.*)"').search(body)
#			self.video_ts = m.group(1)
##			print 'v: %s, ts: %d' % (self.video_id, self.video_ts)
#		except Exception, e:
#			open(os.path.join(self.root_dir,'error.html'), 'wb').write(body)
#			print >> sys.stderr, u'Error: 対応していないHTML形式、ページが見つからない、その他のエラー'
#			print >> sys.stderr, e
#			return False

		return True

	def getFLVPath(self):
		"""getflvから動画URL(*.smilevideo.jpなど)を得る"""
		self.establishConnection()

		if(self.video_id[0:2] == "nm"):
			urlparam = self.video_id + "?as3=1";
		elif(self.economyMode):
			urlparam = self.video_id + "?eco=1"
		else:
			urlparam = self.video_id

#		rs = self.retryingAccess(self.nico_conn, ('GET', '/api/getflv/%s' % urlparam, '', self.headers))
		try:
#			redirect_conn = httplib.HTTPConnection('flapi.nicovideo.jp', 80)
			redirect_conn = httplib.HTTPSConnection('flapi.nicovideo.jp')
			self.headers = {'User-Agent':self.User_Agent,
				'Accept': '*/*',
				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
				'Accept-Charset': 'UTF-8,*',
				'Connection': 'keep-alive',
				'Keep-Alive': '300',
				'Cookie': '; '.join([self.user_session, self.nicohistory])}

			rs = self.retryingAccess(redirect_conn, ('GET', '/api/getflv/%s' % urlparam, '', self.headers))
			body = rs.read()
#			print body

		finally:
			if redirect_conn:
				redirect_conn.close()
			if rs:
				rs.close()

		try:
			# ファイル種類を調べる
			qs = cgi.parse_qs(body)
			if qs.get("url") != None:
				video_url = urllib.unquote(qs["url"][0])
				# ニコニコ公式アニメポータル
				if video_url[0:4] == 'rtmp':
					re_type = re.compile(r"([a-zA-Z])=(\w+):")
				else:
					re_type = re.compile(r"([a-zA-Z])=\d+\.\d+(\w+)?$")

				video_m = re_type.search(video_url)
				vtype = video_m.group(1)

				self.video_ext = NICO_VIDEO_TYPE.get(vtype, NICO_VIDEO_DEFAULT_EXT)
				self.url = qs["url"][0]
			elif qs.get("ms") != None:
				vtype = 'm'
				self.video_ext = NICO_VIDEO_TYPE.get(vtype, NICO_VIDEO_DEFAULT_EXT)

			# threadid 抽出
#			m = re.compile(r'thread_id=(.+?)&').search(body)
#			self.thread_id = m.group(1)
			self.thread_id = qs["thread_id"][0]

#			self.link =  urllib.unquote(qs["link"][0])
#			self.ms =  urllib.unquote(qs["ms"][0])
			self.user_id =  qs["user_id"][0]
#			self.is_premium = qs["is_premium"][0]
#			self.nickname = qs["nickname"][0]
#			self.time = qs["time"][0]
#			self.done = qs["done"][0]
			if qs.get("needs_key") != None:
				self.needs_key = qs["needs_key"][0]
			else:
				self.needs_key = None
#			self.optional_thread_id = qs["optional_thread_id"][0]

			# URL抽出
			if qs.get("url") != None:
				self.video_url = urllib.unquote(qs["url"][0])
				m = re.compile(r'&url=(http|rtmpe)%3A%2F%2F(.+?)(%2F.+?)&').search(body)
				if m:
					self.flv_video_protocol = urllib.unquote_plus(m.group(1))
					self.flv_video_server = urllib.unquote_plus(m.group(2))
					self.flv_video_path = urllib.unquote_plus(m.group(3))
#					self.video_url = m.group(1)+'://%s%s' % (self.flv_video_server, self.flv_video_path)
	#				print 'thread id: %s, video url: %s' % (self.thread_id, self.video_url)
					self.low_check = (0 <= self.video_url.find('low'))
			elif qs.get("ms") != None:
				self.video_url = urllib.unquote(qs["ms"][0])
				m = re.compile(r'&ms=(http|rtmpe)%3A%2F%2F(.+?)(%2F.+?)&').search(body)
				if m:
					self.flv_video_protocol = urllib.unquote_plus(m.group(1))
					self.flv_video_server = urllib.unquote_plus(m.group(2))
					self.flv_video_path = urllib.unquote_plus(m.group(3))
					self.low_check = (0 <= self.video_url.find('low'))

#			if qs.get("url") != None:
#				video_url = urllib.unquote(qs["url"][0])
#				if video_url[0:4] == 'rtmp':
#					m = re.compile(r'&url=rtmpe%3A%2F%2F(.+?)(%2F.+?)&').search(body)
#				else:
#					m = re.compile(r'&url=http%3A%2F%2F(.+?)(%2F.+?)&').search(body)
#
#	#			m = re.compile(r'&url=http%3A%2F%2F(.+?)(%2F.+?)&').search(body)
#				if m:
#					self.flv_video_server = urllib.unquote_plus(m.group(1))
#					self.flv_video_path = urllib.unquote_plus(m.group(2))
#					self.video_url = 'http://%s%s' % (self.flv_video_server, self.flv_video_path)
#	#				print 'thread id: %s, video url: %s' % (self.thread_id, self.video_url)
#					self.low_check = (0 <= self.video_url.find('low'))

			m = re.compile(r'&ms=http%3A%2F%2F(.+?)\.nicovideo\.jp(%2F.+?)&').search(body)
			if m:
				self.message_server = urllib.unquote_plus(m.group(1))
				self.message_path = urllib.unquote_plus(m.group(2))
#				print 'message_server:', self.message_server, self.message_path

			m = re.compile(r'&fmst=(.+)%3A(.+)').search(body)
#			m = re.compile(r'&fmst=(.+)').search(body)
			if m:
#				self.fmst = urllib.unquote_plus(m.group(1))
				self.fmst1 = urllib.unquote_plus(m.group(1))
				self.fmst2 = urllib.unquote_plus(m.group(2))

				m = re.compile(r'm=(.+)').search(self.flv_video_path)
				if m:
					self.playpath = urllib.unquote_plus(m.group(1))
#					print self.playpath

				print "fmst=" + self.fmst1 + ":" + self.fmst2

				userkeyMatcher = re.compile(r'&userkey=(.*)').search(self.fmst2)
				if userkeyMatcher:
					self.userkey = userkeyMatcher.group(1)
					print "userkey=" + self.userkey

					self.fmst2 = re.sub(r'&userkey=.*', "", self.fmst2)
		except Exception, e:
			print 'server error: %s' % e
			return False

		return True

	def retryingAccessRtmp(self, conn, request_args, retry=2, wait=5):
		rs = None
		while retry>0:
			try:
				method, path, body, headers = request_args
				conn.request(method, path, body, headers)
				rs = conn.getresponse()
				break
			except Exception, e:
				print e
				print 'getresponse failed. waiting for %d seconds..' % wait
				retry -= 1
#				if retry<=0:
#					raise e

				time.sleep(wait)
				conn.close()
#				self.loginNicoVideo()

		return rs
	def download(self, filepath, dp = None):
#		import xbmc, xbmcgui


		self.establishFLVConnection(self.flv_video_server)
		if self.flv_video_protocol == "rtmpe":
			"""rtmpdump保存"""
			rtmpdump = 'rtmpdump.exe '
			rtmpdump+= '-o "%s.mp4" ' % self.video_id
			rtmpdump+= '-l 2 '
			rtmpdump+= '-a smile '
			rtmpdump+= '-n %s ' % "smile-chefsf.nicovideo.jp"
			rtmpdump+= '-t %s ' % "rtmpe://smile-chefsf.nicovideo.jp/smile"
			rtmpdump+= '-p %s ' % ("http://www.nicovideo.jp/watch/"+self.video_id)
#			rtmpdump+= '-s %s ' % "http://res.nimg.jp/swf/player/secure_nccreator.swf?t=201111091500"
#			rtmpdump+= '-f %s ' % "WIN 11,6,602,180"
			rtmpdump+= '-y %s ' % self.playpath
			rtmpdump+= '-C S:%s ' % self.fmst2
			rtmpdump+= '-C S:%s ' % self.fmst1
			rtmpdump+= '-C S:%s ' % self.playpath
			rtmpdump+= '-e '
			print rtmpdump

#			rtmpdump = ''
#			rtmpdump = 'rtmpdump.exe '
#			rtmpdump+= '-o "%s.mp4" ' % self.video_id
#			rtmpdump+= '-l 2 '
#			rtmpdump+= '-a smile '
#			rtmpdump+= '-n %s ' % "smile-chefsf.nicovideo.jp"
#			rtmpdump+= '-t %s ' % "rtmpe://smile-chefsf.nicovideo.jp/smile"
#			rtmpdump+= '-p %s ' % ("http://www.nicovideo.jp/watch/"+self.video_id)
##			rtmpdump+= '-s %s ' % "http://res.nimg.jp/swf/player/secure_nccreator.swf?t=201111091500"
##			rtmpdump+= '-f %s ' % "WIN 11,6,602,180"
#			rtmpdump+= '-y %s ' % self.playpath
#			rtmpdump+= '-C S:%s:%s:%s ' % (self.fmst2,self.fmst1,self.playpath)
#			rtmpdump+= '-e '
#			print rtmpdump
			return False
#			rs = self.retryingAccessRtmp(self.flv_conn, ('GET', self.flv_video_path, '', self.headers))
		else:
			"""FLV保存"""
#			self.headers = {'User-Agent':'	Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4',
#				'Accept': '*/*',
#				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
#				'Accept-Charset': 'UTF-8,*',
#				'Connection': 'keep-alive',
#				'Keep-Alive': '300',
#				'Referer': 'http://www.nicovideo.jp/watch/' + self.video_id,
#				'Cookie': '; '.join([self.nicosid, self.user_session, self.nicohistory])}

#			self.headers = {'User-Agent':'	Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.8.1.4) Gecko/20070515 Firefox/2.0.0.4',
#				'Accept': '*/*',
#				'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
#				'Accept-Charset': 'UTF-8,*',
#				'Connection': 'keep-alive',
#				'Keep-Alive': '300',
#				'Cookie': '; '}
			rs = self.retryingAccess(self.flv_conn, ('GET', self.flv_video_path, '', self.headers))


		length = rs.getheader('content-length')
		print "content-length " + length

		self.cache_file_size = int(length)

		if rs.status != 200:
			return False

#		for header in rs.getheaders():
#			if str(header[0]) == 'content-length':
#				#print 'ファイルサイズ : ' + str(header[1])
#				cache_file_size = int(header[1])

		now = time.localtime(time.time())
		n_time = "%02d:%02d:%02d" % (now[3],now[4],now[5])
		if dp == None:
			pass
		else:
			dp.create("接続中... （%s開始）" %n_time,str(self.cache_file_size/kb) + "kb")
		#print 'flv:', rs.status

		fo = open(filepath, 'wb')
		try:
			i = 0
			while True:
				buf = rs.read(self.block_size)
				i = i + self.block_size
				if dp != None:
					if dp.iscanceled():
						fo.close()
						break
					now = time.localtime(time.time())
					nowtime = "%02d:%02d:%02d" % (now[3],now[4],now[5])
					try:
						dp.update(int(i * 100 / self.cache_file_size),self.View_JPtitle,nowtime, str(int(i/kb)) + " / " + str(self.cache_file_size/kb) + "kb")
					except:
						dp.update(int(i * 100 / self.cache_file_size),"",nowtime, str(int(i/kb)) + " / " + str(self.cache_file_size/kb) + "kb")

				else:
					print str(int(i/kb)) + " / " + str(self.cache_file_size/kb) + "kb"

				if len(buf)>0:
					fo.write(buf)
				else:
					break
#				time.sleep(0.1)
		finally:
			fo.close()
			rs.close()
			self.flv_conn.close()
		return True

	def download_message(self, filepath):
		"""コメントXMLの保存"""

		fo = open(filepath, 'wb')
		xmlmsg = self.getMessage()
		fo.write(xmlmsg)
		fo.close()
		#print 'message XML saved.'


	def downloadXml(self, savedirectory, xml_name=None, thumbinfo_name=None):
		'''コメントとThumbInfoのダウンロード'''

		if not self.retrieveVideoID():
			return None
		if not self.getFLVPath():
			return None

		if not os.path.exists(savedirectory):
				os.makedirs(savedirectory)

		if self.save_message_xml:
			if xml_name:
				xml_save_file_path = os.path.join(savedirectory, regulate_filename(xml_name))
			else:
				xml_save_file_path = os.path.join(savedirectory, regulate_filename(self.video_id+'.xml'))
			if self.force_overwrite or not os.access(xml_save_file_path, os.F_OK):
				self.download_message(xml_save_file_path)
			else:
				print 'XML %s already exists.' % xml_save_file_path

			if thumbinfo_name:
				thumbInfo_file_path = os.path.join(savedirectory, regulate_filename(thumbinfo_name))
			else:
				thumbInfo_file_path = os.path.join(savedirectory, regulate_filename(self.video_id+'[ThumbInfo].xml'))
			thumbInfo = self.downloadThumbInfo(thumbInfo_file_path)
		return thumbInfo


	def beginDownload(self, savedirectory, dialogProgress = None):
		"""一連の作業"""
		thumbInfo = self.downloadXml(savedirectory)
		if not thumbInfo:
			return False

		save_tbn = os.path.join(savedirectory, self.video_id + '.tbn')
		if not os.path.exists(save_tbn):
			thumbnail_url_m = re.compile('<thumbnail_url>(.*)</thumbnail_url>').search(thumbInfo)
			if thumbnail_url_m:
				thumbnail_url = thumbnail_url_m.group(1)
				try:
					urllib.urlretrieve(thumbnail_url,save_tbn)
				except Exception, e:
					print str(e)
					print '%s, url=%s' % (self.video_id,thumbnail_url)

		if not self.economyMode and self.low_check:
			print "EconomyMode !! BAD!! BAD!! BAD!!"

		if self.economyMode and not self.low_check:
			print "Not EconomyMode !! BAD!! BAD!! BAD!!"
			return False

		# 通常と低画質（エコノミーモード）の名前を変更
		if self.low_check:
			self.save_file_path = os.path.join(savedirectory, regulate_filename(self.video_id+'[low].'+self.video_ext))
		else:
			self.save_file_path = os.path.join(savedirectory, regulate_filename(self.video_id+'.'+self.video_ext))


		if not self.force_overwrite and os.access(self.save_file_path, os.F_OK):
			print 'File %s already exists.' % self.save_file_path
			return False

#		if urlonly:
#			return True

		if not self.download(self.save_file_path, dialogProgress):
			return False

#		self.createDataFile(savedirectory)
		return thumbInfo

	def getHTML(self, url, headers = None):
		if headers == None:
			headers = self.headers
		self.establishConnection()
		rs = self.retryingAccess(self.nico_conn, ('GET', url, '', headers))
		self.refreshCookie(rs)

		body = rs.read()
		rs.close()
		return body

	def getChannelHTML(self, url = "", headers = None):
		if headers == None:
			headers = self.headers
		self.establishConnectionChannel()
		rs = self.retryingAccess(self.channel_conn, ('GET', url, '', headers))
		self.refreshCookie(rs)

		if rs.status == 301:
			url2 = re.sub(r'http://ch.nicovideo.jp','',rs.getheader('Location'))
			rs2 = self.retryingAccess(self.channel_conn, ('GET', url2, '', headers))
			if rs2.status == 301:
				url3 = re.sub(r'http://ch.nicovideo.jp','',rs2.getheader('Location'))
				rs3 = self.retryingAccess(self.channel_conn, ('GET', url3, '', headers))
				body = rs3.read()
			else:
				body = rs2.read()
			rs2.close()
		else:
			body = rs.read()
		rs.close()
		return body

	def getthreadkey(self):
		''' スレッドキーの取得 '''
		try:
			redirect_conn = httplib.HTTPConnection('flapi.nicovideo.jp', 80)

			rs = self.retryingAccess(redirect_conn, ('GET', '/api/getthreadkey?thread=%s' % self.video_id, '', self.headers))
			body = rs.read()
#			print body
		finally:
			if redirect_conn:
				redirect_conn.close()
			if rs:
				rs.close()

		getthreadkeySet = body.split('&')
		self.getthreadkeyArray = []
		for paramSet in getthreadkeySet:
			self.getthreadkeyArray.append(paramSet.split('='))

	def getMessage(self):
		"""対応するメッセージXMLを取得"""
		com_num = None
		if self.maxCommentNum == 0:
			if self.View_Length == None:
				com_num = 100
			elif self.View_Length < 60:
				com_num = 100
			elif self.View_Length < 300:
				com_num = 250
			elif self.View_Length < 600:
				com_num = 500
			else:
				com_num = 1000
		else:
			com_num = self.maxCommentNum

		if self.needs_key == '1':
			self.getthreadkey()
			xml = '<thread thread="%s" version="%s" user_id="%s" res_from="%s"' % (self.thread_id, 20090904, self.user_id, - com_num)
			for paramSet in self.getthreadkeyArray:
				xml = xml + ' %s="%s"' % (paramSet[0], paramSet[1])
			xml = xml + '/>'
		else:
			xml = '<thread thread="%s" version="%s" res_from="%s" user_id="%s"/>' % (self.thread_id, 20090904, - com_num, self.user_id)

#		xml = '<packet><thread thread="%s" version="%s" user_id="%s" res_from="%s"/><thread_leaves thread="%s" user_id="%s">0-4:100</thread_leaves></packet>' % (self.thread_id, 20090904, self.user_id, self.thread_id, self.user_id )
#		if self.needs_key == '1':
#			self.getthreadkey()
#			xml = '<thread thread="%s" version="%s" res_from="%s" user_id="%s"' % (self.thread_id, 20061206, - com_num, self.user_id)
#			for paramSet in self.getthreadkeyArray:
#				xml = xml + ' %s="%s"' % (paramSet[0], paramSet[1])
#
##			xml = xml + ' force_184="1"
#			xml = xml + '/>'
#		else:
#			xml = '<thread thread="%s" version="%s" res_from="%s" user_id="%s"/>' % (self.thread_id, 20061206, - com_num, self.user_id)

		self.establishMessageConnection(self.message_server)
		headers = self.headers.copy()
		headers['Content-type'] = 'text/xml'

		rs = self.retryingAccess(self.message_conn, ('POST',self.message_path,xml,headers))
		self.refreshCookie(rs)

		body = rs.read()
#		print body
		rs.close()
		return body


##	def getMessage_owner(self):
##		"""対応するメッセージXMLを取得"""
##		self.establishMessageConnection(self.message_server)
##		headers = self.headers.copy()
##		headers['Referer'] = 'http://www.nicovideo.jp/flvplayer.swf?ts=%d' % (self.video_ts)
##		headers['Content-type'] = 'application/x-www-form-urlencoded'
##
#### fork="1" = 投稿者コメントのダウンロード
##		rs = self.retryingAccess(self.message_conn, ('POST',
##			self.message_path,
##			'<thread fork="1" res_from="%d" version="%d" thread="%s" />' % ( - MAX_COMMENT_NUM, 20061206, self.thread_id),
##			headers))
##		self.refreshCookie(rs)
##
##		body = rs.read()
##		rs.close()
##
##		return body
	def getMyList(self):
		'''マイリストを取得します'''
		body = self.getHTML('http://www.nicovideo.jp/api/mylistgroup/list')
		p = re.compile('\{"id":"([0-9]*)","user_id":"[0-9]*","name":"(.*?)","description":"(.*?)".*?}')
		mylistArray = []
		for m in p.finditer(body):
			mylist_id = m.group(1)
			name = m.group(2)
			name = unicode(name.decode('unicode-escape')).encode('utf-8')
			mylistArray.append([mylist_id,name])
		return mylistArray

	# マイリストコメントを返します
	#
	# アイコン画像URL,日付,名前,コメント
#	def getMyListComment(self, videoid):
#		body = self.getHTML("http://www.nicovideo.jp/mylistcomment/video/"+videoid)
#		print body
#		mylistComment_re = re.compile('<td><a href=".*"><img src="(.*)" alt="" class="usericon"></a></td>\s*<td width="100%">\s*<p class="font12" style="color:#999;"><strong>(.*)</strong>.*<a href=".*" style="color:#666;"><strong>(.*)</strong></a>.*</p>\s*<p class=".*" style="margin:4px 0 0;"><strong>(.*)</strong>')
#		mylistCommentArray = []
#		for m in mylistComment_re.finditer(body):
#			#print m.group(1),m.group(2),m.group(3),m.group(4)
#			mylistCommentArray.append([m.group(1),m.group(2),m.group(3),m.group(4)])
#		return mylistCommentArray

	def getMyListComment(self):
		body = self.getHTML("http://www.nicovideo.jp/mylistcomment/video/"+self.video_id)
#		print body

		p = re.compile('(?s)<a href="/user/([0-9]*?)"><img src="(.*?)" alt="" class="usericon"></a>.*?<strong>(.*?)</strong>.*?<strong>(.*?)</strong>.*?<p .*?>(.*?)</p>')
		resultArray = []
		for m in p.finditer(body):
			user = m.group(1)
			img_url = m.group(2)
#			date = m.group(3)
			name = m.group(4)
			discript = m.group(5)
			resultArray.append([user, name,img_url,discript])
		return resultArray

#		p = re.compile('<img src="(.*?)".*></a></td>\s*<td width="100%">\s*<p class="font12".*><strong>(.*)</strong>.*<a href="/user/([0-9]*)".*><strong>(.*)</strong></a>.*</p>\s*<p class="font14"><strong>(.*)</strong></p>')
#		mylistCommentArray = []
#		for m in p.finditer(body):
#			#print m.group(1),m.group(2),m.group(3),m.group(4)
#			mylistCommentArray.append([m.group(1),m.group(2),m.group(4),m.group(5),m.group(3)])
#		return mylistCommentArray

	def downloadThumbInfo(self, filepath):
		"""ThumbInfoの保存"""
		fo = open(filepath, 'wb')
		thumbInfo = self.apiGetThumbInfo(self.video_id)
		fo.write(thumbInfo)
		fo.close()
		return thumbInfo

	def apiGetThumbInfo(self, video_id):
		''' '''
		url = "http://ext.nicovideo.jp/api/getthumbinfo/%s" % video_id
		hs = {'User-Agent':self.User_Agent,
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
			'Accept-Charset':  'UTF-8,*',
			'Connection': 'keep-alive',
			'Keep-Alive': '300',
			'Cookie': '; '}
		con = httplib.HTTPConnection('ext.nicovideo.jp', 80)
		rs = self.retryingAccess(con, ('GET', url, '', hs))

		body = rs.read()
		rs.close()

#		print body
		return body

	def getThumbInfo(self, body=None):
		''' '''
		if body == None:
			body = self.apiGetThumbInfo(self.video_id)
#			print body

		data = ThumbInfoData()

		title_m = re.compile('<title>(.*)</title>').search(body)
		if title_m:
			data.title = title_m.group(1)

		description_m = re.compile('<description>(.*)</description>').search(body)
		if description_m:
			data.description = description_m.group(1)

		thumbnail_url_m = re.compile('<thumbnail_url>(.*)</thumbnail_url>').search(body)
		if thumbnail_url_m:
			data.thumbnail_url = thumbnail_url_m.group(1)

		first_retrieve_m = re.compile('<first_retrieve>(.*)</first_retrieve>').search(body)
		if first_retrieve_m:
			data.first_retrieve = first_retrieve_m.group(1)

		length_m = re.compile('<length>(.*)</length>').search(body)
		if length_m:
			data.length = length_m.group(1)

		movie_type_m = re.compile('<movie_type>(.*)</movie_type>').search(body)
		if movie_type_m:
			data.movie_type = movie_type_m.group(1)

		size_high_m = re.compile('<size_high>(.*)</size_high>').search(body)
		if size_high_m:
			data.size_high = size_high_m.group(1)

		size_low_m = re.compile('<size_low>(.*)</size_low>').search(body)
		if size_low_m:
			data.size_low = size_low_m.group(1)

		view_counter_m = re.compile('<view_counter>(.*)</view_counter>').search(body)
		if view_counter_m:
			data.view_counter = view_counter_m.group(1)

		comment_num_m = re.compile('<comment_num>(.*)</comment_num>').search(body)
		if comment_num_m:
			data.comment_num = comment_num_m.group(1)

		mylist_counter_m = re.compile('<mylist_counter>(.*)</mylist_counter>').search(body)
		if mylist_counter_m:
			data.mylist_counter = mylist_counter_m.group(1)

		last_res_body_m = re.compile('<last_res_body>(.*)</last_res_body>').search(body)
		if last_res_body_m:
			data.last_res_body = last_res_body_m.group(1)

		thumb_type_m = re.compile('<thumb_type>(.*)</thumb_type>').search(body)
		if thumb_type_m:
			data.thumb_type = thumb_type_m.group(1)

		embeddable_m = re.compile('<embeddable>(.*)</embeddable>').search(body)
		if embeddable_m:
			data.embeddable = embeddable_m.group(1)

		tagLockArray = []
		tag_p1 = re.compile('<tag lock="[0-9]*">(.*)</tag>')
		for m in tag_p1.finditer(body):
			tagLockArray.append(m.group(1))
		data.tagLockArray= tagLockArray

		tagArray = []
		tag_p2 = re.compile('<tag>(.*)</tag>')
		for m in tag_p2.finditer(body):
			tagArray.append(m.group(1))
		data.tagArray= tagArray

		user_id_m = re.compile('<user_id>(.*)</user_id>').search(body)
		if user_id_m:
			data.user_id = user_id_m.group(1)
		else:
			data.user_id = ""

		return data

#	def getRecommend(self, videoid = None):
#		''' おすすめ動画を取得します '''
#		if not videoid:
#			videoid = self.video_id
#
#		headers = {'User-Agent':self.User_Agent,
#						'Accept': 'image/jpeg, application/x-ms-application, image/gif, application/xaml+xml, image/pjpeg, application/x-ms-xbap, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*',
#						'Accept-Language': 'ja-JP',
#						'Connection': 'keep-alive'
#			}
#		url = "http://flapi.nicovideo.jp/api/getrelation?page=1&sort=m&order=d&video=%s" % videoid
#		rs = self.retryingAccess(httplib.HTTPConnection('flapi.nicovideo.jp', 80), ('GET', url, '', headers))
#		self.refreshCookie(rs)
#
#		body = rs.read()
##		print body
#		rs.close()
#
#		recommendArray = []
#		p = re.compile(r'<url>http://www.nicovideo.jp/watch/(.*)</url>\s*<thumbnail>(.*)</thumbnail>\s*<title>(.*?(?=<))</title>\s*<view>([0-9]*)</view>\s*<comment>([0-9]*)</comment>\s*<mylist>([0-9]*)</mylist>\s*<length>([0-9]*)</length>\s*<time>([0-9]*)</time>')
#		for m in p.finditer(body):
#			video_no = m.group(1)
##			thumbnail = m.group(2)
#			title = m.group(3)
#			view = m.group(4)
#			comment = m.group(5)
#			mylist = m.group(6)
#			length = int(m.group(7))
##			time = m.group(8)
#
#			recommendArray.append([video_no,title,view,comment,mylist,length])
##			print video_no,title
#		return recommendArray

	def apiGetrelation(self, video_id, page=1, sort='p', order='d'):
		'''オススメ動画を取得します'''
		url = "http://flapi.nicovideo.jp/api/getrelation?page=%s&sort=%s&order=%s&video=%s" % (page,sort,order,video_id)
		hs = {'User-Agent':self.User_Agent,
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
			'Accept-Charset':  'UTF-8,*',
			'Connection': 'keep-alive',
			'Keep-Alive': '300',
			'Cookie': '; '}
		con = httplib.HTTPConnection('flapi.nicovideo.jp', 80)
		rs = self.retryingAccess(con, ('GET', url, '', hs))

		body = rs.read()
		rs.close()

#		print body
		result = []
		ptnStr = '<video>\s*<url>http://www.nicovideo.jp/watch/(.*)</url>\s*<thumbnail>(.*)</thumbnail>\s*<title>(.*)</title>\s*<view>(.*)</view>\s*<comment>(.*)</comment>\s*<mylist>(.*)</mylist>\s*<length>(.*)</length>\s*<time>(.*)</time>\s*</video>'
		p = re.compile(ptnStr)
		for m in p.finditer(body):
			video_id = m.group(1)
			thumbnail = m.group(2)
			title = m.group(3)
			view = m.group(4)
			comment = m.group(5)
			mylist = m.group(6)
			length = m.group(7)
			time = m.group(8)
			result.append([video_id,thumbnail,title,view,comment,mylist,length,time])
		return result

	def getOpenlist(self, videoid = None):
		''' 公開リストを取得します '''
		if not videoid:
			videoid = self.video_id

		body =self.getHTML("http://www.nicovideo.jp/openlist/%s?page=1&sort=c&order=d" % videoid )
#		print body
		openlistArray = []

		p = re.compile(r'<a href="(mylist\/[0-9/]+?)">(.*)</a>.*</span> ([0-9]*)')
		for m in p.finditer(body):
			mylist_no = m.group(1)
			title = m.group(2)
			num = m.group(3)

			openlistArray.append([mylist_no,title,num])
#			print mylist_no,title,num
		return openlistArray

	def getChannel(self):
		''' チャンネルを取得します '''
		try:
			redirect_conn = httplib.HTTPConnection('ch.nicovideo.jp', 80)

			rs = self.retryingAccess(redirect_conn, ('GET', '/chlist', '', self.headers))
			body = rs.read()
#			print body
		finally:
			if redirect_conn:
				redirect_conn.close()
			if rs:
				rs.close()

#		body =self.getHTML("http://ch.nicovideo.jp/chlist")
#		print body

#		p1 = re.compile(r'cc_menu_id=[0-9]*">(.*)</a>\s*<span class="chnum">\(.*?([0-9]+)ch\)</span></p>')
		p1 = re.compile(r'<a href=".*?">(.*)</a>\s*<span class="chnum">\(.*?([0-9]+)ch\)</span></p>')

		channelNameArray = []
		channel_num = []
		for m in p1.finditer(body):
			channelNameArray.append(m.group(1))
			channel_num.append(int(m.group(2)))

		p2 = re.compile(r'(?s)<time>(.*?)</time>.*?<a href="/(ch[0-9]*)".*?title="(.*?)" class="channel_name">')
		channelArray = []
		chIndex = 0
		chCount = 0
		channelCategoryArray = []

		for m in p2.finditer(body):
			cc_ch_id = m.group(2)
			title = m.group(3)
			time = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>','',m.group(1))

			channelArray.append([cc_ch_id,title,time])
			chCount +=1
			if channel_num[chIndex] <= chCount:
				channelCategoryArray.append(channelArray)
				channelArray = []
				chCount = 0
				chIndex += 1

		return channelNameArray,channelCategoryArray

	def getMyChannel(self):
		''' 登録しているチャンネルを取得します '''
		body =self.getHTML("http://www.nicovideo.jp/my/channel")
#		print body

#		p1 = re.compile(r'"/my/channel\?page=([0-9]*)" ')
#		count = 1
#		for m in p1.finditer(body):
#			count += 1
		result = []
		p2 = re.compile(r'><a href="http://ch.nicovideo.jp/channel/(ch[0-9]*)">(.*)</a><')
		for m in p2.finditer(body):
			result.append([m.group(1),m.group(2)])

#		if 1 < count:
#			for page in range(2,count):
#				body =self.getHTML("http://www.nicovideo.jp/my/channel?page="+str(page))
#				for m in p2.finditer(body):
#					result.append([m.group(1),m.group(2)])
		return result


	def parseMylistSource(self,body):
		''' マイリストの解析 '''
		result = []
		p = re.compile(r'\{"video_id":"(.*?)","title":"(.*?)","thumbnail_url":".*?","first_retrieve":([0-9]*),"update_time":([0-9]*),"view_counter":"([0-9]*)","mylist_counter":"([0-9]*)","num_res":"([0-9]*)","group_type":".*?","length_seconds":"([0-9]*)","deleted":"[0-9]*","last_res_body":".*?","watch_id":".*?"\},"watch":.*?,"create_time":(.*?),"update_time":(.*?)\}')
		for m in p.finditer(body):
			video_id = m.group(1)
			title = unicode(m.group(2).decode('unicode-escape')).encode('utf-8')
			first_retrieve = int(m.group(3))
			item_update_time = int(m.group(4))#コメント
			view_counter = m.group(5) #再生数
			mylist_counter = m.group(6) #マイリスト数
			num_res = m.group(7)#コメント
			length_seconds = int(m.group(8)) #時間
			create_time = int(m.group(9))
#			update_time = int(m.group(10))

			result.append([video_id, title, view_counter, num_res, mylist_counter, length_seconds, first_retrieve, item_update_time, create_time])
		return result


	def getRankingList(self,range,ranking_type,ranking_cate,page=None):
		url = "http://www.nicovideo.jp/ranking/%s/%s/%s?rss=2.0" %(ranking_type,range,ranking_cate)
		if page != None:
			url += "&page=" + page
		body = self.getHTML(url)
#		print body
		return self.parceRankingRssSource(body)

	def parceRankingRssSource(self,body):
		''' RSSの解析 '''
		p = re.compile(u'<item>\s*<title>(.*)</title>\s*<link>.*watch/(.*)</link>\s*<guid isPermaLink=".*">.*</guid>\s*<pubDate>(.*)</pubDate>\s*<description><\!\[CDATA\[\s*<p class="nico-thumbnail"><img alt=".*" src="h.*/smile\?i=(.*?)".*</p>\s*<p class="nico-description">(.*)</p>\s*<p class="nico-info"><small><strong class="nico-info-number">(.*?)</strong>pts.*<strong class="nico-info-length">(.*?)</strong>.*<strong class="nico-info-date">(.*?)</strong>.*<strong class="nico-info-total-view">(.*?)</strong>.*<strong class="nico-info-total-res">(.*?)</strong>.*<strong class="nico-info-total-mylist">(.*?)</strong>.*<strong class="nico-info-.*-view">(.*?)</strong>.*<strong class="nico-info-.*-res">(.*?)</strong>.*<strong class="nico-info-.*-mylist">(.*?)</strong>')
		resultArray = []
		for m in p.finditer(body):
			title = m.group(1)
			video_id = m.group(2)

			tbnno = m.group(4)
			comment = m.group(5)
			point = m.group(6)
			len = m.group(7)
			date = m.group(8)

			view_count = m.group(9)
			comment_count = m.group(10)
			mylist_count = m.group(11)

#			view_count_add = m.group(12)
#			comment_count_add = m.group(13)
#			mylist_count_add = m.group(14)

			resultArray.append([video_id, title, date, comment, point, view_count, comment_count, mylist_count,len,tbnno])
		return resultArray

	def parceRankingSource(self,body):
		''' ランキングの解析 '''
		restr = u'<span style=\"font-size:16px; line-height:1;\">([0-9,]+)</span></strong>\s+.*\s+<.*>(.*)</strong>.*\s\s*.*\s*.*\s*<h3><a class="watch" href="watch/(.*?)">(.*?)</a></h3>\s*<p class="font12">(.*)</p>\s*</div>\s*(<p class="vinfo_last_res">(.*)</p>)?\s*<p class="num_status">\s*.*<strong>([0-9,]+)</strong>.*\s*.*<strong>([0-9,]+)</strong>.*\s*.*<strong>([0-9,]+)</strong>'
		p = re.compile(restr)
		resultArray = []
		for m in p.finditer(body):
			m_point = m.group(1)
			m_date = m.group(2)
			m_videono = m.group(3)
			m_title = m.group(4)
			m_comment = m.group(5)
			m_view_count = m.group(8)
			m_comment_count = m.group(9)
			m_mylist_count = m.group(10)
			resultArray.append([m_videono, m_title, m_date, m_comment, m_point, m_view_count, m_comment_count, m_mylist_count])
		return resultArray

	def getSearchKeyword(self,search_united,page=None,sort=None,order=None):
		'''キーワード検索の結果を返します'''
		url = "/search/%s" %(urllib.quote_plus(search_united))
		if(page != None or sort != None or order != None):
			url += "?page=%d&sort=%s&order=%s" %(page,sort,order)
		body = self.getHTML(url)
#		print body
		return self.parceSearchSource(body, "keyword")

	def getSearchTag(self,search_united,page=None,sort=None,order=None):
		'''タグ検索の結果を返します'''
		url = "/tag/%s" %(urllib.quote_plus(search_united))
		if(page != None or sort != None or order != None):
			url += "?page=%d&sort=%s&order=%s" %(page,sort,order)
		body = self.getHTML(url)
#		print body
		return self.parceSearchSource(body, "tag")

	def parceSearchSource(self,body, searchType):
		total = None
		if searchType == "tag":
			m = re.compile('<span class="num">([0-9,]*)</span>件').search(body)
			if m != None:
				total = int(re.sub(",", "",m.group(1)))
		else:
			m = re.compile('<span class="searchTotal">([0-9,]*)</span>').search(body)
			if m != None:
				total = int(re.sub(",", "",m.group(1)))

#		p = re.compile(u'(?s)href[=]["](?=watch)watch/(.*?)".*?<p class="vinfo_length"><span>([0-9:]*)</span>.*?<strong class="vinfo_view">([0-9,]*)</strong>.*?<strong class="vinfo_res">([0-9,]*)</strong>.*?<strong class="vinfo_mylist">([0-9,]*)</strong>.*?<strong .*?class="vinfo_uadp">([0-9,]*)</strong>.*? title="(.*?)".*?"vinfo_description" title="(.*?)"')
#		p = re.compile(u'(?s)<span class="time">(.*?)</span>.*?<a title="(.*?)".*?href[=]["](?=/watch)/watch/(.*?)\?.*?<li class="count view">.*?<span class="value">([0-9,]*)</span>.*?<li class="count comment">.*?<span class="value">([0-9,]*)</span>.*?<li class="count mylist">.*?<span class="value">.*?>.*?([0-9,]*)<.*?</span>.*?<li class="count ads">.*?<span class="value">.*?>([0-9,]*)<')
		p = re.compile(u'(?s)<span class="time">(.*?)</span>.*?<a title="(.*?)".*?href[=]["](?=/watch)/watch/(.*?)["].*?<li class="count view">.*?<span class="value">([0-9,-]*)</span>.*?<li class="count comment">.*?<span class="value">([0-9,-]*)</span>.*?<li class="count mylist">.*?<span class="value">.*?>.*?([0-9,-]*)<.*?</span>.*?<li class="count ads".*?>.*?<span class="value">.*?>([0-9,-]*)<')
		resultArray = []
		for m in p.finditer(body):
			videono = m.group(3)
			date = m.group(1)
			view_count = m.group(4)
			comment_count = m.group(5)
			mylist_count = m.group(6)
			vinfo_uadp = m.group(7)
			title = m.group(2)
#			vinfo_description = m.group(8)
			resultArray.append([videono, title, date, view_count, comment_count, mylist_count, vinfo_uadp])
		return total,resultArray

#	def parceSearchSource(self,body):
#		m = re.compile('<strong class="search_total">([0-9,]*)').search(body)
#		total = int(re.sub(",", "",m.group(1)))
#
#		p = re.compile(u'(?s)href="watch/(.*?[0-9]+).*?".*?i=([0-9]*).*?<p class="vinfo_length"><span>(.*?)</span>.*?<span .*?>(.*?)</span>.*?<span .*?><strong>(.*?)</strong>.*?</span>.*?<a .*?>(.*?)</a>.*?<strong>([0-9,]*)</strong>.*?<strong>([0-9,]*)</strong>.*?<strong>([0-9,]*)</strong>.*?<strong .*?>([0-9,]*)</strong>')
#		resultArray = []
#		for m in p.finditer(body):
#			videono = m.group(1)
#			date = m.group(2)
#			point = m.group(3)
#			upload = m.group(4)
#			title = m.group(5)
#			view_count = m.group(6)
#			comment_count = m.group(7)
#			mylist_count = m.group(8)
#			uad_point_number = m.group(9)
#			resultArray.append([videono, title, date,  view_count, comment_count, mylist_count])
#		return total,resultArray

	def parceCategorySource_(self,body):

		p1 = re.compile(u'<a href="watch/(.*?[0-9]+)\?.*?i=([0-9]*)')
		p2 = re.compile(u'(?s)<p class="vinfo_length"><span>(.*?)</span>.*?<span .*?>(.*?)</span>.*?<span .*?><strong>(.*?)</strong>.*?</span>.*?<a .*?>(.*?)</a>.*?<strong>([0-9,]*)</strong>.*?<strong>([0-9,]*)</strong>.*?<strong>([0-9,]*)</strong>.*?<strong .*?>([0-9,]*)</strong>')
		resultArray = []

		for m in p2.finditer(body):
			date = m.group(1)
			point = m.group(2)
			upload = m.group(3)
			title = m.group(4)
			view_count = m.group(5)
			comment_count = m.group(6)
			mylist_count = m.group(7)
			uad_point_number = m.group(8)
			resultArray.append(["", title, date,  view_count, comment_count, mylist_count,""])
		i=0
		for m in p1.finditer(body):
			videono = m.group(1)
			resultArray[i][0] = videono
			thumb_id = m.group(2)
			resultArray[i][6] = thumb_id
			i+=1
		return resultArray

	def getCategoryList(self,ranking_cate):
		url = "http://www.nicovideo.jp/top/%s" %(ranking_cate)
		body = self.getHTML(url)
#		print body
		return self.parceRelationTagSource(body),self.parceCategorySource(body)

	def parceNewarrivalSource(self,body):
		restr = '(?s)<a href="watch/(.*?)"><img src="(.*?)".*?<p class="vinfo_length"><span>(.*?)</span>.*?<strong class="vinfo_view">(.*?)</strong>.*?<strong class="vinfo_res">(.*?)</strong>.*?<strong class="vinfo_mylist">(.*?)</strong>.*?<strong>(.*?)</strong>\s*投稿\s*<span.*?">(.*?)</span>.*?>.*? title="(.*?)".*?<p class="vinfo_description" title="(.*?)"'

		recomp = re.compile(restr)
		resultArray = []
		for m in recomp.finditer(body):
			thumb_id= m.group(2)
			mov_length = m.group(3)
			view_count = m.group(4)
			comment_count = m.group(5)
			mylist_count = m.group(6)
#			vinfo_uadp = m.group(6)
			date = m.group(7) + m.group(8)
			videono = m.group(1)
			title = m.group(9)
			detail = m.group(10)
			resultArray.append([videono, title, mov_length, view_count, comment_count, mylist_count, thumb_id, date, detail])
		return resultArray

#	def parceCategorySource(self,body):
#		restr = u'(?s)<p class="itemTime"><span class="time">(.*?)</span>.*?<a href="/watch/(.*?)\?.*?>.*?<img src=".*?\?i=(.*?)".*?>.*?<span class="videoLength">(.*?)</span>.*?<a title="(.*?)".*?>.*?<.*?"count view".*?class="value">.*?([0-9,]*)</span>.*?<.*?"count comment".*?class="value">.*?([0-9,]*)</span>.*?<.*?"count mylist".*?class="value"><.*?>([0-9,]*)<.*?>.*?<.*?"count ads".*?<span data-uad-point>([0-9,]*)<'
#
#		recomp = re.compile(restr)
#		resultArray = []
#		for m in recomp.finditer(body):
#			date = m.group(1)
#			videono = m.group(2)
#			thumb_id = m.group(3)
#			mov_length = m.group(4)
#			view_count = m.group(6)
#			comment_count = m.group(7)
#			mylist_count = m.group(8)
#			vinfo_uadp = m.group(9)
#			title = m.group(5)
#			resultArray.append([videono, title, mov_length, view_count, comment_count, mylist_count, thumb_id, vinfo_uadp])
#		return resultArray

	def parceCategorySource(self,body):
		restr = u'(?s)<div\s*class="VideoItem".*?data-video-id="(.*?)".*?data-background-image="(.*?)"\s*alt="(.*?)".*?<div class="VideoLength VideoItem-duration">(.*?)</div>\s*<div class="VideoItem-meta">\s*<span class="VideoItem-metaFirstRetrieve">(.*?)</span>\s*<span class="VideoItem-metaCount VideoItem-metaViewCount">([0-9,]*)</span>\s*<span class="VideoItem-metaCount VideoItem-metaCommentCount">([0-9,]*)</span>\s*<span class="VideoItem-metaCount VideoItem-metaMylistCount">([0-9,]*)</span>\s*<span class="VideoItem-metaCount VideoItem-metaNicoadPoint" data-nicoad-point></span>\s*<span class="VideoItem-metaArrow"></span>'

		recomp = re.compile(restr)
		resultArray = []
		for m in recomp.finditer(body):
			date = m.group(5)
			videono = m.group(1)
			thumb_url = m.group(2)
			mov_length = m.group(4)
			view_count = m.group(6)
			comment_count = m.group(7)
			mylist_count = m.group(8)
#			vinfo_uadp = ''
			title = m.group(3)
			resultArray.append([videono, title, mov_length, view_count, comment_count, mylist_count, thumb_url, date])
		return resultArray

	def parceRelationTagSource(self,body):
		''' 関連タグの解析 '''
		tagList = []
		recomp = re.compile('class="TagItem-link"\s*href="/tag/(.*?)"')
#		recomp = re.compile("additional_tags=(.*?)\"")
#		recomp = re.compile("switchCategoryTag\('(.*)', '(.*)'\)")
		for m in recomp.finditer(body):
			tagList.append([m.group(1),m.group(1)])
#			if 10 == len(tagList):
#				break
		return tagList

#	def parceCategorySource(self,body):
#		m = re.compile('<strong class="search_total">([0-9,]*)').search(body)
#		restr = u'(?s)href="watch/(.*?)".*?i=([0-9]*).*?<p class="vinfo_length"><span>(.*?)</span>.*?<strong class="vinfo_view">([0-9,]*)</strong>.*?<strong class="vinfo_res">([0-9,]*)</strong>.*?<strong class="vinfo_mylist">([0-9,]*)</strong>.*? class="vinfo_uadp">(.*?)</strong>.*? title="(.*?)"'
#		recomp = re.compile(restr)
#		resultArray = []
#		for m in recomp.finditer(body):
#			videono = m.group(1)
#			thumb_id = m.group(2)
#			date = m.group(3)
#			view_count = m.group(4)
#			comment_count = m.group(5)
#			mylist_count = m.group(6)
##			vinfo_uadp = m.group(7)
#			title = m.group(8)
##			vinfo_description = m.group(9)
#			resultArray.append([videono, title, date,  view_count, comment_count, mylist_count, thumb_id])
#		return resultArray

	def getSearchMylist(self,search_united,page=None,sort=None,order=None):
		'''マイリスト検索の結果を返します'''
		url = "/mylist_search/%s" %(urllib.quote_plus(search_united))
		if(page != None or sort != None or order != None):
			url += "?page=%d&sort=%s&order=%s" %(page,sort,order)
		body = self.getHTML(url)
#		print body
		return self.parceMylistSource(body)

	def parceMylistSource(self,body):
		m = re.compile(u'<strong class="search_total">([0-9,]*)').search(body)
		total = int(re.sub(",", "",m.group(1)))

		p = re.compile(u'href="/(mylist\/[0-9]+?)".*>(.*)</a>.*<strong .*>(.*)</strong>')
		resultArray = []
		for m in p.finditer(body):
			mylist = m.group(1)
			title = m.group(2)
			num = m.group(3)

			resultArray.append([mylist, title, num])
		return total,resultArray

	def getDailySougouRanking(self):
		''' デイリー総合ランキングの解析 '''
		body =self.getHTML("http://www.nicovideo.jp/ranking")
#		print body
		dailySougouRankingArray = [ [], [], [], [], [], [] ]

		p = re.compile(r'<p class="vinfo_length"><span>(.*)</span></p>\s*</div>\s*<p class="font12"><a class="watch" href="watch/(.*)">(.*)</a>')
		for i,m in p.finditer(body):
			m_length = m.group(1)
			m_videoid = m.group(2)
			m_title = m.group(3)

			dailySougouRankingArray[i % 6].append([m_videoid,m_title,m_length])
#			print m_videoid,m_title,m_length
		return dailySougouRankingArray


#	def parceChannelVideoSource(self,body):
#		''' チャンネル動画の解析 '''
#		videoNum = 0
#		videoNumMatcher = re.compile(r'(?s)<div class="page_title_cnt">.*?\(([0-9]*?)\)').search(body)
#		if videoNumMatcher:
#			videoNum = int(videoNumMatcher.group(1))
#
#		p = re.compile(u'(?s)<a href="http://www.nicovideo.jp/watch/([0-9:]*?)".*?i=([0-9]*)".*?title="(.*?)"(.*?)<strong>(.*?)</strong>.*?<strong>\s*(.*?)\s*</strong>.*?<p class="videoStats">.*?<strong>(.*?)</strong>.*?<strong>(.*?)</strong>.*?<strong>(.*?)</strong>')
#		resultArray = []
#		for m in p.finditer(body):
#			videoid = m.group(1)
#			tbn = m.group(2)
#			title = m.group(3)
#
#			if re.compile('purchase_type').search(m.group(4)) :
#				purchase_type = True
#			else:
#				purchase_type = False
#			lengthSeconds = m.group(5)
#			videoDate = m.group(6)
#			view_count = m.group(7)
#			comment_count = m.group(8)
#			mylist_count = m.group(9)
#			resultArray.append([videoid, title, view_count, comment_count, mylist_count, lengthSeconds, tbn, videoDate,purchase_type])
#		return resultArray,videoNum

	def parceChannelVideoSource(self,body):
		''' チャンネル動画の解析 '''
		videoNum = 0
		videoNumMatcher = re.compile(r'(?s)<span class="count">\s*<var>([0-9]*?)</var>').search(body)
		if videoNumMatcher:
			videoNum = int(videoNumMatcher.group(1))

		p = re.compile(u'(?s)<div class="item_left">.*?<img data-original="(.*?)".*?>(.*?)<span class="badge .*?length".*?>(.*?)</span>.*?<a href="http://www.nicovideo.jp/watch/(.*?)".*?>(.*?)</a>.*?<ul class="counts">(.*?)</ul>.*?<p class="time">\s*(.*?)\s*</p>')
		resultArray = []
		for m in p.finditer(body):
			tbn = m.group(1)
			video_length = m.group(3)
			if re.compile('purchase_type').search(m.group(2)) :
				purchase_type = True
			else:
				purchase_type = False
#			videoDate =re.sub(r'\r|\n',' ',m.group(7))
#			videoDate =re.sub(r'\t','',videoDate)
			video_id = m.group(4)
			title = m.group(5)

			counts = m.group(6)
			time = m.group(7)

			m = re.compile('<label>再生</label>\s*<var>(.*?)</var>').search(counts)
			if m == None:
				view = "-"
			else:
				view = m.group(1)

			m = re.compile('<label>コメント</label>\s*<var>(.*?)</var>').search(counts)
			if m == None:
				comment = "-"
			else:
				comment = m.group(1)

			m = re.compile('<label>マイリスト</label>\s*.*?<var>(.*?)</var>').search(counts)
			if m == None:
				mylist = "-"
			else:
				mylist = m.group(1)

			m = re.compile('<var.*?>\s*(.*?)\s*</var>').search(time)
			if m == None:
				videoDate = "-"
			else:
				videoDate = m.group(1)

			resultArray.append([video_id, title, view, comment, mylist, video_length, tbn, videoDate, purchase_type])

		return resultArray,videoNum

	def getMyWatchList(self):
		''' 自分のお気に入りユーザーを取得 '''
		page = 1
		next_p = re.compile('<a href="/my/fav/user\?page=([0-9]+)">次へ</a>')

		body = ''
		while page < 50:
			s = self.getHTML("http://www.nicovideo.jp/my/fav/user?page=%d" % (page))
			body += s
			next_m = next_p.search(s)
			if not next_m:
				break
			page += 1
#		print body

		p = re.compile(u'(?s)<a href="/user/([0-9]*)"><img\s+src="(.*?)".*?alt="(.*?)".*?/></a>.*?(<p>(.*?)</p>|buttonShape)')
		resultArray = []
		for m in p.finditer(body):
			user = m.group(1)
			img_url = m.group(2)
			name = m.group(3)
			discript = m.group(5)
			resultArray.append([user, name,img_url,discript])
		return resultArray

	def getMyWatchList_old(self):
		''' 自分のお気に入りユーザーを取得 '''
		body = self.getHTML("http://www.nicovideo.jp/my/watchlist?innerPage=1&type=watch")
		body = unicode(body.decode('unicode-escape')).encode('utf-8')
		body = re.sub("\\\\/", "/", body)
#		print body

		p = re.compile(u'(?s)<a href="/user/([0-9]*)"><img src="(.*?)" alt="(.*?)"></a>.*?(<p>(.*?)</p>|buttons)')
		resultArray = []
		for m in p.finditer(body):
			user = m.group(1)
			img_url = m.group(2)
			name = m.group(3)
			discript = m.group(5)
			resultArray.append([user, name,img_url,discript])
		return resultArray

	def getUserWatchList(self, user):
		''' お気に入りユーザーの一覧を取得 '''
		body =self.getHTML("http://www.nicovideo.jp/user/%s/mylist" % user)

		recomp = re.compile(u'<a href="(mylist/[0-9]*)">.*</span>(.*)</a>')
		resultArray = []
		for m in recomp.finditer(body):
			href = m.group(1)
			name = m.group(2)
			resultArray.append([href, name])
		return resultArray

	def addMylist(self, video_id, group_id=None):
		"""マイリストに動画を追加します （group_idを指定しない場合は「とりあえずマイリスト」に追加）"""
		body =self.getHTML("http://www.nicovideo.jp/mylist_add/video/%s" % video_id )
#		m = re.compile('(?s)item_id.*?value="(.*?)".*NicoAPI.token = "(.*?)"').search(body)
		m = re.compile("(?s)item_type.*?value=\"(.*?)\".*item_id.*?value=\"(.*?)\".*NicoAPI.token = '(.*?)'").search(body)
		item_type = m.group(1)
		item_id = m.group(2)
		token = m.group(3)
		if group_id == None:
			self.getHTML("http://www.nicovideo.jp/api/deflist/add?item_type=%s&item_id=%s&description=&token=%s" % (item_type,item_id,token))
		else:
			self.getHTML("http://www.nicovideo.jp/api/mylist/add?group_id=%s&item_type=%s&item_id=%s&description=&token=%s" % (group_id,item_type,item_id,token))

	def moveMylist(self,video_id, target_group_id, group_id=None):
		"""マイリストの動画を移動します"""
		body =self.getHTML("http://www.nicovideo.jp/mylist_add/video/%s" % video_id )
#		m = re.compile('(?s)item_id.*?value="(.*?)".*NicoAPI.token = "(.*?)"').search(body)
		m = re.compile("(?s)item_type.*?value=\"(.*?)\".*item_id.*?value=\"(.*?)\".*NicoAPI.token = '(.*?)'").search(body)
#		item_type = m.group(1)
		item_id = m.group(2)
		token = m.group(3)
		if group_id == None:
			self.getHTML("http://www.nicovideo.jp/api/deflist/move?id_list[0][]=%s&target_group_id=%s&token=%s" % (item_id,target_group_id,token))
		else:
			self.getHTML("http://www.nicovideo.jp/api/mylist/move?group_id=%s&id_list[0][]=%s&target_group_id=%s&token=%s" % (group_id,item_id,target_group_id,token))

	def copyMylist(self,video_id, target_group_id, group_id=None):
		"""マイリストの動画をコピーします"""
		body =self.getHTML("http://www.nicovideo.jp/mylist_add/video/%s" % video_id )
#		m = re.compile('(?s)item_id.*?value="(.*?)".*NicoAPI.token = "(.*?)"').search(body)
		m = re.compile("(?s)item_type.*?value=\"(.*?)\".*item_id.*?value=\"(.*?)\".*NicoAPI.token = '(.*?)'").search(body)
#		item_type = m.group(1)
		item_id = m.group(2)
		token = m.group(3)
		if group_id == None:
			self.getHTML("http://www.nicovideo.jp/api/deflist/copy?id_list[0][]=%s&target_group_id=%s&token=%s" % (item_id,target_group_id,token))
		else:
			self.getHTML("http://www.nicovideo.jp/api/mylist/copy?group_id=%s&id_list[0][]=%s&target_group_id=%s&token=%s" % (group_id,item_id,target_group_id,token))

	def deleteMylist(self,video_id, group_id=None):
		"""マイリストから動画を削除します"""
		body =self.getHTML("http://www.nicovideo.jp/mylist_add/video/%s" % video_id )
#		m = re.compile('(?s)item_id.*?value="(.*?)".*NicoAPI.token = "(.*?)"').search(body)
		m = re.compile("(?s)item_type.*?value=\"(.*?)\".*item_id.*?value=\"(.*?)\".*NicoAPI.token = '(.*?)'").search(body)
#		item_type = m.group(1)
		item_id = m.group(2)
		token = m.group(3)
		if group_id == None:
			self.getHTML("http://www.nicovideo.jp/api/deflist/delete?id_list[0][]=%s&token=%s" % (item_id,token))
		else:
			self.getHTML("http://www.nicovideo.jp/api/mylist/delete?group_id=%s&id_list[0][]=%s&token=%s" % (group_id,item_id,token))

	def getFavtag(self):
		"""お気に入りタグを取得します"""
		body = self.getHTML("http://www.nicovideo.jp/my/fav/tag")
#		print body
		ptnStr = 'data-nico-tag="(.*?)"'
		resultArray = []
		for m in re.compile(ptnStr).finditer(body):
			resultArray.append(m.group(1))
		return resultArray

	def addFavtag(self, tag):
		"""お気に入りタグに追加します"""
		enctag = urllib.quote(tag)

		self.establishConnection()
		rs = self.retryingAccess(self.nico_conn, ('GET', '/tag/%s' % enctag, '', self.headers))
		self.refreshCookie(rs)
		body = rs.read()
		rs.close()
#		print body
		m = re.compile('<a href="#" class="button nav" data-favtag-add-button data-tag="(.*?)" data-token="(.*?)">').search(body)
		if m == None:
			return False, None
		tag = m.group(1)
		token = m.group(2)

		headers = self.headers.copy()
		headers['Content-type'] = 'application/x-www-form-urlencoded; charset=UTF-8'
		headers['Referer'] = 'http://www.nicovideo.jp/tag/'+tag
		try:
			conn = httplib.HTTPConnection('www.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('POST','/api/favtag/add',"tag=%s&token=%s" % (tag,token),headers))
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		m = re.compile('"status":"(.*?)"').search(body)
		if m == None:
			return False, None

		status = m.group(1)
		if status == "ok":
			return True, None
		else:
			print "addFavtag: %s" % (body)
			m = re.compile('"code":"(.*?)"').search(body)
			if m == None:
				return False, None
			return False, m.group(1)

	def deleteFavtag(self, tag):
		"""お気に入りタグから削除します"""
		enctag = urllib.quote(tag)

		self.establishConnection()
		rs = self.retryingAccess(self.nico_conn, ('GET', '/my/fav/tag', '', self.headers))
		self.refreshCookie(rs)
		body = rs.read()
		rs.close()
#		print body
		m = re.compile("var csrf_token = '(.*?)';").search(body)
		if m == None:
			return False, None
		tag = enctag
		token = m.group(1)

		headers = self.headers.copy()
		headers['Content-type'] = 'application/x-www-form-urlencoded; charset=UTF-8'
		headers['Referer'] = 'http://www.nicovideo.jp/my/fav/tag'
		try:
			conn = httplib.HTTPConnection('www.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('POST','/api/favtag/delete',"tag=%s&token=%s" % (tag,token),headers))
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		m = re.compile('"status":"(.*?)"').search(body)
		if m == None:
			return False, None

		status = m.group(1)
		if status == "ok":
			return True, None
		else:
			print "addFavtag: %s" % (body)
			m = re.compile('"code":"(.*?)"').search(body)
			if m == None:
				return False, None
			return False, m.group(1)


	def addWatchlist(self, video_id):
		"""お気に入りユーザーに追加します"""
		if(video_id[0:2] == "nm"):
			urlparam = video_id + "?as3=1";
		elif(self.economyMode):
			urlparam = video_id + "?eco=1"
		else:
			urlparam = video_id

		self.establishConnection()
		rs = self.retryingAccess(self.nico_conn, ('GET', '/watch/%s' % urlparam, '', self.headers))
		self.refreshCookie(rs)
		body = rs.read()
		rs.close()
#		print body

		m = re.compile("csrfToken&quot;:&quot;(.*?)&.*?videoUserId&quot;:&quot;(.*?)&quot;,&quot;").search(body)
		if m == None:
			return False, None

		item_type = '1';
		item_id = m.group(2)
		token = m.group(1)

		body = self.getHTML("http://www.nicovideo.jp/api/watchitem/add?item_type=%s&item_id=%s&token=%s" % (item_type,item_id,token))
#		print body

		m = re.compile('"status":"(.*?)"').search(body)
		if m == None:
			return False, None

		status = m.group(1)
		if status == "ok":
			return True, None
		else:
			print "addWatchlist: %s" % (body)
			m = re.compile('"code":"(.*?)"').search(body)
			if m == None:
				return False, None
			return False, m.group(1)

	def deleteWatchitem(self, id):
		"""お気に入りユーザーから削除します"""
		body = self.getHTML("http://www.nicovideo.jp/my/fav/user")
#		body = self.getHTML("http://www.nicovideo.jp/my/watchlist")
#		print body
		m = re.compile("Mypage_globals.hash = '(.*?)'").search(body)
		if m == None:
			return False, None
		token = m.group(1)
		print token
		body = self.getHTML("http://www.nicovideo.jp/api/watchitem/delete?id_list[1][]=%s&token=%s" % (id,token))
#		print body

	def addChannel(self, channel_id):
		"""チャンネルをお気に入りに登録します"""
		body = self.getChannelHTML("/channel/%s" % channel_id);

		m = re.compile('params="(channel_id.*)"').search(body)
		params = m.group(1)
		body = self.getChannelHTML("/api/addbookmark?" + params)
#		print body

	def deleteChannel(self, channel_id):
		"""チャンネルをお気に入りから削除します"""
		body = self.getChannelHTML("/channel/%s" % channel_id);
		m = re.compile('params="(channel_id.*)"').search(body)
		params = m.group(1)
		body = self.getChannelHTML("/api/deletebookmark?" + params)
#		print body

	def getLiveSearch(self, keyword, sort='view', search_mode='onair', kind='tags', tags='', page=1):
		# search_mode=onair,closed
		# kind = tags,content
		# track=nicolive_reserved_keyword,nicolive_onair_keyword,nicolive_closed_keyword
		if keyword:
			keyword = urllib.quote(keyword)
		if tags:
			tags = urllib.quote(tags)
#		if search_mode=='onair':
#			track='nicolive_reserved_keyword'
#		else:
#			track='nicolive_closed_keyword'
		track = ""

		resultArray = []
		hit = 0
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			url = '/search?track=%s&sort=%s&date=&keyword=%s&filter=+:%s:&page=%s'%(track,sort,keyword,search_mode,page*2-1)
			print url
			conn.request('GET', url, '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
#			print body

			total_m = re.compile('<strong.* class=&quot;search_total&quot;>([0-9]+)</strong>').search(body)
			if total_m:
				hit = int(total_m.group(1))
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close
		if 0 < hit:
#			ptnStr1 = '"id":([0-9]*?),"num_found":"(.*?)","start_time":([0-9]*?),"end_time":([0-9]*?),"provider_type":"community","timeshift_mode":([0-9]*?),"num_res":([0-9]*?),"reserved_num":([0-9]*?),"view_counter":([0-9]*?),"category_tags":"(.*?)","title":"(.*?)","thumbnail_url":"(.*?)","description":"(.*?)","hide_score":(.*?),"channel_only":"(.*?)","community":"(.*?)","community_only":"(.*?)","user":"(.*?)","attribute":(.*?),"elapsed_time_hour":([0-9]*?),"elapsed_time_min":([0-9]*?),"stream_status":"(.*?)","timeshift_is_enabled":(.*?),"ownername":"(.*?)","communityname":"(.*?)","rerun_stream":null,"_elapsed_time_text":"(.*?)","_total_time_text":"(.*?)","community_query":"(.*?)","provider_class":"(.*?)"'
			ptnStr1 = 'id":([0-9]*?),"num_found":"(.*?)","start_time":([0-9]*?),"end_time":([0-9]*?),"provider_type":"community","timeshift_mode":([0-9]*?),"num_res":([0-9]*?),"reserved_num":([0-9]*?),"view_counter":([0-9]*?),"category_tags":"(.*?)","title":"(.*?)","thumbnail_url":"(.*?)","description":"(.*?)","hide_score":(.*?),"channel_only":"(.*?)","community":"(.*?)","community_only":"(.*?)","user":"(.*?)","attribute":(.*?),"elapsed_time_hour":([0-9]*?),"elapsed_time_min":([0-9]*?),"stream_status":"(.*?)","timeshift_is_enabled":(.*?),"ownername":"(.*?)","communityname":"(.*?)","rerun_stream":null,".*?_elapsed_time_text":"(.*?)","_total_time_text":"(.*?)","community_query":"(.*?)","provider_class":"(.*?)"'
			i=0
			for m in re.compile(ptnStr1).finditer(body):
				stream_status  = m.group(20)

				result = {}

				dateStr = m.group(3)
				if 'close' in stream_status:
					break

				live_id = m.group(1)
				result['live_id'] = "lv"+live_id

				result['category_tags'] = m.group(9)
				result['title'] =unicode(m.group(10).decode('unicode-escape')).encode('utf-8')


				result['view'] = m.group(8)

				result['num_res'] = m.group(6)
				result['num_timeShift'] = m.group(7)
				result['timeshift_is_enabled'] = m.group(22)


				result['date'] = dateStr
#				result['elapsed_time_min'] = m.group(20)
				result['_elapsed_time_text'] = unicode(m.group(25).decode('unicode-escape')).encode('utf-8')
				result['_total_time_text'] = unicode(m.group(26).decode('unicode-escape')).encode('utf-8')

				result['over_time'] = None
				result['search_stream_description'] =unicode(m.group(12).decode('unicode-escape')).encode('utf-8')
				result['community_id'] = m.group(15)
				result['tbn'] = result['community_id']

				result['community_only'] = m.group(16)

				resultArray.append(result)

				i+=1
#				if hit == i:
#					break
		return hit,resultArray
#	def getLiveSearch(self, keyword, sort='view', search_mode='onair', kind='tags', tags='', page=1):
#		# search_mode=onair,closed
#		# kind = tags,content
#		# track=nicolive_reserved_keyword,nicolive_onair_keyword,nicolive_closed_keyword
#		if keyword:
#			keyword = urllib.quote(keyword)
#		if tags:
#			tags = urllib.quote(tags)
##		if search_mode=='onair':
##			track='nicolive_reserved_keyword'
##		else:
##			track='nicolive_closed_keyword'
#		track = ""
#
#		resultArray = []
#		hit = 0
#		try:
#			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
#			url = '/search?track=%s&sort=%s&date=&keyword=%s&filter=+:%s:&page=%s'%(track,sort,keyword,search_mode,page*2-1)
##			print url
#			conn.request('GET', url, '', self.headers)
#			rs = conn.getresponse()
#			body = rs.read()
##			print body
#
#			total_m = re.compile('<strong.* class=&quot;search_total&quot;>([0-9]+)</strong>').search(body)
#			if total_m:
#				hit = int(total_m.group(1))
#		finally:
#			if conn:
#				conn.close()
#			if rs:
#				rs.close
#		if 0 < hit:
#			ptnStr1 = '(?s)<div class="result_item cmn" >.*?<td class="score_area">(.*?)</ul>.*?<p class="status">(.*?)</p>.*?<a href="http://live.nicovideo.jp/searchresult\?v=(lv[0-9]+).*?">\s*(.*?)\s*</a>\s*</p>\s*<span class="search_stream_description">(.*?)</span>'
#			i=0
#			livecheck = "経過"
#			for m in re.compile(ptnStr1).finditer(body):
#				result = {}
#
#				dateStr = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',m.group(2))
#				if not (livecheck in dateStr):
#					break
#
#				live_id = m.group(3)
#				result['live_id'] = live_id
#				result['title'] = m.group(4)
#
#				score_area = m.group(1)
#
#				view_m = re.compile(r'(?s)来場：<span class="number">.*?([0-9,]+)</span>').search(score_area)
#				if view_m:
#					result['view'] = view_m.group(1)
#				else:
#					result['view'] = "-"
#				num_res_m = re.compile(r'(?s)コメ：<span class="number">.*?([0-9,]+)</span>').search(score_area)
#				if num_res_m:
#					result['num_res'] = num_res_m.group(1)
#				else:
#					result['num_res'] = "-"
#				num_timeShift_m = re.compile(r'(?s)予約：<span class="number">.*?([0-9,]+)</span>').search(score_area)
#				if num_timeShift_m:
#					result['num_timeShift'] = num_timeShift_m.group(1)
#				else:
#					result['num_timeShift'] = "-"
#
#				result['date'] = dateStr
#				result['over_time'] = None
#				result['search_stream_description'] = m.group(5)
#				result['community_id'] = None
#				resultArray.append(result)
#				i+=1
#				if hit == i:
#					break
#
#			if 0 < len(resultArray):
#				tbn_m = re.compile('(?s)Searcher.init\(\[\s*(.*?)\]').search(body)
#				if tbn_m:
#					tbnStr = tbn_m.group(1)
#					co_ptn = re.compile('(co[0-9]+).jpg')
#					i=0
#					for m in re.compile('"(.*)"').finditer(tbnStr):
#						resultArray[i]['tbn'] = m.group(1)
#						co_m = co_ptn.search(resultArray[i]['tbn'])
#
#						if co_m:
#							community_id = co_m.group(1)
#						else:
#							community_id = resultArray[i]['live_id']
#						resultArray[i]['community_id'] = community_id
#						i+=1
#						if len(resultArray) <= i:
#							break
#
#		return hit,resultArray

#	def getLiveSearch(self, keyword, sort='view', search_mode='onair', kind='tags', tags='', page=1):
#		# search_mode=onair,closed
#		# kind = tags,content
#		# track=nicolive_reserved_keyword,nicolive_onair_keyword,nicolive_closed_keyword
#		if keyword:
#			keyword = urllib.quote(keyword)
#		if tags:
#			tags = urllib.quote(tags)
##		if search_mode=='onair':
##			track='nicolive_reserved_keyword'
##		else:
##			track='nicolive_closed_keyword'
#		track = ""
#
#		resultArray = []
#		hit = 0
#		try:
#			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
#			url = '/search?track=%s&sort=%s&date=&keyword=%s&filter=+:%s:&page=%s'%(track,sort,keyword,search_mode,page*2-1)
##			print url
#			conn.request('GET', url, '', self.headers)
#			rs = conn.getresponse()
#			body = rs.read()
#			print body
#
#			total_m = re.compile('<strong.* class=&quot;search_total&quot;>([0-9]+)</strong>').search(body)
#			if total_m:
#				hit = int(total_m.group(1))
#		finally:
#			if conn:
#				conn.close()
#			if rs:
#				rs.close
#		if 0 < hit:
#			ptnStr1 = '(?s)来場：<span class="number">.*?([0-9,]+)</span>.*?コメ：<span class="number">.*?([0-9,]+)</span>.*?予約：<span class="number">.*?([0-9,]+)</span>.*?<p class="status">(.*?)</p>.*?<a href="http://live.nicovideo.jp/searchresult\?v=(lv[0-9]+).*?">\s*(.*?)\s*</a>\s*</p>\s*<span class="search_stream_description">(.*?)</span>'
#			i=0
#			checkstr = "経過"
#			for m in re.compile(ptnStr1).finditer(body):
#				result = {}
#				live_id = m.group(5)
#				result['live_id'] = live_id
#				result['title'] = m.group(6)
#				result['view'] = m.group(1)
#				result['num_res'] = m.group(2)
#				result['num_timeShift'] = m.group(3)
#				dateStr = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',m.group(4))
#
#				if not (checkstr in dateStr):
#					break
#
#				result['date'] = dateStr
#				result['over_time'] = None
#				result['search_stream_description'] = m.group(7)
#				result['community_id'] = None
#				resultArray.append(result)
#				i+=1
#				if hit == i:
#					break
#
#			if 0 < len(resultArray):
#				tbn_m = re.compile('(?s)Searcher.init\(\[\s*(.*?)\]').search(body)
#				if tbn_m:
#					tbnStr = tbn_m.group(1)
#					co_ptn = re.compile('(co[0-9]+).jpg')
#					i=0
#					for m in re.compile('"(.*)"').finditer(tbnStr):
#						resultArray[i]['tbn'] = m.group(1)
#						co_m = co_ptn.search(resultArray[i]['tbn'])
#
#						if co_m:
#							community_id = co_m.group(1)
#						else:
#							community_id = resultArray[i]['live_id']
#						resultArray[i]['community_id'] = community_id
#						i+=1
#						if len(resultArray) <= i:
#							break
#
#		return hit,resultArray

	def getLiveRecent(self, tab='', sort='view_counter', order='desc', page=1):
		'''生放送のRSSを取得します'''

		resultArray = []
		url1 = 'http://live.nicovideo.jp/recent/rss?tab=%s&sort=%s&order=%s&p=%s'%(tab,sort,order,page*2-1)
		url2 = 'http://live.nicovideo.jp/recent/rss?tab=%s&sort=%s&order=%s&p=%s'%(tab,sort,order,page*2);

#		print url1
		open = urllib2.urlopen(url1)
		body = open.read()
		open = urllib2.urlopen(url2)
		body += open.read()
#		print body

		p = re.compile('(?s)<item>\s*<title>(.*?)</title>\s*<link>(.*?)</link>\s*<guid.*?>(lv[0-9]+)</guid>\s*<pubDate>(.*?)</pubDate>\s*<description>(.*?)</description>\s*(<category>(.*?)</category>|(.*?))<media:thumbnail.*?url="(.*?)".*?/>\s*<dc:creator>(.*?)</dc:creator>\s*<nicolive:community_name>(.*?)</nicolive:community_name>\s*<nicolive:community_id>(.*?)</nicolive:community_id>\s*<nicolive:num_res>(.*?)</nicolive:num_res>\s*<nicolive:view>(.*?)</nicolive:view>\s*<nicolive:member_only>(.*?)</nicolive:member_only>\s*<nicolive:type>(.*?)</nicolive:type>\s*(<nicolive:owner_name>(.*?)</nicolive:owner_name>|(.*?))</item>')
		for m in p.finditer(body):
			guid = m.group(3)
			for r in resultArray:
				if r['guid'] == guid:
					break
			else:
				result = {}
				result['title'] = m.group(1)
				result['link'] = m.group(2)
				result['guid'] = guid
				result['pubDate'] = m.group(4)
				result['description'] = m.group(5)
				result['category'] = m.group(7)
				if result['category']:
					result['category'] = result['category'].replace('</category><category>',',')
				result['thumbnail'] = m.group(9)
				result['creator'] = m.group(10)
				result['community_name'] = m.group(11)
				result['community_id'] = m.group(12)
				result['num_res'] = m.group(13)
				result['view'] = m.group(14)
				result['member_only'] = m.group(15)
				result['type'] = m.group(16)
				result['owner_name'] = m.group(18)
				resultArray.append(result)
		return resultArray

	def getRealTimeRecentOnairStreams(self, tab='', sort='view_counter', order='desc', page=1, tags=''):
		'''生放送を取得します'''
		if tags: tags = urllib.quote(tags)
		elif tags == None: tags = ''
		url1 = 'http://live.nicovideo.jp/realtimerecentonairstreams?sort=%s&tab=%s&page=%s&order=%s&tags=%s&tk'%(sort,tab,page*2-1,order,tags)
#		print url1
		open = urllib2.urlopen(url1)
		body = open.read()
#		print body
		url2 = 'http://live.nicovideo.jp/realtimerecentonairstreams?sort=%s&tab=%s&page=%s&order=%s&tags=%s&tk'%(sort,tab,page*2,order,tags)
		open = urllib2.urlopen(url2)
		body += open.read()
#		print body

#		p = re.compile('(?s)<div class="time">(.*?)</div>.*?<a href="watch/(lv[0-9]*).*?<img src="(.*?)".*?/>.*?<p class="title"><a .*?>(.*?)</a></p>.*?<p class="comName">(.*?)</p>.*?<li .*?id="view_counter_.*?">\s*(.*?)\s*</li>\s*<li .*?id="comment_counter_.*?">\s*(.*?)\s*</li>')
#		p = re.compile('(?s)title="(.*?)".*?<a href="watch/(lv[0-9]*).*?<img src="(.*?)".*?>.*?<.*?="user-programs-time".*?>(.*?)<.*?<.*?="view_counter_.*?".*?>(.*?)<.*?<.*?="comment_counter_.*?".*?>(.*?)<')
		p = re.compile('(?s)href="watch/(.*?)\?.*?<img class="provider-icon" src="(.*?)".*?>\s*<span class="provider-name">(.*?)</span>\s*<span class="elapsed-time">(.*?)</span>.*?class="title">(.*?)<.*?<span class="watch-count" aria-label="来場者([0-9,-]+)人">.*?<span class="comment-count" aria-label="([0-9,-]+)コメント">');
		resultArray = []
		for m in p.finditer(body):
			live_id = m.group(1)
			community_id = live_id
			thumbnail =  m.group(2)
			m2 = re.compile(r'((ch|co)[0-9]+)').search(thumbnail)
			if m2:
				community_id = m2.group(1)
			for r in resultArray:
				if r['community_id'] == community_id:#重複チェック
					break
			else:
				result = {}
				result['live_id'] = live_id
				result['community_id'] = community_id
				result['time'] = m.group(4)
				result['title'] = m.group(5) # + ' ' + m.group(3)
				result['view'] = m.group(6)
				result['comment'] = m.group(7)
				result['thumbnail'] = thumbnail
				resultArray.append(result)
		return resultArray

	def getLiveRecent2onairstreams(self, tab='', sort='view', page=1, tags=''):
		'''生放送を取得します(ニコニコ動画:Q以前のバージョン)'''
		if tags: tags = urllib.quote(tags)
		elif tags == None: tags = ''

		url1 = 'http://live.nicovideo.jp/recent2onairstreams?tab=%s&sort=%s&p=%s&tags=%s'%(tab,sort,page*2-1,tags)
		open = urllib2.urlopen(url1)
		body = open.read()
		url2 = 'http://live.nicovideo.jp/recent2onairstreams?tab=%s&sort=%s&p=%s&tags=%s'%(tab,sort,page*2,tags)
		open = urllib2.urlopen(url2)
		body += open.read()
#		print body

		p = re.compile('(?s)<span class="over_time">(.*?)</span>.*?<td class="thmb">\s*<a href="http://live.nicovideo.jp/watch/(co[0-9]*).*?.\s<img src="(.*?)">.*?<.*?iconViewerS">([0-9,]*)</span>.*? iconCommentS">([0-9,]*)</span>.*?title="(.*?)"')
		resultArray = []
		for m in p.finditer(body):
			community_id = m.group(2)
			for r in resultArray:
				if r['community_id'] == community_id:
					break
			else:
				result = {}
				result['over_time'] = m.group(1)
				result['title'] = m.group(6)
				result['num_res'] = m.group(5)
				result['view'] = m.group(4)
				result['community_id'] = community_id
				result['thumbnail'] = m.group(3)
				resultArray.append(result)
		return resultArray


	def apiGetActiveRanking(self, type='onair'):
		'''生放送のランキングを取得します'''

		url = 'http://live.nicovideo.jp/api/getactiveranking?type=%s&main_provider_type=' % (type)
		open = urllib2.urlopen(url)
		body = open.read()

#		print body

		p = re.compile('(?s)<span.*?>.*?No<span class="rank">(.*?)</span>(.*?)</span>.*?<p>.*?<span id="score_[0-9]+" class="score">(.*?)</span>(.*?)</p>.*?<div class="status">(.*?)</div>.*?<span class="video_id" .*?>(.*?)</span>.*?<img src="(.*?)".*?/>.*?<span class="video_title">(.*?)</span>.*?<div class="time">(.*?)</div>.*?<ul class="data">.*?(<li id="view_counter_[0-9]+".*?>(.*?)</li>|<li class="timeShift").*?(<li id="comment_counter_[0-9]+".*?>(.*?)</li>|</li>)')
		resultArray = []
		resultArray_official = None
		resultArray_ch = None
		for m in p.finditer(body):
			result = {}
			result['rank'] = m.group(1)
			result['rank_state'] = m.group(2)
			score = m.group(3)+m.group(4)
			result['score'] = score.strip()
			tips = m.group(5)
			tips = re.sub(r'</span>',' ',tips)
			tips = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\n','',tips)
			tips = tips.strip()
			if not tips: tips = 'なし'
			else : tips = re.sub(r' ',',',tips)
			result['tips'] = tips
			result['video_id'] = m.group(6)
			title = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\n','', m.group(7))
			result['thumbnail'] = title
			result['title'] = m.group(8)
			result['time'] = m.group(9)
			result['view'] = m.group(11)
			result['comment'] = m.group(13)

			community_id = "lv" + result['video_id']
			m2 = re.compile(r'((ch|co)[0-9]+)').search(result['thumbnail'])
			if m2:
				community_id = m2.group(1)
			result['community_id'] = community_id
			resultArray.append(result)

		if type == 'onair':
			#公式、チャンネル
			p = re.compile('(?s)<div class="rankNumber">.*?<p class="spriteIcon">No([0-9]+)(.*?)</p>.*?<a .*?provider_type=(official|channel).*?><img src="(.*?)".*?/>.*?<div class="time">(.*?)</div>.*?<a href="watch/(lv[0-9]+).*?>(.*?)</a>.*?<div class="count">.*?(<div.*?>\s*(.*?)\s*</div>|</div>).*?(<div.*?>\s*(.*?)\s*</div>|</div>)')
			resultArray_official = []
			resultArray_ch = []
			for m in p.finditer(body):
				result = {}
				result['rank'] = m.group(1)
				result['rank_state'] = m.group(2)
				provider_type = m.group(3)
				result['thumbnail'] = m.group(4)
				result['time'] = m.group(5)
				result['live_id'] = m.group(6)
				title = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\n','', m.group(7))
				result['title'] = title
				result['view'] = m.group(9)
				result['comment'] = m.group(11)

				if provider_type == 'official':
					resultArray_official.append(result)
				else:
					resultArray_ch.append(result)

		return resultArray,resultArray_official,resultArray_ch

	def getMyTimeshift(self,body=None):
		'''タイムシフト予約リストを取得します'''
#		if not body:
#			try:
#				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
#				conn.request('GET', '/my', '', self.headers)
#				rs = conn.getresponse()
#				body = rs.read()
#			finally:
#				if conn:
#					conn.close()
#				if rs:
#					rs.close()
#		p = re.compile('(?s)<div class="name"><a href="http://live.nicovideo.jp/gate/(lv[0-9]+)".*?title="(.*?)">.*?class="timeshift_.*?">(.*?(いつでも視聴可能になりました)|.*?\[(.*?)\]).*?Nicolive.TimeshiftActions.deleteSingle\(\'(.*?)\', \'(.*?)\',\'(.*?)\'\)')
		timeshiftArray = []
#		for m in p.finditer(body):
#			result = {}
#			time = m.group(3)
#			time = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s|視聴する','',m.group(3))
#
#			result['id'] = m.group(1)
#			result['title'] = m.group(2)
#			result['time'] = time
#			result['token'] = m.group(8)
#			timeshiftArray.append(result)
		return timeshiftArray

	def getMyParticipate(self,body=None):
		'''参加中のチャンネル/コミュニティで放送されている番組と予約を取得します'''

		if body == None:
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('GET', '/my', '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()
		liveArray,reserveArray = self.getMyParticipateLive(body)
#		reserveArray = self.getMyParticipateReserve(body)
		return liveArray,reserveArray

	def getMyParticipateLive(self,body=None):
		'''参加中のチャンネル/コミュニティで放送されている番組を取得します'''
		if body == None:
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('GET', '/my', '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()
		p1 = re.compile('(?s)<div class="liveItem(|_ch)(| last)">.*?<a href="http://live.nicovideo.jp/.*?/(lv[0-9]+).*?".*?title="(.*?)">.*?<img src=".*?/((ch|co)[0-9]+?).jpg.*?<p class="start_time"><strong>\s*(.*?)\s*</strong></p>.*?<p title="(.*?)">.*?</p>\s*<div class="liveItemBtn(|Nano)"')
		liveArray = []
		reserveArray = []
		for m in p1.finditer(body):
			result = {}
			result['guid'] = m.group(3)
			result['title'] = m.group(4)
			result['community_id'] = m.group(5)
			result['start_time'] = m.group(7)
			result['community_title'] = m.group(8)
			btn = m.group(9)
			if btn == '':
				liveArray.append(result)
			else:
				reserveArray.append(result)

		return liveArray,reserveArray

	def getMyParticipateReserve(self,body=None):
		'''参加中のチャンネル/コミュニティの放送予約を取得します'''
		if body == None:
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('GET', '/my', '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()
		p2 = re.compile('(?s)<div class="liveItem_reserve">.*?<a href="http://live.nicovideo.jp/gate/(lv[0-9]+)".*?title="(.*?)">.*?<img src=".*?/((ch|co)[0-9]+?).jpg.*?<p class="start_time"><strong>\s*(.*?)\s*</strong></p>.*?<p title="(.*?)"')
		liveArray = []

		for m in p2.finditer(body):
			result = {}
			result['guid'] = m.group(1)
			result['title'] = m.group(2)
			result['community_id'] = m.group(3)
			result['start_time'] = m.group(5)
			result['community_title'] = m.group(6)
			liveArray.insert(0,result)
		return liveArray

	def getSPLiveMypageData(self):
		'''参加中のチャンネル/コミュニティで放送されている番組を取得します'''

		try:
			conn = httplib.HTTPConnection('sp.live.nicovideo.jp', 80)
			conn.request('GET', '/?frompc', '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		liveArray = []
		timelineArray = []
		return liveArray,timelineArray


	def getSpLiveData(self):
		'''モバイルページの生放送情報を返します'''

		try:
			conn = httplib.HTTPConnection('sp.live.nicovideo.jp', 80)
			conn.request('GET', '/?frompc', '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		sectionArray = {}
		sectionArray['onair_program_area'] =  {}
		sectionArray['favorite_program_area'] =  {}
		sectionArray['community_program_area'] =  {}

		p1 = re.compile('(?s)(<section id="(.*?)".*?>.*?</section>)')
		for m in p1.finditer(body):
			section_body = m.group(1).replace('&nbsp;',' ')
			section = m.group(2)
#			print section
#			print section_body
			result = self.parceSpLive(section_body,section)
			sectionArray[section] = result

#		sectionArray['closed_ranking_area'] =  {}
#		sectionArray['picup_area'] =  {}
#		sectionArray['feature_area'] =  {}
#		p1 = re.compile('(?s)(<section class="(.*?)".*?>.*?</section>)')
#		for m in p1.finditer(body):
#			section_body = m.group(1).replace('&nbsp;',' ')
#			section = m.group(2)
##			print section
##			print section_body
#			result = self.parceSpLive(section_body,section)
#			sectionArray[section] = result

		return sectionArray


	def parceSpLive(self, body, section):
		s = '(?s)data-stream-status="(.*?)".*?data-provider-type="(.*?)".*?<a href="watch/((ch|co|lv)[0-9]+).*?".*?<img src="(.*?)" alt="(.*?)".*?>.*?<p class="(desc|elapsed_time)">(.*?)</p>'
		p1 = re.compile(s)
		array = []
		for m in p1.finditer(body):
			result = {}
			result['live_id'] = m.group(3)
			result['status'] = m.group(1)
			img = m.group(5)
			title = m.group(6)
			#タイトル名文字化け対策
#			print title
			try:
				unicode(title,'utf-8')
			except:
				title = title[0:len(title)-3]
				while 0 < len(title):
					title = title[0:len(title)-1]
					try:
						unicode(title,'utf-8')
						title = title + "..."
						break
					except:
						pass
			result['title'] = title
			result['start_time'] = m.group(8)

#			chco_m = re.compile(r'(ch|co[0-9]+)').search(img)
#			if chco_m:
#				result['community_id'] = chco_m.group(1)
#			else:
#				result['community_id'] = result['live_id']
			result['community_id'] = result['live_id']
			result['thumb'] = img

			array.append(result)
		return array

	def parceSpLiveOld(self, body, section):

		s = '(?s)<div class="watch_area" onclick="watch\(\'(lv[0-9]+)\',\'.*?\'\);">.*?<img src=".*?" alt="(.*?)">.*?<img (src|id)="(.*?)".*?>.*?<div class="start">\s*(.*?)\s*</div>.*?<div class="title">(.*?)</div>(.*?)<a href="http://sp.live.nicovideo.jp/gate/(lv[0-9]+)">'

		if section == 2:
			s = s + '.*?Result.setData\(".*?","(.*?/((ch|co)[0-9]+?).jpg.*?)","img"\)'
		p1 = re.compile(s)
		array = []
		for m in p1.finditer(body):
			result = {}
			result['live_id'] = m.group(1)
			result['status'] = m.group(2)
			title = m.group(6)
			#タイトル名文字化け対策
#			print title
			try:
				unicode(title,'utf-8')
			except:
				title = title[0:len(title)-3]
				while 0 < len(title):
					title = title[0:len(title)-1]
					try:
						unicode(title,'utf-8')
						title = title + "..."
						break
					except:
						pass
			result['title'] = title

			result['community_id'] = result['live_id']
			result['start_time'] = m.group(5)
			result['community_title'] = ""
			count = m.group(7)

			view_m = re.compile(r'(?s)<img src="img/smartphone/view.png".*?>\s*([0-9,]*)').search(count)
			if view_m:
				result['view'] = view_m.group(1)
			else:
				result['view'] = "-"

			comment_m = re.compile(r'(?s)<img src="img/smartphone/comment.png".*?>\s*([0-9,]*)').search(count)
			if comment_m:
				result['comment'] = comment_m.group(1)
			else:
				result['comment'] = "-"

			img = None
			if section == 2:
				img = m.group(9)

				result['community_id'] = m.group(10)
			else:
				img = m.group(4)
				if img[0:7] == "http://":
					chco_m = re.compile(r'(ch|co[0-9]+)').search(img)
					if chco_m:
						result['community_id'] = chco_m.group(1)
				else:
					img = "http://sp.live.nicovideo.jp/" + img.replace('.60x60.jpg', '.jpg')

			result['thumb'] = img

			array.append(result)
		return array

	def parceSpLive_old(self, body, section):

		s = '(?s)<div class="watch_area" onclick="watch\(\'(lv[0-9]+)\',\'.*?\'\);">.*?<img src=".*?" alt="(.*?)">.*?<img (src|id)="(.*?)".*?>.*?<div class="start">\s*(.*?)\s*</div>.*?<div class="title">(.*?)</div>(.*?)<a href="http://sp.live.nicovideo.jp/gate/(lv[0-9]+)">'

		if section == 2:
			s = s + '.*?Result.setData\(".*?","(.*?/((ch|co)[0-9]+?).jpg.*?)","img"\)'
		p1 = re.compile(s)
		array = []
		for m in p1.finditer(body):
			result = {}
			result['live_id'] = m.group(1)
			result['status'] = m.group(2)
			title = m.group(6)
			#タイトル名文字化け対策
#			print title
			try:
				unicode(title,'utf-8')
			except:
				title = title[0:len(title)-3]
				while 0 < len(title):
					title = title[0:len(title)-1]
					try:
						unicode(title,'utf-8')
						title = title + "..."
						break
					except:
						pass
			result['title'] = title

			result['community_id'] = result['live_id']
			result['start_time'] = m.group(5)
			result['community_title'] = ""
			count = m.group(7)

			view_m = re.compile(r'(?s)<img src="img/smartphone/view.png".*?>\s*([0-9,]*)').search(count)
			if view_m:
				result['view'] = view_m.group(1)
			else:
				result['view'] = "-"

			comment_m = re.compile(r'(?s)<img src="img/smartphone/comment.png".*?>\s*([0-9,]*)').search(count)
			if comment_m:
				result['comment'] = comment_m.group(1)
			else:
				result['comment'] = "-"

			img = None
			if section == 2:
				img = m.group(9)

				result['community_id'] = m.group(10)
			else:
				img = m.group(4)
				if img[0:7] == "http://":
					chco_m = re.compile(r'(ch|co[0-9]+)').search(img)
					if chco_m:
						result['community_id'] = chco_m.group(1)
				else:
					img = "http://sp.live.nicovideo.jp/" + img.replace('.60x60.jpg', '.jpg')

			result['thumb'] = img

			array.append(result)
		return array

	def getLiveMypageData(self):
		'''参加中のチャンネル/コミュニティで放送されている番組を取得します'''

		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/my', '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		liveArray,reserveArray = self.getMyParticipate(body)
		timeshiftArray = self.getMyTimeshift(body)
		return liveArray,reserveArray,timeshiftArray

	def deleteTimeshift(self, vid,confirm_token):
		'''タイムシフト予約を削除します'''
		num_m = re.compile("[a-z]*([0-9]*)").match(vid)
		if num_m == None:
			return
		num = num_m.group(1)

		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/my?delete=timeshift&vid=%s&confirm=%s' % (num,confirm_token), '', self.headers)
			rs = conn.getresponse()
#			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()


	def getLiveRanking2(self,type):
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/ranking?type=rookie', '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()


	def getLiveRanking(self,type):
		'''ニコ生のランキングを取得します'''
		resultArray = []
		rankitems_param_ptn = re.compile('\{"ranking_pt":(.*?),"id":"(.*?)","title":"(.*?)","description":"(.*?)","provider_type":"(.*?)","thumbnail_url":"(.*?)","default_community":(.*?),"communityinfo":\{(.*?)\},"enable_archive":(.*?),"_display_timeshift_button":(.*?),')
		for i in range(10):
			result_count = len(resultArray)
			url = 'http://live.nicovideo.jp/api/loadallranking?lp=%d&nr=%d&type=%s'  % (i * 10,i * 10 + 1,type)
			open = urllib2.urlopen(url)
			body = open.read()
#			print body
			for m in rankitems_param_ptn.finditer(body):
				id = m.group(2)
				for r in resultArray:
					if r['id'] == id:
						break
				else:
					result = {}
					result['ranking_pt'] = m.group(1).replace('"', '')
					result['id'] = id
					result['title'] = unicode(m.group(3).decode('unicode-escape')).encode('utf-8')
					result['description'] = unicode(m.group(4).decode('unicode-escape')).encode('utf-8')
					result['provider_type'] = m.group(5)
					result['thumbnail_url'] =re.sub(r'\\','',m.group(6))
					default_community = m.group(7).replace('"', '')
					if default_community == 'null':
						default_community = None
					result['default_community'] = default_community
					result['name'] = unicode(m.group(8).decode('unicode-escape')).encode('utf-8')
#					result['_currentstatus'] = m.group(11).replace('"', '')
					result['enable_archive'] = m.group(9)
					result['_display_timeshift_button'] = m.group(10)
					resultArray.append(result)
			if result_count == len(resultArray):
				break
		return resultArray

#	def getTimeShiftRanking(self):
#		'''注目の番組ランキングを取得します'''
#		open = urllib2.urlopen('http://live.nicovideo.jp/ranking')
#		body = open.read()
#		print body
#		p1 = re.compile('(?s)<div class="day">(.*?)</div>.*?タイムシフト予約数：<strong>([0-9]+)</strong>.*?<a href="http://live.nicovideo.jp/watch/(.*?[0-9]+).*?" title="(.*?)" class="title">.*?<span class="comchaof">.*?\[(.*?)\]')
#		resultArray = []
#		for m in p1.finditer(body):
#			result = {}
#			time = m.group(1)
#			time = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',time)
#
#			result['id'] = m.group(3)
#			result['yoyaku'] = m.group(2)
#			result['time'] = time
#			result['title'] = m.group(4)
#			result['category'] = m.group(5)
#			resultArray.append(result)
#		return resultArray

	def getTimeline(self,start,end):
		'''公式動画情報を取得します'''

		try:
			conn = httplib.HTTPConnection('watch.live.nicovideo.jp', 80)
			conn.request('GET', '/api/timeline.php?start=%s&end=%s&left=1&right=6' % (start,end), '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
#			print 'http://watch.live.nicovideo.jp/api/timeline.php?start=%s&end=%s&left=1&right=6' % (start,end)
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		p1 = re.compile('(lv[0-9]+)\t([0-9]+)\t([0-9]+)\t([0-9]+)\t([0-9]+)\t([0-9]+)\t(.*?)\t(.*?)\t(.*?)\t(.*?)\t(.*?)\t(.*?)\t(.*?)\t')
		resultArray = []
		for m in p1.finditer(body):
			result = {}
			result['live_id'] = m.group(1)
#			unknoun2 = m.group(2)
			result['start'] = m.group(3)
#			unknoun4 = m.group(4)
#			unknoun5 = m.group(5)
#			unknoun6 = m.group(6)
			result['status'] = m.group(7)
			result['title'] = m.group(8)
			result['category'] = m.group(9)
			result['community_id'] = m.group(10)
#			unknoun11 = m.group(11)
			result['description'] = m.group(12)
			result['thumb'] = m.group(13)
			resultArray.append(result)
		return resultArray

	def getChTimeline(self):
		'''ﾁｬﾝﾈﾙ生放送のﾀｲﾑﾗｲﾝを取得します'''
		open = urllib2.urlopen('http://live.nicovideo.jp/api/timeline.php?mode=ch')
		body = open.read()
		p1 = re.compile('(lv[0-9]+)\s([0-9]+)\s(.+?)\s(ch[0-9]+)\s(.+?)\s([0-9]+)\s(.+)')
		resultArray = []
		for m in p1.finditer(body):
			lv_id = m.group(1)
			time = m.group(2)
			title = m.group(3)

			ch_id = m.group(4)
			ch_name = m.group(5)
			time2 = m.group(6)
			thumb = 'http://live.nicovideo.jp/'+m.group(7)
			resultArray.append([lv_id,time,title,ch_id,ch_name,time2,thumb])
		return resultArray

	def getLiveTagRelated(self, tab='', tag=''):
		'''関連タグを取得します'''

		url = 'http://live.nicovideo.jp/recent?tab=%s'%(tab)
#		url = 'http://live.nicovideo.jp/recent2tags/rss?tab=%s&tag=%s'% (tab,tag)
#		print url
		open = urllib2.urlopen(url)
		body = open.read()
#		print body
		p1 = re.compile('<a href=".+?"\s*onclick=".+?">(.+?)\(([0-9]+)\)</a>')
		resultArray = []
		for m in p1.finditer(body):
			tag = m.group(1)
			num = m.group(2)
			resultArray.append([tag,num])
		return resultArray

	def getwaybackkey(self, thread):
		try:
			conn = httplib.HTTPConnection('watch.live.nicovideo.jp', 80)
			conn.request('GET', '/api/getwaybackkey?thread=%s' % thread, '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		waybackkey = body[body.index('=') + 1:]
		return waybackkey


	def downloadMessageAll(self, filepath):
		"""コメントXMLの保存"""
		import struct

		f = open(filepath, 'wb')
		p1 = re.compile(r'last_res="([0-9]+)"')
		p2 = re.compile(r'date="([0-9]+)"')
		when = -1
		try:
			getwaybackkey = self.getwaybackkey(self.ms_thread)

#			xml = '<thread thread="%s" version="20061206" res_from="-1000" scores="1" />\0' % self.ms_thread
#			xml = '<thread thread="%s" res_from="-%s" version="20061206" when="%s" waybackkey="%s" user_id="%s" scores="1" />\0' % (self.ms_thread,1000,self.start_time,getwaybackkey,self.user_id)
#			xml = '<thread thread="%s" version="20061206" res_from="-1000"/>\0' % self.ms_thread
			xml = '<thread thread="%s" version=\"20061206\" res_from=\"-1000\" when="%s" waybackkey="%s" user_id="%s"/>\0' % (self.ms_thread,1439119318,getwaybackkey,self.user_id)
			print xml

			try:
				sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
				sock.connect((self.ms_addr, self.ms_port))
				sock.setsockopt(socket.SOL_SOCKET, socket.SO_RCVTIMEO, struct.pack('2L', 3, 0))
				sock.send(xml)
				data = sock.recv(1024)
				check_last_res = int(p1.search(data).group(1))
				print "last_res=%s" % check_last_res
				date_m = p2.search(data)
				if date_m:
					when = int(date_m.group(1)) - 1
					print "when=%s" % when
				f.write(data)

				while True:
					data = sock.recv(1024)
					f.write(data)
			except Exception, e:
				print str(e)
			sock.close()
			if self.is_premium != 0 and when != -1:
				while True:
					xml = '<thread thread="%s" version=\"20061206\" res_from=\"-1000\" when="%s" waybackkey="%s" user_id="%s"/>\0' % (self.ms_thread,when,getwaybackkey,self.user_id)
					sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
					sock.connect((self.ms_addr, self.ms_port))
					sock.setsockopt(socket.SOL_SOCKET, socket.SO_RCVTIMEO, struct.pack('2L', 3, 0))
					sock.send(xml)
					data = sock.recv(1024)
					m = p1.search(data)
					if not m:
						break
					last_res = int(m.group(1))
					print "last_res=%s" % last_res
					if last_res == check_last_res:
						break
					when = int(p2.search(data).group(1)) - 1
					print "when=%s" % when
					check_last_res = last_res
					f.write(data)
					try:
						while True:
							data = sock.recv(1024)
							f.write(data)
					except Exception, e:
						print str(e)
					sock.close()
		finally:
			f.close()

	def apiHeartBeat(self,video_id = None):
		'''
			来場者数・コメント数を取得
		'''

		if not video_id: video_id = self.video_id
		try:
			conn = httplib.HTTPConnection('watch.live.nicovideo.jp', 80)
			conn.request('GET', '/api/heartbeat?v=' + video_id, '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		return body

	def ichibaShowMain(self,video_id = None):
		'''
		'''

		if not video_id: video_id = self.video_id
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/ichiba/showMain?v=' + video_id + "&mode=get", '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		return body
	def getIchiba(self,video_id = None):
		if not video_id: video_id = self.video_id
		body = self.ichibaShowMain(video_id)
		p = re.compile('<img .* src="(.*?)" width="([0-9]+)" height="([0-9]+)" title="(.*?)"')
		resultList = []
		for m in p.finditer(body):
			result = {}
#			url = m.group(1)
#			width = m.group(2)
#			height = m.group(3)
#			title = m.group(4)
#			print "%s,%s,%s,%s" % (title,width,height,url)
			result['url'] =  m.group(1)
			result['width'] = m.group(2)
			result['height'] = m.group(3)
			result['title'] =  m.group(4)
			resultList.append(result)
			print result
		return resultList

	def apiGetPlayerStatus(self,video_id = None):
		if not video_id: video_id = self.video_id

		headers = self.headers.copy()
#		headers['Referer'] = 'http://live.nicovideo.jp/watch/' + video_id
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/watch/%s' % video_id, '', headers)
			rs = conn.getresponse()
#			body = rs.read()
#			print body
		finally:
			if conn: conn.close()
			if rs: rs.close()

#		headers['Accept'] = 'text/html, application/xhtml+xml, */*'
		try:
			conn = httplib.HTTPConnection('watch.live.nicovideo.jp', 80)
			conn.request('GET', '/api/getplayerstatus?v=%s' % video_id, '', headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn: conn.close()
			if rs: rs.close()
		return body

	def apiGetPlayerStatus_back(self,video_id = None):
		if not video_id: video_id = self.video_id

		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/watch/%s' % video_id, '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
			print body
		finally:
			if conn: conn.close()
			if rs: rs.close()

		try:
			conn = httplib.HTTPConnection('watch.live.nicovideo.jp', 80)
			conn.request('GET', '/api/getplayerstatus?v=%s' % video_id, '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn: conn.close()
			if rs: rs.close()
		return body
#test
#	def apiGetPlayerStatusow(self,video_id = None):
#		if not video_id: video_id = self.video_id
#
#		headers = self.headers.copy()
##		headers['Referer'] = 'http://live.nicovideo.jp/watch/' + video_id
#		try:
#			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
#			conn.request('GET', '/watch/%s' % video_id, '', headers)
#			rs = conn.getresponse()
#			body = rs.read()
#			print body
#		finally:
#			if conn: conn.close()
#			if rs: rs.close()
#
#		headers = self.headers.copy()
##		headers['Content-type'] = 'application/x-shockwave-flash'
##		headers['Referer'] = ' http://live.nicovideo.jp/nicoliveplayer.swf?140414180952/[[DYNAMIC]]/1'
##		headers['Content-Location'] = 'getplayerstatus.php'
##		headers['Vary'] = 'negotiate'
##		headers['TCN'] = 'choice'
##		headers['Content-Type'] = 'application/xml'
#		try:
#			conn = httplib.HTTPConnection('ow.live.nicovideo.jp', 80)
#			conn.request('GET', '/api/getplayerstatus?v=%s&lang=ja-jp&locale=GLOBAL&seat_locale=JP' % video_id, '', headers)
#			rs = conn.getresponse()
#			body = rs.read()
#
#			print rs.status
#			print body
#
#		finally:
#			if conn: conn.close()
#			if rs: rs.close()
#		return body
#
#	def setGetplayerstatusow(self,getplayerstatus=None, confirm_watch_my=False):
#		'''番組､ユーザー情報の取得'''
#		if getplayerstatus == None:
#			getplayerstatus = self.apiGetPlayerStatusow()
#
#		self.live_id = None
#		self.title = None
#		self.rtmp_url = None
#		self.rtmp_ticket = None
#		self.contents = []
#		self.quesheet = None
#		self.ms_addr = None
#		self.ms_port = None
#		self.ms_thread = None
#		self.tickets = []
#		self.is_premium = None
#		self.user_id = None
#		self.base_time = None
#		self.thread = None
#		self.is_premium = None
#
#		error_m = re.compile(r'><error><code>(.+)</code></error></getplayerstatus>').search(getplayerstatus)
#		if confirm_watch_my and error_m:
#			if error_m.group(1) == 'require_accept_print_timeshift_ticket':
#				print "require_accept_print_timeshift_ticket auto confirm_watch_my"
#				self.setWatchingReservation('confirm_watch_my',self.video_id)
#			getplayerstatus = self.apiGetPlayerStatus()
#
#		if error_m:
#			error = error_m.group(1)
#			return error
#		else:
#			id_m = re.compile(r'<id>(.*?)</id>').search(getplayerstatus)
#			if id_m:
#				self.live_id = id_m.group(1)
#
#			title_m = re.compile(r'<title>(.*?)</title>').search(getplayerstatus)
#			if title_m:
#				self.title = title_m.group(1)
#
#			rtmp_m = re.compile(r'<rtmp.*?>(<url>(.*?)</url>|(<url.*/>))<ticket>(.*?)</ticket>').search(getplayerstatus)
#			if rtmp_m:
#				self.rtmp_url = rtmp_m.group(2)
#				self.rtmp_ticket = rtmp_m.group(4)
#
#			contents_ptn = re.compile(r'(?s)<contents .*?>(.*?)</contents>')
#			for m in contents_ptn.finditer(getplayerstatus):
#				self.contents.append(m.group(1))
#
#			quesheet_m = re.compile(r'(?s)<quesheet>(.*?)</quesheet').search(getplayerstatus)
#			if quesheet_m:
#				self.quesheet = quesheet_m.group(1)
#
#			ms_m = re.compile(r'(?s)<ms.*?><addr>(.*?)</addr><port>(.*?)</port><thread>(.*?)</thread></ms>').search(getplayerstatus)
#			if ms_m:
#				self.ms_addr = ms_m.group(1)
#				self.ms_port = int(ms_m.group(2))
#				self.ms_thread = ms_m.group(3)
#
#			tickets_pat = re.compile(r'(?s)<stream name="(.*?)">(.*?)</stream>')
#			for m in tickets_pat.finditer(getplayerstatus):
#				tickets_stream = {}
#				tickets_stream["name"] = m.group(1)
#				tickets_stream["str"] = m.group(2)
#				self.tickets.append(tickets_stream)
#
#			default_m = re.compile(r'<is_premium>([0-9]+)</is_premium>.*<user_id>([0-9]+)</user_id>').search(getplayerstatus)
#			if default_m:
#				self.is_premium = default_m.group(1)
#				self.user_id = default_m.group(2)
#
#			base_time_m = re.compile(r'<base_time>(.*?)</base_time>').search(getplayerstatus)
#			if base_time_m:
#				self.base_time = base_time_m.group(1)
#
#			is_premium_m = re.compile(r'<is_premium>(.*?)</is_premium>').search(getplayerstatus)
#			if is_premium_m:
#				self.is_premium = is_premium_m.group(1)
#		return None

	def setGetplayerstatus(self,getplayerstatus=None, confirm_watch_my=False):
		'''番組､ユーザー情報の取得'''
		if getplayerstatus == None:
			getplayerstatus = self.apiGetPlayerStatus()

		self.live_id = None
		self.title = None
		self.rtmp_url = None
		self.rtmp_ticket = None
		self.contents = []
		self.quesheet = None
		self.ms_addr = None
		self.ms_port = None
		self.ms_thread = None
		self.tickets = []
		self.is_premium = None
		self.user_id = None
		self.base_time = None
		self.thread = None
		self.is_premium = None

		error_m = re.compile(r'><error><code>(.+)</code></error></getplayerstatus>').search(getplayerstatus)
		if confirm_watch_my and error_m:
			if error_m.group(1) == 'require_accept_print_timeshift_ticket':
				print "require_accept_print_timeshift_ticket auto confirm_watch_my"
				self.setWatchingReservation('confirm_watch_my',self.video_id)
			getplayerstatus = self.apiGetPlayerStatus()

		if error_m:
			error = error_m.group(1)
			return error
		else:
			id_m = re.compile(r'<id>(.*?)</id>').search(getplayerstatus)
			if id_m:
				self.live_id = id_m.group(1)

			title_m = re.compile(r'<title>(.*?)</title>').search(getplayerstatus)
			if title_m:
				self.title = title_m.group(1)

			rtmp_m = re.compile(r'<rtmp.*?>(<url>(.*?)</url>|(<url.*/>))<ticket>(.*?)</ticket>').search(getplayerstatus)
			if rtmp_m:
				self.rtmp_url = rtmp_m.group(2)
				self.rtmp_ticket = rtmp_m.group(4)

			contents_ptn = re.compile(r'(?s)<contents .*?>(.*?)</contents>')
			for m in contents_ptn.finditer(getplayerstatus):
				self.contents.append(m.group(1))

			quesheet_m = re.compile(r'(?s)<quesheet>(.*?)</quesheet').search(getplayerstatus)
			if quesheet_m:
				self.quesheet = quesheet_m.group(1)

			ms_m = re.compile(r'(?s)<ms.*?><addr>(.*?)</addr><port>(.*?)</port><thread>(.*?)</thread></ms>').search(getplayerstatus)
			if ms_m:
				self.ms_addr = ms_m.group(1)
				self.ms_port = int(ms_m.group(2))
				self.ms_thread = ms_m.group(3)

			tickets_pat = re.compile(r'(?s)<stream name="(.*?)">(.*?)</stream>')
			for m in tickets_pat.finditer(getplayerstatus):
				tickets_stream = {}
				tickets_stream["name"] = m.group(1)
				tickets_stream["str"] = m.group(2)
				self.tickets.append(tickets_stream)

			default_m = re.compile(r'<is_premium>([0-9]+)</is_premium>').search(getplayerstatus)
			if default_m:
				self.is_premium = default_m.group(1)

			base_time_m = re.compile(r'<base_time>(.*?)</base_time>').search(getplayerstatus)
			if base_time_m:
				self.base_time = base_time_m.group(1)

			start_time_m = re.compile(r'<start_time>(.*?)</start_time>').search(getplayerstatus)
			if start_time_m:
				self.start_time = start_time_m.group(1)
			end_time_m = re.compile(r'<end_time>(.*?)</end_time>').search(getplayerstatus)
			if end_time_m:
				self.end_time = end_time_m.group(1)
			user_id_m = re.compile(r'<user_id>(.*?)</user_id>').search(getplayerstatus)
			if user_id_m:
				self.user_id = user_id_m.group(1)


			is_premium_m = re.compile(r'<is_premium>(.*?)</is_premium>').search(getplayerstatus)
			if is_premium_m:
				self.is_premium = is_premium_m.group(1)
		return None

	def getLiveVideoUrl(self):
		liveid = None
		contents_str = ''
		contentsList = []
		if 0 < len(self.contents):
			s = urllib.unquote(self.contents[0])
			if s:
				contents_ptn = re.compile(r'(.*?):(.*?):((rtmp://.*?),(.*?))[,|<]')
				for m in contents_ptn.finditer(s+"<"):
					contentsList.append([m.group(1),m.group(2),m.group(3),m.group(4),m.group(5)])
					liveid = m.group(3)

				if len(contentsList) == 0:
					m = re.compile(r'((rtmp://.*),(.*))').search(s)
					if m:
						contents_str = m.group(1)
						liveid = m.group(3)
						contentsList.append([None,None,contents_str,m.group(2),m.group(3)])
					else:
						liveid = s

		que_rtmp = ''
		quesheet = ''
		if self.quesheet:
			quesheet_pat = re.compile('/publish lv.+? (.*?)</que>')

			for m in quesheet_pat.finditer(self.quesheet):
				que_rtmp = m.group(1)
				if que_rtmp[0:4] == 'rtmp':
					if re.compile('.f4v').search(que_rtmp):
						quesheet = re.sub(",/", "/mp4:", que_rtmp)
					else:
						quesheet = re.sub(",", "", que_rtmp)
				else:
					if re.compile('.f4v').search(que_rtmp) or re.compile('.mp4').search(que_rtmp):
						quesheet = self.rtmp_url + "/mp4:" + que_rtmp
					else:
						quesheet = self.rtmp_url + "/" + que_rtmp
				print "quesheet:%s" % quesheet

		ticket_url = None
		for contents in contentsList:
			for ticket in self.tickets:
				if contents[4] == ticket["name"]:
					ticket_url = contents[3] + "/" + contents[4] + "?" + ticket["str"]
					contents_str = contents[2]
					ticket_url
					ticket_url = ticket_url.replace('&amp;','&')
					break
			if contents[0] == None or contents[0] == "premium":
				break

		#RTMPDump
#		if quesheet:
#			rtmpdump = 'rtmpdump.exe '
#			rtmpdump+= '-o "%s.flv" ' % self.video_id
#			rtmpdump+= '-r "%s" ' % quesheet
#			rtmpdump+= '-C S:"%s"' % self.rtmp_ticket
#		elif ticket_url:
#			rtmpdump = 'rtmpdump.exe '
#			rtmpdump+= '-o "%s.flv" ' % self.video_id
#			rtmpdump+= '-vr "%s" ' % ticket_url
#			rtmpdump+= '-C S:%s' % self.rtmp_ticket

#		if que_rtmp:
#			rtmpdump = 'rtmpdump.exe '
#			rtmpdump+= '-vr %s ' % self.rtmp_url
#			rtmpdump+= '-C S:"%s ' % self.rtmp_ticket
#			rtmpdump+= '-N %s ' % que_rtmp
#			rtmpdump+= '-o %s.flv ' % self.video_id
		if que_rtmp:
			rtmpdump = 'rtmpdump.exe '
			rtmpdump+= '-r "%s" ' % self.rtmp_url
			rtmpdump+= '-C S:"%s" ' % self.rtmp_ticket
			rtmpdump+= '-y "mp4:%s" ' % que_rtmp
			rtmpdump+= '-o %s.flv ' % self.video_id
		elif ticket_url:
			rtmpdump = 'rtmpdump.exe '
			rtmpdump+= '-o "%s.flv" ' % self.video_id
			rtmpdump+= '-vr "%s" ' % ticket_url
			rtmpdump+= '-C S:%s' % self.rtmp_ticket
#		if que_rtmp:
#			rtmpdump = 'rtmpdump.exe '
#			rtmpdump+= '-vr %s ' % self.rtmp_url
#			rtmpdump+= '-C S:"%s ' % self.rtmp_ticket
#			rtmpdump+= '-N %s ' % que_rtmp
#			rtmpdump+= '-o %s.flv ' % self.video_id
#		elif ticket_url:
#			rtmpdump = 'rtmpdump.exe '
#			rtmpdump+= '-vr %s ' % ticket_url
#			rtmpdump+= '-C S:%s ' % self.rtmp_ticket
#			rtmpdump+= '-N %s ' % que_rtmp
#			rtmpdump+= '-o %s.flv ' % self.video_id
		else:
			if contents_str:
				rtmpdump = 'rtmpdump.exe '
				rtmpdump+= '-vr %s/%s ' % (self.rtmp_url,liveid)
				rtmpdump+= '-C S:%s ' % self.rtmp_ticket
				rtmpdump+= '-d %s ' % contents_str
				rtmpdump+= '-o %s.flv ' % self.video_id
			else:
				rtmpdump = 'rtmpdump.exe '

				rtmpdump+= '-vr %s/%s ' % (self.rtmp_url,liveid)
				rtmpdump+= '-C S:%s ' % self.rtmp_ticket
				rtmpdump+= '-o %s.flv ' % self.video_id
#		rtmpdump+= ' -p http://live.nicovideo.jp/watch/%s' % self.video_id
##		rtmpdump+= ' -p http://live.nicovideo.jp/watch/lv%s' % self.video_id
		print rtmpdump

		if quesheet:
			playurl = '%s ' % (que_rtmp)
#			playurl+= 'timeout=10000 '
#			playurl+= 'flashver="WIN 10,0,32,18" '
#			playurl+= 'swfUrl="http://live.nicovideo.jp/liveplayer.swf?20100531" '
#			playurl+= 'start=5000 '
			playurl+= 'conn=S:%s' % self.rtmp_ticket
		elif ticket_url:
			playurl = '%s ' % ticket_url
#			playurl+= 'timeout=10000 '
#			playurl+= 'flashver="WIN 10,0,32,18" '
#			playurl+= 'swfUrl="http://live.nicovideo.jp/liveplayer.swf?20100531" '
#			playurl+= 'start=5000 '
			playurl+= 'conn=S:%s ' % self.rtmp_ticket
			playurl+= 'live=true'
		else:
			if liveid == None or self.rtmp_url == None or self.rtmp_ticket == None:
				return None
			if contents_str:
				playurl = '%s/%s ' % (self.rtmp_url,liveid)
	#			playurl+= 'timeout=10000 '
	#			playurl+= 'flashver="WIN 10,0,32,18" '
#				playurl+= 'swfUrl="http://live.nicovideo.jp/liveplayer.swf?20100531" '
#				playurl+= 'start=5000 '
				playurl+= 'subscribe=%s ' % contents_str
				playurl+= 'conn=S:%s ' % self.rtmp_ticket
				playurl+= 'live=true'
			else:
				playurl = '%s/%s ' % (self.rtmp_url,liveid)
	#			playurl+= 'timeout=10000 '
	#			playurl+= 'flashver="WIN 10,0,32,18" '
#				playurl+= 'swfUrl="http://live.nicovideo.jp/liveplayer.swf?20100531" '
#				playurl+= 'start=5000 '
				playurl+= 'conn=S:%s ' % self.rtmp_ticket
				playurl+= 'live=true'
#		playurl+= ' -p http://live.nicovideo.jp/watch/lv%s' % self.video_id
		playurl+= ' -p http://live.nicovideo.jp/watch/%s' % self.video_id
		return playurl


#	def getMyCommunity(self):
#		''' 参加中のコミュニティの情報を取得します '''
#		page = 1
#		p = re.compile(r'レベル：.*?([0-9]+).*?メンバー.*?([0-9]+).*?投稿動画.*?([0-9]+).*?<p class="date">(.*?)<.*?href="/community/(co[0-9]+)".*?>(.*?)<')
#		result = []
#		while page < 10:
#			body =self.getHTML("http://www.nicovideo.jp/community?page=%s" % page)
##			print body
#			for m in p.finditer(body):
#				level = m.group(1)
#				member = m.group(2)
#				video = m.group(3)
#				update = m.group(4)
#				co_id = m.group(5)
#				title = m.group(6)
#				result.append([level,member,video,update,co_id,title])
#			if re.compile('<span class="in">([0-9]+)</span>\s*<span class="next">').search(body) == None:
#				break
#			page += 1
#
#		return result
#
#	def getMyCommunity(self):
#		''' 参加中のコミュニティの情報を取得します '''
#		p1 = re.compile(r'<a href="/my/community\?page=([0-9]*)">次へ</a>')
#		p2 = re.compile(r'<a href="/user/([0-9]*)">(.*)</a>.*<a href="http://live.nicovideo.jp/watch/(lv[0-9]*)">(.*)</a>.*<span class="time">(.*)</span>')
#		pageIndex = 1
#		result = []
#		while True:
#			body =self.getHTML("http://www.nicovideo.jp/my/community?page=%s" % pageIndex)
##			print body
#			for m in p2.finditer(body):
#				user_id = m.group(1)
#				user_name = m.group(2)
#				live_id = m.group(3)
#				title = m.group(4)
#				time = m.group(5)
#				result.append([user_id,user_name,live_id,title,time])
#			if p1.search(body):
#				pageIndex += 1
#			else:
#				break
#
#		return result


	def getMyCommunity(self):
		''' 参加中のコミュニティの情報を取得します '''
		p1 = re.compile(r'<a href="/my/community\?page=([0-9]*)">次へ</a>')
		p2 = re.compile(r'(?s)<a href="https://com.nicovideo.jp/community/(co.*?)"><img src="(.*?)" class="community" alt="(.*?)" /></a>.*?フォロワー数: ([0-9,]+)')
		pageIndex = 1
		result = []
		while True:
			body =self.getHTML("http://www.nicovideo.jp/my/community?page=%s" % pageIndex)
#			print body
			for m in p2.finditer(body):
				user_id = m.group(1)
				thumb = m.group(2)
				title = m.group(3)
				fnum = m.group(4)
				result.append([user_id,title,fnum,thumb])
			if p1.search(body):
				pageIndex += 1
			else:
				break

		return result

	def getLiveArchives(self, co_id, page = 1):
		'''コミュニティの放送履歴を返します'''
		try:
			conn = httplib.HTTPConnection('com.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('GET','/live_archives/%s?page=%s&bias=3' % (co_id,page),"",self.headers))
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		report_re = re.compile(r'(?s)<td class="date">(.*?)</td>.*?<td class="user">(.*?)</td>.*?<td class="title">.*?<a href="http://live.nicovideo.jp/watch/(lv[0-9]+)\?ref=community">(.*?)</a>.*?<td class="desc">(.*?)</td>')
		result = []
		p = re.compile(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>|\s|\r\n|\n\r|\n|\r')
		for m in report_re.finditer(body):
			date = p.sub('',m.group(1))
			user = p.sub('',m.group(2))
			live_id = m.group(3)
			title = m.group(4)
			desc = p.sub('',m.group(5))
			result.append([date,user,live_id,title,desc])
		return result;

	def getCommunityInfo(self, co_id):
		'''コミュニティの情報を返します'''
		try:
			conn = httplib.HTTPConnection('com.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('GET','/community/%s' % co_id,"",self.headers))
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()
		result = {}

		result['motion_form'] = re.compile(r'<a href="/motion/'+co_id+'"').search(body) != None
		result['leave_form'] = re.compile(r'<a href="/leave/'+co_id+'"').search(body) != None
		lv_id = None
		lv_title = None

		p = re.compile(r'(?s)<a class="now_live_inner".*?href="http://live.nicovideo.jp/watch/(lv[0-9]+).*?".*?>.*?<.*?class="now_live_title">(.*?)</').search(body)
		if p:
			lv_id = p.group(1)
			lv_title = p.group(2)

		result['lv_id'] = lv_id
		result['lv_title'] = lv_title
		return result

	def motionCommunity(self, co_id):
		"""
			コニュニティに参加します
		"""

		headers = self.headers.copy()
		headers['Content-type'] = 'application/x-www-form-urlencoded'
		headers['Referer'] = 'http://com.nicovideo.jp/motion/%s' % co_id
		try:
			conn = httplib.HTTPConnection('com.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('POST','/motion/%s' % co_id,"mode=commit&title=%E5%8F%82%E5%8A%A0%E7%94%B3%E8%AB%8B&comment=&notify=",headers))
#			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

	def leaveCommunity(self, co_id):
		"""
			コミュニティを退会します
		"""

		headers = self.headers.copy()
		try:
			conn = httplib.HTTPConnection('com.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('GET','/leave/%s' % co_id,"",headers))
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		m = re.compile(r'<input type="hidden" name="time" value="([0-9]*)">\s*<input type="hidden" name="commit_key" value="(.*)">').search(body)
		time = m.group(1)
		commit_key = m.group(2)

		headers['Content-type'] = 'application/x-www-form-urlencoded'
		headers['Referer'] = 'http://com.nicovideo.jp/leave/%s' % co_id
		try:
			conn = httplib.HTTPConnection('com.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('POST','/leave/%s' % co_id, "time=" + time + "&commit_key=" + commit_key + "&commit=%E3%81%AF%E3%81%84%E3%80%81%E9%80%80%E4%BC%9A%E3%81%97%E3%81%BE%E3%81%99", headers))
#			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

	def setWatchingReservation(self, mode, vid):
		"""
			生放送をタイムシフト予約します
			mode = 'watch_num','confirm_watch_my'
		"""
		num_m = re.compile("[a-z]*([0-9]*)").match(vid)
		if num_m == None:
			return
		num = num_m.group(1)

		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/api/watchingreservation?mode=%s&vid=%s&next_url=&analytic=' % (mode,num), '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

#		print body

		if mode == 'watch_num':
			if re.compile('既に予約済み').search(body):
				return -1

			token_m = re.compile('(ulck_[0-9]+)').search(body)
			if token_m == None:
				return -2
			token = token_m.group(1)
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('POST', '/api/watchingreservation?mode=regist&vid=%s&token=%s' % (num,token), '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()

		elif mode == 'confirm_watch_my':
			token_m = re.compile('(ulck_[0-9]+)').search(body)
			if token_m == None:
				return -2
			token = token_m.group(1)
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('POST', '/api/watchingreservation?accept=true&mode=use&vid=%s&token=%s' % (num,token), '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
				print rs.status
				print body
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()

		return 1

	def setWatchingReservation_old(self, mode, vid):
		"""
			生放送をタイムシフト予約します
			mode = 'watch_num','confirm_watch_my'
		"""
		num_m = re.compile("[a-z]*([0-9]*)").match(vid)
		if num_m == None:
			return
		num = num_m.group(1)

		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			conn.request('GET', '/api/watchingreservation?mode=watch_num&vid=%s&next_url=&analytic=' % (num), '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		print body

		if mode == 'watch_num':
			if re.compile('既に予約済み').search(body):
				return -1

			token_m = re.compile('(ulck_[0-9]+)').search(body)
			if token_m == None:
				return -2
			token = token_m.group(1)
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('POST', '/api/watchingreservation?mode=regist&vid=%s&token=%s' % (num,token), '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()

		elif mode == 'confirm_watch_my':
			token_m = re.compile('(ulck_[0-9]+)').search(body)
			if token_m == None:
				return -2
			token = token_m.group(1)
			try:
				conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
				conn.request('POST', '/api/watchingreservation?accept=true&mode=use&vid=%s&token=%s' % (num,token), '', self.headers)
				rs = conn.getresponse()
				body = rs.read()
			finally:
				if conn:
					conn.close()
				if rs:
					rs.close()

		return 1

	def setWatchingReservationOfficial(self, mode, vid):

		num_m = re.compile("[a-z]*([0-9]*)").match(vid)
		if num_m == None:
			return
		num = num_m.group(1)

		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			url = r'/api/watchingreservation?mode=watch_num&vid=%s&next_url=watch%%2F%s&analytic=watch_modal_0_official_%s_closed' % (num,vid,vid)
			conn.request('GET', url, '', self.headers)
			rs = conn.getresponse()
			body = rs.read()
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		print body

		token_m = re.compile('(ulck_[0-9]+)').search(body)
		if token_m == None:
			return -2
		token = token_m.group(1)

		print token


	def apiGetStreaminfo(self,live_id):
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('GET', '/api/getstreaminfo/%s' % live_id, '', self.headers))
			body = rs.read()
#			print body
			return body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

	def loginNicoliveAntenna(self):
		"""
			ニコ生アンテナにログインし、チケットを取得します
		"""
		self.establishSecureConnection()
		post_dict = {'next_url': '',
			'submit': '',
			'mail': self.mailAddress,
			'password': self.passWord,
#			'submit.x': '65',
#			'submit.y': '7'
			}
		headers = self.headers.copy()
		headers['Content-type'] = 'application/x-www-form-urlencoded';
		rs = self.retryingAccess(self.nico_secure_conn, ('POST', '/secure/login?site=nicolive_antenna', urllib.urlencode(post_dict), headers))
		body = rs.read()
#		print body
		rs.close()
		m = re.compile('<ticket>(.*)</ticket>').search(body)
		self.nicolive_antenna_ticket = m.group(1)

	def apiGetAlertStatus(self):
		"""
			ニコ生アラートの接続情報とコミュニティIDを取得します

			アラートを取得するために必要なアドレス、ポート、スレッドと、参加しているコミュニティの一覧を設定します
		"""
		post_dict = {'ticket': self.nicolive_antenna_ticket}
		headers = self.headers.copy()
		headers['Content-type'] = 'application/x-www-form-urlencoded';
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('POST', '/api/getalertstatus', urllib.urlencode(post_dict), headers))
			body = rs.read()
#			print body
			m = re.compile('<ms><addr>(.*)</addr><port>(.*)</port><thread>(.*)</thread></ms>').search(body)
			self.alert_ms_addr = m.group(1)
			self.alert_ms_port = int(m.group(2))
			self.alert_ms_thread = m.group(3)

			p = re.compile(r'<community_id>(.*?)</community_id>')
			community_id_list = []
			for m in p.finditer(body):
				community_id_list.append(m.group(1))
			self.community_id_list = community_id_list
		finally:
			if conn: conn.close()
			if rs: rs.close()


	def getWatchPlayer(self,live_id):
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('GET', '/watch/%s' % live_id, '', self.headers))
			body = rs.read()
#			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		title = None
		description = None
		thumbnail = None
		postedAt = None

		title_ptn = re.compile("title:\s*'(.*)',").search(body)
		if title_ptn: title = title_ptn.group(1)

		description_ptn = re.compile("description:\s*'(.*)',").search(body)
		if description_ptn:
			description = description_ptn.group(1)
			description = re.sub(r'\\r\\n','\r\n',description)
			description = re.sub(r'<("[^"]*"|\'[^\']*\'|[^\'">])*>','',description)

		thumbnail_ptn = re.compile("thumbnail:\s*'(.*)',").search(body)
		if thumbnail_ptn: thumbnail = thumbnail_ptn.group(1)

		postedAt_ptn = re.compile("postedAt:\s*'(.*)'").search(body)
		if postedAt_ptn:
			postedAt = postedAt_ptn.group(1)

		if title == None and description == None and thumbnail and postedAt == None:
			return None

		result = {}
		result['title'] = title
		result['description'] = description
		result['thumbnail'] = thumbnail
		result['postedAt'] = postedAt
		return result

	def sendComment(self,comment,mail = "184"):

		vpos = (math.floor(time.time()) - self.base_time) * 100

		block_no = 0
		try:
			conn = httplib.HTTPConnection('live.nicovideo.jp', 80)
			rs = self.retryingAccess(conn, ('GET', '/api/getpostkey?thread=%s&block_no=%s' % (self.ms_thread, block_no), '', self.headers))
			body = rs.read()
			print body
		finally:
			if conn:
				conn.close()
			if rs:
				rs.close()

		postkey = body[body.index("=")+1:-1]

		comment = '<chat thread="%s" ticket="%s" vpos="%s" postkey="%s" mail="%s" user_id="%s" premium="%s">%s</chat>\0' % (self.ms_thread,self.rtmp_ticket,vpos,postkey,mail,self.user_id,self.is_premium,comment)

		sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		sock.connect((self.ms_addr, self.ms_port))
		sock.sendall(comment)

		sock.close()


	def getChannelRanking(self):
		''' チャンネルのランキングを取得します '''
		body =self.getChannelHTML("/ranking")
#		print body

		restr = u'(?s)<a href="/(ch[0-9]*)".*?title="(.*?)".*?<img data-original="(.*?)".*?<div class="rank (.*?)">.*?<img data-original="(.*?)".*?<span class="badge br length" title="(.*?)">.*?class="title"><a href="http://www.nicovideo.jp/watch/(.*?)\?ch_ranking">(.*?)</a>.*?<ul class="counts">.*?<var>([0-9,-]*)</var>.*?<var>([0-9,-]*)</var>.*?<var>([0-9,-]*)</var>'
		p = re.compile(restr)
		chArray = []
		resultArray = []
		for m in p.finditer(body):
			ch_id = m.group(1)
			ch_title = m.group(2)
			ch_thumb = m.group(3)
			chArray.append([ch_id, ch_title, ''])

			rank = m.group(4)
			thumb = m.group(5)
			length = m.group(6)
			video_id = m.group(7)
			title = m.group(8)
			view_count = m.group(9)
			comment_count = m.group(10)
			mylist_count = m.group(11)
			resultArray.append([video_id, title, view_count, comment_count, mylist_count,length, rank, thumb])

		return chArray,resultArray

#Raspberry Pi
#class HTTPSConnection(HTTPConnection):
#	"This class allows communication via SSL."
#	default_port = HTTPS_PORT
#
#	def __init__(self, host, port=None, key_file=None, cert_file=None,
#				strict=None, timeout=socket._GLOBAL_DEFAULT_TIMEOUT,
#				source_address=None):
#		HTTPConnection.__init__(self, host, port, strict, timeout,source_address)
#		self.key_file = key_file
#		self.cert_file = cert_file
#
#	def connect(self):
#		"Connect to a host on a given (SSL) port."
#		sock = socket.create_connection((self.host, self.port),self.timeout, self.source_address)
#		if self._tunnel_host:
#			self.sock = sock
#			self._tunnel()
#		# this is the only line we modified from the httplib.py file
#		# we added the ssl_version variable
#		self.sock = ssl.wrap_socket(sock, self.key_file, self.cert_file, ssl_version=ssl.PROTOCOL_TLSv1)

