#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
import time
import httplib

DEF_headers = {'User-Agent':'Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2',
	'Accept': '*/*',
	'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
	'Accept-Charset': 'UTF-8,*',
	'Connection': 'keep-alive',
	'Keep-Alive': '300'}

# にこ★さうんど＃(http://nicosound.anyap.info)の情報を扱うためのクラス
class NicoSound:

	def __init__(self):
		pass

	def getHTML(self, url):
		try:
			url = re.compile('^http://nicosound.anyap.info(.+)$').match(url).group(1)
		except:
			print u'NicoSoundのURLではありません'
			return None
		conn=httplib.HTTPConnection('nicosound.anyap.info', 80)
		rs = self.retryingAccess(conn, ('GET', url, '', DEF_headers))
		body = rs.read()
		rs.close()
		conn.close()
		return body

	def getNicoSound(self, url_cate, page=None):
		'''ランキングを取得します'''
		if page:
			url = "http://nicosound.anyap.info/"+url_cate+"?p="+str(page)
		else:
			url = "http://nicosound.anyap.info/"+url_cate
		body = self.getHTML(url)
#		print body
		return self.parceNicoSoundHTML(body)

	def getNicoSoundRelatedVideo(self, videoid):
		'''関連さうんどを取得します'''
		url = "http://nicosound.anyap.info/sound/"+videoid
		body = self.getHTML(url);
#		print body
		return self.parceRelatedVideoNicoSoundHTML(body)

	def parceNicoSoundHTML(self, body):
		sm_re= re.compile(r'(?s)class="content">.*?href="/sound/(.*?)".*?class="title">\s*(.*?)\s*</.*?class="playtime">\s*(.*?)\s*</.*?class="plays"><b>\s*(.*?)\s*</.*?class="bitrate"><b>(.*?)</')
		video_list = []
		title_list = []
		stb_value_list = []
		for m in sm_re.finditer(body):
			video_list.append(m.group(1))
			title_list.append(m.group(2))
			stb_value_list.append([m.group(3),m.group(4),m.group(5)])

		return stb_value_list,video_list,title_list

	def parceRelatedVideoNicoSoundHTML(self, body):
		video_re_str = r'(?s)<div class="sound-item item0 ">.*?<a href="/sound/(.*?)" class="title-layout">\s*<span class="title">\s*(.*?)\s*</span>.*?<span class="playtime">\s*(.*?)\s*</span>.*?<span class="plays"><b>(.*?)</b></span>.*?<span class="bitrate"><b>(.*?)</b>'
		video_list = []
		title_list = []
		videoInfo_list = []
		video_re = re.compile(video_re_str)
		for m in video_re.finditer(body):
			video_list.append(m.group(1))
			title_list.append(m.group(2))
			videoInfo_list.append([m.group(3),m.group(4),m.group(5)])

		return video_list,title_list,videoInfo_list

	def retryingAccess(self, conn, request_args, retry=2, wait=5):
		rs = None
		while 0<retry:
			try:
				method, path, body, headers = request_args
				conn.request(method, path, body, headers)
				rs = conn.getresponse()
				break
			except Exception, e:
				print e
				print 'getresponse failed. waiting for %d seconds..' % wait
				time.sleep(wait)
				conn.close()
				retry -= 1

		return rs