#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
import time
import httplib
import urllib

DEF_headers = {'User-Agent':'Mozilla/5.0 (Windows; U; Windows NT 5.1; ja; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2',
	'Accept': '*/*',
	'Accept-Language': 'ja,en-us;q=0.7,en;q=0.3',
	'Accept-Charset': 'UTF-8,*',
	'Connection': 'keep-alive',
	'Keep-Alive': '300'}

CHIKURAN_SORT_ARRAY = ['active','act184','actper','per184','per186']
CHIKURAN_SORT_NAME_ARRAY = ['アクティブ人数順','184人数順','アクティブ率順','184率順','184外し率順']

VALUE1_TYPE_NAME_ARRAY = ['アク','アク','アク','アク','アク']
VALUE2_TYPE_NAME_ARRAY = ['公順位','公順位','Act率','来場者数','来場者数']
VALUE3_TYPE_NAME_ARRAY = ['公ﾃｨﾌﾞ','公ﾃｨﾌﾞ','公ﾃｨﾌﾞ','公ﾃｨﾌﾞ','公ﾃｨﾌﾞ']

# ちくわちゃんランキングを扱うためのクラス
class ChikuwachanRanking:

	def __init__(self):
		pass

	def getHTML(self, url):
		conn=httplib.HTTPConnection('dm.chikuwachan.com', 80)
		rs = self.retryingAccess(conn, ('GET', url, '', DEF_headers))
		body = rs.read()
		rs.close()
		conn.close()
		return body

	def getLiveRanking(self, live_id):
		url = "/live/index.cgi?jsmode=1&sort=&tag=&mark=&category=&search=%s&page=1&type=&callback=&date=" % (live_id)
		#print "http://dm.chikuwachan.com" + url
		body = self.getHTML(url)
		body = re.sub(r'\\r\\n|\r|\n','',body)
		#print body
		if body == "" or re.compile('<title>\[ちくわちゃん\] 500 Internal Server Error</title>').search(body):
			return None
		else:
			return self.parceHtml(body,live_id)

	def getAllRanking(self, page=1, tag='', category='', search='',sort=''):
		return self.getChikuwachanRanking(page,tag,category,search,'',sort)


	def getRookieRanking(self, page=1, tag='', category='', search='', sort=''):
		return self.getChikuwachanRanking(page,tag,category,search,'rookie',sort)

	def getChikuwachanRanking(self, page=1, tag='', category='', search='', type='', sort='active'):
		'''アクティブ人数ランキングを取得します'''

		url = "/live/index.cgi?jsmode=1&sort=%s&tag=%s&mark=&category=%s&search=%s&page=%s&type=%s&callback=&date=" % (sort, urllib.quote_plus(tag), urllib.quote_plus(category), urllib.quote_plus(search), page, type)
		print "http://dm.chikuwachan.com" + url
		retry = 1
		while 0 < retry:
			body = self.getHTML(url)
			body = re.sub(r'\\r\\n|\r|\n','',body)
#			print body
			if body == "" or re.compile('<title>\[ちくわちゃん\] 500 Internal Server Error</title>').search(body):
				retry -= 1
				if 0 < retry:
					return None
				print "retry..."
				time.sleep(5.0)
			else:
				return self.parceHtml(body)

	def parceHtml(self, body, search_live_id = None):
		if search_live_id == None:
			search_live_id = 'lv[0-9]+'
		p = re.compile(r'(?s)<td .*?class=\\"rate\\">([0-9]+).*?<img src=\\"(.*?)\\".*?<a .*?href=\\"http://live.nicovideo.jp/watch/(%s)\\">(.+?)</a>.*?<span .*?class=\\"date.*?\\">(.*?)</span>.*?<a .*?href=\\"http://com.nicovideo.jp/.*?/(.*?)\\">(.*?)</a>.*?<span class=\\"community2\\".*?>([0-9]+?)</span>.*?<td .*?class=\\".*?\\">(.*?)</td>.*?<tr class=\\"main_tr comm_.*?>(.*?)</tr>' % (search_live_id))
		resultArray = []

		p2 = re.compile(r'(?s)<td .*?class=\\".*?\\">(.*?)</td>.*?<td .*?class=\\".*?\\">(.*?)</td>')
		for m in p.finditer(body):
			result = {}
			result['rate'] = m.group(1)
			result['thumbnail'] = m.group(2)
			result['live_id'] = m.group(3)
			result['title'] = m.group(4)

			date = re.sub(r'\\r|\\n|<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',m.group(5))
			result['date'] = date

			result['community'] = m.group(6)
			result['community_name'] = m.group(7)
			result['community2'] = m.group(8)

			active = re.sub(r'\\r|\\n|<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',m.group(9))
			result['value1'] = active

			value = m.group(10)
			if re.search("公式ランク外", value) != None :
				result['value2'] = "公式ランク外"
				result['value3'] = "-"
			else:
				m2 = p2.search(value)
				if m2 == None:
					result['value2'] = "不明"
					result['value3'] = "-"
				else:
					attend = re.sub(r'\\r|\\n|<!--.*-->|<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',m2.group(1))
					result['value2'] = attend
					comment = re.sub(r'\\r|\\n|<("[^"]*"|\'[^\']*\'|[^\'">])*>|\t|\s','',m2.group(2))
					result['value3'] = comment

			resultArray.append(result)
		return resultArray

	def retryingAccess(self, conn, request_args, retry=2, wait=5):
		rs = None
		while 0<retry:
			try:
				method, path, body, headers = request_args
				conn.request(method, path, body, headers)
				rs = conn.getresponse()
				break
			except Exception, e:
				print e
				print 'getresponse failed. waiting for %d seconds..' % wait
				time.sleep(wait)
				conn.close()
				retry -= 1
		return rs