// ============================================================================
//
// Copyright (c) 2006-2015, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.hostconfigcheck_4_4;

import routines.Numeric;
import routines.DataOperation;
import routines.TalendDataGenerator;
import routines.TalendString;
import routines.RoutineHistoryETL;
import routines.StringHandling;
import routines.Relational;
import routines.TalendDate;
import routines.Mathematical;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: HostConfigCheck Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 6.1.1.20151214_1327
 * @status 
 */
public class HostConfigCheck implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

			if (lastFullHostCheck != null) {

				String pattern_lastFullHostCheck = "yyyy-MM-dd HH:mm:ss";
				String value_lastFullHostCheck = "";
				String[] parts_lastFullHostCheck = value_lastFullHostCheck
						.split(";");
				if (parts_lastFullHostCheck.length > 1) {
					pattern_lastFullHostCheck = parts_lastFullHostCheck[0];
					this.setProperty(
							"lastFullHostCheck",
							pattern_lastFullHostCheck
									+ ";"
									+ FormatterUtils.format_Date(
											lastFullHostCheck,
											pattern_lastFullHostCheck));
				} else {
					this.setProperty("lastFullHostCheck", FormatterUtils
							.format_Date(lastFullHostCheck,
									pattern_lastFullHostCheck));
				}

			}

		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}

		public java.util.Date lastFullHostCheck;

		public java.util.Date getLastFullHostCheck() {
			return this.lastFullHostCheck;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "4.4";
	private final String jobName = "HostConfigCheck";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = new java.util.HashMap<String, Object>();
	private final static java.util.Map<String, Object> junitGlobalMap = new java.util.HashMap<String, Object>();

	private final java.util.Map<String, Long> start_Hash = new java.util.HashMap<String, Long>();
	private final java.util.Map<String, Long> end_Hash = new java.util.HashMap<String, Long>();
	private final java.util.Map<String, Boolean> ok_Hash = new java.util.HashMap<String, Boolean>();
	public final java.util.List<String[]> globalBuffer = new java.util.ArrayList<String[]>();

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private Exception exception;

	public Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					HostConfigCheck.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(HostConfigCheck.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (TalendException e) {
					// do nothing

				} catch (Exception e) {
					this.e.printStackTrace();
				}
			}
		}
	}

	public void tJDBCConnection_2_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row21_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tAdvancedHash_row1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_2 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_2 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_2 = decryptedPassword_tJDBCConnection_2;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "engine";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_2, dbUser_tJDBCConnection_2,
						dbPwd_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// dbUser_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// dbPwd_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */

				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */

				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "sample_ovirt_engine_history";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tJDBCConnection_1:OnSubjobOk",
						"", Thread.currentThread().getId() + "", "", "", "",
						"", "");
			}

			tJDBCInput_4Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public java.util.Date value;

		public java.util.Date getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// java.util.Date

				writeDate(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + String.valueOf(value));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT var_name, var_datetime\nFROM  dwh_history_timekeeping\nwhere var_name = 'lastFullHostCheck'";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);

				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						if (colQtyInRs_tJDBCInput_4 < 1) {
							row3.key = null;
						} else {

							row3.key = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_4, 1, false);
						}
						if (colQtyInRs_tJDBCInput_4 < 2) {
							row3.value = null;
						} else {

							java.util.Date date_tJDBCInput_4 = null;
							try {
								date_tJDBCInput_4 = rs_tJDBCInput_4
										.getTimestamp(2);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_4 = rs_tJDBCInput_4.getDate(2);
							}
							row3.value = date_tJDBCInput_4;
						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */

						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tContextLoad_1 main ] start
						 */

						currentComponent = "tContextLoad_1";

						// ////////////////////////
						String tmp_key_tContextLoad_1 = null;
						String key_tContextLoad_1 = null;
						if (row3.key != null) {
							tmp_key_tContextLoad_1 = row3.key.trim();
							if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
									.startsWith("!"))) {
								tmp_key_tContextLoad_1 = null;
							} else {
								row3.key = tmp_key_tContextLoad_1;
							}
						}
						if (row3.key != null) {
							key_tContextLoad_1 = row3.key;
						}
						String value_tContextLoad_1 = null;
						if (row3.value != null) {
							value_tContextLoad_1 = FormatterUtils.format_Date(
									row3.value, "yyyy-MM-dd HH:mm:ss.SSSSSS");
						}

						if (tmp_key_tContextLoad_1 != null) {
							try {
								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "runTime".equals(key_tContextLoad_1)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_1));

								}

								if (key_tContextLoad_1 != null
										&& "lastFullHostCheck"
												.equals(key_tContextLoad_1)) {
									String context_lastFullHostCheck_value = context
											.getProperty("lastFullHostCheck");
									if (context_lastFullHostCheck_value == null)
										context_lastFullHostCheck_value = "";
									int context_lastFullHostCheck_pos = context_lastFullHostCheck_value
											.indexOf(";");
									String context_lastFullHostCheck_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_lastFullHostCheck_pos > -1) {
										context_lastFullHostCheck_pattern = context_lastFullHostCheck_value
												.substring(0,
														context_lastFullHostCheck_pos);
									}
									context.lastFullHostCheck = (java.util.Date) (new java.text.SimpleDateFormat(
											context_lastFullHostCheck_pattern)
											.parse(value_tContextLoad_1));

								}

								if (context.getProperty(key_tContextLoad_1) != null) {
									assignList_tContextLoad_1
											.add(key_tContextLoad_1);
								} else {
									newPropertyList_tContextLoad_1
											.add(key_tContextLoad_1);
								}
								if (value_tContextLoad_1 == null) {
									context.setProperty(key_tContextLoad_1, "");
								} else {
									context.setProperty(key_tContextLoad_1,
											value_tContextLoad_1);
								}
							} catch (java.lang.Exception e) {
								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_1
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_1++;
						}
						// ////////////////////////

						tos_count_tContextLoad_1++;

						/**
						 * [tContextLoad_1 main ] stop
						 */

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					if (rs_tJDBCInput_4 != null) {
						rs_tJDBCInput_4.close();
					}
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				if (TalendDate.diffDate(context.runTime,
						context.lastFullHostCheck, "HH") >= 1L) {

					tJDBCInput_2Process(globalMap);
				}

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				List<String> parametersToEncrypt_tContextLoad_1 = new java.util.ArrayList<String>();

				parametersToEncrypt_tContextLoad_1.add("ovirtEngineDbPassword");

				parametersToEncrypt_tContextLoad_1
						.add("ovirtEngineHistoryDbPassword");

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context,
								parametersToEncrypt_tContextLoad_1));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class host_changesStruct implements
			routines.system.IPersistableRow<host_changesStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public short host_type;

		public short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public int vdsm_port;

		public int getVdsm_port() {
			return this.vdsm_port;
		}

		public Integer cluster_configuration_version;

		public Integer getCluster_configuration_version() {
			return this.cluster_configuration_version;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		public java.util.Date delete_date;

		public java.util.Date getDelete_date() {
			return this.delete_date;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.host_type = dis.readShort();

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = dis.readInt();

					this.cluster_configuration_version = readInteger(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

					this.delete_date = readDate(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// short

				dos.writeShort(this.host_type);

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// int

				dos.writeInt(this.vdsm_port);

				// Integer

				writeInteger(this.cluster_configuration_version, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

				// java.util.Date

				writeDate(this.delete_date, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",cluster_configuration_version="
					+ String.valueOf(cluster_configuration_version));
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append(",delete_date=" + String.valueOf(delete_date));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(host_changesStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class after_tJDBCInput_2Struct implements
			routines.system.IPersistableRow<after_tJDBCInput_2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];

		public Object host_id;

		public Object getHost_id() {
			return this.host_id;
		}

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public String host_unique_id;

		public String getHost_unique_id() {
			return this.host_unique_id;
		}

		public String host_name;

		public String getHost_name() {
			return this.host_name;
		}

		public Object cluster_id;

		public Object getCluster_id() {
			return this.cluster_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		public Short host_type;

		public Short getHost_type() {
			return this.host_type;
		}

		public String fqdn_or_ip;

		public String getFqdn_or_ip() {
			return this.fqdn_or_ip;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		public Integer vdsm_port;

		public Integer getVdsm_port() {
			return this.vdsm_port;
		}

		public Short threads_per_core;

		public Short getThreads_per_core() {
			return this.threads_per_core;
		}

		public String hardware_manufacturer;

		public String getHardware_manufacturer() {
			return this.hardware_manufacturer;
		}

		public String hardware_product_name;

		public String getHardware_product_name() {
			return this.hardware_product_name;
		}

		public String hardware_version;

		public String getHardware_version() {
			return this.hardware_version;
		}

		public String hardware_serial_number;

		public String getHardware_serial_number() {
			return this.hardware_serial_number;
		}

		public java.util.Date create_date;

		public java.util.Date getCreate_date() {
			return this.create_date;
		}

		public java.util.Date update_date;

		public java.util.Date getUpdate_date() {
			return this.update_date;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.host_id = (Object) dis.readObject();

					this.host_join_id = readString(dis);

					this.host_unique_id = readString(dis);

					this.host_name = readString(dis);

					this.cluster_id = (Object) dis.readObject();

					this.cluster_join_id = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.host_type = null;
					} else {
						this.host_type = dis.readShort();
					}

					this.fqdn_or_ip = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

					this.vdsm_port = readInteger(dis);

					length = dis.readByte();
					if (length == -1) {
						this.threads_per_core = null;
					} else {
						this.threads_per_core = dis.readShort();
					}

					this.hardware_manufacturer = readString(dis);

					this.hardware_product_name = readString(dis);

					this.hardware_version = readString(dis);

					this.hardware_serial_number = readString(dis);

					this.create_date = readDate(dis);

					this.update_date = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				} catch (ClassNotFoundException eCNFE) {
					throw new RuntimeException(eCNFE);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// Object

				dos.writeObject(this.host_id);

				// String

				writeString(this.host_join_id, dos);

				// String

				writeString(this.host_unique_id, dos);

				// String

				writeString(this.host_name, dos);

				// Object

				dos.writeObject(this.cluster_id);

				// String

				writeString(this.cluster_join_id, dos);

				// Short

				if (this.host_type == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.host_type);
				}

				// String

				writeString(this.fqdn_or_ip, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

				// Integer

				writeInteger(this.vdsm_port, dos);

				// Short

				if (this.threads_per_core == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.threads_per_core);
				}

				// String

				writeString(this.hardware_manufacturer, dos);

				// String

				writeString(this.hardware_product_name, dos);

				// String

				writeString(this.hardware_version, dos);

				// String

				writeString(this.hardware_serial_number, dos);

				// java.util.Date

				writeDate(this.create_date, dos);

				// java.util.Date

				writeDate(this.update_date, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_id=" + String.valueOf(host_id));
			sb.append(",host_join_id=" + host_join_id);
			sb.append(",host_unique_id=" + host_unique_id);
			sb.append(",host_name=" + host_name);
			sb.append(",cluster_id=" + String.valueOf(cluster_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append(",host_type=" + String.valueOf(host_type));
			sb.append(",fqdn_or_ip=" + fqdn_or_ip);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append(",vdsm_port=" + String.valueOf(vdsm_port));
			sb.append(",threads_per_core=" + String.valueOf(threads_per_core));
			sb.append(",hardware_manufacturer=" + hardware_manufacturer);
			sb.append(",hardware_product_name=" + hardware_product_name);
			sb.append(",hardware_version=" + hardware_version);
			sb.append(",hardware_serial_number=" + hardware_serial_number);
			sb.append(",create_date=" + String.valueOf(create_date));
			sb.append(",update_date=" + String.valueOf(update_date));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(after_tJDBCInput_2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				tJDBCInput_1Process(globalMap);
				tJDBCInput_3Process(globalMap);

				row2Struct row2 = new row2Struct();
				host_changesStruct host_changes = new host_changesStruct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				String insert_tJDBCOutput_1 = "INSERT INTO "
						+ "host_configuration"
						+ " (host_id,host_unique_id,host_name,cluster_id,host_type,fqdn_or_ip,memory_size_mb,swap_size_mb,cpu_model,number_of_cores,number_of_sockets,cpu_speed_mh,host_os,kernel_version,kvm_version,vdsm_version,vdsm_port,cluster_configuration_version,create_date,update_date,delete_date,threads_per_core,hardware_manufacturer,hardware_product_name,hardware_version,hardware_serial_number) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(insert_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tMap_1 begin ] start
				 */

				ok_Hash.put("tMap_1", false);
				start_Hash.put("tMap_1", System.currentTimeMillis());

				currentComponent = "tMap_1";

				int tos_count_tMap_1 = 0;

				// ###############################
				// # Lookup's keys initialization

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row1Struct> tHash_Lookup_row1 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row1Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row1Struct>) globalMap
						.get("tHash_Lookup_row1"));

				row1Struct row1HashKey = new row1Struct();
				row1Struct row1Default = new row1Struct();

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row21Struct> tHash_Lookup_row21 = (org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row21Struct>) ((org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row21Struct>) globalMap
						.get("tHash_Lookup_row21"));

				row21Struct row21HashKey = new row21Struct();
				row21Struct row21Default = new row21Struct();
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_1__Struct {
				}
				Var__tMap_1__Struct Var__tMap_1 = new Var__tMap_1__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				host_changesStruct host_changes_tmp = new host_changesStruct();
				// ###############################

				/**
				 * [tMap_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT \n  host_id, \n  upper(cast(host_id as char(36))) as host_join_id,\n  host_unique_id, \n  host_name, \n  cluster_id,\n  upper(cast(cluster_id as char(36))) as cluster_join_id,  \n  host_type, \n  fqdn_or_ip, \n  memory_size_mb, \n  swap_size_mb, \n  cpu_model, \n  number_of_cores,\n  number_of_sockets,\n  cpu_speed_mh,\n  host_os, \n  kernel_version, \n  kvm_version, \n  vdsm_version, \n  vdsm_port, \n  threads_per_core,\n  hardware_manufacturer,\n  hardware_product_name,\n  hardware_version,\n  hardware_serial_number,\n  create_date, \n  update_date\nFROM dwh_host_configuration_full_check_view";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);

				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						if (colQtyInRs_tJDBCInput_2 < 1) {
							row2.host_id = null;
						} else {

							if (rs_tJDBCInput_2.getObject(1) != null) {
								row2.host_id = rs_tJDBCInput_2.getObject(1);
							} else {
								row2.host_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 2) {
							row2.host_join_id = null;
						} else {

							row2.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 2, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 3) {
							row2.host_unique_id = null;
						} else {

							row2.host_unique_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 3, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 4) {
							row2.host_name = null;
						} else {

							row2.host_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 4, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 5) {
							row2.cluster_id = null;
						} else {

							if (rs_tJDBCInput_2.getObject(5) != null) {
								row2.cluster_id = rs_tJDBCInput_2.getObject(5);
							} else {
								row2.cluster_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 6) {
							row2.cluster_join_id = null;
						} else {

							row2.cluster_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 6, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 7) {
							row2.host_type = null;
						} else {

							if (rs_tJDBCInput_2.getObject(7) != null) {
								row2.host_type = rs_tJDBCInput_2.getShort(7);
							} else {
								row2.host_type = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 8) {
							row2.fqdn_or_ip = null;
						} else {

							row2.fqdn_or_ip = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 8, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 9) {
							row2.memory_size_mb = null;
						} else {

							if (rs_tJDBCInput_2.getObject(9) != null) {
								row2.memory_size_mb = rs_tJDBCInput_2.getInt(9);
							} else {
								row2.memory_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 10) {
							row2.swap_size_mb = null;
						} else {

							if (rs_tJDBCInput_2.getObject(10) != null) {
								row2.swap_size_mb = rs_tJDBCInput_2.getInt(10);
							} else {
								row2.swap_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 11) {
							row2.cpu_model = null;
						} else {

							row2.cpu_model = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 11, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 12) {
							row2.number_of_cores = null;
						} else {

							if (rs_tJDBCInput_2.getObject(12) != null) {
								row2.number_of_cores = rs_tJDBCInput_2
										.getShort(12);
							} else {
								row2.number_of_cores = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 13) {
							row2.number_of_sockets = null;
						} else {

							if (rs_tJDBCInput_2.getObject(13) != null) {
								row2.number_of_sockets = rs_tJDBCInput_2
										.getShort(13);
							} else {
								row2.number_of_sockets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 14) {
							row2.cpu_speed_mh = null;
						} else {

							if (rs_tJDBCInput_2.getObject(14) != null) {
								row2.cpu_speed_mh = rs_tJDBCInput_2
										.getDouble(14);
							} else {
								row2.cpu_speed_mh = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 15) {
							row2.host_os = null;
						} else {

							row2.host_os = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_2, 15, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 16) {
							row2.kernel_version = null;
						} else {

							row2.kernel_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 16, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 17) {
							row2.kvm_version = null;
						} else {

							row2.kvm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 17, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 18) {
							row2.vdsm_version = null;
						} else {

							row2.vdsm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 18, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 19) {
							row2.vdsm_port = null;
						} else {

							if (rs_tJDBCInput_2.getObject(19) != null) {
								row2.vdsm_port = rs_tJDBCInput_2.getInt(19);
							} else {
								row2.vdsm_port = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 20) {
							row2.threads_per_core = null;
						} else {

							if (rs_tJDBCInput_2.getObject(20) != null) {
								row2.threads_per_core = rs_tJDBCInput_2
										.getShort(20);
							} else {
								row2.threads_per_core = null;
							}
						}
						if (colQtyInRs_tJDBCInput_2 < 21) {
							row2.hardware_manufacturer = null;
						} else {

							row2.hardware_manufacturer = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 21, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 22) {
							row2.hardware_product_name = null;
						} else {

							row2.hardware_product_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 22, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 23) {
							row2.hardware_version = null;
						} else {

							row2.hardware_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 23, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 24) {
							row2.hardware_serial_number = null;
						} else {

							row2.hardware_serial_number = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_2, 24, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 25) {
							row2.create_date = null;
						} else {

							java.util.Date date_tJDBCInput_2 = null;
							try {
								date_tJDBCInput_2 = rs_tJDBCInput_2
										.getTimestamp(25);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_2 = rs_tJDBCInput_2.getDate(25);
							}
							row2.create_date = date_tJDBCInput_2;
						}
						if (colQtyInRs_tJDBCInput_2 < 26) {
							row2.update_date = null;
						} else {

							java.util.Date date_tJDBCInput_2 = null;
							try {
								date_tJDBCInput_2 = rs_tJDBCInput_2
										.getTimestamp(26);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_2 = rs_tJDBCInput_2.getDate(26);
							}
							row2.update_date = date_tJDBCInput_2;
						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */

						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tMap_1 main ] start
						 */

						currentComponent = "tMap_1";

						boolean hasCasePrimitiveKeyWithNull_tMap_1 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_1 = false;
						boolean mainRowRejected_tMap_1 = false;

						// /////////////////////////////////////////////
						// Starting Lookup Table "row1"
						// /////////////////////////////////////////////

						boolean forceLooprow1 = false;

						row1Struct row1ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_1) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_1 = false;

							row1HashKey.cluster_join_id = row2.cluster_join_id;

							row1HashKey.hashCodeDirty = true;

							tHash_Lookup_row1.lookup(row1HashKey);

						} // G_TM_M_020

						if (tHash_Lookup_row1 != null
								&& tHash_Lookup_row1.getCount(row1HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row1' and it contains more one result from keys :  row1.cluster_join_id = '"
							// + row1HashKey.cluster_join_id + "'");
						} // G 071

						row1Struct row1 = null;

						row1Struct fromLookup_row1 = null;
						row1 = row1Default;

						if (tHash_Lookup_row1 != null
								&& tHash_Lookup_row1.hasNext()) { // G 099

							fromLookup_row1 = tHash_Lookup_row1.next();

						} // G 099

						if (fromLookup_row1 != null) {
							row1 = fromLookup_row1;
						}

						// /////////////////////////////////////////////
						// Starting Lookup Table "row21"
						// /////////////////////////////////////////////

						boolean forceLooprow21 = false;

						row21Struct row21ObjectFromLookup = null;

						if (!rejectedInnerJoin_tMap_1) { // G_TM_M_020

							hasCasePrimitiveKeyWithNull_tMap_1 = false;

							row21HashKey.host_join_id = row2.host_join_id;

							row21HashKey.memory_size_mb = row2.memory_size_mb;

							row21HashKey.swap_size_mb = row2.swap_size_mb;

							row21HashKey.cpu_model = StringHandling
									.TRIM(row2.cpu_model);

							row21HashKey.number_of_cores = row2.number_of_cores;

							row21HashKey.number_of_sockets = row2.number_of_sockets;

							row21HashKey.cpu_speed_mh = row2.cpu_speed_mh;

							row21HashKey.host_os = StringHandling
									.TRIM(row2.host_os);

							row21HashKey.kernel_version = StringHandling
									.TRIM(row2.kernel_version);

							row21HashKey.kvm_version = StringHandling
									.TRIM(row2.kvm_version);

							row21HashKey.vdsm_version = StringHandling
									.TRIM(row2.vdsm_version);

							row21HashKey.hashCodeDirty = true;

							tHash_Lookup_row21.lookup(row21HashKey);

							if (!tHash_Lookup_row21.hasNext()) { // G_TM_M_090

								rejectedInnerJoin_tMap_1 = true;

							} // G_TM_M_090

						} // G_TM_M_020

						if (tHash_Lookup_row21 != null
								&& tHash_Lookup_row21.getCount(row21HashKey) > 1) { // G
																					// 071

							// System.out.println("WARNING: UNIQUE MATCH is configured for the lookup 'row21' and it contains more one result from keys :  row21.host_join_id = '"
							// + row21HashKey.host_join_id +
							// "', row21.memory_size_mb = '" +
							// row21HashKey.memory_size_mb +
							// "', row21.swap_size_mb = '" +
							// row21HashKey.swap_size_mb +
							// "', row21.cpu_model = '" + row21HashKey.cpu_model
							// + "', row21.number_of_cores = '" +
							// row21HashKey.number_of_cores +
							// "', row21.number_of_sockets = '" +
							// row21HashKey.number_of_sockets +
							// "', row21.cpu_speed_mh = '" +
							// row21HashKey.cpu_speed_mh +
							// "', row21.host_os = '" + row21HashKey.host_os +
							// "', row21.kernel_version = '" +
							// row21HashKey.kernel_version +
							// "', row21.kvm_version = '" +
							// row21HashKey.kvm_version +
							// "', row21.vdsm_version = '" +
							// row21HashKey.vdsm_version + "'");
						} // G 071

						row21Struct row21 = null;

						row21Struct fromLookup_row21 = null;
						row21 = row21Default;

						if (tHash_Lookup_row21 != null
								&& tHash_Lookup_row21.hasNext()) { // G 099

							fromLookup_row21 = tHash_Lookup_row21.next();

						} // G 099

						if (fromLookup_row21 != null) {
							row21 = fromLookup_row21;
						}

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_1__Struct Var = Var__tMap_1;// ###############################
							// ###############################
							// # Output tables

							host_changes = null;

							if (!rejectedInnerJoin_tMap_1) {
							} // closing inner join bracket (1)
								// ###### START REJECTS #####

							// # Output reject table : 'host_changes'
							// # Filter conditions
							if (rejectedInnerJoin_tMap_1) {
								host_changes_tmp.host_id = row2.host_id;
								host_changes_tmp.host_unique_id = StringHandling
										.TRIM(row2.host_unique_id);
								host_changes_tmp.host_name = StringHandling
										.TRIM(row2.host_name);
								host_changes_tmp.cluster_id = row2.cluster_id;
								host_changes_tmp.host_type = row2.host_type;
								host_changes_tmp.fqdn_or_ip = StringHandling
										.TRIM(row2.fqdn_or_ip);
								host_changes_tmp.memory_size_mb = row2.memory_size_mb;
								host_changes_tmp.swap_size_mb = row2.swap_size_mb;
								host_changes_tmp.cpu_model = StringHandling
										.TRIM(row2.cpu_model);
								host_changes_tmp.number_of_cores = row2.number_of_cores;
								host_changes_tmp.number_of_sockets = row2.number_of_sockets;
								host_changes_tmp.cpu_speed_mh = row2.cpu_speed_mh;
								host_changes_tmp.host_os = StringHandling
										.TRIM(row2.host_os);
								host_changes_tmp.kernel_version = StringHandling
										.TRIM(row2.kernel_version);
								host_changes_tmp.kvm_version = StringHandling
										.TRIM(row2.kvm_version);
								host_changes_tmp.vdsm_version = StringHandling
										.TRIM(row2.vdsm_version);
								host_changes_tmp.vdsm_port = row2.vdsm_port;
								host_changes_tmp.cluster_configuration_version = row1.history_id;
								host_changes_tmp.create_date = row2.create_date;
								host_changes_tmp.update_date = context.runTime;
								host_changes_tmp.delete_date = null;
								host_changes_tmp.threads_per_core = row2.threads_per_core;
								host_changes_tmp.hardware_manufacturer = StringHandling
										.TRIM(row2.hardware_manufacturer);
								host_changes_tmp.hardware_product_name = StringHandling
										.TRIM(row2.hardware_product_name);
								host_changes_tmp.hardware_version = StringHandling
										.TRIM(row2.hardware_version);
								host_changes_tmp.hardware_serial_number = StringHandling
										.TRIM(row2.hardware_serial_number);
								host_changes = host_changes_tmp;
							} // closing filter/reject
								// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_1 = false;

						tos_count_tMap_1++;

						/**
						 * [tMap_1 main ] stop
						 */
						// Start of branch "host_changes"
						if (host_changes != null) {

							/**
							 * [tJDBCOutput_1 main ] start
							 */

							currentComponent = "tJDBCOutput_1";

							whetherReject_tJDBCOutput_1 = false;
							if (host_changes.host_id == null) {
								pstmt_tJDBCOutput_1.setNull(1,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_1.setObject(1,
										host_changes.host_id);
							}

							if (host_changes.host_unique_id == null) {
								pstmt_tJDBCOutput_1.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(2,
										host_changes.host_unique_id);
							}

							if (host_changes.host_name == null) {
								pstmt_tJDBCOutput_1.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(3,
										host_changes.host_name);
							}

							if (host_changes.cluster_id == null) {
								pstmt_tJDBCOutput_1.setNull(4,
										java.sql.Types.OTHER);
							} else {
								pstmt_tJDBCOutput_1.setObject(4,
										host_changes.cluster_id);
							}

							pstmt_tJDBCOutput_1.setShort(5,
									host_changes.host_type);

							if (host_changes.fqdn_or_ip == null) {
								pstmt_tJDBCOutput_1.setNull(6,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(6,
										host_changes.fqdn_or_ip);
							}

							if (host_changes.memory_size_mb == null) {
								pstmt_tJDBCOutput_1.setNull(7,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1.setInt(7,
										host_changes.memory_size_mb);
							}

							if (host_changes.swap_size_mb == null) {
								pstmt_tJDBCOutput_1.setNull(8,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1.setInt(8,
										host_changes.swap_size_mb);
							}

							if (host_changes.cpu_model == null) {
								pstmt_tJDBCOutput_1.setNull(9,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(9,
										host_changes.cpu_model);
							}

							if (host_changes.number_of_cores == null) {
								pstmt_tJDBCOutput_1.setNull(10,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1.setShort(10,
										host_changes.number_of_cores);
							}

							if (host_changes.number_of_sockets == null) {
								pstmt_tJDBCOutput_1.setNull(11,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1.setShort(11,
										host_changes.number_of_sockets);
							}

							if (host_changes.cpu_speed_mh == null) {
								pstmt_tJDBCOutput_1.setNull(12,
										java.sql.Types.DOUBLE);
							} else {
								pstmt_tJDBCOutput_1.setDouble(12,
										host_changes.cpu_speed_mh);
							}

							if (host_changes.host_os == null) {
								pstmt_tJDBCOutput_1.setNull(13,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(13,
										host_changes.host_os);
							}

							if (host_changes.kernel_version == null) {
								pstmt_tJDBCOutput_1.setNull(14,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(14,
										host_changes.kernel_version);
							}

							if (host_changes.kvm_version == null) {
								pstmt_tJDBCOutput_1.setNull(15,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(15,
										host_changes.kvm_version);
							}

							if (host_changes.vdsm_version == null) {
								pstmt_tJDBCOutput_1.setNull(16,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(16,
										host_changes.vdsm_version);
							}

							pstmt_tJDBCOutput_1.setInt(17,
									host_changes.vdsm_port);

							if (host_changes.cluster_configuration_version == null) {
								pstmt_tJDBCOutput_1.setNull(18,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1
										.setInt(18,
												host_changes.cluster_configuration_version);
							}

							if (host_changes.create_date != null) {
								pstmt_tJDBCOutput_1.setTimestamp(
										19,
										new java.sql.Timestamp(
												host_changes.create_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_1.setNull(19,
										java.sql.Types.DATE);
							}

							if (host_changes.update_date != null) {
								pstmt_tJDBCOutput_1.setTimestamp(
										20,
										new java.sql.Timestamp(
												host_changes.update_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_1.setNull(20,
										java.sql.Types.DATE);
							}

							if (host_changes.delete_date != null) {
								pstmt_tJDBCOutput_1.setTimestamp(
										21,
										new java.sql.Timestamp(
												host_changes.delete_date
														.getTime()));
							} else {
								pstmt_tJDBCOutput_1.setNull(21,
										java.sql.Types.DATE);
							}

							if (host_changes.threads_per_core == null) {
								pstmt_tJDBCOutput_1.setNull(22,
										java.sql.Types.INTEGER);
							} else {
								pstmt_tJDBCOutput_1.setShort(22,
										host_changes.threads_per_core);
							}

							if (host_changes.hardware_manufacturer == null) {
								pstmt_tJDBCOutput_1.setNull(23,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(23,
										host_changes.hardware_manufacturer);
							}

							if (host_changes.hardware_product_name == null) {
								pstmt_tJDBCOutput_1.setNull(24,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(24,
										host_changes.hardware_product_name);
							}

							if (host_changes.hardware_version == null) {
								pstmt_tJDBCOutput_1.setNull(25,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(25,
										host_changes.hardware_version);
							}

							if (host_changes.hardware_serial_number == null) {
								pstmt_tJDBCOutput_1.setNull(26,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_1.setString(26,
										host_changes.hardware_serial_number);
							}

							try {
								insertedCount_tJDBCOutput_1 = insertedCount_tJDBCOutput_1
										+ pstmt_tJDBCOutput_1.executeUpdate();
								nb_line_tJDBCOutput_1++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_1 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_1++;

							/**
							 * [tJDBCOutput_1 main ] stop
							 */

						} // End of branch "host_changes"

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					if (rs_tJDBCInput_2 != null) {
						rs_tJDBCInput_2.close();
					}
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tMap_1 end ] start
				 */

				currentComponent = "tMap_1";

				// ###############################
				// # Lookup hashes releasing
				if (tHash_Lookup_row1 != null) {
					tHash_Lookup_row1.endGet();
				}
				globalMap.remove("tHash_Lookup_row1");

				if (tHash_Lookup_row21 != null) {
					tHash_Lookup_row21.endGet();
				}
				globalMap.remove("tHash_Lookup_row21");

				// ###############################

				ok_Hash.put("tMap_1", true);
				end_Hash.put("tMap_1", System.currentTimeMillis());

				/**
				 * [tMap_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_5Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			// free memory for "tMap_1"
			globalMap.remove("tHash_Lookup_row21");

			// free memory for "tMap_1"
			globalMap.remove("tHash_Lookup_row1");

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tMap_1 finally ] start
				 */

				currentComponent = "tMap_1";

				/**
				 * [tMap_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_1 finally ] start
				 */

				currentComponent = "tJDBCOutput_1";

				/**
				 * [tJDBCOutput_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class update_lastSyncStruct implements
			routines.system.IPersistableRow<update_lastSyncStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public String var_value;

		public String getVar_value() {
			return this.var_value;
		}

		public java.util.Date var_datetime;

		public java.util.Date getVar_datetime() {
			return this.var_datetime;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.var_name == null) ? 0 : this.var_name
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final update_lastSyncStruct other = (update_lastSyncStruct) obj;

			if (this.var_name == null) {
				if (other.var_name != null)
					return false;

			} else if (!this.var_name.equals(other.var_name))

				return false;

			return true;
		}

		public void copyDataTo(update_lastSyncStruct other) {

			other.var_name = this.var_name;
			other.var_value = this.var_value;
			other.var_datetime = this.var_datetime;

		}

		public void copyKeysDataTo(update_lastSyncStruct other) {

			other.var_name = this.var_name;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_value = readString(dis);

					this.var_datetime = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// String

				writeString(this.var_value, dos);

				// java.util.Date

				writeDate(this.var_datetime, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_value=" + var_value);
			sb.append(",var_datetime=" + String.valueOf(var_datetime));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(update_lastSyncStruct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.var_name, other.var_name);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row34Struct implements
			routines.system.IPersistableRow<row34Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public String var_value;

		public String getVar_value() {
			return this.var_value;
		}

		public java.util.Date var_datetime;

		public java.util.Date getVar_datetime() {
			return this.var_datetime;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_value = readString(dis);

					this.var_datetime = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// String

				writeString(this.var_value, dos);

				// java.util.Date

				writeDate(this.var_datetime, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_value=" + var_value);
			sb.append(",var_datetime=" + String.valueOf(var_datetime));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row34Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row34Struct row34 = new row34Struct();
				update_lastSyncStruct update_lastSync = new update_lastSyncStruct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int updateKeyCount_tJDBCOutput_2 = 1;
				if (updateKeyCount_tJDBCOutput_2 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				String update_tJDBCOutput_2 = "UPDATE "
						+ "dwh_history_timekeeping"
						+ " SET var_value = ?,var_datetime = ? WHERE var_name = ?";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(update_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());

				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				update_lastSyncStruct update_lastSync_tmp = new update_lastSyncStruct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT *\nFROM  dwh_history_timekeeping\nwhere var_name = 'lastFullHostCheck'";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);

				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						if (colQtyInRs_tJDBCInput_5 < 1) {
							row34.var_name = null;
						} else {

							row34.var_name = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 1, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 2) {
							row34.var_value = null;
						} else {

							row34.var_value = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_5, 2, false);
						}
						if (colQtyInRs_tJDBCInput_5 < 3) {
							row34.var_datetime = null;
						} else {

							java.util.Date date_tJDBCInput_5 = null;
							try {
								date_tJDBCInput_5 = rs_tJDBCInput_5
										.getTimestamp(3);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_5 = rs_tJDBCInput_5.getDate(3);
							}
							row34.var_datetime = date_tJDBCInput_5;
						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */

						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tMap_3 main ] start
						 */

						currentComponent = "tMap_3";

						boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_3 = false;
						boolean mainRowRejected_tMap_3 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
							// ###############################
							// # Output tables

							update_lastSync = null;

							// # Output table : 'update_lastSync'
							update_lastSync_tmp.var_name = row34.var_name;
							update_lastSync_tmp.var_value = row34.var_value;
							update_lastSync_tmp.var_datetime = context.runTime;
							update_lastSync = update_lastSync_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_3 = false;

						tos_count_tMap_3++;

						/**
						 * [tMap_3 main ] stop
						 */
						// Start of branch "update_lastSync"
						if (update_lastSync != null) {

							/**
							 * [tJDBCOutput_2 main ] start
							 */

							currentComponent = "tJDBCOutput_2";

							whetherReject_tJDBCOutput_2 = false;
							if (update_lastSync.var_value == null) {
								pstmt_tJDBCOutput_2.setNull(1,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_2.setString(1,
										update_lastSync.var_value);
							}

							if (update_lastSync.var_datetime != null) {
								pstmt_tJDBCOutput_2.setTimestamp(
										2,
										new java.sql.Timestamp(
												update_lastSync.var_datetime
														.getTime()));
							} else {
								pstmt_tJDBCOutput_2.setNull(2,
										java.sql.Types.DATE);
							}

							if (update_lastSync.var_name == null) {
								pstmt_tJDBCOutput_2.setNull(3,
										java.sql.Types.VARCHAR);
							} else {
								pstmt_tJDBCOutput_2.setString(3,
										update_lastSync.var_name);
							}

							try {
								updatedCount_tJDBCOutput_2 = updatedCount_tJDBCOutput_2
										+ pstmt_tJDBCOutput_2.executeUpdate();
								nb_line_tJDBCOutput_2++;
							} catch (java.lang.Exception e) {
								whetherReject_tJDBCOutput_2 = true;
								throw (e);
							}

							tos_count_tJDBCOutput_2++;

							/**
							 * [tJDBCOutput_2 main ] stop
							 */

						} // End of branch "update_lastSync"

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					if (rs_tJDBCInput_5 != null) {
						rs_tJDBCInput_5.close();
					}
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tMap_3 finally ] start
				 */

				currentComponent = "tMap_3";

				/**
				 * [tMap_3 finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class row21Struct implements
			routines.system.IPersistableComparableLookupRow<row21Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String host_join_id;

		public String getHost_join_id() {
			return this.host_join_id;
		}

		public Integer memory_size_mb;

		public Integer getMemory_size_mb() {
			return this.memory_size_mb;
		}

		public Integer swap_size_mb;

		public Integer getSwap_size_mb() {
			return this.swap_size_mb;
		}

		public String cpu_model;

		public String getCpu_model() {
			return this.cpu_model;
		}

		public Short number_of_cores;

		public Short getNumber_of_cores() {
			return this.number_of_cores;
		}

		public Short number_of_sockets;

		public Short getNumber_of_sockets() {
			return this.number_of_sockets;
		}

		public Double cpu_speed_mh;

		public Double getCpu_speed_mh() {
			return this.cpu_speed_mh;
		}

		public String host_os;

		public String getHost_os() {
			return this.host_os;
		}

		public String kernel_version;

		public String getKernel_version() {
			return this.kernel_version;
		}

		public String kvm_version;

		public String getKvm_version() {
			return this.kvm_version;
		}

		public String vdsm_version;

		public String getVdsm_version() {
			return this.vdsm_version;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.host_join_id == null) ? 0 : this.host_join_id
								.hashCode());

				result = prime
						* result
						+ ((this.memory_size_mb == null) ? 0
								: this.memory_size_mb.hashCode());

				result = prime
						* result
						+ ((this.swap_size_mb == null) ? 0 : this.swap_size_mb
								.hashCode());

				result = prime
						* result
						+ ((this.cpu_model == null) ? 0 : this.cpu_model
								.hashCode());

				result = prime
						* result
						+ ((this.number_of_cores == null) ? 0
								: this.number_of_cores.hashCode());

				result = prime
						* result
						+ ((this.number_of_sockets == null) ? 0
								: this.number_of_sockets.hashCode());

				result = prime
						* result
						+ ((this.cpu_speed_mh == null) ? 0 : this.cpu_speed_mh
								.hashCode());

				result = prime
						* result
						+ ((this.host_os == null) ? 0 : this.host_os.hashCode());

				result = prime
						* result
						+ ((this.kernel_version == null) ? 0
								: this.kernel_version.hashCode());

				result = prime
						* result
						+ ((this.kvm_version == null) ? 0 : this.kvm_version
								.hashCode());

				result = prime
						* result
						+ ((this.vdsm_version == null) ? 0 : this.vdsm_version
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row21Struct other = (row21Struct) obj;

			if (this.host_join_id == null) {
				if (other.host_join_id != null)
					return false;

			} else if (!this.host_join_id.equals(other.host_join_id))

				return false;

			if (this.memory_size_mb == null) {
				if (other.memory_size_mb != null)
					return false;

			} else if (!this.memory_size_mb.equals(other.memory_size_mb))

				return false;

			if (this.swap_size_mb == null) {
				if (other.swap_size_mb != null)
					return false;

			} else if (!this.swap_size_mb.equals(other.swap_size_mb))

				return false;

			if (this.cpu_model == null) {
				if (other.cpu_model != null)
					return false;

			} else if (!this.cpu_model.equals(other.cpu_model))

				return false;

			if (this.number_of_cores == null) {
				if (other.number_of_cores != null)
					return false;

			} else if (!this.number_of_cores.equals(other.number_of_cores))

				return false;

			if (this.number_of_sockets == null) {
				if (other.number_of_sockets != null)
					return false;

			} else if (!this.number_of_sockets.equals(other.number_of_sockets))

				return false;

			if (this.cpu_speed_mh == null) {
				if (other.cpu_speed_mh != null)
					return false;

			} else if (!this.cpu_speed_mh.equals(other.cpu_speed_mh))

				return false;

			if (this.host_os == null) {
				if (other.host_os != null)
					return false;

			} else if (!this.host_os.equals(other.host_os))

				return false;

			if (this.kernel_version == null) {
				if (other.kernel_version != null)
					return false;

			} else if (!this.kernel_version.equals(other.kernel_version))

				return false;

			if (this.kvm_version == null) {
				if (other.kvm_version != null)
					return false;

			} else if (!this.kvm_version.equals(other.kvm_version))

				return false;

			if (this.vdsm_version == null) {
				if (other.vdsm_version != null)
					return false;

			} else if (!this.vdsm_version.equals(other.vdsm_version))

				return false;

			return true;
		}

		public void copyDataTo(row21Struct other) {

			other.host_join_id = this.host_join_id;
			other.memory_size_mb = this.memory_size_mb;
			other.swap_size_mb = this.swap_size_mb;
			other.cpu_model = this.cpu_model;
			other.number_of_cores = this.number_of_cores;
			other.number_of_sockets = this.number_of_sockets;
			other.cpu_speed_mh = this.cpu_speed_mh;
			other.host_os = this.host_os;
			other.kernel_version = this.kernel_version;
			other.kvm_version = this.kvm_version;
			other.vdsm_version = this.vdsm_version;

		}

		public void copyKeysDataTo(row21Struct other) {

			other.host_join_id = this.host_join_id;
			other.memory_size_mb = this.memory_size_mb;
			other.swap_size_mb = this.swap_size_mb;
			other.cpu_model = this.cpu_model;
			other.number_of_cores = this.number_of_cores;
			other.number_of_sockets = this.number_of_sockets;
			other.cpu_speed_mh = this.cpu_speed_mh;
			other.host_os = this.host_os;
			other.kernel_version = this.kernel_version;
			other.kvm_version = this.kvm_version;
			other.vdsm_version = this.vdsm_version;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.host_join_id = readString(dis);

					this.memory_size_mb = readInteger(dis);

					this.swap_size_mb = readInteger(dis);

					this.cpu_model = readString(dis);

					length = dis.readByte();
					if (length == -1) {
						this.number_of_cores = null;
					} else {
						this.number_of_cores = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.number_of_sockets = null;
					} else {
						this.number_of_sockets = dis.readShort();
					}

					length = dis.readByte();
					if (length == -1) {
						this.cpu_speed_mh = null;
					} else {
						this.cpu_speed_mh = dis.readDouble();
					}

					this.host_os = readString(dis);

					this.kernel_version = readString(dis);

					this.kvm_version = readString(dis);

					this.vdsm_version = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.host_join_id, dos);

				// Integer

				writeInteger(this.memory_size_mb, dos);

				// Integer

				writeInteger(this.swap_size_mb, dos);

				// String

				writeString(this.cpu_model, dos);

				// Short

				if (this.number_of_cores == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_cores);
				}

				// Short

				if (this.number_of_sockets == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeShort(this.number_of_sockets);
				}

				// Double

				if (this.cpu_speed_mh == null) {
					dos.writeByte(-1);
				} else {
					dos.writeByte(0);
					dos.writeDouble(this.cpu_speed_mh);
				}

				// String

				writeString(this.host_os, dos);

				// String

				writeString(this.kernel_version, dos);

				// String

				writeString(this.kvm_version, dos);

				// String

				writeString(this.vdsm_version, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

			}

			finally {
			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

			} finally {
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("host_join_id=" + host_join_id);
			sb.append(",memory_size_mb=" + String.valueOf(memory_size_mb));
			sb.append(",swap_size_mb=" + String.valueOf(swap_size_mb));
			sb.append(",cpu_model=" + cpu_model);
			sb.append(",number_of_cores=" + String.valueOf(number_of_cores));
			sb.append(",number_of_sockets=" + String.valueOf(number_of_sockets));
			sb.append(",cpu_speed_mh=" + String.valueOf(cpu_speed_mh));
			sb.append(",host_os=" + host_os);
			sb.append(",kernel_version=" + kernel_version);
			sb.append(",kvm_version=" + kvm_version);
			sb.append(",vdsm_version=" + vdsm_version);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row21Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.host_join_id,
					other.host_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.memory_size_mb,
					other.memory_size_mb);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.swap_size_mb,
					other.swap_size_mb);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.cpu_model, other.cpu_model);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.number_of_cores,
					other.number_of_cores);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.number_of_sockets,
					other.number_of_sockets);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.cpu_speed_mh,
					other.cpu_speed_mh);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.host_os, other.host_os);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.kernel_version,
					other.kernel_version);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.kvm_version,
					other.kvm_version);
			if (returnValue != 0) {
				return returnValue;
			}

			returnValue = checkNullsAndCompare(this.vdsm_version,
					other.vdsm_version);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row21Struct row21 = new row21Struct();

				/**
				 * [tAdvancedHash_row21 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row21", false);
				start_Hash.put("tAdvancedHash_row21",
						System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row21";

				int tos_count_tAdvancedHash_row21 = 0;

				// connection name:row21
				// source node:tJDBCInput_1 - inputs:(after_tJDBCInput_2)
				// outputs:(row21,row21) | target node:tAdvancedHash_row21 -
				// inputs:(row21) outputs:()
				// linked node: tMap_1 - inputs:(row2,row21,row1)
				// outputs:(host_changes)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row21 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row21Struct> tHash_Lookup_row21 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row21Struct> getLookup(matchingModeEnum_row21);

				globalMap.put("tHash_Lookup_row21", tHash_Lookup_row21);

				/**
				 * [tAdvancedHash_row21 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "SELECT upper(cast(host_id as char(36))) as host_join_id,\n		memory_size_mb, \n		swap_size_mb,\n		cpu_model, \n		number_of_cores,\n        number_of_sockets,\n        cpu_speed_mh,\n		host_os, \n		kernel_version, \n		kvm_version, \n		vdsm_version\nFROM v4_4_latest_configuration_hosts";

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);

				java.sql.ResultSet rs_tJDBCInput_1 = null;
				try {
					rs_tJDBCInput_1 = stmt_tJDBCInput_1
							.executeQuery(dbquery_tJDBCInput_1);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
							.getMetaData();
					int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
							.getColumnCount();

					String tmpContent_tJDBCInput_1 = null;

					while (rs_tJDBCInput_1.next()) {
						nb_line_tJDBCInput_1++;

						if (colQtyInRs_tJDBCInput_1 < 1) {
							row21.host_join_id = null;
						} else {

							row21.host_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 1, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 2) {
							row21.memory_size_mb = null;
						} else {

							if (rs_tJDBCInput_1.getObject(2) != null) {
								row21.memory_size_mb = rs_tJDBCInput_1
										.getInt(2);
							} else {
								row21.memory_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 3) {
							row21.swap_size_mb = null;
						} else {

							if (rs_tJDBCInput_1.getObject(3) != null) {
								row21.swap_size_mb = rs_tJDBCInput_1.getInt(3);
							} else {
								row21.swap_size_mb = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 4) {
							row21.cpu_model = null;
						} else {

							row21.cpu_model = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 4, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 5) {
							row21.number_of_cores = null;
						} else {

							if (rs_tJDBCInput_1.getObject(5) != null) {
								row21.number_of_cores = rs_tJDBCInput_1
										.getShort(5);
							} else {
								row21.number_of_cores = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 6) {
							row21.number_of_sockets = null;
						} else {

							if (rs_tJDBCInput_1.getObject(6) != null) {
								row21.number_of_sockets = rs_tJDBCInput_1
										.getShort(6);
							} else {
								row21.number_of_sockets = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 7) {
							row21.cpu_speed_mh = null;
						} else {

							if (rs_tJDBCInput_1.getObject(7) != null) {
								row21.cpu_speed_mh = rs_tJDBCInput_1
										.getDouble(7);
							} else {
								row21.cpu_speed_mh = null;
							}
						}
						if (colQtyInRs_tJDBCInput_1 < 8) {
							row21.host_os = null;
						} else {

							row21.host_os = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_1, 8, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 9) {
							row21.kernel_version = null;
						} else {

							row21.kernel_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 9, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 10) {
							row21.kvm_version = null;
						} else {

							row21.kvm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 10, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 11) {
							row21.vdsm_version = null;
						} else {

							row21.vdsm_version = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_1, 11, false);
						}

						/**
						 * [tJDBCInput_1 begin ] stop
						 */

						/**
						 * [tJDBCInput_1 main ] start
						 */

						currentComponent = "tJDBCInput_1";

						tos_count_tJDBCInput_1++;

						/**
						 * [tJDBCInput_1 main ] stop
						 */

						/**
						 * [tAdvancedHash_row21 main ] start
						 */

						currentComponent = "tAdvancedHash_row21";

						row21Struct row21_HashRow = new row21Struct();

						row21_HashRow.host_join_id = row21.host_join_id;

						row21_HashRow.memory_size_mb = row21.memory_size_mb;

						row21_HashRow.swap_size_mb = row21.swap_size_mb;

						row21_HashRow.cpu_model = row21.cpu_model;

						row21_HashRow.number_of_cores = row21.number_of_cores;

						row21_HashRow.number_of_sockets = row21.number_of_sockets;

						row21_HashRow.cpu_speed_mh = row21.cpu_speed_mh;

						row21_HashRow.host_os = row21.host_os;

						row21_HashRow.kernel_version = row21.kernel_version;

						row21_HashRow.kvm_version = row21.kvm_version;

						row21_HashRow.vdsm_version = row21.vdsm_version;

						tHash_Lookup_row21.put(row21_HashRow);

						tos_count_tAdvancedHash_row21++;

						/**
						 * [tAdvancedHash_row21 main ] stop
						 */

						/**
						 * [tJDBCInput_1 end ] start
						 */

						currentComponent = "tJDBCInput_1";

					}
				} finally {
					if (rs_tJDBCInput_1 != null) {
						rs_tJDBCInput_1.close();
					}
					stmt_tJDBCInput_1.close();

				}
				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tAdvancedHash_row21 end ] start
				 */

				currentComponent = "tAdvancedHash_row21";

				tHash_Lookup_row21.endPut();

				ok_Hash.put("tAdvancedHash_row21", true);
				end_Hash.put("tAdvancedHash_row21", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row21 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row21 finally ] start
				 */

				currentComponent = "tAdvancedHash_row21";

				/**
				 * [tAdvancedHash_row21 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public static class row1Struct implements
			routines.system.IPersistableComparableLookupRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public Integer history_id;

		public Integer getHistory_id() {
			return this.history_id;
		}

		public String cluster_join_id;

		public String getCluster_join_id() {
			return this.cluster_join_id;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.cluster_join_id == null) ? 0
								: this.cluster_join_id.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row1Struct other = (row1Struct) obj;

			if (this.cluster_join_id == null) {
				if (other.cluster_join_id != null)
					return false;

			} else if (!this.cluster_join_id.equals(other.cluster_join_id))

				return false;

			return true;
		}

		public void copyDataTo(row1Struct other) {

			other.history_id = this.history_id;
			other.cluster_join_id = this.cluster_join_id;

		}

		public void copyKeysDataTo(row1Struct other) {

			other.cluster_join_id = this.cluster_join_id;

		}

		private Integer readInteger(DataInputStream dis, ObjectInputStream ois)
				throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, DataOutputStream dos,
				ObjectOutputStream oos) throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readKeysData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.cluster_join_id = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeKeysData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.cluster_join_id, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		/**
		 * Fill Values data by reading ObjectInputStream.
		 */
		public void readValuesData(DataInputStream dis, ObjectInputStream ois) {
			try {

				int length = 0;

				this.history_id = readInteger(dis, ois);

			} catch (IOException e) {
				throw new RuntimeException(e);

			}

		}

		/**
		 * Return a byte array which represents Values data.
		 */
		public void writeValuesData(DataOutputStream dos, ObjectOutputStream oos) {
			try {

				writeInteger(this.history_id, dos, oos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("history_id=" + String.valueOf(history_id));
			sb.append(",cluster_join_id=" + cluster_join_id);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.cluster_join_id,
					other.cluster_join_id);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row1Struct row1 = new row1Struct();

				/**
				 * [tAdvancedHash_row1 begin ] start
				 */

				ok_Hash.put("tAdvancedHash_row1", false);
				start_Hash
						.put("tAdvancedHash_row1", System.currentTimeMillis());

				currentComponent = "tAdvancedHash_row1";

				int tos_count_tAdvancedHash_row1 = 0;

				// connection name:row1
				// source node:tJDBCInput_3 - inputs:(after_tJDBCInput_2)
				// outputs:(row1,row1) | target node:tAdvancedHash_row1 -
				// inputs:(row1) outputs:()
				// linked node: tMap_1 - inputs:(row2,row21,row1)
				// outputs:(host_changes)

				org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE matchingModeEnum_row1 = org.talend.designer.components.lookup.common.ICommonLookup.MATCHING_MODE.UNIQUE_MATCH;

				org.talend.designer.components.lookup.memory.AdvancedMemoryLookup<row1Struct> tHash_Lookup_row1 = org.talend.designer.components.lookup.memory.AdvancedMemoryLookup
						.<row1Struct> getLookup(matchingModeEnum_row1);

				globalMap.put("tHash_Lookup_row1", tHash_Lookup_row1);

				/**
				 * [tAdvancedHash_row1 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT history_id, upper(cast(cluster_id as char(36))) as cluster_join_id\nFROM  v4_4_latest_configuration_clusters";

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);

				java.sql.ResultSet rs_tJDBCInput_3 = null;
				try {
					rs_tJDBCInput_3 = stmt_tJDBCInput_3
							.executeQuery(dbquery_tJDBCInput_3);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
							.getMetaData();
					int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
							.getColumnCount();

					String tmpContent_tJDBCInput_3 = null;

					while (rs_tJDBCInput_3.next()) {
						nb_line_tJDBCInput_3++;

						if (colQtyInRs_tJDBCInput_3 < 1) {
							row1.history_id = null;
						} else {

							if (rs_tJDBCInput_3.getObject(1) != null) {
								row1.history_id = rs_tJDBCInput_3.getInt(1);
							} else {
								row1.history_id = null;
							}
						}
						if (colQtyInRs_tJDBCInput_3 < 2) {
							row1.cluster_join_id = null;
						} else {

							row1.cluster_join_id = routines.system.JDBCUtil
									.getString(rs_tJDBCInput_3, 2, false);
						}

						/**
						 * [tJDBCInput_3 begin ] stop
						 */

						/**
						 * [tJDBCInput_3 main ] start
						 */

						currentComponent = "tJDBCInput_3";

						tos_count_tJDBCInput_3++;

						/**
						 * [tJDBCInput_3 main ] stop
						 */

						/**
						 * [tAdvancedHash_row1 main ] start
						 */

						currentComponent = "tAdvancedHash_row1";

						row1Struct row1_HashRow = new row1Struct();

						row1_HashRow.history_id = row1.history_id;

						row1_HashRow.cluster_join_id = row1.cluster_join_id;

						tHash_Lookup_row1.put(row1_HashRow);

						tos_count_tAdvancedHash_row1++;

						/**
						 * [tAdvancedHash_row1 main ] stop
						 */

						/**
						 * [tJDBCInput_3 end ] start
						 */

						currentComponent = "tJDBCInput_3";

					}
				} finally {
					if (rs_tJDBCInput_3 != null) {
						rs_tJDBCInput_3.close();
					}
					stmt_tJDBCInput_3.close();

				}
				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tAdvancedHash_row1 end ] start
				 */

				currentComponent = "tAdvancedHash_row1";

				tHash_Lookup_row1.endPut();

				ok_Hash.put("tAdvancedHash_row1", true);
				end_Hash.put("tAdvancedHash_row1", System.currentTimeMillis());

				/**
				 * [tAdvancedHash_row1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_3 finally ] start
				 */

				currentComponent = "tJDBCInput_3";

				/**
				 * [tJDBCInput_3 finally ] stop
				 */

				/**
				 * [tAdvancedHash_row1 finally ] start
				 */

				currentComponent = "tAdvancedHash_row1";

				/**
				 * [tAdvancedHash_row1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HostConfigCheck, 0,
						length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HostConfigCheck) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */

					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}
					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final HostConfigCheck HostConfigCheckClass = new HostConfigCheck();

		int exitCode = HostConfigCheckClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public boolean hastBufferOutputComponent() {
		boolean hastBufferOutput = false;

		return hastBufferOutput;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = HostConfigCheck.class
					.getClassLoader().getResourceAsStream(
							"ovirt_engine_dwh/hostconfigcheck_4_4/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			String pwd_ovirtEngineDbPassword_value = context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbPassword = null;
			if (pwd_ovirtEngineDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineDbPassword")) {// no
																			// need
																			// to
																			// decrypt
																			// if
																			// it
																			// come
																			// from
																			// program
																			// argument
																			// or
																			// parent
																			// job
																			// runtime
					context.ovirtEngineDbPassword = pwd_ovirtEngineDbPassword_value;
				} else if (!pwd_ovirtEngineDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineDbPassword_value);
						context.put("ovirtEngineDbPassword",
								context.ovirtEngineDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			String pwd_ovirtEngineHistoryDbPassword_value = context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbPassword = null;
			if (pwd_ovirtEngineHistoryDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineHistoryDbPassword")) {// no
																				// need
																				// to
																				// decrypt
																				// if
																				// it
																				// come
																				// from
																				// program
																				// argument
																				// or
																				// parent
																				// job
																				// runtime
					context.ovirtEngineHistoryDbPassword = pwd_ovirtEngineHistoryDbPassword_value;
				} else if (!pwd_ovirtEngineHistoryDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineHistoryDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineHistoryDbPassword_value);
						context.put("ovirtEngineHistoryDbPassword",
								context.ovirtEngineHistoryDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
			try {
				String context_lastFullHostCheck_value = context
						.getProperty("lastFullHostCheck");
				if (context_lastFullHostCheck_value == null) {
					context_lastFullHostCheck_value = "";
				}
				int context_lastFullHostCheck_pos = context_lastFullHostCheck_value
						.indexOf(";");
				String context_lastFullHostCheck_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastFullHostCheck_pos > -1) {
					context_lastFullHostCheck_pattern = context_lastFullHostCheck_value
							.substring(0, context_lastFullHostCheck_pos);
					context_lastFullHostCheck_value = context_lastFullHostCheck_value
							.substring(context_lastFullHostCheck_pos + 1);
				}

				context.lastFullHostCheck = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastFullHostCheck_pattern)
						.parse(context_lastFullHostCheck_value));

			} catch (ParseException e) {
				context.lastFullHostCheck = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
			if (parentContextMap.containsKey("lastFullHostCheck")) {
				context.lastFullHostCheck = (java.util.Date) parentContextMap
						.get("lastFullHostCheck");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		List<String> parametersToEncrypt = new java.util.ArrayList<String>();
		parametersToEncrypt.add("ovirtEngineDbPassword");
		parametersToEncrypt.add("ovirtEngineHistoryDbPassword");
		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "",
				resumeUtil.convertToJsonText(context, parametersToEncrypt));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		this.globalResumeTicket = false;// to run others jobs

		try {
			errorCode = null;
			tJDBCConnection_2Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tJDBCConnection_2) {
			globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", -1);

			e_tJDBCConnection_2.printStackTrace();

		}

		this.globalResumeTicket = true;// to run tPostJob

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out.println((endUsedMemory - startUsedMemory)
					+ " bytes memory increase when running : HostConfigCheck");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	// only for OSGi env
	public void destroy() {
		closeSqlDbConnections();

	}

	private void closeSqlDbConnections() {
		try {
			Object obj_conn;
			obj_conn = globalMap.remove("conn_tJDBCConnection_2");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_1");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
		} catch (java.lang.Exception e) {
		}
	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		connections.put("conn_tJDBCConnection_2",
				globalMap.get("conn_tJDBCConnection_2"));
		connections.put("conn_tJDBCConnection_1",
				globalMap.get("conn_tJDBCConnection_1"));

		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\\\", "\\" }, { "\\n", "\n" },
			{ "\\'", "\'" }, { "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" },
			{ "\\t", "\t" } };

	private String replaceEscapeChars(String keyValue) {

		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}

		StringBuilder result = new StringBuilder();
		int currIndex = 0;
		while (currIndex < keyValue.length()) {
			int index = -1;
			// judege if the left string includes escape chars
			for (String[] strArray : escapeChars) {
				index = keyValue.indexOf(strArray[0], currIndex);
				if (index >= 0) {

					result.append(keyValue.substring(currIndex,
							index + strArray[0].length()).replace(strArray[0],
							strArray[1]));
					currIndex = index + strArray[0].length();
					break;
				}
			}
			// if the left string doesn't include escape chars, append the left
			// into the result
			if (index < 0) {
				result.append(keyValue.substring(currIndex));
				currIndex = currIndex + keyValue.length();
			}
		}

		return result.toString();
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 200347 characters generated by Talend Open Studio for Data Integration on the
 * February 11, 2018 1:56:24 PM IST
 ************************************************************************************************/
