/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Map;
import java.util.Set;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;

@Scope(value=Scopes.NAMED_CACHE)
@MBean(objectName="StateTransferManager", description="Component that handles state transfer")
public interface StateTransferManager {
    @ManagedAttribute(description="If true, the node has successfully joined the grid and is considered to hold state.  If false, the join process is still in progress.", displayName="Is join completed?", dataType=DataType.TRAIT)
    public boolean isJoinComplete();

    @ManagedAttribute(description="Checks whether there is a pending inbound state transfer on this cluster member.", displayName="Is state transfer in progress?", dataType=DataType.TRAIT)
    public boolean isStateTransferInProgress();

    public boolean isStateTransferInProgressForKey(Object var1);

    @Deprecated
    public CacheTopology getCacheTopology();

    public void start() throws Exception;

    public void waitForInitialStateTransferToComplete();

    public void stop();

    public Map<Address, Response> forwardCommandIfNeeded(TopologyAffectedCommand var1, Set<Object> var2, Address var3);

    @Deprecated
    public boolean ownsData();

    @Deprecated
    public int getFirstTopologyAsMember();

    @ManagedAttribute(description="Retrieves the rebalancing status for this cache. Possible values are PENDING, SUSPENDED, IN_PROGRESS, BALANCED", displayName="Rebalancing progress", dataType=DataType.TRAIT)
    public String getRebalancingStatus() throws Exception;
}

