/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class EJBRemotingConnectorClientMappingsEntryProviderService
implements CapabilityServiceConfigurator,
Supplier<Map.Entry<String, List<ClientMapping>>> {
    private final SupplierDependency<RemotingConnectorBindingInfoService.RemotingConnectorInfo> remotingConnectorInfo;
    private volatile SupplierDependency<Group> group;
    private volatile String clientMappingsClusterName;
    private volatile ServiceName name;

    public EJBRemotingConnectorClientMappingsEntryProviderService(String clientMappingsClusterName, ServiceName remotingConnectorInfoServiceName) {
        this.clientMappingsClusterName = clientMappingsClusterName;
        this.remotingConnectorInfo = new ServiceSupplierDependency(remotingConnectorInfoServiceName);
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public ServiceConfigurator configure(OperationContext context) {
        this.name = ClusteringCacheRequirement.REGISTRY_ENTRY.getServiceName(context, this.clientMappingsClusterName, "client-mappings");
        this.group = new ServiceSupplierDependency(ClusteringRequirement.GROUP.getServiceName(context, this.clientMappingsClusterName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.name);
        Consumer entry = new CompositeDependency(new Dependency[]{this.group, this.remotingConnectorInfo}).register(builder).provides(new ServiceName[]{this.name});
        FunctionalService service = new FunctionalService(entry, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public Map.Entry<String, List<ClientMapping>> get() {
        return new AbstractMap.SimpleImmutableEntry<String, List<ClientMapping>>(((Group)this.group.get()).getLocalMember().getName(), this.getClientMappings());
    }

    List<ClientMapping> getClientMappings() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        RemotingConnectorBindingInfoService.RemotingConnectorInfo info = (RemotingConnectorBindingInfoService.RemotingConnectorInfo)this.remotingConnectorInfo.get();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            String destinationAddress = info.getSocketBinding().getAddress().getHostAddress();
            try {
                clientNetworkAddress = InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationAddress, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }
}

