/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.undertow_httpspi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class PathUtils {
    public static String getPath(String addr) {
        return PathUtils.getPathInternal(PathUtils.getPathFromString(addr));
    }

    public static String getPath(URI addr) {
        return PathUtils.getPathInternal(addr.getPath());
    }

    public static String getPathFromRequest(String requestPath) {
        return PathUtils.getPathInternal(requestPath);
    }

    private static String getPathInternal(String rawpath) {
        String path = PathUtils.removeTrailingSlash(rawpath);
        if (path == null || path.length() == 0) {
            return path;
        }
        int idx = path.lastIndexOf("/");
        return idx > 0 ? path.substring(path.lastIndexOf("/")) : "";
    }

    public static String getContextPath(String addr) {
        return PathUtils.getContextPathInternal(PathUtils.getPathFromString(addr));
    }

    public static String getContextPathFromRequest(String requestPath) {
        return PathUtils.getContextPathInternal(requestPath);
    }

    public static String getContextPath(URI addr) {
        return PathUtils.getContextPathInternal(addr.getPath());
    }

    private static String getContextPathInternal(String rawpath) {
        String path = PathUtils.removeTrailingSlash(rawpath);
        if (path == null || path.length() == 0) {
            return "/";
        }
        int idx = path.lastIndexOf("/");
        return idx > 0 ? path.substring(0, idx) : path;
    }

    private static String getPathFromString(String addr) {
        String path = null;
        try {
            path = new URL(addr).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return path;
    }

    public static String removeTrailingSlash(String path) {
        if (path != null && path.length() > 0 && path.lastIndexOf(47) == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

