/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Int8Array;

public final class Int8ArrayImpl
extends ArrayBufferViewImpl
implements Int8Array {
    public Int8ArrayImpl(ArrayBuffer buffer, int byteOffset, int byteLength) {
        super(buffer, byteOffset, byteLength);
    }

    @Override
    public byte get(int index) {
        return this.arrayBuf.getInt8(this.checkRange(index, 1));
    }

    @Override
    public int length() {
        return this.byteLength() / 1;
    }

    @Override
    public void set(byte[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(byte[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, (int)array[i]);
        }
    }

    @Override
    public void set(int index, int value) {
        this.arrayBuf.setInt8(this.checkRange(index, 1), (byte)(value & 0xFF));
    }

    @Override
    public void set(int[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(int[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(Int8Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Int8Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, (int)array.get(i));
        }
    }

    @Override
    public Int8Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 1;
        return this.subarray(begin, count);
    }

    @Override
    public Int8Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 1;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Int8ArrayImpl(this.arrayBuf, begin * 1, end * 1);
    }
}

