var webpack = require('webpack')
var CleanWebpackPlugin = require('clean-webpack-plugin')
var CopyWebpackPlugin = require('copy-webpack-plugin')
var GenerateI18N = require('./GenerateI18N')

var isProd = process.env.NODE_ENV === 'production'

var config = module.exports = {
  entry: [
    './src/ovirt.js'
  ],
  output: {
    path: __dirname + '/dist',
    publicPath: './',
    filename: 'bundle.js'
  },
  module: {
    loaders: [{
      test: /\.jsx?$/,
      exclude: /node_modules/,
      loader: 'babel-loader',
        query:
        {
          presets: ['es2015']
        }
    }, {
      test: /\.css$/,
      loader: 'style!css'
    }, {
      test: /\.(png|jpg|jpeg|gif|svg)$/,
      loader: 'url?limit=10000'
    }, {
      test: /\.woff(2)?(\?v=[0-9].[0-9].[0-9])?$/,
      loader: 'url?mimetype=application/font-woff'
    }, {
      test: /\.(ttf|eot|svg)(\?v=[0-9].[0-9].[0-9])?$/,
      loader: 'file?name=[name].[ext]'
    }]
  },
  externals: {
    // require("jquery") is external and available
    //  on the global var jQuery
    'jquery': 'jQuery',
    'cockpit': 'cockpit',
    'mustache': 'Mustache'
  },
  plugins: [
    new CleanWebpackPlugin(['dist']),
    new GenerateI18N(['dist/i18n/', 'po/LOCALES']),
    new CopyWebpackPlugin([
      {from: 'LICENSE'},
      {from: 'README.md'},
      {from: 'static/manifest.json'},
      {from: 'static/ovirt.html'},
      {from: 'static/app.css'},
      {from: 'static/vdsm', to: 'vdsm'},
      {from: 'static/images', to: 'images'}
    ])
  ]
}

if (isProd) {
  config.plugins.push(
    new webpack.optimize.DedupePlugin(),
    new webpack.optimize.UglifyJsPlugin({
      minimize: true
    })
  )
} else {// isDev
  config.plugins.push(
    new webpack.DefinePlugin({
      '__DEV__': JSON.stringify(true)
    })
  )
}
