// ============================================================================
//
// Copyright (c) 2006-2013, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.deletetimekeepingjob_3_5;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

//the import part of tJava_1
//import java.util.List;

@SuppressWarnings("unused")
/**
 * Job: DeleteTimeKeepingJob Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 5.4.1.r111943
 * @status 
 */
public class DeleteTimeKeepingJob implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (deleteMore != null) {

				this.setProperty("deleteMore", deleteMore.toString());

			}

			if (hoursToKeepDaily != null) {

				this.setProperty("hoursToKeepDaily",
						hoursToKeepDaily.toString());

			}

			if (hoursToKeepHourly != null) {

				this.setProperty("hoursToKeepHourly",
						hoursToKeepHourly.toString());

			}

			if (hoursToKeepSamples != null) {

				this.setProperty("hoursToKeepSamples",
						hoursToKeepSamples.toString());

			}

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runDeleteTime != null) {

				this.setProperty("runDeleteTime", runDeleteTime.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

		}

		public Integer deleteMore;

		public Integer getDeleteMore() {
			return this.deleteMore;
		}

		public Integer hoursToKeepDaily;

		public Integer getHoursToKeepDaily() {
			return this.hoursToKeepDaily;
		}

		public Integer hoursToKeepHourly;

		public Integer getHoursToKeepHourly() {
			return this.hoursToKeepHourly;
		}

		public Integer hoursToKeepSamples;

		public Integer getHoursToKeepSamples() {
			return this.hoursToKeepSamples;
		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public Integer runDeleteTime;

		public Integer getRunDeleteTime() {
			return this.runDeleteTime;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "3.5";
	private final String jobName = "DeleteTimeKeepingJob";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	public boolean isExportedAsOSGI = false;

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils tLogCatcher_1 = new LogCatcherUtils();
	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private java.lang.Exception exception = null;

	public java.lang.Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends java.lang.Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private java.lang.Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(java.lang.Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public java.lang.Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(java.lang.Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					DeleteTimeKeepingJob.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(DeleteTimeKeepingJob.this, new Object[] {
									e, currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						tLogCatcher_1.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						try {
							tLogCatcher_1Process(globalMap);
						} finally {
							talendLogs_LOGSProcess(globalMap);
						}
					}
				} catch (java.lang.SecurityException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalArgumentException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalAccessException e) {
					this.e.printStackTrace();
				} catch (java.lang.reflect.InvocationTargetException e) {
					this.e.printStackTrace();
				} catch (TalendException e) {
					// do nothing
				}

			}
		}
	}

	public void tPostjob_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tPostjob_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPostjob_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_10_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_10", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_10_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_10", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_10_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJava_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tRunJob_2", System.currentTimeMillis());

		tRunJob_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRollback_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCRollback_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRollback_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCCommit_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCCommit_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCCommit_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_2", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_4", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_9_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_9_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_9", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_9_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_3", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_8", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_6", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_5", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tContextLoad_7", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCInput_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLogCatcher_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tLogCatcher_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLogCatcher_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tMap_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLogCatcher_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLogCatcher_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_CONSOLE_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {
		end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPostjob_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_10_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRunJob_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "ERROR", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

		try {

			((java.util.Map) threadLocal.get()).put("errorCode", null);
			tJDBCRollback_1Process(globalMap);
			if (!"failure".equals(((java.util.Map) threadLocal.get())
					.get("status"))) {
				((java.util.Map) threadLocal.get()).put("status", "end");
			}
		} catch (java.lang.Exception e) {
			e.printStackTrace();
		}
	}

	public void tJDBCRollback_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCCommit_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_9_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_8_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_7_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tLogCatcher_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPostjob_2Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPostjob_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPostjob_2 begin ] start
				 */

				ok_Hash.put("tPostjob_2", false);
				start_Hash.put("tPostjob_2", System.currentTimeMillis());

				currentComponent = "tPostjob_2";

				int tos_count_tPostjob_2 = 0;

				/**
				 * [tPostjob_2 begin ] stop
				 */
				/**
				 * [tPostjob_2 main ] start
				 */

				currentComponent = "tPostjob_2";

				tos_count_tPostjob_2++;

				/**
				 * [tPostjob_2 main ] stop
				 */
				/**
				 * [tPostjob_2 end ] start
				 */

				currentComponent = "tPostjob_2";

				ok_Hash.put("tPostjob_2", true);
				end_Hash.put("tPostjob_2", System.currentTimeMillis());

				tJDBCInput_10Process(globalMap);

				/**
				 * [tPostjob_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPostjob_2 finally ] start
				 */

				currentComponent = "tPostjob_2";

				/**
				 * [tPostjob_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPostjob_2_SUBPROCESS_STATE", 1);
	}

	public static class row11Struct implements
			routines.system.IPersistableRow<row11Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public java.util.Date value;

		public java.util.Date getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// java.util.Date

				writeDate(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + String.valueOf(value));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row11Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_10Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row11Struct row11 = new row11Struct();

				/**
				 * [tContextLoad_10 begin ] start
				 */

				ok_Hash.put("tContextLoad_10", false);
				start_Hash.put("tContextLoad_10", System.currentTimeMillis());

				currentComponent = "tContextLoad_10";

				int tos_count_tContextLoad_10 = 0;

				java.util.List<String> assignList_tContextLoad_10 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_10 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_10 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_10 = 0;

				/**
				 * [tContextLoad_10 begin ] stop
				 */

				/**
				 * [tJDBCInput_10 begin ] start
				 */

				ok_Hash.put("tJDBCInput_10", false);
				start_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				currentComponent = "tJDBCInput_10";

				int tos_count_tJDBCInput_10 = 0;

				int nb_line_tJDBCInput_10 = 0;
				java.sql.Connection conn_tJDBCInput_10 = null;
				conn_tJDBCInput_10 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_10 = conn_tJDBCInput_10
						.createStatement();

				String dbquery_tJDBCInput_10 = "select distinct 'runTime', CURRENT_TIMESTAMP(6)";

				globalMap.put("tJDBCInput_10_QUERY", dbquery_tJDBCInput_10);
				java.sql.ResultSet rs_tJDBCInput_10 = null;
				try {
					rs_tJDBCInput_10 = stmt_tJDBCInput_10
							.executeQuery(dbquery_tJDBCInput_10);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_10 = rs_tJDBCInput_10
							.getMetaData();
					int colQtyInRs_tJDBCInput_10 = rsmd_tJDBCInput_10
							.getColumnCount();

					String tmpContent_tJDBCInput_10 = null;
					int column_index_tJDBCInput_10 = 1;

					while (rs_tJDBCInput_10.next()) {
						nb_line_tJDBCInput_10++;

						column_index_tJDBCInput_10 = 1;

						if (colQtyInRs_tJDBCInput_10 < column_index_tJDBCInput_10) {
							row11.key = null;
						} else {

							tmpContent_tJDBCInput_10 = rs_tJDBCInput_10
									.getString(column_index_tJDBCInput_10);
							if (tmpContent_tJDBCInput_10 != null) {
								row11.key = tmpContent_tJDBCInput_10;
							} else {
								row11.key = null;
							}

						}

						column_index_tJDBCInput_10 = 2;

						if (colQtyInRs_tJDBCInput_10 < column_index_tJDBCInput_10) {
							row11.value = null;
						} else {

							java.util.Date date_tJDBCInput_10 = null;
							try {
								date_tJDBCInput_10 = rs_tJDBCInput_10
										.getTimestamp(column_index_tJDBCInput_10);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_10 = rs_tJDBCInput_10
										.getDate(column_index_tJDBCInput_10);
							}
							row11.value = date_tJDBCInput_10;

						}

						/**
						 * [tJDBCInput_10 begin ] stop
						 */
						/**
						 * [tJDBCInput_10 main ] start
						 */

						currentComponent = "tJDBCInput_10";

						tos_count_tJDBCInput_10++;

						/**
						 * [tJDBCInput_10 main ] stop
						 */

						/**
						 * [tContextLoad_10 main ] start
						 */

						currentComponent = "tContextLoad_10";

						// ////////////////////////
						String tmp_key_tContextLoad_10 = null;

						String key_tContextLoad_10 = null;
						if (row11.key != null) {
							tmp_key_tContextLoad_10 = row11.key.trim();
							if ((tmp_key_tContextLoad_10.startsWith("#") || tmp_key_tContextLoad_10
									.startsWith("!"))) {
								tmp_key_tContextLoad_10 = null;
							} else {
								row11.key = tmp_key_tContextLoad_10;
							}
						}
						if (row11.key != null) {

							key_tContextLoad_10 =

							row11.key;

						}

						String value_tContextLoad_10 = null;
						if (row11.value != null) {

							value_tContextLoad_10 =

							FormatterUtils.format_Date(row11.value,
									"yyyy-MM-dd HH:mm:ss.SSSSSS");

						}

						if (tmp_key_tContextLoad_10 != null) {
							try {
								if (key_tContextLoad_10 != null
										&& "deleteMore"
												.equals(key_tContextLoad_10)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_10);

								}

								if (key_tContextLoad_10 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_10)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_10);

								}

								if (key_tContextLoad_10 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_10)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_10);

								}

								if (key_tContextLoad_10 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_10)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_10);

								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineDbPassword = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineDbUser = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_10)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_10;
								}

								if (key_tContextLoad_10 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_10)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_10);

								}

								if (key_tContextLoad_10 != null
										&& "runTime"
												.equals(key_tContextLoad_10)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_10));

								}

								if (context.getProperty(key_tContextLoad_10) != null) {
									assignList_tContextLoad_10
											.add(key_tContextLoad_10);
								} else {
									newPropertyList_tContextLoad_10
											.add(key_tContextLoad_10);
								}
								context.setProperty(key_tContextLoad_10,
										value_tContextLoad_10);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_10
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_10++;

						}
						// ////////////////////////

						tos_count_tContextLoad_10++;

						/**
						 * [tContextLoad_10 main ] stop
						 */

						/**
						 * [tJDBCInput_10 end ] start
						 */

						currentComponent = "tJDBCInput_10";

					}
				} finally {
					rs_tJDBCInput_10.close();
					stmt_tJDBCInput_10.close();

				}
				globalMap.put("tJDBCInput_10_NB_LINE", nb_line_tJDBCInput_10);

				ok_Hash.put("tJDBCInput_10", true);
				end_Hash.put("tJDBCInput_10", System.currentTimeMillis());

				/**
				 * [tJDBCInput_10 end ] stop
				 */

				/**
				 * [tContextLoad_10 end ] start
				 */

				currentComponent = "tContextLoad_10";

				java.util.Enumeration<?> enu_tContextLoad_10 = context
						.propertyNames();
				while (enu_tContextLoad_10.hasMoreElements()) {
					String key_tContextLoad_10 = (String) enu_tContextLoad_10
							.nextElement();
					if (!assignList_tContextLoad_10
							.contains(key_tContextLoad_10)
							&& !newPropertyList_tContextLoad_10
									.contains(key_tContextLoad_10)) {
						noAssignList_tContextLoad_10.add(key_tContextLoad_10);
					}
				}

				String newPropertyStr_tContextLoad_10 = newPropertyList_tContextLoad_10
						.toString();
				String newProperty_tContextLoad_10 = newPropertyStr_tContextLoad_10
						.substring(1,
								newPropertyStr_tContextLoad_10.length() - 1);

				String noAssignStr_tContextLoad_10 = noAssignList_tContextLoad_10
						.toString();
				String noAssign_tContextLoad_10 = noAssignStr_tContextLoad_10
						.substring(1, noAssignStr_tContextLoad_10.length() - 1);

				globalMap.put("tContextLoad_10_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_10);
				globalMap.put("tContextLoad_10_KEY_NOT_LOADED",
						noAssign_tContextLoad_10);

				globalMap.put("tContextLoad_10_NB_LINE",
						nb_line_tContextLoad_10);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_10", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_10", true);
				end_Hash.put("tContextLoad_10", System.currentTimeMillis());

				/**
				 * [tContextLoad_10 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_10:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJava_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_10 finally ] start
				 */

				currentComponent = "tJDBCInput_10";

				/**
				 * [tJDBCInput_10 finally ] stop
				 */

				/**
				 * [tContextLoad_10 finally ] start
				 */

				currentComponent = "tContextLoad_10";

				/**
				 * [tContextLoad_10 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_10_SUBPROCESS_STATE", 1);
	}

	public void tJava_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_1 begin ] start
				 */

				ok_Hash.put("tJava_1", false);
				start_Hash.put("tJava_1", System.currentTimeMillis());

				currentComponent = "tJava_1";

				int tos_count_tJava_1 = 0;

				if (context.deleteMore == 0) {
					Thread.sleep((Long) TalendDate.diffDate(TalendDate.addDate(
							TalendDate.addDate(RoutineHistoryETL
									.startOfDay(context.runTime), 1, "dd"),
							context.runDeleteTime, "HH"), context.runTime,
							"SSS"));
				} else {
					Thread.sleep(5000);
				}

				/**
				 * [tJava_1 begin ] stop
				 */
				/**
				 * [tJava_1 main ] start
				 */

				currentComponent = "tJava_1";

				tos_count_tJava_1++;

				/**
				 * [tJava_1 main ] stop
				 */
				/**
				 * [tJava_1 end ] start
				 */

				currentComponent = "tJava_1";

				ok_Hash.put("tJava_1", true);
				end_Hash.put("tJava_1", System.currentTimeMillis());

				/**
				 * [tJava_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_1 finally ] start
				 */

				currentComponent = "tJava_1";

				/**
				 * [tJava_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineDbJdbcConnection;

				String userName_tJDBCConnection_2 = context.ovirtEngineDbUser;
				String password_tJDBCConnection_2 = context.ovirtEngineDbPassword;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "engine-events";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_2, userName_tJDBCConnection_2,
						password_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(true);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// userName_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// password_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */
				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */
				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				tJDBCConnection_1Process(globalMap);

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineHistoryDbJdbcConnection;

				String userName_tJDBCConnection_1 = context.ovirtEngineHistoryDbUser;
				String password_tJDBCConnection_1 = context.ovirtEngineHistoryDbPassword;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "delete_ovirt_engine_history";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_1, userName_tJDBCConnection_1,
						password_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// userName_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// password_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */
				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */
				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				tJDBCInput_1Process(globalMap);

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public java.util.Date value;

		public java.util.Date getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readDate(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// java.util.Date

				writeDate(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + String.valueOf(value));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row1Struct row1 = new row1Struct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "select distinct 'runTime', CURRENT_TIMESTAMP(6)";

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);
				java.sql.ResultSet rs_tJDBCInput_1 = null;
				try {
					rs_tJDBCInput_1 = stmt_tJDBCInput_1
							.executeQuery(dbquery_tJDBCInput_1);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
							.getMetaData();
					int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
							.getColumnCount();

					String tmpContent_tJDBCInput_1 = null;
					int column_index_tJDBCInput_1 = 1;

					while (rs_tJDBCInput_1.next()) {
						nb_line_tJDBCInput_1++;

						column_index_tJDBCInput_1 = 1;

						if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
							row1.key = null;
						} else {

							tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
									.getString(column_index_tJDBCInput_1);
							if (tmpContent_tJDBCInput_1 != null) {
								row1.key = tmpContent_tJDBCInput_1;
							} else {
								row1.key = null;
							}

						}

						column_index_tJDBCInput_1 = 2;

						if (colQtyInRs_tJDBCInput_1 < column_index_tJDBCInput_1) {
							row1.value = null;
						} else {

							java.util.Date date_tJDBCInput_1 = null;
							try {
								date_tJDBCInput_1 = rs_tJDBCInput_1
										.getTimestamp(column_index_tJDBCInput_1);
							} catch (java.lang.Exception e) {
								date_tJDBCInput_1 = rs_tJDBCInput_1
										.getDate(column_index_tJDBCInput_1);
							}
							row1.value = date_tJDBCInput_1;

						}

						/**
						 * [tJDBCInput_1 begin ] stop
						 */
						/**
						 * [tJDBCInput_1 main ] start
						 */

						currentComponent = "tJDBCInput_1";

						tos_count_tJDBCInput_1++;

						/**
						 * [tJDBCInput_1 main ] stop
						 */

						/**
						 * [tContextLoad_1 main ] start
						 */

						currentComponent = "tContextLoad_1";

						// ////////////////////////
						String tmp_key_tContextLoad_1 = null;

						String key_tContextLoad_1 = null;
						if (row1.key != null) {
							tmp_key_tContextLoad_1 = row1.key.trim();
							if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
									.startsWith("!"))) {
								tmp_key_tContextLoad_1 = null;
							} else {
								row1.key = tmp_key_tContextLoad_1;
							}
						}
						if (row1.key != null) {

							key_tContextLoad_1 =

							row1.key;

						}

						String value_tContextLoad_1 = null;
						if (row1.value != null) {

							value_tContextLoad_1 =

							FormatterUtils.format_Date(row1.value,
									"yyyy-MM-dd HH:mm:ss.SSSSSS");

						}

						if (tmp_key_tContextLoad_1 != null) {
							try {
								if (key_tContextLoad_1 != null
										&& "deleteMore"
												.equals(key_tContextLoad_1)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_1)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "runTime".equals(key_tContextLoad_1)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_1));

								}

								if (context.getProperty(key_tContextLoad_1) != null) {
									assignList_tContextLoad_1
											.add(key_tContextLoad_1);
								} else {
									newPropertyList_tContextLoad_1
											.add(key_tContextLoad_1);
								}
								context.setProperty(key_tContextLoad_1,
										value_tContextLoad_1);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_1
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_1++;

						}
						// ////////////////////////

						tos_count_tContextLoad_1++;

						/**
						 * [tContextLoad_1 main ] stop
						 */

						/**
						 * [tJDBCInput_1 end ] start
						 */

						currentComponent = "tJDBCInput_1";

					}
				} finally {
					rs_tJDBCInput_1.close();
					stmt_tJDBCInput_1.close();

				}
				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tRunJob_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public void tRunJob_2Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRunJob_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tRunJob_2 begin ] start
				 */

				ok_Hash.put("tRunJob_2", false);
				start_Hash.put("tRunJob_2", System.currentTimeMillis());

				currentComponent = "tRunJob_2";

				int tos_count_tRunJob_2 = 0;

				/**
				 * [tRunJob_2 begin ] stop
				 */
				/**
				 * [tRunJob_2 main ] start
				 */

				currentComponent = "tRunJob_2";

				java.util.List<String> paraList_tRunJob_2 = new java.util.ArrayList<String>();
				paraList_tRunJob_2.add("--father_pid=" + pid);

				paraList_tRunJob_2.add("--root_pid=" + rootPid);

				paraList_tRunJob_2.add("--father_node=tRunJob_2");

				paraList_tRunJob_2.add("--context=Default");

				// for feature:10589
				paraList_tRunJob_2.add("--stat_port=" + portStats);

				if (resuming_logs_dir_path != null) {
					paraList_tRunJob_2.add("--resuming_logs_dir_path="
							+ resuming_logs_dir_path);
				}
				String childResumePath_tRunJob_2 = ResumeUtil
						.getChildJobCheckPointPath(resuming_checkpoint_path);
				String tRunJobName_tRunJob_2 = ResumeUtil
						.getRighttRunJob(resuming_checkpoint_path);
				if ("tRunJob_2".equals(tRunJobName_tRunJob_2)
						&& childResumePath_tRunJob_2 != null) {
					paraList_tRunJob_2
							.add("--resuming_checkpoint_path="
									+ ResumeUtil
											.getChildJobCheckPointPath(resuming_checkpoint_path));
				}
				paraList_tRunJob_2.add("--parent_part_launcher=JOB:" + jobName
						+ "/NODE:tRunJob_2");

				java.util.Map<String, Object> parentContextMap_tRunJob_2 = new java.util.HashMap<String, Object>();

				context.synchronizeContext();
				java.util.Enumeration<?> propertyNames_tRunJob_2 = context
						.propertyNames();
				while (propertyNames_tRunJob_2.hasMoreElements()) {
					String key_tRunJob_2 = (String) propertyNames_tRunJob_2
							.nextElement();
					Object value_tRunJob_2 = (Object) context
							.get(key_tRunJob_2);
					paraList_tRunJob_2.add("--context_param " + key_tRunJob_2
							+ "=" + value_tRunJob_2);
				}

				parentContextMap_tRunJob_2
						.put("deleteMore", context.deleteMore);
				parentContextMap_tRunJob_2.put("hoursToKeepDaily",
						context.hoursToKeepDaily);
				parentContextMap_tRunJob_2.put("hoursToKeepHourly",
						context.hoursToKeepHourly);
				parentContextMap_tRunJob_2.put("hoursToKeepSamples",
						context.hoursToKeepSamples);
				parentContextMap_tRunJob_2.put("ovirtEngineDbDriverClass",
						context.ovirtEngineDbDriverClass);
				parentContextMap_tRunJob_2.put("ovirtEngineDbJdbcConnection",
						context.ovirtEngineDbJdbcConnection);
				parentContextMap_tRunJob_2.put("ovirtEngineDbPassword",
						context.ovirtEngineDbPassword);
				parentContextMap_tRunJob_2.put("ovirtEngineDbUser",
						context.ovirtEngineDbUser);
				parentContextMap_tRunJob_2.put(
						"ovirtEngineHistoryDbDriverClass",
						context.ovirtEngineHistoryDbDriverClass);
				parentContextMap_tRunJob_2.put(
						"ovirtEngineHistoryDbJdbcConnection",
						context.ovirtEngineHistoryDbJdbcConnection);
				parentContextMap_tRunJob_2.put("ovirtEngineHistoryDbPassword",
						context.ovirtEngineHistoryDbPassword);
				parentContextMap_tRunJob_2.put("ovirtEngineHistoryDbUser",
						context.ovirtEngineHistoryDbUser);
				parentContextMap_tRunJob_2.put("runDeleteTime",
						context.runDeleteTime);
				parentContextMap_tRunJob_2.put("runTime", context.runTime);

				Object obj_tRunJob_2 = null;

				ovirt_engine_dwh.historydelete_3_5.HistoryDelete childJob_tRunJob_2 = new ovirt_engine_dwh.historydelete_3_5.HistoryDelete();
				// pass DataSources
				java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_2 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
						.get(KEY_DB_DATASOURCES);
				if (null != talendDataSources_tRunJob_2) {
					java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_2 = new java.util.HashMap<String, javax.sql.DataSource>();
					for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_2 : talendDataSources_tRunJob_2
							.entrySet()) {
						dataSources_tRunJob_2.put(
								talendDataSourceEntry_tRunJob_2.getKey(),
								talendDataSourceEntry_tRunJob_2.getValue()
										.getRawDataSource());
					}
					childJob_tRunJob_2.setDataSources(dataSources_tRunJob_2);
				}
				childJob_tRunJob_2.parentContextMap = parentContextMap_tRunJob_2;

				String[][] childReturn_tRunJob_2 = childJob_tRunJob_2
						.runJob((String[]) paraList_tRunJob_2
								.toArray(new String[paraList_tRunJob_2.size()]));

				((java.util.Map) threadLocal.get()).put("errorCode",
						childJob_tRunJob_2.getErrorCode());

				if (childJob_tRunJob_2.getErrorCode() == null) {
					globalMap.put(
							"tRunJob_2_CHILD_RETURN_CODE",
							childJob_tRunJob_2.getStatus() != null
									&& ("failure").equals(childJob_tRunJob_2
											.getStatus()) ? 1 : 0);
				} else {
					globalMap.put("tRunJob_2_CHILD_RETURN_CODE",
							childJob_tRunJob_2.getErrorCode());
				}
				if (childJob_tRunJob_2.getExceptionStackTrace() != null) {
					globalMap.put("tRunJob_2_CHILD_EXCEPTION_STACKTRACE",
							childJob_tRunJob_2.getExceptionStackTrace());
				}

				if (childJob_tRunJob_2.getErrorCode() != null
						|| ("failure").equals(childJob_tRunJob_2.getStatus())) {

					throw new RuntimeException("Child job running failed");
				}

				tos_count_tRunJob_2++;

				/**
				 * [tRunJob_2 main ] stop
				 */
				/**
				 * [tRunJob_2 end ] start
				 */

				currentComponent = "tRunJob_2";

				ok_Hash.put("tRunJob_2", true);
				end_Hash.put("tRunJob_2", System.currentTimeMillis());

				/**
				 * [tRunJob_2 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tRunJob_2:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tJDBCCommit_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRunJob_2 finally ] start
				 */

				currentComponent = "tRunJob_2";

				/**
				 * [tRunJob_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRunJob_2_SUBPROCESS_STATE", 1);
	}

	public void tJDBCRollback_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCRollback_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCRollback_1 begin ] start
				 */

				ok_Hash.put("tJDBCRollback_1", false);
				start_Hash.put("tJDBCRollback_1", System.currentTimeMillis());

				currentComponent = "tJDBCRollback_1";

				int tos_count_tJDBCRollback_1 = 0;

				/**
				 * [tJDBCRollback_1 begin ] stop
				 */
				/**
				 * [tJDBCRollback_1 main ] start
				 */

				currentComponent = "tJDBCRollback_1";

				java.sql.Connection conn_tJDBCRollback_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (conn_tJDBCRollback_1 != null
						&& !conn_tJDBCRollback_1.isClosed()) {
					conn_tJDBCRollback_1.rollback();
				}

				tos_count_tJDBCRollback_1++;

				/**
				 * [tJDBCRollback_1 main ] stop
				 */
				/**
				 * [tJDBCRollback_1 end ] start
				 */

				currentComponent = "tJDBCRollback_1";

				ok_Hash.put("tJDBCRollback_1", true);
				end_Hash.put("tJDBCRollback_1", System.currentTimeMillis());

				/**
				 * [tJDBCRollback_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCRollback_1 finally ] start
				 */

				currentComponent = "tJDBCRollback_1";

				/**
				 * [tJDBCRollback_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCRollback_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCCommit_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCCommit_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCCommit_1 begin ] start
				 */

				ok_Hash.put("tJDBCCommit_1", false);
				start_Hash.put("tJDBCCommit_1", System.currentTimeMillis());

				currentComponent = "tJDBCCommit_1";

				int tos_count_tJDBCCommit_1 = 0;

				/**
				 * [tJDBCCommit_1 begin ] stop
				 */
				/**
				 * [tJDBCCommit_1 main ] start
				 */

				currentComponent = "tJDBCCommit_1";

				java.sql.Connection conn_tJDBCCommit_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (conn_tJDBCCommit_1 != null
						&& !conn_tJDBCCommit_1.isClosed()) {
					conn_tJDBCCommit_1.commit();
				}

				tos_count_tJDBCCommit_1++;

				/**
				 * [tJDBCCommit_1 main ] stop
				 */
				/**
				 * [tJDBCCommit_1 end ] start
				 */

				currentComponent = "tJDBCCommit_1";

				ok_Hash.put("tJDBCCommit_1", true);
				end_Hash.put("tJDBCCommit_1", System.currentTimeMillis());

				/**
				 * [tJDBCCommit_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCCommit_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCCommit_1 finally ] start
				 */

				currentComponent = "tJDBCCommit_1";

				/**
				 * [tJDBCCommit_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCCommit_1_SUBPROCESS_STATE", 1);
	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row2Struct row2 = new row2Struct();

				/**
				 * [tContextLoad_2 begin ] start
				 */

				ok_Hash.put("tContextLoad_2", false);
				start_Hash.put("tContextLoad_2", System.currentTimeMillis());

				currentComponent = "tContextLoad_2";

				int tos_count_tContextLoad_2 = 0;

				java.util.List<String> assignList_tContextLoad_2 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_2 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_2 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_2 = 0;

				/**
				 * [tContextLoad_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT 'deleteMore', '1'  FROM datacenter_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);
				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;
					int column_index_tJDBCInput_2 = 1;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						column_index_tJDBCInput_2 = 1;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row2.key = null;
						} else {

							tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
									.getString(column_index_tJDBCInput_2);
							if (tmpContent_tJDBCInput_2 != null) {
								row2.key = tmpContent_tJDBCInput_2;
							} else {
								row2.key = null;
							}

						}

						column_index_tJDBCInput_2 = 2;

						if (colQtyInRs_tJDBCInput_2 < column_index_tJDBCInput_2) {
							row2.value = null;
						} else {

							tmpContent_tJDBCInput_2 = rs_tJDBCInput_2
									.getString(column_index_tJDBCInput_2);
							if (tmpContent_tJDBCInput_2 != null) {
								row2.value = tmpContent_tJDBCInput_2;
							} else {
								row2.value = null;
							}

						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */
						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tContextLoad_2 main ] start
						 */

						currentComponent = "tContextLoad_2";

						// ////////////////////////
						String tmp_key_tContextLoad_2 = null;

						String key_tContextLoad_2 = null;
						if (row2.key != null) {
							tmp_key_tContextLoad_2 = row2.key.trim();
							if ((tmp_key_tContextLoad_2.startsWith("#") || tmp_key_tContextLoad_2
									.startsWith("!"))) {
								tmp_key_tContextLoad_2 = null;
							} else {
								row2.key = tmp_key_tContextLoad_2;
							}
						}
						if (row2.key != null) {

							key_tContextLoad_2 =

							row2.key;

						}

						String value_tContextLoad_2 = null;
						if (row2.value != null) {

							value_tContextLoad_2 =

							row2.value;

						}

						if (tmp_key_tContextLoad_2 != null) {
							try {
								if (key_tContextLoad_2 != null
										&& "deleteMore"
												.equals(key_tContextLoad_2)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_2);

								}

								if (key_tContextLoad_2 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_2)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_2);

								}

								if (key_tContextLoad_2 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_2)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_2);

								}

								if (key_tContextLoad_2 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_2)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_2);

								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineDbPassword = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineDbUser = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_2)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_2;
								}

								if (key_tContextLoad_2 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_2)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_2);

								}

								if (key_tContextLoad_2 != null
										&& "runTime".equals(key_tContextLoad_2)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_2));

								}

								if (context.getProperty(key_tContextLoad_2) != null) {
									assignList_tContextLoad_2
											.add(key_tContextLoad_2);
								} else {
									newPropertyList_tContextLoad_2
											.add(key_tContextLoad_2);
								}
								context.setProperty(key_tContextLoad_2,
										value_tContextLoad_2);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_2
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_2++;

						}
						// ////////////////////////

						tos_count_tContextLoad_2++;

						/**
						 * [tContextLoad_2 main ] stop
						 */

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					rs_tJDBCInput_2.close();
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tContextLoad_2 end ] start
				 */

				currentComponent = "tContextLoad_2";

				java.util.Enumeration<?> enu_tContextLoad_2 = context
						.propertyNames();
				while (enu_tContextLoad_2.hasMoreElements()) {
					String key_tContextLoad_2 = (String) enu_tContextLoad_2
							.nextElement();
					if (!assignList_tContextLoad_2.contains(key_tContextLoad_2)
							&& !newPropertyList_tContextLoad_2
									.contains(key_tContextLoad_2)) {
						noAssignList_tContextLoad_2.add(key_tContextLoad_2);
					}
				}

				String newPropertyStr_tContextLoad_2 = newPropertyList_tContextLoad_2
						.toString();
				String newProperty_tContextLoad_2 = newPropertyStr_tContextLoad_2
						.substring(1,
								newPropertyStr_tContextLoad_2.length() - 1);

				String noAssignStr_tContextLoad_2 = noAssignList_tContextLoad_2
						.toString();
				String noAssign_tContextLoad_2 = noAssignStr_tContextLoad_2
						.substring(1, noAssignStr_tContextLoad_2.length() - 1);

				globalMap.put("tContextLoad_2_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_2);
				globalMap.put("tContextLoad_2_KEY_NOT_LOADED",
						noAssign_tContextLoad_2);

				globalMap.put("tContextLoad_2_NB_LINE", nb_line_tContextLoad_2);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_2", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_2", true);
				end_Hash.put("tContextLoad_2", System.currentTimeMillis());

				/**
				 * [tContextLoad_2 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_4Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tContextLoad_2 finally ] start
				 */

				currentComponent = "tContextLoad_2";

				/**
				 * [tContextLoad_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row4Struct row4 = new row4Struct();

				/**
				 * [tContextLoad_4 begin ] start
				 */

				ok_Hash.put("tContextLoad_4", false);
				start_Hash.put("tContextLoad_4", System.currentTimeMillis());

				currentComponent = "tContextLoad_4";

				int tos_count_tContextLoad_4 = 0;

				java.util.List<String> assignList_tContextLoad_4 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_4 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_4 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_4 = 0;

				/**
				 * [tContextLoad_4 begin ] stop
				 */

				/**
				 * [tJDBCInput_4 begin ] start
				 */

				ok_Hash.put("tJDBCInput_4", false);
				start_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				currentComponent = "tJDBCInput_4";

				int tos_count_tJDBCInput_4 = 0;

				int nb_line_tJDBCInput_4 = 0;
				java.sql.Connection conn_tJDBCInput_4 = null;
				conn_tJDBCInput_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_4 = conn_tJDBCInput_4
						.createStatement();

				String dbquery_tJDBCInput_4 = "SELECT 'deleteMore', '1'  FROM storage_domain_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_4_QUERY", dbquery_tJDBCInput_4);
				java.sql.ResultSet rs_tJDBCInput_4 = null;
				try {
					rs_tJDBCInput_4 = stmt_tJDBCInput_4
							.executeQuery(dbquery_tJDBCInput_4);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_4 = rs_tJDBCInput_4
							.getMetaData();
					int colQtyInRs_tJDBCInput_4 = rsmd_tJDBCInput_4
							.getColumnCount();

					String tmpContent_tJDBCInput_4 = null;
					int column_index_tJDBCInput_4 = 1;

					while (rs_tJDBCInput_4.next()) {
						nb_line_tJDBCInput_4++;

						column_index_tJDBCInput_4 = 1;

						if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
							row4.key = null;
						} else {

							tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
									.getString(column_index_tJDBCInput_4);
							if (tmpContent_tJDBCInput_4 != null) {
								row4.key = tmpContent_tJDBCInput_4;
							} else {
								row4.key = null;
							}

						}

						column_index_tJDBCInput_4 = 2;

						if (colQtyInRs_tJDBCInput_4 < column_index_tJDBCInput_4) {
							row4.value = null;
						} else {

							tmpContent_tJDBCInput_4 = rs_tJDBCInput_4
									.getString(column_index_tJDBCInput_4);
							if (tmpContent_tJDBCInput_4 != null) {
								row4.value = tmpContent_tJDBCInput_4;
							} else {
								row4.value = null;
							}

						}

						/**
						 * [tJDBCInput_4 begin ] stop
						 */
						/**
						 * [tJDBCInput_4 main ] start
						 */

						currentComponent = "tJDBCInput_4";

						tos_count_tJDBCInput_4++;

						/**
						 * [tJDBCInput_4 main ] stop
						 */

						/**
						 * [tContextLoad_4 main ] start
						 */

						currentComponent = "tContextLoad_4";

						// ////////////////////////
						String tmp_key_tContextLoad_4 = null;

						String key_tContextLoad_4 = null;
						if (row4.key != null) {
							tmp_key_tContextLoad_4 = row4.key.trim();
							if ((tmp_key_tContextLoad_4.startsWith("#") || tmp_key_tContextLoad_4
									.startsWith("!"))) {
								tmp_key_tContextLoad_4 = null;
							} else {
								row4.key = tmp_key_tContextLoad_4;
							}
						}
						if (row4.key != null) {

							key_tContextLoad_4 =

							row4.key;

						}

						String value_tContextLoad_4 = null;
						if (row4.value != null) {

							value_tContextLoad_4 =

							row4.value;

						}

						if (tmp_key_tContextLoad_4 != null) {
							try {
								if (key_tContextLoad_4 != null
										&& "deleteMore"
												.equals(key_tContextLoad_4)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_4);

								}

								if (key_tContextLoad_4 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_4)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_4);

								}

								if (key_tContextLoad_4 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_4)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_4);

								}

								if (key_tContextLoad_4 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_4)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_4);

								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineDbPassword = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineDbUser = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_4)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_4;
								}

								if (key_tContextLoad_4 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_4)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_4);

								}

								if (key_tContextLoad_4 != null
										&& "runTime".equals(key_tContextLoad_4)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_4));

								}

								if (context.getProperty(key_tContextLoad_4) != null) {
									assignList_tContextLoad_4
											.add(key_tContextLoad_4);
								} else {
									newPropertyList_tContextLoad_4
											.add(key_tContextLoad_4);
								}
								context.setProperty(key_tContextLoad_4,
										value_tContextLoad_4);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_4
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_4++;

						}
						// ////////////////////////

						tos_count_tContextLoad_4++;

						/**
						 * [tContextLoad_4 main ] stop
						 */

						/**
						 * [tJDBCInput_4 end ] start
						 */

						currentComponent = "tJDBCInput_4";

					}
				} finally {
					rs_tJDBCInput_4.close();
					stmt_tJDBCInput_4.close();

				}
				globalMap.put("tJDBCInput_4_NB_LINE", nb_line_tJDBCInput_4);

				ok_Hash.put("tJDBCInput_4", true);
				end_Hash.put("tJDBCInput_4", System.currentTimeMillis());

				/**
				 * [tJDBCInput_4 end ] stop
				 */

				/**
				 * [tContextLoad_4 end ] start
				 */

				currentComponent = "tContextLoad_4";

				java.util.Enumeration<?> enu_tContextLoad_4 = context
						.propertyNames();
				while (enu_tContextLoad_4.hasMoreElements()) {
					String key_tContextLoad_4 = (String) enu_tContextLoad_4
							.nextElement();
					if (!assignList_tContextLoad_4.contains(key_tContextLoad_4)
							&& !newPropertyList_tContextLoad_4
									.contains(key_tContextLoad_4)) {
						noAssignList_tContextLoad_4.add(key_tContextLoad_4);
					}
				}

				String newPropertyStr_tContextLoad_4 = newPropertyList_tContextLoad_4
						.toString();
				String newProperty_tContextLoad_4 = newPropertyStr_tContextLoad_4
						.substring(1,
								newPropertyStr_tContextLoad_4.length() - 1);

				String noAssignStr_tContextLoad_4 = noAssignList_tContextLoad_4
						.toString();
				String noAssign_tContextLoad_4 = noAssignStr_tContextLoad_4
						.substring(1, noAssignStr_tContextLoad_4.length() - 1);

				globalMap.put("tContextLoad_4_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_4);
				globalMap.put("tContextLoad_4_KEY_NOT_LOADED",
						noAssign_tContextLoad_4);

				globalMap.put("tContextLoad_4_NB_LINE", nb_line_tContextLoad_4);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_4", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_4", true);
				end_Hash.put("tContextLoad_4", System.currentTimeMillis());

				/**
				 * [tContextLoad_4 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_4:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_9Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_4 finally ] start
				 */

				currentComponent = "tJDBCInput_4";

				/**
				 * [tJDBCInput_4 finally ] stop
				 */

				/**
				 * [tContextLoad_4 finally ] start
				 */

				currentComponent = "tContextLoad_4";

				/**
				 * [tContextLoad_4 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_4_SUBPROCESS_STATE", 1);
	}

	public static class row9Struct implements
			routines.system.IPersistableRow<row9Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row9Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_9Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row9Struct row9 = new row9Struct();

				/**
				 * [tContextLoad_9 begin ] start
				 */

				ok_Hash.put("tContextLoad_9", false);
				start_Hash.put("tContextLoad_9", System.currentTimeMillis());

				currentComponent = "tContextLoad_9";

				int tos_count_tContextLoad_9 = 0;

				java.util.List<String> assignList_tContextLoad_9 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_9 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_9 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_9 = 0;

				/**
				 * [tContextLoad_9 begin ] stop
				 */

				/**
				 * [tJDBCInput_9 begin ] start
				 */

				ok_Hash.put("tJDBCInput_9", false);
				start_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				currentComponent = "tJDBCInput_9";

				int tos_count_tJDBCInput_9 = 0;

				int nb_line_tJDBCInput_9 = 0;
				java.sql.Connection conn_tJDBCInput_9 = null;
				conn_tJDBCInput_9 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_9 = conn_tJDBCInput_9
						.createStatement();

				String dbquery_tJDBCInput_9 = "SELECT 'deleteMore', '1'  FROM host_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_9_QUERY", dbquery_tJDBCInput_9);
				java.sql.ResultSet rs_tJDBCInput_9 = null;
				try {
					rs_tJDBCInput_9 = stmt_tJDBCInput_9
							.executeQuery(dbquery_tJDBCInput_9);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_9 = rs_tJDBCInput_9
							.getMetaData();
					int colQtyInRs_tJDBCInput_9 = rsmd_tJDBCInput_9
							.getColumnCount();

					String tmpContent_tJDBCInput_9 = null;
					int column_index_tJDBCInput_9 = 1;

					while (rs_tJDBCInput_9.next()) {
						nb_line_tJDBCInput_9++;

						column_index_tJDBCInput_9 = 1;

						if (colQtyInRs_tJDBCInput_9 < column_index_tJDBCInput_9) {
							row9.key = null;
						} else {

							tmpContent_tJDBCInput_9 = rs_tJDBCInput_9
									.getString(column_index_tJDBCInput_9);
							if (tmpContent_tJDBCInput_9 != null) {
								row9.key = tmpContent_tJDBCInput_9;
							} else {
								row9.key = null;
							}

						}

						column_index_tJDBCInput_9 = 2;

						if (colQtyInRs_tJDBCInput_9 < column_index_tJDBCInput_9) {
							row9.value = null;
						} else {

							tmpContent_tJDBCInput_9 = rs_tJDBCInput_9
									.getString(column_index_tJDBCInput_9);
							if (tmpContent_tJDBCInput_9 != null) {
								row9.value = tmpContent_tJDBCInput_9;
							} else {
								row9.value = null;
							}

						}

						/**
						 * [tJDBCInput_9 begin ] stop
						 */
						/**
						 * [tJDBCInput_9 main ] start
						 */

						currentComponent = "tJDBCInput_9";

						tos_count_tJDBCInput_9++;

						/**
						 * [tJDBCInput_9 main ] stop
						 */

						/**
						 * [tContextLoad_9 main ] start
						 */

						currentComponent = "tContextLoad_9";

						// ////////////////////////
						String tmp_key_tContextLoad_9 = null;

						String key_tContextLoad_9 = null;
						if (row9.key != null) {
							tmp_key_tContextLoad_9 = row9.key.trim();
							if ((tmp_key_tContextLoad_9.startsWith("#") || tmp_key_tContextLoad_9
									.startsWith("!"))) {
								tmp_key_tContextLoad_9 = null;
							} else {
								row9.key = tmp_key_tContextLoad_9;
							}
						}
						if (row9.key != null) {

							key_tContextLoad_9 =

							row9.key;

						}

						String value_tContextLoad_9 = null;
						if (row9.value != null) {

							value_tContextLoad_9 =

							row9.value;

						}

						if (tmp_key_tContextLoad_9 != null) {
							try {
								if (key_tContextLoad_9 != null
										&& "deleteMore"
												.equals(key_tContextLoad_9)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_9);

								}

								if (key_tContextLoad_9 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_9)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_9);

								}

								if (key_tContextLoad_9 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_9)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_9);

								}

								if (key_tContextLoad_9 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_9)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_9);

								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineDbPassword = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineDbUser = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_9)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_9;
								}

								if (key_tContextLoad_9 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_9)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_9);

								}

								if (key_tContextLoad_9 != null
										&& "runTime".equals(key_tContextLoad_9)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_9));

								}

								if (context.getProperty(key_tContextLoad_9) != null) {
									assignList_tContextLoad_9
											.add(key_tContextLoad_9);
								} else {
									newPropertyList_tContextLoad_9
											.add(key_tContextLoad_9);
								}
								context.setProperty(key_tContextLoad_9,
										value_tContextLoad_9);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_9
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_9++;

						}
						// ////////////////////////

						tos_count_tContextLoad_9++;

						/**
						 * [tContextLoad_9 main ] stop
						 */

						/**
						 * [tJDBCInput_9 end ] start
						 */

						currentComponent = "tJDBCInput_9";

					}
				} finally {
					rs_tJDBCInput_9.close();
					stmt_tJDBCInput_9.close();

				}
				globalMap.put("tJDBCInput_9_NB_LINE", nb_line_tJDBCInput_9);

				ok_Hash.put("tJDBCInput_9", true);
				end_Hash.put("tJDBCInput_9", System.currentTimeMillis());

				/**
				 * [tJDBCInput_9 end ] stop
				 */

				/**
				 * [tContextLoad_9 end ] start
				 */

				currentComponent = "tContextLoad_9";

				java.util.Enumeration<?> enu_tContextLoad_9 = context
						.propertyNames();
				while (enu_tContextLoad_9.hasMoreElements()) {
					String key_tContextLoad_9 = (String) enu_tContextLoad_9
							.nextElement();
					if (!assignList_tContextLoad_9.contains(key_tContextLoad_9)
							&& !newPropertyList_tContextLoad_9
									.contains(key_tContextLoad_9)) {
						noAssignList_tContextLoad_9.add(key_tContextLoad_9);
					}
				}

				String newPropertyStr_tContextLoad_9 = newPropertyList_tContextLoad_9
						.toString();
				String newProperty_tContextLoad_9 = newPropertyStr_tContextLoad_9
						.substring(1,
								newPropertyStr_tContextLoad_9.length() - 1);

				String noAssignStr_tContextLoad_9 = noAssignList_tContextLoad_9
						.toString();
				String noAssign_tContextLoad_9 = noAssignStr_tContextLoad_9
						.substring(1, noAssignStr_tContextLoad_9.length() - 1);

				globalMap.put("tContextLoad_9_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_9);
				globalMap.put("tContextLoad_9_KEY_NOT_LOADED",
						noAssign_tContextLoad_9);

				globalMap.put("tContextLoad_9_NB_LINE", nb_line_tContextLoad_9);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_9", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_9", true);
				end_Hash.put("tContextLoad_9", System.currentTimeMillis());

				/**
				 * [tContextLoad_9 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_9:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_3Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_9 finally ] start
				 */

				currentComponent = "tJDBCInput_9";

				/**
				 * [tJDBCInput_9 finally ] stop
				 */

				/**
				 * [tContextLoad_9 finally ] start
				 */

				currentComponent = "tContextLoad_9";

				/**
				 * [tContextLoad_9 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_9_SUBPROCESS_STATE", 1);
	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();

				/**
				 * [tContextLoad_3 begin ] start
				 */

				ok_Hash.put("tContextLoad_3", false);
				start_Hash.put("tContextLoad_3", System.currentTimeMillis());

				currentComponent = "tContextLoad_3";

				int tos_count_tContextLoad_3 = 0;

				java.util.List<String> assignList_tContextLoad_3 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_3 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_3 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_3 = 0;

				/**
				 * [tContextLoad_3 begin ] stop
				 */

				/**
				 * [tJDBCInput_3 begin ] start
				 */

				ok_Hash.put("tJDBCInput_3", false);
				start_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				currentComponent = "tJDBCInput_3";

				int tos_count_tJDBCInput_3 = 0;

				int nb_line_tJDBCInput_3 = 0;
				java.sql.Connection conn_tJDBCInput_3 = null;
				conn_tJDBCInput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_3 = conn_tJDBCInput_3
						.createStatement();

				String dbquery_tJDBCInput_3 = "SELECT 'deleteMore', '1'  FROM host_interface_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_3_QUERY", dbquery_tJDBCInput_3);
				java.sql.ResultSet rs_tJDBCInput_3 = null;
				try {
					rs_tJDBCInput_3 = stmt_tJDBCInput_3
							.executeQuery(dbquery_tJDBCInput_3);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_3 = rs_tJDBCInput_3
							.getMetaData();
					int colQtyInRs_tJDBCInput_3 = rsmd_tJDBCInput_3
							.getColumnCount();

					String tmpContent_tJDBCInput_3 = null;
					int column_index_tJDBCInput_3 = 1;

					while (rs_tJDBCInput_3.next()) {
						nb_line_tJDBCInput_3++;

						column_index_tJDBCInput_3 = 1;

						if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
							row3.key = null;
						} else {

							tmpContent_tJDBCInput_3 = rs_tJDBCInput_3
									.getString(column_index_tJDBCInput_3);
							if (tmpContent_tJDBCInput_3 != null) {
								row3.key = tmpContent_tJDBCInput_3;
							} else {
								row3.key = null;
							}

						}

						column_index_tJDBCInput_3 = 2;

						if (colQtyInRs_tJDBCInput_3 < column_index_tJDBCInput_3) {
							row3.value = null;
						} else {

							tmpContent_tJDBCInput_3 = rs_tJDBCInput_3
									.getString(column_index_tJDBCInput_3);
							if (tmpContent_tJDBCInput_3 != null) {
								row3.value = tmpContent_tJDBCInput_3;
							} else {
								row3.value = null;
							}

						}

						/**
						 * [tJDBCInput_3 begin ] stop
						 */
						/**
						 * [tJDBCInput_3 main ] start
						 */

						currentComponent = "tJDBCInput_3";

						tos_count_tJDBCInput_3++;

						/**
						 * [tJDBCInput_3 main ] stop
						 */

						/**
						 * [tContextLoad_3 main ] start
						 */

						currentComponent = "tContextLoad_3";

						// ////////////////////////
						String tmp_key_tContextLoad_3 = null;

						String key_tContextLoad_3 = null;
						if (row3.key != null) {
							tmp_key_tContextLoad_3 = row3.key.trim();
							if ((tmp_key_tContextLoad_3.startsWith("#") || tmp_key_tContextLoad_3
									.startsWith("!"))) {
								tmp_key_tContextLoad_3 = null;
							} else {
								row3.key = tmp_key_tContextLoad_3;
							}
						}
						if (row3.key != null) {

							key_tContextLoad_3 =

							row3.key;

						}

						String value_tContextLoad_3 = null;
						if (row3.value != null) {

							value_tContextLoad_3 =

							row3.value;

						}

						if (tmp_key_tContextLoad_3 != null) {
							try {
								if (key_tContextLoad_3 != null
										&& "deleteMore"
												.equals(key_tContextLoad_3)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_3);

								}

								if (key_tContextLoad_3 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_3)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_3);

								}

								if (key_tContextLoad_3 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_3)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_3);

								}

								if (key_tContextLoad_3 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_3)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_3);

								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineDbPassword = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineDbUser = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_3)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_3;
								}

								if (key_tContextLoad_3 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_3)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_3);

								}

								if (key_tContextLoad_3 != null
										&& "runTime".equals(key_tContextLoad_3)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_3));

								}

								if (context.getProperty(key_tContextLoad_3) != null) {
									assignList_tContextLoad_3
											.add(key_tContextLoad_3);
								} else {
									newPropertyList_tContextLoad_3
											.add(key_tContextLoad_3);
								}
								context.setProperty(key_tContextLoad_3,
										value_tContextLoad_3);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_3
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_3++;

						}
						// ////////////////////////

						tos_count_tContextLoad_3++;

						/**
						 * [tContextLoad_3 main ] stop
						 */

						/**
						 * [tJDBCInput_3 end ] start
						 */

						currentComponent = "tJDBCInput_3";

					}
				} finally {
					rs_tJDBCInput_3.close();
					stmt_tJDBCInput_3.close();

				}
				globalMap.put("tJDBCInput_3_NB_LINE", nb_line_tJDBCInput_3);

				ok_Hash.put("tJDBCInput_3", true);
				end_Hash.put("tJDBCInput_3", System.currentTimeMillis());

				/**
				 * [tJDBCInput_3 end ] stop
				 */

				/**
				 * [tContextLoad_3 end ] start
				 */

				currentComponent = "tContextLoad_3";

				java.util.Enumeration<?> enu_tContextLoad_3 = context
						.propertyNames();
				while (enu_tContextLoad_3.hasMoreElements()) {
					String key_tContextLoad_3 = (String) enu_tContextLoad_3
							.nextElement();
					if (!assignList_tContextLoad_3.contains(key_tContextLoad_3)
							&& !newPropertyList_tContextLoad_3
									.contains(key_tContextLoad_3)) {
						noAssignList_tContextLoad_3.add(key_tContextLoad_3);
					}
				}

				String newPropertyStr_tContextLoad_3 = newPropertyList_tContextLoad_3
						.toString();
				String newProperty_tContextLoad_3 = newPropertyStr_tContextLoad_3
						.substring(1,
								newPropertyStr_tContextLoad_3.length() - 1);

				String noAssignStr_tContextLoad_3 = noAssignList_tContextLoad_3
						.toString();
				String noAssign_tContextLoad_3 = noAssignStr_tContextLoad_3
						.substring(1, noAssignStr_tContextLoad_3.length() - 1);

				globalMap.put("tContextLoad_3_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_3);
				globalMap.put("tContextLoad_3_KEY_NOT_LOADED",
						noAssign_tContextLoad_3);

				globalMap.put("tContextLoad_3_NB_LINE", nb_line_tContextLoad_3);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_3", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_3", true);
				end_Hash.put("tContextLoad_3", System.currentTimeMillis());

				/**
				 * [tContextLoad_3 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_3:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_8Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_3 finally ] start
				 */

				currentComponent = "tJDBCInput_3";

				/**
				 * [tJDBCInput_3 finally ] stop
				 */

				/**
				 * [tContextLoad_3 finally ] start
				 */

				currentComponent = "tContextLoad_3";

				/**
				 * [tContextLoad_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_3_SUBPROCESS_STATE", 1);
	}

	public static class row8Struct implements
			routines.system.IPersistableRow<row8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row8Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_8Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row8Struct row8 = new row8Struct();

				/**
				 * [tContextLoad_8 begin ] start
				 */

				ok_Hash.put("tContextLoad_8", false);
				start_Hash.put("tContextLoad_8", System.currentTimeMillis());

				currentComponent = "tContextLoad_8";

				int tos_count_tContextLoad_8 = 0;

				java.util.List<String> assignList_tContextLoad_8 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_8 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_8 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_8 = 0;

				/**
				 * [tContextLoad_8 begin ] stop
				 */

				/**
				 * [tJDBCInput_8 begin ] start
				 */

				ok_Hash.put("tJDBCInput_8", false);
				start_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				currentComponent = "tJDBCInput_8";

				int tos_count_tJDBCInput_8 = 0;

				int nb_line_tJDBCInput_8 = 0;
				java.sql.Connection conn_tJDBCInput_8 = null;
				conn_tJDBCInput_8 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_8 = conn_tJDBCInput_8
						.createStatement();

				String dbquery_tJDBCInput_8 = "SELECT 'deleteMore', '1'  FROM vm_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_8_QUERY", dbquery_tJDBCInput_8);
				java.sql.ResultSet rs_tJDBCInput_8 = null;
				try {
					rs_tJDBCInput_8 = stmt_tJDBCInput_8
							.executeQuery(dbquery_tJDBCInput_8);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_8 = rs_tJDBCInput_8
							.getMetaData();
					int colQtyInRs_tJDBCInput_8 = rsmd_tJDBCInput_8
							.getColumnCount();

					String tmpContent_tJDBCInput_8 = null;
					int column_index_tJDBCInput_8 = 1;

					while (rs_tJDBCInput_8.next()) {
						nb_line_tJDBCInput_8++;

						column_index_tJDBCInput_8 = 1;

						if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
							row8.key = null;
						} else {

							tmpContent_tJDBCInput_8 = rs_tJDBCInput_8
									.getString(column_index_tJDBCInput_8);
							if (tmpContent_tJDBCInput_8 != null) {
								row8.key = tmpContent_tJDBCInput_8;
							} else {
								row8.key = null;
							}

						}

						column_index_tJDBCInput_8 = 2;

						if (colQtyInRs_tJDBCInput_8 < column_index_tJDBCInput_8) {
							row8.value = null;
						} else {

							tmpContent_tJDBCInput_8 = rs_tJDBCInput_8
									.getString(column_index_tJDBCInput_8);
							if (tmpContent_tJDBCInput_8 != null) {
								row8.value = tmpContent_tJDBCInput_8;
							} else {
								row8.value = null;
							}

						}

						/**
						 * [tJDBCInput_8 begin ] stop
						 */
						/**
						 * [tJDBCInput_8 main ] start
						 */

						currentComponent = "tJDBCInput_8";

						tos_count_tJDBCInput_8++;

						/**
						 * [tJDBCInput_8 main ] stop
						 */

						/**
						 * [tContextLoad_8 main ] start
						 */

						currentComponent = "tContextLoad_8";

						// ////////////////////////
						String tmp_key_tContextLoad_8 = null;

						String key_tContextLoad_8 = null;
						if (row8.key != null) {
							tmp_key_tContextLoad_8 = row8.key.trim();
							if ((tmp_key_tContextLoad_8.startsWith("#") || tmp_key_tContextLoad_8
									.startsWith("!"))) {
								tmp_key_tContextLoad_8 = null;
							} else {
								row8.key = tmp_key_tContextLoad_8;
							}
						}
						if (row8.key != null) {

							key_tContextLoad_8 =

							row8.key;

						}

						String value_tContextLoad_8 = null;
						if (row8.value != null) {

							value_tContextLoad_8 =

							row8.value;

						}

						if (tmp_key_tContextLoad_8 != null) {
							try {
								if (key_tContextLoad_8 != null
										&& "deleteMore"
												.equals(key_tContextLoad_8)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_8);

								}

								if (key_tContextLoad_8 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_8)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_8);

								}

								if (key_tContextLoad_8 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_8)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_8);

								}

								if (key_tContextLoad_8 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_8)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_8);

								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineDbPassword = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineDbUser = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_8)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_8;
								}

								if (key_tContextLoad_8 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_8)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_8);

								}

								if (key_tContextLoad_8 != null
										&& "runTime".equals(key_tContextLoad_8)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_8));

								}

								if (context.getProperty(key_tContextLoad_8) != null) {
									assignList_tContextLoad_8
											.add(key_tContextLoad_8);
								} else {
									newPropertyList_tContextLoad_8
											.add(key_tContextLoad_8);
								}
								context.setProperty(key_tContextLoad_8,
										value_tContextLoad_8);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_8
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_8++;

						}
						// ////////////////////////

						tos_count_tContextLoad_8++;

						/**
						 * [tContextLoad_8 main ] stop
						 */

						/**
						 * [tJDBCInput_8 end ] start
						 */

						currentComponent = "tJDBCInput_8";

					}
				} finally {
					rs_tJDBCInput_8.close();
					stmt_tJDBCInput_8.close();

				}
				globalMap.put("tJDBCInput_8_NB_LINE", nb_line_tJDBCInput_8);

				ok_Hash.put("tJDBCInput_8", true);
				end_Hash.put("tJDBCInput_8", System.currentTimeMillis());

				/**
				 * [tJDBCInput_8 end ] stop
				 */

				/**
				 * [tContextLoad_8 end ] start
				 */

				currentComponent = "tContextLoad_8";

				java.util.Enumeration<?> enu_tContextLoad_8 = context
						.propertyNames();
				while (enu_tContextLoad_8.hasMoreElements()) {
					String key_tContextLoad_8 = (String) enu_tContextLoad_8
							.nextElement();
					if (!assignList_tContextLoad_8.contains(key_tContextLoad_8)
							&& !newPropertyList_tContextLoad_8
									.contains(key_tContextLoad_8)) {
						noAssignList_tContextLoad_8.add(key_tContextLoad_8);
					}
				}

				String newPropertyStr_tContextLoad_8 = newPropertyList_tContextLoad_8
						.toString();
				String newProperty_tContextLoad_8 = newPropertyStr_tContextLoad_8
						.substring(1,
								newPropertyStr_tContextLoad_8.length() - 1);

				String noAssignStr_tContextLoad_8 = noAssignList_tContextLoad_8
						.toString();
				String noAssign_tContextLoad_8 = noAssignStr_tContextLoad_8
						.substring(1, noAssignStr_tContextLoad_8.length() - 1);

				globalMap.put("tContextLoad_8_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_8);
				globalMap.put("tContextLoad_8_KEY_NOT_LOADED",
						noAssign_tContextLoad_8);

				globalMap.put("tContextLoad_8_NB_LINE", nb_line_tContextLoad_8);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_8", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_8", true);
				end_Hash.put("tContextLoad_8", System.currentTimeMillis());

				/**
				 * [tContextLoad_8 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_8:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_6Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_8 finally ] start
				 */

				currentComponent = "tJDBCInput_8";

				/**
				 * [tJDBCInput_8 finally ] stop
				 */

				/**
				 * [tContextLoad_8 finally ] start
				 */

				currentComponent = "tContextLoad_8";

				/**
				 * [tContextLoad_8 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_8_SUBPROCESS_STATE", 1);
	}

	public static class row6Struct implements
			routines.system.IPersistableRow<row6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row6Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row6Struct row6 = new row6Struct();

				/**
				 * [tContextLoad_6 begin ] start
				 */

				ok_Hash.put("tContextLoad_6", false);
				start_Hash.put("tContextLoad_6", System.currentTimeMillis());

				currentComponent = "tContextLoad_6";

				int tos_count_tContextLoad_6 = 0;

				java.util.List<String> assignList_tContextLoad_6 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_6 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_6 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_6 = 0;

				/**
				 * [tContextLoad_6 begin ] stop
				 */

				/**
				 * [tJDBCInput_6 begin ] start
				 */

				ok_Hash.put("tJDBCInput_6", false);
				start_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				currentComponent = "tJDBCInput_6";

				int tos_count_tJDBCInput_6 = 0;

				int nb_line_tJDBCInput_6 = 0;
				java.sql.Connection conn_tJDBCInput_6 = null;
				conn_tJDBCInput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_6 = conn_tJDBCInput_6
						.createStatement();

				String dbquery_tJDBCInput_6 = "SELECT 'deleteMore', '1'  FROM vm_interface_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_6_QUERY", dbquery_tJDBCInput_6);
				java.sql.ResultSet rs_tJDBCInput_6 = null;
				try {
					rs_tJDBCInput_6 = stmt_tJDBCInput_6
							.executeQuery(dbquery_tJDBCInput_6);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_6 = rs_tJDBCInput_6
							.getMetaData();
					int colQtyInRs_tJDBCInput_6 = rsmd_tJDBCInput_6
							.getColumnCount();

					String tmpContent_tJDBCInput_6 = null;
					int column_index_tJDBCInput_6 = 1;

					while (rs_tJDBCInput_6.next()) {
						nb_line_tJDBCInput_6++;

						column_index_tJDBCInput_6 = 1;

						if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
							row6.key = null;
						} else {

							tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
									.getString(column_index_tJDBCInput_6);
							if (tmpContent_tJDBCInput_6 != null) {
								row6.key = tmpContent_tJDBCInput_6;
							} else {
								row6.key = null;
							}

						}

						column_index_tJDBCInput_6 = 2;

						if (colQtyInRs_tJDBCInput_6 < column_index_tJDBCInput_6) {
							row6.value = null;
						} else {

							tmpContent_tJDBCInput_6 = rs_tJDBCInput_6
									.getString(column_index_tJDBCInput_6);
							if (tmpContent_tJDBCInput_6 != null) {
								row6.value = tmpContent_tJDBCInput_6;
							} else {
								row6.value = null;
							}

						}

						/**
						 * [tJDBCInput_6 begin ] stop
						 */
						/**
						 * [tJDBCInput_6 main ] start
						 */

						currentComponent = "tJDBCInput_6";

						tos_count_tJDBCInput_6++;

						/**
						 * [tJDBCInput_6 main ] stop
						 */

						/**
						 * [tContextLoad_6 main ] start
						 */

						currentComponent = "tContextLoad_6";

						// ////////////////////////
						String tmp_key_tContextLoad_6 = null;

						String key_tContextLoad_6 = null;
						if (row6.key != null) {
							tmp_key_tContextLoad_6 = row6.key.trim();
							if ((tmp_key_tContextLoad_6.startsWith("#") || tmp_key_tContextLoad_6
									.startsWith("!"))) {
								tmp_key_tContextLoad_6 = null;
							} else {
								row6.key = tmp_key_tContextLoad_6;
							}
						}
						if (row6.key != null) {

							key_tContextLoad_6 =

							row6.key;

						}

						String value_tContextLoad_6 = null;
						if (row6.value != null) {

							value_tContextLoad_6 =

							row6.value;

						}

						if (tmp_key_tContextLoad_6 != null) {
							try {
								if (key_tContextLoad_6 != null
										&& "deleteMore"
												.equals(key_tContextLoad_6)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_6);

								}

								if (key_tContextLoad_6 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_6)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_6);

								}

								if (key_tContextLoad_6 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_6)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_6);

								}

								if (key_tContextLoad_6 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_6)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_6);

								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineDbPassword = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineDbUser = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_6)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_6;
								}

								if (key_tContextLoad_6 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_6)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_6);

								}

								if (key_tContextLoad_6 != null
										&& "runTime".equals(key_tContextLoad_6)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_6));

								}

								if (context.getProperty(key_tContextLoad_6) != null) {
									assignList_tContextLoad_6
											.add(key_tContextLoad_6);
								} else {
									newPropertyList_tContextLoad_6
											.add(key_tContextLoad_6);
								}
								context.setProperty(key_tContextLoad_6,
										value_tContextLoad_6);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_6
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_6++;

						}
						// ////////////////////////

						tos_count_tContextLoad_6++;

						/**
						 * [tContextLoad_6 main ] stop
						 */

						/**
						 * [tJDBCInput_6 end ] start
						 */

						currentComponent = "tJDBCInput_6";

					}
				} finally {
					rs_tJDBCInput_6.close();
					stmt_tJDBCInput_6.close();

				}
				globalMap.put("tJDBCInput_6_NB_LINE", nb_line_tJDBCInput_6);

				ok_Hash.put("tJDBCInput_6", true);
				end_Hash.put("tJDBCInput_6", System.currentTimeMillis());

				/**
				 * [tJDBCInput_6 end ] stop
				 */

				/**
				 * [tContextLoad_6 end ] start
				 */

				currentComponent = "tContextLoad_6";

				java.util.Enumeration<?> enu_tContextLoad_6 = context
						.propertyNames();
				while (enu_tContextLoad_6.hasMoreElements()) {
					String key_tContextLoad_6 = (String) enu_tContextLoad_6
							.nextElement();
					if (!assignList_tContextLoad_6.contains(key_tContextLoad_6)
							&& !newPropertyList_tContextLoad_6
									.contains(key_tContextLoad_6)) {
						noAssignList_tContextLoad_6.add(key_tContextLoad_6);
					}
				}

				String newPropertyStr_tContextLoad_6 = newPropertyList_tContextLoad_6
						.toString();
				String newProperty_tContextLoad_6 = newPropertyStr_tContextLoad_6
						.substring(1,
								newPropertyStr_tContextLoad_6.length() - 1);

				String noAssignStr_tContextLoad_6 = noAssignList_tContextLoad_6
						.toString();
				String noAssign_tContextLoad_6 = noAssignStr_tContextLoad_6
						.substring(1, noAssignStr_tContextLoad_6.length() - 1);

				globalMap.put("tContextLoad_6_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_6);
				globalMap.put("tContextLoad_6_KEY_NOT_LOADED",
						noAssign_tContextLoad_6);

				globalMap.put("tContextLoad_6_NB_LINE", nb_line_tContextLoad_6);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_6", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_6", true);
				end_Hash.put("tContextLoad_6", System.currentTimeMillis());

				/**
				 * [tContextLoad_6 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_6:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_5Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_6 finally ] start
				 */

				currentComponent = "tJDBCInput_6";

				/**
				 * [tJDBCInput_6 finally ] stop
				 */

				/**
				 * [tContextLoad_6 finally ] start
				 */

				currentComponent = "tContextLoad_6";

				/**
				 * [tContextLoad_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_6_SUBPROCESS_STATE", 1);
	}

	public static class row5Struct implements
			routines.system.IPersistableRow<row5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row5Struct row5 = new row5Struct();

				/**
				 * [tContextLoad_5 begin ] start
				 */

				ok_Hash.put("tContextLoad_5", false);
				start_Hash.put("tContextLoad_5", System.currentTimeMillis());

				currentComponent = "tContextLoad_5";

				int tos_count_tContextLoad_5 = 0;

				java.util.List<String> assignList_tContextLoad_5 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_5 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_5 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_5 = 0;

				/**
				 * [tContextLoad_5 begin ] stop
				 */

				/**
				 * [tJDBCInput_5 begin ] start
				 */

				ok_Hash.put("tJDBCInput_5", false);
				start_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				currentComponent = "tJDBCInput_5";

				int tos_count_tJDBCInput_5 = 0;

				int nb_line_tJDBCInput_5 = 0;
				java.sql.Connection conn_tJDBCInput_5 = null;
				conn_tJDBCInput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_5 = conn_tJDBCInput_5
						.createStatement();

				String dbquery_tJDBCInput_5 = "SELECT 'deleteMore', '1'  FROM vm_disk_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_5_QUERY", dbquery_tJDBCInput_5);
				java.sql.ResultSet rs_tJDBCInput_5 = null;
				try {
					rs_tJDBCInput_5 = stmt_tJDBCInput_5
							.executeQuery(dbquery_tJDBCInput_5);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_5 = rs_tJDBCInput_5
							.getMetaData();
					int colQtyInRs_tJDBCInput_5 = rsmd_tJDBCInput_5
							.getColumnCount();

					String tmpContent_tJDBCInput_5 = null;
					int column_index_tJDBCInput_5 = 1;

					while (rs_tJDBCInput_5.next()) {
						nb_line_tJDBCInput_5++;

						column_index_tJDBCInput_5 = 1;

						if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
							row5.key = null;
						} else {

							tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
									.getString(column_index_tJDBCInput_5);
							if (tmpContent_tJDBCInput_5 != null) {
								row5.key = tmpContent_tJDBCInput_5;
							} else {
								row5.key = null;
							}

						}

						column_index_tJDBCInput_5 = 2;

						if (colQtyInRs_tJDBCInput_5 < column_index_tJDBCInput_5) {
							row5.value = null;
						} else {

							tmpContent_tJDBCInput_5 = rs_tJDBCInput_5
									.getString(column_index_tJDBCInput_5);
							if (tmpContent_tJDBCInput_5 != null) {
								row5.value = tmpContent_tJDBCInput_5;
							} else {
								row5.value = null;
							}

						}

						/**
						 * [tJDBCInput_5 begin ] stop
						 */
						/**
						 * [tJDBCInput_5 main ] start
						 */

						currentComponent = "tJDBCInput_5";

						tos_count_tJDBCInput_5++;

						/**
						 * [tJDBCInput_5 main ] stop
						 */

						/**
						 * [tContextLoad_5 main ] start
						 */

						currentComponent = "tContextLoad_5";

						// ////////////////////////
						String tmp_key_tContextLoad_5 = null;

						String key_tContextLoad_5 = null;
						if (row5.key != null) {
							tmp_key_tContextLoad_5 = row5.key.trim();
							if ((tmp_key_tContextLoad_5.startsWith("#") || tmp_key_tContextLoad_5
									.startsWith("!"))) {
								tmp_key_tContextLoad_5 = null;
							} else {
								row5.key = tmp_key_tContextLoad_5;
							}
						}
						if (row5.key != null) {

							key_tContextLoad_5 =

							row5.key;

						}

						String value_tContextLoad_5 = null;
						if (row5.value != null) {

							value_tContextLoad_5 =

							row5.value;

						}

						if (tmp_key_tContextLoad_5 != null) {
							try {
								if (key_tContextLoad_5 != null
										&& "deleteMore"
												.equals(key_tContextLoad_5)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_5);

								}

								if (key_tContextLoad_5 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_5)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_5);

								}

								if (key_tContextLoad_5 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_5)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_5);

								}

								if (key_tContextLoad_5 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_5)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_5);

								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineDbPassword = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineDbUser = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_5)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_5;
								}

								if (key_tContextLoad_5 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_5)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_5);

								}

								if (key_tContextLoad_5 != null
										&& "runTime".equals(key_tContextLoad_5)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_5));

								}

								if (context.getProperty(key_tContextLoad_5) != null) {
									assignList_tContextLoad_5
											.add(key_tContextLoad_5);
								} else {
									newPropertyList_tContextLoad_5
											.add(key_tContextLoad_5);
								}
								context.setProperty(key_tContextLoad_5,
										value_tContextLoad_5);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_5
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_5++;

						}
						// ////////////////////////

						tos_count_tContextLoad_5++;

						/**
						 * [tContextLoad_5 main ] stop
						 */

						/**
						 * [tJDBCInput_5 end ] start
						 */

						currentComponent = "tJDBCInput_5";

					}
				} finally {
					rs_tJDBCInput_5.close();
					stmt_tJDBCInput_5.close();

				}
				globalMap.put("tJDBCInput_5_NB_LINE", nb_line_tJDBCInput_5);

				ok_Hash.put("tJDBCInput_5", true);
				end_Hash.put("tJDBCInput_5", System.currentTimeMillis());

				/**
				 * [tJDBCInput_5 end ] stop
				 */

				/**
				 * [tContextLoad_5 end ] start
				 */

				currentComponent = "tContextLoad_5";

				java.util.Enumeration<?> enu_tContextLoad_5 = context
						.propertyNames();
				while (enu_tContextLoad_5.hasMoreElements()) {
					String key_tContextLoad_5 = (String) enu_tContextLoad_5
							.nextElement();
					if (!assignList_tContextLoad_5.contains(key_tContextLoad_5)
							&& !newPropertyList_tContextLoad_5
									.contains(key_tContextLoad_5)) {
						noAssignList_tContextLoad_5.add(key_tContextLoad_5);
					}
				}

				String newPropertyStr_tContextLoad_5 = newPropertyList_tContextLoad_5
						.toString();
				String newProperty_tContextLoad_5 = newPropertyStr_tContextLoad_5
						.substring(1,
								newPropertyStr_tContextLoad_5.length() - 1);

				String noAssignStr_tContextLoad_5 = noAssignList_tContextLoad_5
						.toString();
				String noAssign_tContextLoad_5 = noAssignStr_tContextLoad_5
						.substring(1, noAssignStr_tContextLoad_5.length() - 1);

				globalMap.put("tContextLoad_5_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_5);
				globalMap.put("tContextLoad_5_KEY_NOT_LOADED",
						noAssign_tContextLoad_5);

				globalMap.put("tContextLoad_5_NB_LINE", nb_line_tContextLoad_5);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_5", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_5", true);
				end_Hash.put("tContextLoad_5", System.currentTimeMillis());

				/**
				 * [tContextLoad_5 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_5:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCInput_7Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_5 finally ] start
				 */

				currentComponent = "tJDBCInput_5";

				/**
				 * [tJDBCInput_5 finally ] stop
				 */

				/**
				 * [tContextLoad_5 finally ] start
				 */

				currentComponent = "tContextLoad_5";

				/**
				 * [tContextLoad_5 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_5_SUBPROCESS_STATE", 1);
	}

	public static class row7Struct implements
			routines.system.IPersistableRow<row7Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row7Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_7Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row7Struct row7 = new row7Struct();

				/**
				 * [tContextLoad_7 begin ] start
				 */

				ok_Hash.put("tContextLoad_7", false);
				start_Hash.put("tContextLoad_7", System.currentTimeMillis());

				currentComponent = "tContextLoad_7";

				int tos_count_tContextLoad_7 = 0;

				java.util.List<String> assignList_tContextLoad_7 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_7 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_7 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_7 = 0;

				/**
				 * [tContextLoad_7 begin ] stop
				 */

				/**
				 * [tJDBCInput_7 begin ] start
				 */

				ok_Hash.put("tJDBCInput_7", false);
				start_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				currentComponent = "tJDBCInput_7";

				int tos_count_tJDBCInput_7 = 0;

				int nb_line_tJDBCInput_7 = 0;
				java.sql.Connection conn_tJDBCInput_7 = null;
				conn_tJDBCInput_7 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_7 = conn_tJDBCInput_7
						.createStatement();

				String dbquery_tJDBCInput_7 = "SELECT 'deleteMore', '1'  FROM vm_disks_usage_samples_history  WHERE history_datetime < '"
						+ new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ")
								.format(TalendDate.addDate(context.runTime,
										context.hoursToKeepSamples * -1, "HH"))
						+ "' LIMIT 1";

				globalMap.put("tJDBCInput_7_QUERY", dbquery_tJDBCInput_7);
				java.sql.ResultSet rs_tJDBCInput_7 = null;
				try {
					rs_tJDBCInput_7 = stmt_tJDBCInput_7
							.executeQuery(dbquery_tJDBCInput_7);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_7 = rs_tJDBCInput_7
							.getMetaData();
					int colQtyInRs_tJDBCInput_7 = rsmd_tJDBCInput_7
							.getColumnCount();

					String tmpContent_tJDBCInput_7 = null;
					int column_index_tJDBCInput_7 = 1;

					while (rs_tJDBCInput_7.next()) {
						nb_line_tJDBCInput_7++;

						column_index_tJDBCInput_7 = 1;

						if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
							row7.key = null;
						} else {

							tmpContent_tJDBCInput_7 = rs_tJDBCInput_7
									.getString(column_index_tJDBCInput_7);
							if (tmpContent_tJDBCInput_7 != null) {
								row7.key = tmpContent_tJDBCInput_7;
							} else {
								row7.key = null;
							}

						}

						column_index_tJDBCInput_7 = 2;

						if (colQtyInRs_tJDBCInput_7 < column_index_tJDBCInput_7) {
							row7.value = null;
						} else {

							tmpContent_tJDBCInput_7 = rs_tJDBCInput_7
									.getString(column_index_tJDBCInput_7);
							if (tmpContent_tJDBCInput_7 != null) {
								row7.value = tmpContent_tJDBCInput_7;
							} else {
								row7.value = null;
							}

						}

						/**
						 * [tJDBCInput_7 begin ] stop
						 */
						/**
						 * [tJDBCInput_7 main ] start
						 */

						currentComponent = "tJDBCInput_7";

						tos_count_tJDBCInput_7++;

						/**
						 * [tJDBCInput_7 main ] stop
						 */

						/**
						 * [tContextLoad_7 main ] start
						 */

						currentComponent = "tContextLoad_7";

						// ////////////////////////
						String tmp_key_tContextLoad_7 = null;

						String key_tContextLoad_7 = null;
						if (row7.key != null) {
							tmp_key_tContextLoad_7 = row7.key.trim();
							if ((tmp_key_tContextLoad_7.startsWith("#") || tmp_key_tContextLoad_7
									.startsWith("!"))) {
								tmp_key_tContextLoad_7 = null;
							} else {
								row7.key = tmp_key_tContextLoad_7;
							}
						}
						if (row7.key != null) {

							key_tContextLoad_7 =

							row7.key;

						}

						String value_tContextLoad_7 = null;
						if (row7.value != null) {

							value_tContextLoad_7 =

							row7.value;

						}

						if (tmp_key_tContextLoad_7 != null) {
							try {
								if (key_tContextLoad_7 != null
										&& "deleteMore"
												.equals(key_tContextLoad_7)) {

									context.deleteMore = Integer
											.parseInt(value_tContextLoad_7);

								}

								if (key_tContextLoad_7 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_7)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_7);

								}

								if (key_tContextLoad_7 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_7)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_7);

								}

								if (key_tContextLoad_7 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_7)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_7);

								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineDbPassword = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineDbUser = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_7)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_7;
								}

								if (key_tContextLoad_7 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_7)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_7);

								}

								if (key_tContextLoad_7 != null
										&& "runTime".equals(key_tContextLoad_7)) {
									String context_runTime_value = context
											.getProperty("runTime");
									if (context_runTime_value == null)
										context_runTime_value = "";
									int context_runTime_pos = context_runTime_value
											.indexOf(";");
									String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_runTime_pos > -1) {
										context_runTime_pattern = context_runTime_value
												.substring(0,
														context_runTime_pos);
									}
									context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
											context_runTime_pattern)
											.parse(value_tContextLoad_7));

								}

								if (context.getProperty(key_tContextLoad_7) != null) {
									assignList_tContextLoad_7
											.add(key_tContextLoad_7);
								} else {
									newPropertyList_tContextLoad_7
											.add(key_tContextLoad_7);
								}
								context.setProperty(key_tContextLoad_7,
										value_tContextLoad_7);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_7
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_7++;

						}
						// ////////////////////////

						tos_count_tContextLoad_7++;

						/**
						 * [tContextLoad_7 main ] stop
						 */

						/**
						 * [tJDBCInput_7 end ] start
						 */

						currentComponent = "tJDBCInput_7";

					}
				} finally {
					rs_tJDBCInput_7.close();
					stmt_tJDBCInput_7.close();

				}
				globalMap.put("tJDBCInput_7_NB_LINE", nb_line_tJDBCInput_7);

				ok_Hash.put("tJDBCInput_7", true);
				end_Hash.put("tJDBCInput_7", System.currentTimeMillis());

				/**
				 * [tJDBCInput_7 end ] stop
				 */

				/**
				 * [tContextLoad_7 end ] start
				 */

				currentComponent = "tContextLoad_7";

				java.util.Enumeration<?> enu_tContextLoad_7 = context
						.propertyNames();
				while (enu_tContextLoad_7.hasMoreElements()) {
					String key_tContextLoad_7 = (String) enu_tContextLoad_7
							.nextElement();
					if (!assignList_tContextLoad_7.contains(key_tContextLoad_7)
							&& !newPropertyList_tContextLoad_7
									.contains(key_tContextLoad_7)) {
						noAssignList_tContextLoad_7.add(key_tContextLoad_7);
					}
				}

				String newPropertyStr_tContextLoad_7 = newPropertyList_tContextLoad_7
						.toString();
				String newProperty_tContextLoad_7 = newPropertyStr_tContextLoad_7
						.substring(1,
								newPropertyStr_tContextLoad_7.length() - 1);

				String noAssignStr_tContextLoad_7 = noAssignList_tContextLoad_7
						.toString();
				String noAssign_tContextLoad_7 = noAssignStr_tContextLoad_7
						.substring(1, noAssignStr_tContextLoad_7.length() - 1);

				globalMap.put("tContextLoad_7_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_7);
				globalMap.put("tContextLoad_7_KEY_NOT_LOADED",
						noAssign_tContextLoad_7);

				globalMap.put("tContextLoad_7_NB_LINE", nb_line_tContextLoad_7);

				resumeUtil.addLog("NODE", "NODE:tContextLoad_7", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context));

				ok_Hash.put("tContextLoad_7", true);
				end_Hash.put("tContextLoad_7", System.currentTimeMillis());

				/**
				 * [tContextLoad_7 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_7 finally ] start
				 */

				currentComponent = "tJDBCInput_7";

				/**
				 * [tJDBCInput_7 finally ] stop
				 */

				/**
				 * [tContextLoad_7 finally ] start
				 */

				currentComponent = "tContextLoad_7";

				/**
				 * [tContextLoad_7 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_7_SUBPROCESS_STATE", 1);
	}

	public static class event_outputStruct implements
			routines.system.IPersistableRow<event_outputStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public java.util.Date log_time;

		public java.util.Date getLog_time() {
			return this.log_time;
		}

		public String log_type_name;

		public String getLog_type_name() {
			return this.log_type_name;
		}

		public int log_type;

		public int getLog_type() {
			return this.log_type;
		}

		public int severity;

		public int getSeverity() {
			return this.severity;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.log_time = readDate(dis);

					this.log_type_name = readString(dis);

					this.log_type = dis.readInt();

					this.severity = dis.readInt();

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.log_time, dos);

				// String

				writeString(this.log_type_name, dos);

				// int

				dos.writeInt(this.log_type);

				// int

				dos.writeInt(this.severity);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("log_time=" + String.valueOf(log_time));
			sb.append(",log_type_name=" + log_type_name);
			sb.append(",log_type=" + String.valueOf(log_type));
			sb.append(",severity=" + String.valueOf(severity));
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(event_outputStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row10Struct implements
			routines.system.IPersistableRow<row10Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row10Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tLogCatcher_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tLogCatcher_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row10Struct row10 = new row10Struct();
				event_outputStruct event_output = new event_outputStruct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				int batchSize_tJDBCOutput_1 = 10000;
				int batchSizeCounter_tJDBCOutput_1 = 0;

				String insert_tJDBCOutput_1 = "INSERT INTO "
						+ "audit_log"
						+ " (log_time,log_type_name,log_type,severity,message) VALUES (?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(insert_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tMap_1 begin ] start
				 */

				ok_Hash.put("tMap_1", false);
				start_Hash.put("tMap_1", System.currentTimeMillis());

				currentComponent = "tMap_1";

				int tos_count_tMap_1 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_1__Struct {
				}
				Var__tMap_1__Struct Var__tMap_1 = new Var__tMap_1__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				event_outputStruct event_output_tmp = new event_outputStruct();
				// ###############################

				/**
				 * [tMap_1 begin ] stop
				 */

				/**
				 * [tLogCatcher_1 begin ] start
				 */

				ok_Hash.put("tLogCatcher_1", false);
				start_Hash.put("tLogCatcher_1", System.currentTimeMillis());

				currentComponent = "tLogCatcher_1";

				int tos_count_tLogCatcher_1 = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : tLogCatcher_1
						.getMessages()) {
					row10.type = lcm.getType();
					row10.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row10.priority = lcm.getPriority();
					row10.message = lcm.getMessage();
					row10.code = lcm.getCode();

					row10.moment = java.util.Calendar.getInstance().getTime();

					row10.pid = pid;
					row10.root_pid = rootPid;
					row10.father_pid = fatherPid;

					row10.project = projectName;
					row10.job = jobName;
					row10.context = contextStr;

					/**
					 * [tLogCatcher_1 begin ] stop
					 */
					/**
					 * [tLogCatcher_1 main ] start
					 */

					currentComponent = "tLogCatcher_1";

					tos_count_tLogCatcher_1++;

					/**
					 * [tLogCatcher_1 main ] stop
					 */

					/**
					 * [tMap_1 main ] start
					 */

					currentComponent = "tMap_1";

					boolean hasCasePrimitiveKeyWithNull_tMap_1 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_1 = false;
					boolean mainRowRejected_tMap_1 = false;

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_1__Struct Var = Var__tMap_1;// ###############################
						// ###############################
						// # Output tables

						event_output = null;

						// # Output table : 'event_output'
						event_output_tmp.log_time = row10.moment;
						event_output_tmp.log_type_name = "DWH_ERROR";
						event_output_tmp.log_type = 9704;
						event_output_tmp.severity = 2;
						event_output_tmp.message = "ETL service has encountered an error while deleting old data. Please consult the service log for more details.";
						event_output = event_output_tmp;
						// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_1 = false;

					tos_count_tMap_1++;

					/**
					 * [tMap_1 main ] stop
					 */
					// Start of branch "event_output"
					if (event_output != null) {

						/**
						 * [tJDBCOutput_1 main ] start
						 */

						currentComponent = "tJDBCOutput_1";

						whetherReject_tJDBCOutput_1 = false;
						if (event_output.log_time != null) {
							pstmt_tJDBCOutput_1.setTimestamp(1,
									new java.sql.Timestamp(
											event_output.log_time.getTime()));
						} else {
							pstmt_tJDBCOutput_1.setNull(1, java.sql.Types.DATE);
						}

						if (event_output.log_type_name == null) {
							pstmt_tJDBCOutput_1.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1.setString(2,
									event_output.log_type_name);
						}

						pstmt_tJDBCOutput_1.setInt(3, event_output.log_type);

						pstmt_tJDBCOutput_1.setInt(4, event_output.severity);

						if (event_output.message == null) {
							pstmt_tJDBCOutput_1.setNull(5,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1.setString(5,
									event_output.message);
						}

						try {
							insertedCount_tJDBCOutput_1 = insertedCount_tJDBCOutput_1
									+ pstmt_tJDBCOutput_1.executeUpdate();
							nb_line_tJDBCOutput_1++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_1 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_1++;

						/**
						 * [tJDBCOutput_1 main ] stop
						 */

					} // End of branch "event_output"

					/**
					 * [tLogCatcher_1 end ] start
					 */

					currentComponent = "tLogCatcher_1";

				}

				ok_Hash.put("tLogCatcher_1", true);
				end_Hash.put("tLogCatcher_1", System.currentTimeMillis());

				/**
				 * [tLogCatcher_1 end ] stop
				 */

				/**
				 * [tMap_1 end ] start
				 */

				currentComponent = "tMap_1";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_1", true);
				end_Hash.put("tMap_1", System.currentTimeMillis());

				/**
				 * [tMap_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tLogCatcher_1 finally ] start
				 */

				currentComponent = "tLogCatcher_1";

				/**
				 * [tLogCatcher_1 finally ] stop
				 */

				/**
				 * [tMap_1 finally ] start
				 */

				currentComponent = "tMap_1";

				/**
				 * [tMap_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_1 finally ] start
				 */

				currentComponent = "tJDBCOutput_1";

				/**
				 * [tJDBCOutput_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tLogCatcher_1_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_DeleteTimeKeepingJob) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";
		int iterateLoop = 0;
		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */
					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}

					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private SyncInt runningThreadCount = new SyncInt();

	private class SyncInt {
		private int count = 0;

		public synchronized void add(int i) {
			count += i;
		}

		public synchronized int getCount() {
			return count;
		}
	}

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final DeleteTimeKeepingJob DeleteTimeKeepingJobClass = new DeleteTimeKeepingJob();

		int exitCode = DeleteTimeKeepingJobClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = DeleteTimeKeepingJob.class
					.getClassLoader().getResourceAsStream(
							"ovirt_engine_dwh/deletetimekeepingjob_3_5/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			try {
				context.deleteMore = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("deleteMore"));
			} catch (NumberFormatException e) {
				context.deleteMore = null;
			}
			try {
				context.hoursToKeepDaily = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepDaily"));
			} catch (NumberFormatException e) {
				context.hoursToKeepDaily = null;
			}
			try {
				context.hoursToKeepHourly = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepHourly"));
			} catch (NumberFormatException e) {
				context.hoursToKeepHourly = null;
			}
			try {
				context.hoursToKeepSamples = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepSamples"));
			} catch (NumberFormatException e) {
				context.hoursToKeepSamples = null;
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			context.ovirtEngineDbPassword = (java.lang.String) context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			context.ovirtEngineHistoryDbPassword = (java.lang.String) context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				context.runDeleteTime = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runDeleteTime"));
			} catch (NumberFormatException e) {
				context.runDeleteTime = null;
			}
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("deleteMore")) {
				context.deleteMore = (Integer) parentContextMap
						.get("deleteMore");
			}
			if (parentContextMap.containsKey("hoursToKeepDaily")) {
				context.hoursToKeepDaily = (Integer) parentContextMap
						.get("hoursToKeepDaily");
			}
			if (parentContextMap.containsKey("hoursToKeepHourly")) {
				context.hoursToKeepHourly = (Integer) parentContextMap
						.get("hoursToKeepHourly");
			}
			if (parentContextMap.containsKey("hoursToKeepSamples")) {
				context.hoursToKeepSamples = (Integer) parentContextMap
						.get("hoursToKeepSamples");
			}
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runDeleteTime")) {
				context.runDeleteTime = (Integer) parentContextMap
						.get("runDeleteTime");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "", resumeUtil.convertToJsonText(context));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		this.globalResumeTicket = false;// to run others jobs

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tJDBCConnection_2Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tJDBCConnection_2) {
					globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", -1);

					e_tJDBCConnection_2.printStackTrace();

				} catch (Error e_tJDBCConnection_2) {
					globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", -1);

					e_tJDBCConnection_2.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		while (runningThreadCount.getCount() > 0) {
			try {
				Thread.sleep(10);
			} catch (java.lang.Exception e) {
				e.printStackTrace();
			}
		}

		this.globalResumeTicket = true;// to run tPostJob

		try {
			errorCode = null;
			tPostjob_2Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPostjob_2) {
			globalMap.put("tPostjob_2_SUBPROCESS_STATE", -1);

			e_tPostjob_2.printStackTrace();

		}

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out
					.println((endUsedMemory - startUsedMemory)
							+ " bytes memory increase when running : DeleteTimeKeepingJob");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	public void destroy() {

	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\n", "\n" }, { "\\'", "\'" },
			{ "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" }, { "\\t", "\t" },
			{ "\\\\", "\\" } };

	private String replaceEscapeChars(String keyValue) {
		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}
		for (String[] strArray : escapeChars) {
			keyValue = keyValue.replace(strArray[0], strArray[1]);
		}
		return keyValue;
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 264910 characters generated by Talend Open Studio for Data Integration on the
 * June 7, 2015 12:43:21 PM IDT
 ************************************************************************************************/
