#!/bin/sh
# This file is in the public domain.
#
# Script for regenerating all autogenerated files.

# Usage: ./autogen.sh [--skip-gnulib]

skip_gnulib=false
while :; do
  case "$1" in
    --skip-gnulib) skip_gnulib=true; shift;;
    *) break ;;
  esac
done

if test $skip_gnulib = false; then
  if test -n "$GNULIB_SRCDIR"; then
    test -d "$GNULIB_SRCDIR" || {
      echo "*** GNULIB_SRCDIR is set but does not point to an existing directory." 1>&2
      exit 1
    }
  fi
  # Now it should contain a gnulib-tool.
  GNULIB_TOOL="$GNULIB_SRCDIR/gnulib-tool"
  test -f "$GNULIB_TOOL" || {
    echo "*** gnulib-tool not found." 1>&2
    exit 1
  }
  GNULIB_MODULES='
    alloca
    unistd
    get_ppid_of
    non-recursive-gnulib-prefix-hack
  '
  $GNULIB_TOOL --lib=libgnu --source-base=lib --m4-base=gnulib-m4 \
    --makefile-name=gnulib.mk \
    --import $GNULIB_MODULES
  build-aux/prefix-gnulib-mk --lib-name=libgnu lib/gnulib.mk
  $GNULIB_TOOL --copy-file build-aux/ar-lib; chmod a+x build-aux/ar-lib
  $GNULIB_TOOL --copy-file build-aux/config.guess; chmod a+x build-aux/config.guess
  $GNULIB_TOOL --copy-file build-aux/config.sub;   chmod a+x build-aux/config.sub
fi

aclocal -I m4 -I gnulib-m4
autoconf
autoheader && touch config.h.in
automake -a -c
rm -rf autom4te.cache
