# This file is processed when the IAR compiler is used for an assembler file

include(Compiler/IAR)

if("${CMAKE_ASM${ASM_DIALECT}_COMPILER_ARCHITECTURE_ID}" STREQUAL "ARM")
set(CMAKE_ASM_COMPILE_OBJECT  "<CMAKE_ASM_COMPILER> -S <SOURCE> <DEFINES> <INCLUDES> <FLAGS> -o <OBJECT>")
  __compiler_iar_ARM(ASM)
  set(CMAKE_ASM_SOURCE_FILE_EXTENSIONS s;asm;msa)

  string(APPEND CMAKE_ASM_FLAGS_INIT " ")
  string(APPEND CMAKE_ASM_FLAGS_DEBUG_INIT " -r")
  string(APPEND CMAKE_ASM_FLAGS_MINSIZEREL_INIT " -DNDEBUG")
  string(APPEND CMAKE_ASM_FLAGS_RELEASE_INIT " -DNDEBUG")
  string(APPEND CMAKE_ASM_FLAGS_RELWITHDEBINFO_INIT " -r -DNDEBUG")

elseif("${CMAKE_ASM${ASM_DIALECT}_COMPILER_ARCHITECTURE_ID}" STREQUAL "AVR")
  set(CMAKE_ASM_COMPILE_OBJECT  "<CMAKE_ASM_COMPILER> -S <SOURCE> <DEFINES> <INCLUDES> <FLAGS> -o <OBJECT>")
  __compiler_iar_AVR(ASM)
  set(CMAKE_ASM_SOURCE_FILE_EXTENSIONS s90;asm;msa)

endif()
