#ifndef _LWTUNNEL_H_
#define _LWTUNNEL_H_

#include <linux/types.h>

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE,
	LWTUNNEL_ENCAP_MPLS,
	LWTUNNEL_ENCAP_IP,
	LWTUNNEL_ENCAP_ILA,
	LWTUNNEL_ENCAP_IP6,
	__LWTUNNEL_ENCAP_MAX,
};

#define LWTUNNEL_ENCAP_MAX (__LWTUNNEL_ENCAP_MAX - 1)

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC,
	LWTUNNEL_IP_ID,
	LWTUNNEL_IP_DST,
	LWTUNNEL_IP_SRC,
	LWTUNNEL_IP_TTL,
	LWTUNNEL_IP_TOS,
	LWTUNNEL_IP_FLAGS,
	LWTUNNEL_IP_PAD,
	__LWTUNNEL_IP_MAX,
};

#define LWTUNNEL_IP_MAX (__LWTUNNEL_IP_MAX - 1)

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC,
	LWTUNNEL_IP6_ID,
	LWTUNNEL_IP6_DST,
	LWTUNNEL_IP6_SRC,
	LWTUNNEL_IP6_HOPLIMIT,
	LWTUNNEL_IP6_TC,
	LWTUNNEL_IP6_FLAGS,
	LWTUNNEL_IP6_PAD,
	__LWTUNNEL_IP6_MAX,
};

#define LWTUNNEL_IP6_MAX (__LWTUNNEL_IP6_MAX - 1)

#endif /* _LWTUNNEL_H_ */
