/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

public class QuadTree {
    private static final int cutOffSize = 4;
    private int size;
    private QuadNode root = new QuadNode();
    private QuadNode terminator;

    public QuadTree(int width, int height) {
        this.size = this.roundUpToPowerOf2(Math.max(width, height));
        this.terminator = new QuadNode();
        for (int i = 0; i < this.terminator.children.length; ++i) {
            this.terminator.children[i] = this.terminator;
        }
    }

    private int roundUpToPowerOf2(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public void add(int x, int y) {
        QuadNode current = this.root;
        int cellSize = this.size;
        while (cellSize > 4) {
            int yIndex;
            QuadNode next;
            int xIndex = x / (cellSize /= 2);
            if ((next = current.children[xIndex + 2 * (yIndex = y / cellSize)]) == null) {
                next = cellSize <= 4 ? this.terminator : new QuadNode();
                current.children[xIndex + 2 * yIndex] = next;
            }
            x -= cellSize * xIndex;
            y -= cellSize * yIndex;
            current = next;
        }
    }

    public int spaceAt(int x, int y) {
        QuadNode current = this.root;
        int cellSize = this.size;
        while (cellSize > 4) {
            int yIndex;
            QuadNode next;
            int xIndex = x / (cellSize /= 2);
            if ((next = current.children[xIndex + 2 * (yIndex = y / cellSize)]) == null) {
                return cellSize;
            }
            x -= cellSize * xIndex;
            y -= cellSize * yIndex;
            current = next;
        }
        return 0;
    }

    public static void main(String[] args) {
        int width = 15;
        int height = 17;
        QuadTree q = new QuadTree(width, height);
        q.add(0, 0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                System.out.printf("%02d ", q.spaceAt(x, y));
            }
            System.out.println();
        }
    }

    private static class QuadNode {
        public QuadNode[] children = new QuadNode[4];

        private QuadNode() {
        }
    }
}

