/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.LibId;
import com.sun.electric.database.Snapshot;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdMapper
implements Serializable {
    private final HashMap<LibId, LibId> libIdMap = new HashMap();
    private final HashMap<CellId, CellId> cellIdMap = new HashMap();
    private final HashMap<ExportId, ExportId> exportIdMap = new HashMap();

    public static IdMapper renameLibrary(Snapshot snapshot, LibId oldLibId, LibId newLibId) {
        IdMapper idMapper = new IdMapper();
        idMapper.libIdMap.put(oldLibId, newLibId);
        for (CellBackup cellBackup : snapshot.cellBackups) {
            int i;
            if (cellBackup == null || cellBackup.d.libId != oldLibId) continue;
            CellId oldCellId = cellBackup.d.cellId;
            CellId newCellId = newLibId.newCellId(null);
            idMapper.cellIdMap.put(oldCellId, newCellId);
            String[] externalIds = new String[cellBackup.exports.size()];
            for (i = 0; i < externalIds.length; ++i) {
                ImmutableExport e = (ImmutableExport)cellBackup.exports.get(i);
                externalIds[i] = e.exportId.externalId;
            }
            newCellId.newExportIds(externalIds);
            for (i = 0; i < externalIds.length; ++i) {
                idMapper.exportIdMap.put(((ImmutableExport)cellBackup.exports.get((int)i)).exportId, newCellId.findExportId(externalIds[i]));
            }
        }
        return idMapper;
    }

    public LibId get(LibId key) {
        LibId value = this.libIdMap.get(key);
        return value != null ? value : key;
    }

    public CellId get(CellId key) {
        CellId value = this.cellIdMap.get(key);
        return value != null ? value : key;
    }

    public ExportId get(ExportId key) {
        ExportId value = this.exportIdMap.get(key);
        return value != null ? value : key;
    }

    public Collection<CellId> getNewCellIds() {
        return this.cellIdMap.values();
    }

    public Collection<ExportId> getNewExportIds() {
        return this.exportIdMap.values();
    }
}

