/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.swtbot.designer;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.tests.swtbot.designer.bot.WindowBuilderWorkbenchBot;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;

@ExtendWith(value={LoggerExtension.class})
public abstract class AbstractSWTBotTest {
    protected static final Logger LOGGER = Logger.getLogger(AbstractSWTBotTest.class.getSimpleName());
    protected WindowBuilderWorkbenchBot bot;

    static {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream is = AbstractSWTBotTest.class.getResourceAsStream("WindowBuilder SWTBot Logging.properties");){
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        if (Display.getCurrent() != null) {
            Assertions.fail((String)"SWTBot test needs to run in a non-UI thread.\nMake sure that \"Run in UI thread\" is unchecked in your launch configuration or that useUIThread is set to false in the pom.xml\n");
        }
        this.bot = new WindowBuilderWorkbenchBot();
    }

    public static class LoggerExtension
    implements BeforeTestExecutionCallback {
        public void beforeTestExecution(ExtensionContext context) throws Exception {
            LOGGER.info(context.getRequiredTestClass().getSimpleName() + ":" + context.getDisplayName());
        }
    }
}

