/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.DesignContextMenuProvider;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;

public abstract class DesignerTestCase
extends Assertions {
    private static boolean m_firstDesignerTest = true;
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @RegisterExtension
    private LoggerExtension extension = new LoggerExtension();
    private int m_numberOfExceptionsDuringThisEditorSession = 0;
    private final ILogListener m_logListener = new ILogListener(){

        public void logging(IStatus status, String plugin) {
            ++DesignerTestCase.this.m_numberOfExceptionsDuringThisEditorSession;
        }
    };
    public static boolean m_getSource_ignoreSpaces = false;
    public static boolean m_getSource_ignoreSpacesCheck = false;

    @BeforeEach
    public void setUp() throws Exception {
        this.configureFirstTime();
    }

    @AfterEach
    public void clearMemoryLeaks() throws Exception {
        ((Map)ReflectionUtils.getFieldObject(ObjectInfoUtils.class, (String)"m_idToObjectInfo")).clear();
        ((Map)ReflectionUtils.getFieldObject(ObjectInfoUtils.class, (String)"m_objectInfoToId")).clear();
    }

    private void configureFirstTime() {
        this.configureEclipseWindowLocation();
        if (!m_firstDesignerTest) {
            return;
        }
        m_firstDesignerTest = false;
        EnvironmentUtils.setTestingTime((boolean)true);
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
        UIPlugin.getDefault().getPreferenceStore().setValue("ENABLE_ANIMATIONS", false);
        IPreferenceStore preferenceStore = EditorsPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue("spellingEnabled", false);
        TestUtils.closeAllViews();
    }

    private void configureEclipseWindowLocation() {
        int x = 450;
        int y = 0;
        Shell shell = Activator.getShell();
        Point shellLocation = shell.getLocation();
        if (shellLocation.x != x || shellLocation.y != y) {
            Rectangle clientArea = Display.getDefault().getClientArea();
            shell.setBounds(x, y, clientArea.width - x, clientArea.height - 300);
            DesignerTestCase.waitEventLoop(100, 10L);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.clearInstanceFields();
    }

    private void clearInstanceFields() throws Exception {
        this.clearInstanceFields(((Object)((Object)this)).getClass());
    }

    private void clearInstanceFields(Class<?> clazz) throws Exception {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            boolean isObject = Object.class.isAssignableFrom(field.getType());
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isObject && !isStatic && field.getName().indexOf(36) == -1) {
                field.setAccessible(true);
                field.set((Object)this, null);
            }
            ++n2;
        }
        if (clazz != DesignerTestCase.class) {
            this.clearInstanceFields(clazz.getSuperclass());
        }
    }

    protected final void addExceptionsListener() {
        this.m_numberOfExceptionsDuringThisEditorSession = 0;
        ILog log = DesignerPlugin.getDefault().getLog();
        log.addLogListener(this.m_logListener);
    }

    protected final void removeExceptionsListener() {
        ILog log = DesignerPlugin.getDefault().getLog();
        log.removeLogListener(this.m_logListener);
    }

    protected final void assertNoLoggedExceptions() {
        DesignerTestCase.assertEquals((int)0, (int)this.m_numberOfExceptionsDuringThisEditorSession, (String)"Check console for logged exceptions.");
    }

    protected static void assertInstanceOf(String expectedClassName, Object o) {
        DesignerTestCase.assertNotNull((Object)o, (String)(expectedClassName + " class expected, but 'null' found."));
        if (!ReflectionUtils.isSuccessorOf((Object)o, (String)expectedClassName)) {
            DesignerTestCase.fail((String)(expectedClassName + " class expected, but " + o.getClass().getName() + " found."));
        }
    }

    protected static void assertNotInstanceOf(Class<?> expectedClass, Object o) {
        DesignerTestCase.assertNotNull((Object)o);
        DesignerTestCase.assertFalse((boolean)expectedClass.isAssignableFrom(o.getClass()), (String)(expectedClass.getName() + " class expected, but " + o.getClass().getName() + " found."));
    }

    public static RGB getPixelRGB(Image image, int x, int y) {
        ImageData imageData = image.getImageData();
        int pixel = imageData.getPixel(x, y);
        return imageData.palette.getRGB(pixel);
    }

    public static void assertRGB(RGB rgb, int red, int green, int blue) {
        String message = rgb.toString();
        DesignerTestCase.assertEquals((int)rgb.red, (int)red, (String)message);
        DesignerTestCase.assertEquals((int)rgb.green, (int)green, (String)message);
        DesignerTestCase.assertEquals((int)rgb.blue, (int)blue, (String)message);
    }

    protected static String readProjectFileContent(String path) throws Exception {
        FileInputStream inputStream = new FileInputStream(path);
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    protected static String readResourceFileContent(String path) throws Exception {
        return DesignerTestCase.readFileContent("/resources/" + path);
    }

    protected static String readFileContent(String path) throws Exception {
        URL entry = Activator.getDefault().getBundle().getEntry(path);
        InputStream inputStream = entry.openStream();
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static String[] replace(String[] lines, String repl, String with) {
        String[] newLines = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            String s = lines[i];
            newLines[i] = s.replace(repl, with);
            ++i;
        }
        return newLines;
    }

    public static String getSource(String ... lines) {
        return DesignerTestCase.getSource(new String[][]{lines});
    }

    public static String getSource2(String[] lines_1, String[] lines_2) {
        return DesignerTestCase.getSource(new String[][]{lines_1, lines_2});
    }

    public static String getSource3(String[] lines_1, String[] lines_2, String[] lines_3) {
        return DesignerTestCase.getSource(new String[][]{lines_1, lines_2, lines_3});
    }

    public static String getSource(String[][] lines2) {
        StringBuffer buffer = new StringBuffer();
        String[][] stringArray = lines2;
        int n = lines2.length;
        int n2 = 0;
        while (n2 < n) {
            String[] lines = stringArray[n2];
            if (lines != null) {
                String[] stringArray2 = lines;
                int n3 = lines.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object line = stringArray2[n4];
                    if (!m_getSource_ignoreSpaces) {
                        int spaceCount = 0;
                        char[] cArray = ((String)line).toCharArray();
                        int n5 = cArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            char c = cArray[n6];
                            if (c != ' ') break;
                            ++spaceCount;
                            ++n6;
                        }
                        if (!m_getSource_ignoreSpacesCheck) {
                            DesignerTestCase.assertEquals((int)0, (int)(spaceCount % 2));
                            line = StringUtils.repeat((String)"\t", (int)(spaceCount / 2)) + ((String)line).substring(spaceCount);
                        } else {
                            int tabCount = spaceCount / 2;
                            line = StringUtils.repeat((String)"\t", (int)tabCount) + ((String)line).substring(2 * tabCount);
                        }
                    }
                    buffer.append((String)line);
                    buffer.append("\n");
                    ++n4;
                }
            }
            ++n2;
        }
        m_getSource_ignoreSpaces = false;
        m_getSource_ignoreSpacesCheck = false;
        return buffer.toString();
    }

    public static String[] getDoubleQuotes(String[] lines) {
        int i = 0;
        while (i < lines.length) {
            lines[i] = DesignerTestCase.getSourceDQ(lines[i]);
            ++i;
        }
        return lines;
    }

    public static String getSourceDQ(String s) {
        return s.replace("'", "\"");
    }

    public static String getSourceDQ(String ... lines) {
        String source = DesignerTestCase.getSource(lines);
        return source.replace("'", "\"");
    }

    protected static String getLinesForSourceDQ(String ... lines) {
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            buffer.append('\"');
            line = line.replace("\t", "  ");
            line = line.replace('\"', '\'');
            buffer.append(StringUtilities.escapeForJavaSource((String)line));
            buffer.append('\"');
            buffer.append(",\n");
            ++n2;
        }
        String result = buffer.toString();
        result = StringUtils.removeEnd((String)result, (String)",\n");
        return result;
    }

    protected static void waitEventLoop(int time) {
        DesignerTestCase.waitEventLoop(time, 0L);
    }

    public static void waitEventLoop(int time, long sleepMillis) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (Display.getCurrent().readAndDispatch()) {
            }
        } while (System.currentTimeMillis() - start < (long)time);
    }

    public static void animateOpenTypeSelection(SWTBot bot, String typeName, String buttonName) {
        SWTBotShell shellBot = bot.shell("Open type");
        SWTBot shell = shellBot.bot();
        SWTBotText filterText = shell.text();
        filterText.setText(typeName);
        final SWTBotTable typesTable = shell.table();
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return typesTable.rowCount() != 0;
            }

            public String getFailureMessage() {
                return "\"Open type\" dialog took too long to find types.";
            }
        });
        shell.button(buttonName).click();
    }

    protected static MenuManager getDesignerMenuManager() {
        MenuManager menuManager = new MenuManager();
        DesignContextMenuProvider.addGroups((IMenuManager)menuManager);
        return menuManager;
    }

    protected static IMenuManager findChildMenuManager(IContributionManager manager, String text) {
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            MenuManager managerChild;
            IContributionItem contributionItem = items[i];
            if (contributionItem instanceof MenuManager && (managerChild = (MenuManager)contributionItem).getMenuText().equals(text)) {
                return managerChild;
            }
            ++i;
        }
        return null;
    }

    protected static IAction findChildAction(IContributionManager manager, String text) {
        List<IAction> actions = DesignerTestCase.findChildActions(manager, text);
        return (IAction)GenericsUtils.getFirstOrNull(actions);
    }

    protected static List<IAction> findChildActions(IContributionManager manager, String text) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        text = DesignerTestCase.getNormalizedActionText(text);
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem actionContributionItem;
            IAction action;
            IContributionItem contributionItem = iContributionItemArray[n2];
            if (contributionItem instanceof ActionContributionItem && DesignerTestCase.getNormalizedActionText((action = (actionContributionItem = (ActionContributionItem)contributionItem).getAction()).getText()).equals(text)) {
                actions.add(action);
            }
            ++n2;
        }
        return actions;
    }

    private static String getNormalizedActionText(String text) {
        int index = text.indexOf(9);
        if (index != -1) {
            text = text.substring(0, index);
        }
        text = StringUtils.remove((String)text, (String)"&");
        return text;
    }

    protected static IAction findAction(List<?> actions, String text) {
        for (Object object : actions) {
            IAction action;
            if (!(object instanceof IAction) || !text.equals((action = (IAction)object).getText()) && !text.equals(action.getToolTipText())) continue;
            return action;
        }
        return null;
    }

    public static IMenuManager getContextMenu(ObjectInfo ... objectsArray) throws Exception {
        MenuManager manager = DesignerTestCase.getDesignerMenuManager();
        List<ObjectInfo> objects = List.of(objectsArray);
        ObjectInfo object = objectsArray[0];
        object.getBroadcastObject().addContextMenu(objects, object, (IMenuManager)manager);
        return manager;
    }

    public static List<Object> getSelectionActions_noSelection(ObjectInfo root) throws Exception {
        ArrayList<Object> actions = new ArrayList<Object>();
        List objects = Collections.emptyList();
        root.getBroadcastObject().addSelectionActions(objects, actions);
        return actions;
    }

    public static List<Object> getSelectionActions(ObjectInfo ... objectsArray) throws Exception {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (objectsArray.length != 0) {
            ObjectInfo object = objectsArray[0];
            List<ObjectInfo> objects = List.of(objectsArray);
            object.getBroadcastObject().addSelectionActions(objects, actions);
        }
        return actions;
    }

    protected static boolean notifySelecting(ObjectInfo object) throws Exception {
        boolean[] refresh = new boolean[1];
        object.getBroadcastObject().selecting(object, refresh);
        return refresh[0];
    }

    public class LoggerExtension
    implements BeforeTestExecutionCallback {
        public void beforeTestExecution(ExtensionContext context) throws Exception {
            DesignerTestCase.this.logger.info(context.getRequiredTestClass().getSimpleName() + ":" + context.getDisplayName());
        }
    }
}

