/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.menu;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuItemInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class MenuTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_MenuStylePresentation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Menu menuBar = new Menu(this, SWT.BAR);", "      setMenuBar(menuBar);", "    }", "    {", "      Menu popup = new Menu(this);", "      setMenu(popup);", "      {", "        MenuItem item = new MenuItem(popup, SWT.CASCADE);", "        {", "          Menu subMenu = new Menu(item);", "          item.setMenu(subMenu);", "        }", "      }", "    }", "  }", "}");
        shell.refresh();
        List menuChildren = shell.getChildren(MenuInfo.class);
        MenuInfo menuBar = (MenuInfo)menuChildren.get(0);
        MenuInfo menuPopup = (MenuInfo)menuChildren.get(1);
        MenuItemInfo item = (MenuItemInfo)menuPopup.getChildren(MenuItemInfo.class).get(0);
        MenuInfo menuCascade = (MenuInfo)item.getChildren(MenuInfo.class).get(0);
        MenuTest.assertNotSame((Object)menuBar.getPresentation().getIcon(), (Object)menuPopup.getPresentation().getIcon());
        MenuTest.assertNotSame((Object)menuPopup.getPresentation().getIcon(), (Object)menuCascade.getPresentation().getIcon());
        MenuTest.assertNotSame((Object)menuCascade.getPresentation().getIcon(), (Object)menuBar.getPresentation().getIcon());
    }

    @Test
    public void test_boundsBar() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu mainMenu = new Menu(this, SWT.BAR);", "    setMenuBar(mainMenu);", "  }", "}");
        shell.refresh();
        MenuInfo bar = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuTest.assertEquals((Object)bar.getBounds(), (Object)bar.getModelBounds());
    }

    @Test
    public void test_isBar() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu mainMenu = new Menu(this, SWT.BAR);", "    setMenuBar(mainMenu);", "  }", "}");
        shell.refresh();
        MenuInfo menu = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuTest.assertTrue((boolean)menu.isBar());
        MenuTest.assertFalse((boolean)menu.isPopup());
    }

    @Test
    public void test_isPopup() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menu = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuTest.assertTrue((boolean)menu.isPopup());
        MenuTest.assertFalse((boolean)menu.isBar());
    }

    @Test
    public void test_impl_IMenuInfo_no() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuTest.assertNull((Object)menuInfo.getAdapter(List.class));
    }

    @Test
    public void test_impl_IMenuInfo_bar() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        List itemInfos = menuInfo.getChildrenItems();
        IMenuInfo menuObject = (IMenuInfo)menuInfo.getAdapter(IMenuInfo.class);
        MenuTest.assertNotNull((Object)menuObject);
        MenuTest.assertSame((Object)menuInfo, (Object)menuObject.getModel());
        MenuTest.assertSame((Object)menuInfo.getImage(), (Object)menuObject.getImageDescriptor());
        MenuTest.assertSame((Object)menuInfo.getBounds(), (Object)menuObject.getBounds());
        MenuTest.assertTrue((boolean)menuObject.isHorizontal());
        List itemObjects = menuObject.getItems();
        MenuTest.assertEquals((int)1, (int)itemObjects.size());
        MenuTest.assertSame(itemInfos.get(0), (Object)((IMenuItemInfo)itemObjects.get(0)).getModel());
    }

    @Test
    public void test_impl_IMenuInfo_popup() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        IMenuInfo menuObject = (IMenuInfo)menuInfo.getAdapter(IMenuInfo.class);
        MenuTest.assertNotNull((Object)menuObject);
        MenuTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        MenuTest.assertSame((Object)menuInfo.getImage(), (Object)ReflectionUtils.getFieldObject((Object)menuObject.getImageDescriptor(), (String)"originalImage"));
        MenuTest.assertSame((Object)menuInfo.getBounds(), (Object)menuObject.getBounds());
        MenuTest.assertFalse((boolean)menuObject.isHorizontal());
    }

    @Test
    public void test_impl_IMenuPopupInfo_popup() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        IMenuInfo menuObject = (IMenuInfo)menuInfo.getAdapter(IMenuInfo.class);
        IMenuPopupInfo popupObject = (IMenuPopupInfo)menuInfo.getAdapter(IMenuPopupInfo.class);
        MenuTest.assertNotNull((Object)popupObject);
        MenuTest.assertSame((Object)menuInfo, (Object)popupObject.getModel());
        MenuTest.assertSame((Object)menuInfo.getPresentation().getIcon(), (Object)popupObject.getImageDescriptor());
        MenuTest.assertEquals((int)16, (int)popupObject.getBounds().width);
        MenuTest.assertEquals((int)16, (int)popupObject.getBounds().height);
        MenuTest.assertSame((Object)menuObject, (Object)popupObject.getMenu());
    }

    @Test
    public void test_IMenuInfo_create_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        Object button = MenuTest.createJavaInfo("org.eclipse.swt.widgets.Button");
        MenuTest.assertFalse((boolean)menuPolicy.validateCreate(button));
        Object itemInfo = MenuTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem");
        MenuTest.assertTrue((boolean)menuPolicy.validateCreate(itemInfo));
        menuPolicy.commandCreate(itemInfo, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem menuItem = new MenuItem(menu, SWT.NONE);", "      menuItem.setText('New Item');", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_create_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)menuInfo.getChildrenItems().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        Object newItemInfo = MenuTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem");
        MenuTest.assertTrue((boolean)menuPolicy.validateCreate((Object)itemInfo));
        menuPolicy.commandCreate(newItemInfo, (Object)itemInfo);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem menuItem = new MenuItem(menu, SWT.NONE);", "      menuItem.setText('New Item');", "    }", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_create_3() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        Object itemInfo = MenuTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem", "cascade");
        MenuTest.assertTrue((boolean)menuPolicy.validateCreate(itemInfo));
        menuPolicy.commandCreate(itemInfo, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem menuItem = new MenuItem(menu, SWT.CASCADE);", "      menuItem.setText('New SubMenu');", "      {", "        Menu menu_1 = new Menu(menuItem);", "        menuItem.setMenu(menu_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_paste_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo = (MenuItemInfo)menuInfo.getChildrenItems().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)itemInfo);
        List<JavaInfoMemento> mementoList = Collections.singletonList(memento);
        MenuTest.assertTrue((boolean)menuPolicy.validatePaste(mementoList));
        menuPolicy.commandPaste(mementoList, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "    {", "      MenuItem item = new MenuItem(menu, SWT.NONE);", "      item.setText('Item');", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_paste_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Button');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)buttonInfo);
        MenuTest.assertFalse((boolean)menuPolicy.validatePaste(Collections.singletonList(memento)));
    }

    @Test
    public void test_IMenuInfo_move_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item_1 = new MenuItem(menu, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      MenuItem item_2 = new MenuItem(menu, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo itemInfo_1 = (MenuItemInfo)menuInfo.getChildrenItems().get(0);
        MenuItemInfo itemInfo_2 = (MenuItemInfo)menuInfo.getChildrenItems().get(1);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        MenuTest.assertTrue((boolean)menuPolicy.validateMove((Object)itemInfo_2));
        menuPolicy.commandMove((Object)itemInfo_2, (Object)itemInfo_1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item_2 = new MenuItem(menu, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "    {", "      MenuItem item_1 = new MenuItem(menu, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_move_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Button');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        ControlInfo buttonInfo = (ControlInfo)shell.getChildrenControls().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        MenuTest.assertFalse((boolean)menuPolicy.validateMove((Object)buttonInfo));
    }

    @Test
    public void test_commandCreate_bar() throws Exception {
        final CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        final MenuInfo newMenuBar = (MenuInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, Menu.class, (CreationSupport)new ConstructorCreationSupport("bar", true));
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                newMenuBar.command_CREATE((WidgetInfo)shell);
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this, SWT.BAR);", "      setMenuBar(menu);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)newMenuBar.getAssociation();
        List associations = compoundAssociation.getAssociations();
        MenuTest.assertEquals((int)2, (int)associations.size());
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        MenuTest.assertSame((Object)newMenuBar, (Object)association.getJavaInfo());
        MenuTest.assertEquals((Object)"new Menu(this, SWT.BAR)", (Object)association.getSource());
        association = (InvocationChildAssociation)associations.get(1);
        MenuTest.assertSame((Object)newMenuBar, (Object)association.getJavaInfo());
        MenuTest.assertEquals((Object)"setMenuBar(menu)", (Object)association.getSource());
    }

    @Test
    public void test_commandCreate_popup() throws Exception {
        final CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        final MenuInfo newMenuPopup = (MenuInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, Menu.class, (CreationSupport)new ConstructorCreationSupport());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                newMenuPopup.command_CREATE((WidgetInfo)shell);
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)newMenuPopup.getAssociation();
        List associations = compoundAssociation.getAssociations();
        MenuTest.assertEquals((int)2, (int)associations.size());
        ConstructorParentAssociation association = (ConstructorParentAssociation)associations.get(0);
        MenuTest.assertSame((Object)newMenuPopup, (Object)association.getJavaInfo());
        MenuTest.assertEquals((Object)"new Menu(this)", (Object)association.getSource());
        association = (InvocationChildAssociation)associations.get(1);
        MenuTest.assertSame((Object)newMenuPopup, (Object)association.getJavaInfo());
        MenuTest.assertEquals((Object)"setMenu(menu)", (Object)association.getSource());
    }

    @Test
    public void test_commandPaste() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "      {", "        Menu menu = new Menu(button_1);", "        button_1.setMenu(menu);", "        {", "          MenuItem item = new MenuItem(menu, SWT.CASCADE);", "          item.setText('My item');", "          {", "            Menu subMenu = new Menu(item);", "            item.setMenu(subMenu);", "          }", "        }", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        MenuInfo menu = (MenuInfo)button_1.getChildren(MenuInfo.class).get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)menu);
        MenuInfo menuCopy = (MenuInfo)memento.create((JavaInfo)shell);
        menuCopy.command_CREATE((WidgetInfo)button_2);
        memento.apply();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setText('Button 1');", "      {", "        Menu menu = new Menu(button_1);", "        button_1.setMenu(menu);", "        {", "          MenuItem item = new MenuItem(menu, SWT.CASCADE);", "          item.setText('My item');", "          {", "            Menu subMenu = new Menu(item);", "            item.setMenu(subMenu);", "          }", "        }", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setText('Button 2');", "      {", "        Menu menu = new Menu(button_2);", "        button_2.setMenu(menu);", "        {", "          MenuItem item = new MenuItem(menu, SWT.CASCADE);", "          item.setText('My item');", "          {", "            Menu subMenu = new Menu(item);", "            item.setMenu(subMenu);", "          }", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_commandMove_fromItem_toItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menuBar = new Menu(this, SWT.BAR);", "    setMenuBar(menuBar);", "    {", "      MenuItem item_1 = new MenuItem(menuBar, SWT.CASCADE);", "      item_1.setText('Item 1');", "      {", "        Menu subMenu = new Menu(item_1);", "        item_1.setMenu(subMenu);", "      }", "    }", "    {", "      MenuItem item_2 = new MenuItem(menuBar, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menuBar = (MenuInfo)shell.getChildrenJava().get(1);
        MenuItemInfo item_1 = (MenuItemInfo)menuBar.getChildrenItems().get(0);
        MenuItemInfo item_2 = (MenuItemInfo)menuBar.getChildrenItems().get(1);
        MenuInfo subMenu = (MenuInfo)item_1.getChildren(MenuInfo.class).get(0);
        subMenu.command_ADD((WidgetInfo)item_2);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menuBar = new Menu(this, SWT.BAR);", "    setMenuBar(menuBar);", "    {", "      MenuItem item_1 = new MenuItem(menuBar, SWT.NONE);", "      item_1.setText('Item 1');", "    }", "    {", "      MenuItem item_2 = new MenuItem(menuBar, SWT.CASCADE);", "      item_2.setText('Item 2');", "      {", "        Menu subMenu = new Menu(item_2);", "        item_2.setMenu(subMenu);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_commandMove_fromItem_toControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "      {", "        MenuItem item = new MenuItem(menu, SWT.CASCADE);", "        {", "          Menu subMenu = new Menu(item);", "          item.setMenu(subMenu);", "        }", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        MenuInfo menu = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)menu.getChildrenItems().get(0);
        MenuInfo subMenu = (MenuInfo)item.getChildren(MenuInfo.class).get(0);
        subMenu.command_ADD((WidgetInfo)button);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        Menu subMenu = new Menu(button);", "        button.setMenu(subMenu);", "      }", "    }", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "      {", "        MenuItem item = new MenuItem(menu, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_commandMove_fromControl_toItem() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        Menu subMenu = new Menu(button);", "        button.setMenu(subMenu);", "      }", "    }", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "      {", "        MenuItem item = new MenuItem(menu, SWT.NONE);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        MenuInfo subMenu = (MenuInfo)button.getChildren(MenuInfo.class).get(0);
        MenuInfo menu = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuItemInfo item = (MenuItemInfo)menu.getChildrenItems().get(0);
        subMenu.command_ADD((WidgetInfo)item);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "    {", "      Menu menu = new Menu(this);", "      setMenu(menu);", "      {", "        MenuItem item = new MenuItem(menu, SWT.CASCADE);", "        {", "          Menu subMenu = new Menu(item);", "          item.setMenu(subMenu);", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_commandMove_fromControl_toControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      {", "        Menu menu = new Menu(button_1);", "        button_1.setMenu(menu);", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        MenuInfo menu = (MenuInfo)button_1.getChildren(MenuInfo.class).get(0);
        menu.command_ADD((WidgetInfo)button_2);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      {", "        Menu menu = new Menu(button_2);", "        button_2.setMenu(menu);", "      }", "    }", "  }", "}");
    }

    private MenuInfo parseMenuBar() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "  }", "}");
        shell.refresh();
        return (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
    }

    @Test
    public void test_setVisible_default() throws Exception {
        MenuInfo menu = this.parseMenuBar();
        MenuTest.assertEquals((Object)false, (Object)menu.getPropertyByTitle("visible").getValue());
    }

    @Test
    public void test_getAdapter() throws Exception {
        MenuInfo menu = this.parseMenuBar();
        MenuTest.assertNull((Object)menu.getAdapter(Integer.class));
    }

    @Test
    public void test_placeHolder() throws Exception {
        MenuInfo menuInfo = this.parseMenuBar();
        MenuTest.assertEquals((int)0, (int)menuInfo.getChildrenItems().size());
        Menu menuObject = menuInfo.getWidget();
        MenuItem[] items = menuObject.getItems();
        MenuTest.assertEquals((int)1, (int)items.length);
    }

    @Test
    public void test_fetchVisualDataBar() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item_1 = new MenuItem(menu, SWT.NONE);", "      item_1.setText('Item 2');", "    }", "    {", "      MenuItem item_2 = new MenuItem(menu, SWT.NONE);", "      item_2.setText('Item 2');", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menu = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        MenuTest.assertNotNull((Object)menu.getModelBounds());
        if (EnvironmentUtils.IS_MAC) {
            MenuTest.assertNotNull((Object)menu.getImage());
        } else {
            MenuTest.assertNull((Object)menu.getImage());
        }
        List items = menu.getChildrenItems();
        MenuTest.assertEquals((int)2, (int)items.size());
        for (MenuItemInfo item : items) {
            MenuTest.assertNotNull((Object)item.getModelBounds());
            MenuTest.assertNull((Object)item.getImage());
        }
    }

    @Test
    public void test_fetchVisualDataCascaded() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this, SWT.BAR);", "    setMenuBar(menu);", "    {", "      MenuItem item = new MenuItem(menu, SWT.CASCADE);", "      item.setText('Item');", "      {", "        Menu subMenu = new Menu(item);", "        item.setMenu(subMenu);", "        {", "          MenuItem subItem_1 = new MenuItem(subMenu, SWT.NONE);", "          subItem_1.setText('SubItem 1');", "        }", "        {", "          MenuItem subItem_2 = new MenuItem(subMenu, SWT.NONE);", "          subItem_2.setText('SubItem 1');", "        }", "      }", "    }", "  }", "}");
        shell.refresh();
        MenuInfo menu = (MenuInfo)shell.getChildrenJava().get(1);
        MenuItemInfo menuItem = (MenuItemInfo)menu.getChildren(MenuItemInfo.class).get(0);
        MenuInfo subMenu = (MenuInfo)menuItem.getChildren().get(0);
        MenuTest.assertNotNull((Object)subMenu.getImage());
        List items = subMenu.getChildrenItems();
        MenuTest.assertEquals((int)2, (int)items.size());
        for (MenuItemInfo item : items) {
            MenuTest.assertNotNull((Object)item.getModelBounds());
            MenuTest.assertNull((Object)item.getImage());
        }
    }

    @Test
    public void test_parse_DecorationsInConstructor() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu bar = new Menu(this, SWT.BAR);", "    setMenuBar(bar);", "    {", "      MenuItem item = new MenuItem(bar, SWT.NONE);", "      {", "        Menu dropDown = new Menu(this, SWT.DROP_DOWN);", "        item.setMenu(dropDown);", "      }", "    }", "  }", "}");
        MenuTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Menu(this, SWT.BAR)/ /setMenuBar(bar)/ /new Menu(this, SWT.DROP_DOWN)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Menu} {local-unique: bar} {/new Menu(this, SWT.BAR)/ /setMenuBar(bar)/ /new MenuItem(bar, SWT.NONE)/}", "    {new: org.eclipse.swt.widgets.MenuItem} {local-unique: item} {/new MenuItem(bar, SWT.NONE)/ /item.setMenu(dropDown)/}", "      {new: org.eclipse.swt.widgets.Menu} {local-unique: dropDown} {/new Menu(this, SWT.DROP_DOWN)/ /item.setMenu(dropDown)/}");
    }

    @Test
    public void test_separatorItem_hasNoVariable() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "  }", "}");
        shell.refresh();
        MenuInfo menuInfo = (MenuInfo)shell.getChildren(MenuInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        Object itemInfo = MenuTest.createJavaInfo("org.eclipse.swt.widgets.MenuItem", "separator");
        MenuTest.assertTrue((boolean)menuPolicy.validateCreate(itemInfo));
        menuPolicy.commandCreate(itemInfo, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    Menu menu = new Menu(this);", "    setMenu(menu);", "    {", "      new MenuItem(menu, SWT.SEPARATOR);", "    }", "  }", "}");
    }

    @Test
    public void test_parse_sharedContextMenu() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Button button_1 = new Button(this, SWT.NONE);", "    Button button_2 = new Button(this, SWT.NONE);", "    //", "    Menu menu = new Menu(this);", "    button_1.setMenu(menu);", "    button_2.setMenu(menu);", "  }", "}");
        MenuTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/ /new Button(this, SWT.NONE)/ /new Menu(this)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button_1} {/new Button(this, SWT.NONE)/ /button_1.setMenu(menu)/}", "    {new: org.eclipse.swt.widgets.Menu} {local-unique: menu} {/new Menu(this)/ /button_1.setMenu(menu)/ /button_2.setMenu(menu)/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button_2} {/new Button(this, SWT.NONE)/ /button_2.setMenu(menu)/}");
    }
}

