/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts.grid;

import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class GridLayoutExposedTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_deleteExposedComponent_noExplicitData() throws Exception {
        this.configureForDelete();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)gridData.getCreationSupport());
        GridLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)gridData.getVariableSupport());
        GridLayoutExposedTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)button.getCreationSupport());
        GridLayoutExposedTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        GridLayoutExposedTest.assertFalse((boolean)button.isDeleted());
        gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)gridData.getCreationSupport());
        GridLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)gridData.getVariableSupport());
    }

    @Test
    public void test_deleteExposedComponent_withExplicitData() throws Exception {
        this.configureForDelete();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    myComposite.getButton().setLayoutData(new GridData());", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutExposedTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)gridData.getCreationSupport());
        GridLayoutExposedTest.assertInstanceOf(EmptyVariableSupport.class, (Object)gridData.getVariableSupport());
        GridLayoutExposedTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)button.getCreationSupport());
        GridLayoutExposedTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        GridLayoutExposedTest.assertTrue((boolean)myComposite.getChildren().contains(button));
        gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        GridLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataCreationSupport.class, (Object)gridData.getCreationSupport());
        GridLayoutExposedTest.assertInstanceOf(ImplicitLayoutDataVariableSupport.class, (Object)gridData.getVariableSupport());
    }

    @Test
    public void test_deleteWhenTwoExposed() throws Exception {
        this.createASTCompilationUnit("test", "MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  private Text m_text;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    m_button = new Button(this, SWT.NONE);", "    m_text = new Text(this, SWT.NONE);", "  }", "  public Button getButton() {", "    return m_button;", "  }", "  public Text getText() {", "    return m_text;", "  }", "}"));
        GridLayoutExposedTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)myComposite.getChildrenControls().get(0);
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
    }

    private void configureForDelete() throws Exception {
        GridLayoutExposedTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    m_button = new Button(this, SWT.NONE);", "    m_button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        GridLayoutExposedTest.waitForAutoBuild();
    }
}

