/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import org.eclipse.core.resources.IFile;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.JFrameInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ImagePropertyEditorTest
extends SwingModelTest {
    @Test
    public void test_getText_noIimage() throws Exception {
        this.assertImagePropertyText(null, new String[]{"public class Test extends JFrame {", "  public Test() {", "  }", "}"});
    }

    @Test
    public void test_getText_null() throws Exception {
        this.assertImagePropertyText("(null)", new String[]{"public class Test extends JFrame {", "  public Test() {", "    setIconImage(null);", "  }", "}"});
    }

    @Test
    public void test_getText_fromFile() throws Exception {
        IFile imageFile = TestUtils.createImagePNG(m_testProject, "1.png", 10, 10);
        try {
            String absoluteImagePath = imageFile.getLocation().toPortableString();
            this.assertImagePropertyText("File: " + absoluteImagePath, new String[]{"public class Test extends JFrame {", "  public Test() {", "    setIconImage(Toolkit.getDefaultToolkit().getImage(\"" + absoluteImagePath + "\"));", "  }", "}"});
        }
        finally {
            imageFile.delete(true, null);
        }
    }

    @Test
    public void test_getText_Class_getResource_1() throws Exception {
        ImagePropertyEditorTest.setFileContentSrc("Test.png", TestUtils.createImagePNG(1, 1));
        this.assertImagePropertyText("Classpath: /Test.png", new String[]{"public class Test extends JFrame {", "  public Test() {", "    setIconImage(Toolkit.getDefaultToolkit().getImage(Test.class.getResource(\"/Test.png\")));", "  }", "}"});
    }

    @Test
    public void test_getText_Class_getResource_2() throws Exception {
        ImagePropertyEditorTest.setFileContentSrc("Test.png", TestUtils.createImagePNG(1, 1));
        this.assertImagePropertyText("Classpath: /Test.png", new String[]{"public class Test extends JFrame {", "  public Test() {", "    Image icon = Toolkit.getDefaultToolkit().getImage(Test.class.getResource(\"/Test.png\"));", "    setIconImage(icon);", "  }", "}"});
    }

    @Test
    public void test_getText_Class_getResource_3() throws Exception {
        ImagePropertyEditorTest.setFileContentSrc("Test.png", TestUtils.createImagePNG(1, 1));
        this.assertImagePropertyText("Classpath: /Test.png", new String[]{"public class Test extends JFrame {", "  public Test() {", "    java.net.URL url = Test.class.getResource(\"/Test.png\");", "    Image icon = Toolkit.getDefaultToolkit().getImage(url);", "    setIconImage(icon);", "  }", "}"});
    }

    private void assertImagePropertyText(String expectedText, String[] lines) throws Exception {
        this.m_waitForAutoBuild = true;
        JFrameInfo frame = (JFrameInfo)this.parseContainer(lines);
        frame.refresh();
        ImagePropertyEditorTest.assertNoErrors((JavaInfo)frame);
        Property iconProperty = frame.getPropertyByTitle("iconImage");
        ImagePropertyEditorTest.assertEquals((Object)expectedText, (Object)ImagePropertyEditorTest.getPropertyText(iconProperty));
    }
}

