/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.CoordinateUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class MigLayoutTest
extends AbstractMigLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_Activator() throws Exception {
        MigLayoutTest.assertNotNull((Object)Activator.getDefault());
    }

    @DisposeProjectAfter
    @Test
    public void test_setLayoutFromContextMenu() throws Exception {
        MigLayoutTest.do_projectDispose();
        MigLayoutTest.do_projectCreate();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        MigLayoutTest.assertTrue((boolean)panel.hasLayout());
        MenuManager menuManager = MigLayoutTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(panel), (ObjectInfo)panel, (IMenuManager)menuManager);
        IMenuManager layoutManager = MigLayoutTest.findChildMenuManager((IContributionManager)menuManager, "Set layout");
        MigLayoutTest.assertNotNull((Object)layoutManager);
        IAction action = MigLayoutTest.findChildAction((IContributionManager)layoutManager, "MigLayout");
        action.run();
        this.m_includeMigImports = false;
        this.assertEditor("import net.miginfocom.swing.MigLayout;", "// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
    }

    @Test
    public void test_dangling() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private MigLayout m_layout = new MigLayout();", "  public Test() {", "  }", "}");
        MigLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_nonVisual() throws Exception {
        this.parseContainer("import java.util.ArrayList;", "class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private JPanel inner = new JPanel();", "  Test() {", "    inner.setLayout(new MigLayout());", "  }", "}");
        MigLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {NonVisualBeans}", "    {new: javax.swing.JPanel} {field-initializer: inner} {/new JPanel()/ /inner.setLayout(new MigLayout())/}", "      {new: net.miginfocom.swing.MigLayout} {empty} {/inner.setLayout(new MigLayout())/}");
        this.refresh();
        MigLayoutTest.assertNoErrors(this.m_lastParseInfo);
    }

    @Test
    public void test_writeDimensions_constructorProperties() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
        ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)layout.getCreationSupport();
        MigLayoutTest.assertEquals((Object)"<init>(java.lang.String,java.lang.String,java.lang.String)", (Object)creationSupport.getDescription().getSignature());
    }

    @Test
    public void test_writeDimensions_LC() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(new LC().insets('10 20 30 40')));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('insets 10 20 30 40', '[]', '[]'));", "  }", "}");
    }

    @Disabled
    @Test
    public void test_IGridInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0, width 100px, height 40px');", "    add(new JButton(C_2), 'cell 1 1, width 150px');", "    add(new JButton(C_3), 'cell 2 1, width 50px');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        IGridInfo gridInfo = layout.getGridInfo();
        MigLayoutTest.assertEquals((int)3, (int)gridInfo.getColumnCount());
        Object[] columnIntervals = gridInfo.getColumnIntervals();
        Assertions.assertThat((Object[])columnIntervals).hasSize(3);
        MigLayoutTest.assertEquals((Object)"Interval(7, 100)", (Object)columnIntervals[0].toString());
        MigLayoutTest.assertEquals((Object)"Interval(111, 150)", (Object)columnIntervals[1].toString());
        MigLayoutTest.assertEquals((Object)"Interval(265, 50)", (Object)columnIntervals[2].toString());
        MigLayoutTest.assertEquals((int)2, (int)gridInfo.getRowCount());
        Object[] rowIntervals = gridInfo.getRowIntervals();
        Assertions.assertThat((Object[])rowIntervals).hasSize(2);
        MigLayoutTest.assertEquals((Object)"Interval(7, 40)", (Object)rowIntervals[0].toString());
        MigLayoutTest.assertEquals((Object)Expectations.get("Interval(51, 23)", new Expectations.StrValue("kosta-home", "Interval(51, 25)"), new Expectations.StrValue("scheglov-win", "Interval(51, 23)")), (Object)rowIntervals[1].toString());
        MigLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_1));
        MigLayoutTest.assertEquals((Object)new Rectangle(1, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_2));
        MigLayoutTest.assertEquals((Object)new Rectangle(2, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_3));
        Rectangle cells = new Rectangle(0, 0, 1, 1);
        Rectangle expected = new Rectangle(7, 7, 101, 41);
        MigLayoutTest.assertEquals((Object)expected, (Object)gridInfo.getCellsRectangle(cells));
        cells = new Rectangle(2, 0, 1, 1);
        expected = new Rectangle(265, 7, 51, 41);
        MigLayoutTest.assertEquals((Object)expected, (Object)gridInfo.getCellsRectangle(cells));
        cells = new Rectangle(0, 0, 2, 2);
        expected = Expectations.get(new Rectangle(7, 7, 255, 68), new Expectations.RectValue("kosta-home", new Rectangle(7, 7, 255, 70)), new Expectations.RectValue("scheglov-win", new Rectangle(7, 7, 255, 68)));
        MigLayoutTest.assertEquals((Object)expected, (Object)gridInfo.getCellsRectangle(cells));
        MigLayoutTest.assertSame((Object)button_1, (Object)gridInfo.getOccupied(0, 0));
        MigLayoutTest.assertSame((Object)button_2, (Object)gridInfo.getOccupied(1, 1));
        MigLayoutTest.assertSame((Object)button_3, (Object)gridInfo.getOccupied(2, 1));
        MigLayoutTest.assertNull((Object)gridInfo.getOccupied(1, 0));
        MigLayoutTest.assertNull((Object)gridInfo.getOccupied(0, 1));
        MigLayoutTest.assertNull((Object)gridInfo.getOccupied(2, 0));
        MigLayoutTest.assertEquals((Object)CoordinateUtils.get((Insets)panel.getContainer().getInsets()), (Object)gridInfo.getInsets());
        MigLayoutTest.assertEquals((int)4, (int)gridInfo.getVirtualColumnGap());
        MigLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualColumnSize());
        MigLayoutTest.assertEquals((int)4, (int)gridInfo.getVirtualRowGap());
        MigLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualRowSize());
    }

    @Test
    public void test_IGridInfo_emptyColumnRow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        MigLayoutTest.assertEquals((int)1, (int)gridInfo.getColumnCount());
        Object[] columnIntervals = gridInfo.getColumnIntervals();
        Assertions.assertThat((Object[])columnIntervals).hasSize(1);
        Assertions.assertThat((int)columnIntervals[0].length()).isGreaterThan(18);
        MigLayoutTest.assertFalse((boolean)columnIntervals[0].isEmpty());
        MigLayoutTest.assertEquals((int)1, (int)gridInfo.getRowCount());
        Object[] rowIntervals = gridInfo.getRowIntervals();
        Assertions.assertThat((Object[])rowIntervals).hasSize(1);
        Assertions.assertThat((int)rowIntervals[0].length()).isGreaterThan(18);
        MigLayoutTest.assertFalse((boolean)rowIntervals[0].isEmpty());
    }

    @Test
    public void test_IGridInfo_getCellsRectangle_empty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Rectangle cells = gridInfo.getCellsRectangle(new Rectangle(0, 0, 0, 0));
        Rectangle expected = new Rectangle(7, 7, 0, 0);
        MigLayoutTest.assertEquals((int)expected.width, (int)cells.width);
        MigLayoutTest.assertEquals((int)expected.height, (int)cells.height);
    }

    @Test
    public void test_IGridInfo_withContainerInsets() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setBorder(new EmptyBorder(10, 20, 30, 40));", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        JButton buttonObject = (JButton)buttonInfo.getComponent();
        MigLayoutTest.assertEquals((int)1, (int)gridInfo.getColumnCount());
        MigLayoutTest.assertEquals((int)1, (int)gridInfo.getRowCount());
        Interval[] intervals = gridInfo.getColumnIntervals();
        MigLayoutTest.assertEquals((int)1, (int)intervals.length);
        MigLayoutTest.assertEquals((Object)new Interval(buttonObject.getX(), buttonObject.getWidth()), (Object)intervals[0]);
        intervals = gridInfo.getRowIntervals();
        MigLayoutTest.assertEquals((int)1, (int)intervals.length);
        MigLayoutTest.assertEquals((Object)new Interval(buttonObject.getY(), buttonObject.getHeight()), (Object)intervals[0]);
    }

    @Test
    public void test_IGridInfo_withSpanSplit() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0 2 1');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        IGridInfo gridInfo = layout.getGridInfo();
        MigLayoutTest.assertEquals((Object)new Rectangle(0, 0, 2, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_1));
        MigLayoutTest.assertEquals((Object)new Rectangle(0, 0, 2, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button_2));
    }

    @Test
    public void test_dimensions_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0, width 100px, height 40px');", "    add(new JButton(C_2), 'cell 1 1, width 150px');", "    add(new JButton(C_3), 'cell 2 1, width 50px');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        Assertions.assertThat((List)columns).hasSize(3);
        List rows = layout.getRows();
        Assertions.assertThat((List)rows).hasSize(2);
    }

    @Test
    public void test_dimensions_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][][][]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        Assertions.assertThat((List)columns).hasSize(2);
        List rows = layout.getRows();
        Assertions.assertThat((List)rows).hasSize(4);
    }

    @Test
    public void test_dimensions_getString() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10mm:3cm:3in][left]', '[100px,top][]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        MigColumnInfo column = (MigColumnInfo)columns.get(0);
        MigLayoutTest.assertEquals((Object)"[10mm:3cm:3in]", (Object)column.getString(true));
        MigLayoutTest.assertEquals((Object)"10mm:3cm:3in", (Object)column.getString(false));
        column = (MigColumnInfo)columns.get(1);
        MigLayoutTest.assertEquals((Object)"[left]", (Object)column.getString(true));
        List rows = layout.getRows();
        MigRowInfo row = (MigRowInfo)rows.get(0);
        MigLayoutTest.assertEquals((Object)"[100px,top]", (Object)row.getString(true));
        row = (MigRowInfo)rows.get(1);
        MigLayoutTest.assertEquals((Object)"[]", (Object)row.getString(true));
    }

    @Test
    public void test_dimensions_setString() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        column.setString("[100px:null,grow]");
        MigLayoutTest.assertEquals((Object)"[100px:null,grow]", (Object)column.getString(true));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px:null,grow]', '[]'));", "  }", "}");
        column = (MigColumnInfo)layout.getColumns().get(0);
        column.setString("[]");
        MigLayoutTest.assertEquals((Object)"[]", (Object)column.getString(true));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
        MigRowInfo row = (MigRowInfo)layout.getRows().get(0);
        row.setString("[20mm,fill]");
        MigLayoutTest.assertEquals((Object)"[20mm,fill]", (Object)row.getString(true));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[20mm,fill]'));", "  }", "}");
    }

    @Test
    public void test_dimensions_getTooltip() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10mm:3cm:3in][left]', '[100px,top][]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        MigColumnInfo column = (MigColumnInfo)columns.get(0);
        MigLayoutTest.assertEquals((Object)"[10mm:3cm:3in]", (Object)column.getTooltip());
        column = (MigColumnInfo)columns.get(1);
        MigLayoutTest.assertEquals((Object)"[left]", (Object)column.getTooltip());
        List rows = layout.getRows();
        MigRowInfo row = (MigRowInfo)rows.get(0);
        MigLayoutTest.assertEquals((Object)"[100px,top]", (Object)row.getTooltip());
        row = (MigRowInfo)rows.get(1);
        MigLayoutTest.assertEquals((Object)"[]", (Object)row.getTooltip());
    }

    @Test
    public void test_dimensions_isGrab() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        MigLayoutTest.assertFalse((boolean)column.hasGrow());
        column.flipGrow();
        MigLayoutTest.assertTrue((boolean)column.hasGrow());
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[grow]', '[]'));", "  }", "}");
        column.flipGrow();
        MigLayoutTest.assertFalse((boolean)column.hasGrow());
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
    }

    @Test
    public void test_dimensions_growWeightPriority() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        MigLayoutTest.assertEquals((int)100, (int)column.getGrowPriority());
        MigLayoutTest.assertEquals(null, (Float)column.getGrow());
        column.setGrow(Float.valueOf(150.0f));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[grow 150]', '[]'));", "  }", "}");
        column.setGrowPriority(200);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[growprio 200,grow 150]', '[]'));", "  }", "}");
        column.setGrow(Float.valueOf(100.0f));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[growprio 200,grow]', '[]'));", "  }", "}");
        column.setGrow(Float.valueOf(0.0f));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[growprio 200,grow 0]', '[]'));", "  }", "}");
        column.setGrow(null);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[growprio 200]', '[]'));", "  }", "}");
        column.setGrowPriority(100);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
    }

    @Test
    public void test_dimensions_shrinkWeightPriority() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        MigLayoutTest.assertEquals((int)100, (int)column.getShrinkPriority());
        MigLayoutTest.assertEquals((Float)Float.valueOf(100.0f), (Float)column.getShrink());
        column.setShrink(Float.valueOf(150.0f));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[shrink 150]', '[]'));", "  }", "}");
        column.setShrinkPriority(200);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[shrinkprio 200,shrink 150]', '[]'));", "  }", "}");
        column.setShrink(Float.valueOf(100.0f));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[shrinkprio 200]', '[]'));", "  }", "}");
        column.setShrink(Float.valueOf(0.0f));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[shrinkprio 200,shrink 0]', '[]'));", "  }", "}");
        column.setShrink(null);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[shrinkprio 200]', '[]'));", "  }", "}");
        column.setShrinkPriority(100);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
    }

    @Test
    public void test_ColumnInfo_getAlignment_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        Assertions.assertThat((List)columns).hasSize(2);
        MigColumnInfo column = (MigColumnInfo)columns.get(0);
        MigLayoutTest.assertSame((Object)MigColumnInfo.Alignment.DEFAULT, (Object)column.getAlignment(false));
        MigLayoutTest.assertSame((Object)MigColumnInfo.Alignment.LEADING, (Object)column.getAlignment(true));
        column = (MigColumnInfo)columns.get(1);
        MigLayoutTest.assertSame((Object)MigColumnInfo.Alignment.DEFAULT, (Object)column.getAlignment(false));
        MigLayoutTest.assertSame((Object)MigColumnInfo.Alignment.LEADING, (Object)column.getAlignment(true));
    }

    @Test
    public void test_ColumnInfo_getAlignment_LEFT() throws Exception {
        this.check_ColumnInfo_getAlignment("left", MigColumnInfo.Alignment.LEFT);
    }

    @Test
    public void test_ColumnInfo_getAlignment_CENTER() throws Exception {
        this.check_ColumnInfo_getAlignment("center", MigColumnInfo.Alignment.CENTER);
    }

    @Test
    public void test_ColumnInfo_getAlignment_RIGHT() throws Exception {
        this.check_ColumnInfo_getAlignment("right", MigColumnInfo.Alignment.RIGHT);
    }

    @Test
    public void test_ColumnInfo_getAlignment_FILL() throws Exception {
        this.check_ColumnInfo_getAlignment("fill", MigColumnInfo.Alignment.FILL);
    }

    @Test
    public void test_ColumnInfo_getAlignment_LEADING() throws Exception {
        this.check_ColumnInfo_getAlignment("leading", MigColumnInfo.Alignment.LEADING);
    }

    @Test
    public void test_ColumnInfo_getAlignment_TRAILING() throws Exception {
        this.check_ColumnInfo_getAlignment("trailing", MigColumnInfo.Alignment.TRAILING);
    }

    @Test
    public void test_ColumnInfo_getAlignment_UNKNOWN() throws Exception {
        this.check_ColumnInfo_getAlignment("align 30%", MigColumnInfo.Alignment.UNKNOWN);
    }

    private void check_ColumnInfo_getAlignment(String alignmentString, MigColumnInfo.Alignment expectedAlignment) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '" + alignmentString + "'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        MigLayoutTest.assertSame((Object)expectedAlignment, (Object)column.getAlignment(true));
    }

    @Test
    public void test_ColumnInfo_setAlignment_LEFT() throws Exception {
        this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.LEFT, "'', '[left]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_CENTER() throws Exception {
        this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.CENTER, "'', '[center]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_RIGHT() throws Exception {
        this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.RIGHT, "'', '[right]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_FILL() throws Exception {
        this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.FILL, "'', '[fill]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_LEADING() throws Exception {
        this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.LEADING, "'', '[leading]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_TRAILING() throws Exception {
        this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.TRAILING, "'', '[trailing]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_toDefault_1() throws Exception {
        this.check_ColumnInfo_setAlignment("'', 'left', ''", MigColumnInfo.Alignment.DEFAULT, "'', '[]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_toDefault_2() throws Exception {
        this.check_ColumnInfo_setAlignment("'', 'fill', ''", MigColumnInfo.Alignment.DEFAULT, "'', '[]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_withGrow_RIGHT() throws Exception {
        this.check_ColumnInfo_setAlignment("'', '[grow]', ''", MigColumnInfo.Alignment.RIGHT, "'', '[grow,right]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_withFill_RIGHT() throws Exception {
        this.check_ColumnInfo_setAlignment("'', '[fill]', ''", MigColumnInfo.Alignment.RIGHT, "'', '[right]', '[]'");
    }

    @Test
    public void test_ColumnInfo_setAlignment_UNKNOWN() throws Exception {
        try {
            this.check_ColumnInfo_setAlignment(MigColumnInfo.Alignment.UNKNOWN, "not used");
            MigLayoutTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void check_ColumnInfo_setAlignment(MigColumnInfo.Alignment alignment, String expectedLayoutArgs) throws Exception {
        this.check_ColumnInfo_setAlignment("", alignment, expectedLayoutArgs);
    }

    private void check_ColumnInfo_setAlignment(String initialArgs, MigColumnInfo.Alignment alignment, String expectedArgs) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(" + initialArgs + "));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        column.setAlignment(alignment);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(" + expectedArgs + "));", "  }", "}");
    }

    @Test
    public void test_RowInfo_getAlignment_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List rows = layout.getRows();
        Assertions.assertThat((List)rows).hasSize(2);
        MigRowInfo row = (MigRowInfo)rows.get(0);
        MigLayoutTest.assertSame((Object)MigRowInfo.Alignment.DEFAULT, (Object)row.getAlignment(false));
        MigLayoutTest.assertSame((Object)MigRowInfo.Alignment.BASELINE, (Object)row.getAlignment(true));
        row = (MigRowInfo)rows.get(1);
        MigLayoutTest.assertSame((Object)MigRowInfo.Alignment.DEFAULT, (Object)row.getAlignment(false));
        MigLayoutTest.assertSame((Object)MigRowInfo.Alignment.BASELINE, (Object)row.getAlignment(true));
    }

    @Test
    public void test_RowInfo_getAlignment_TOP() throws Exception {
        this.check_RowInfo_getAlignment("top", MigRowInfo.Alignment.TOP);
    }

    @Test
    public void test_RowInfo_getAlignment_CENTER() throws Exception {
        this.check_RowInfo_getAlignment("center", MigRowInfo.Alignment.CENTER);
    }

    @Test
    public void test_RowInfo_getAlignment_BOTTOM() throws Exception {
        this.check_RowInfo_getAlignment("bottom", MigRowInfo.Alignment.BOTTOM);
    }

    @Test
    public void test_RowInfo_getAlignment_FILL() throws Exception {
        this.check_RowInfo_getAlignment("fill", MigRowInfo.Alignment.FILL);
    }

    @Test
    public void test_RowInfo_getAlignment_BASELINE() throws Exception {
        this.check_RowInfo_getAlignment("baseline", MigRowInfo.Alignment.BASELINE);
    }

    @Test
    public void test_RowInfo_getAlignment_UNKNOWN() throws Exception {
        this.check_RowInfo_getAlignment("align 30%", MigRowInfo.Alignment.UNKNOWN);
    }

    private void check_RowInfo_getAlignment(String alignmentString, MigRowInfo.Alignment expectedAlignment) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '', '" + alignmentString + "'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigRowInfo row = (MigRowInfo)layout.getRows().get(0);
        MigLayoutTest.assertSame((Object)expectedAlignment, (Object)row.getAlignment(true));
    }

    @Test
    public void test_RowInfo_setAlignment_TOP() throws Exception {
        this.check_RowInfo_setAlignment(MigRowInfo.Alignment.TOP, "'', '[]', '[top]'");
    }

    @Test
    public void test_RowInfo_setAlignment_CENTER() throws Exception {
        this.check_RowInfo_setAlignment(MigRowInfo.Alignment.CENTER, "'', '[]', '[center]'");
    }

    @Test
    public void test_RowInfo_setAlignment_BOTTOM() throws Exception {
        this.check_RowInfo_setAlignment(MigRowInfo.Alignment.BOTTOM, "'', '[]', '[bottom]'");
    }

    @Test
    public void test_RowInfo_setAlignment_FILL() throws Exception {
        this.check_RowInfo_setAlignment(MigRowInfo.Alignment.FILL, "'', '[]', '[fill]'");
    }

    @Test
    public void test_RowInfo_setAlignment_BASELINE() throws Exception {
        this.check_RowInfo_setAlignment(MigRowInfo.Alignment.BASELINE, "'', '[]', '[baseline]'");
    }

    @Test
    public void test_RowInfo_setAlignment_UNKNOWN() throws Exception {
        try {
            this.check_RowInfo_setAlignment(MigRowInfo.Alignment.UNKNOWN, "not used");
            MigLayoutTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_RowInfo_setAlignment_toDefault_1() throws Exception {
        this.check_RowInfo_setAlignment("'', '', 'top'", MigRowInfo.Alignment.DEFAULT, "'', '[]', '[]'");
    }

    @Test
    public void test_RowInfo_setAlignment_toDefault_2() throws Exception {
        this.check_RowInfo_setAlignment("'', '', 'fill'", MigRowInfo.Alignment.DEFAULT, "'', '[]', '[]'");
    }

    @Test
    public void test_RowInfo_setAlignment_withGrow_TOP() throws Exception {
        this.check_RowInfo_setAlignment("'', '', 'grow'", MigRowInfo.Alignment.TOP, "'', '[]', '[grow,top]'");
    }

    @Test
    public void test_RowInfo_setAlignment_withFill_TOP() throws Exception {
        this.check_RowInfo_setAlignment("'', '', 'fill'", MigRowInfo.Alignment.TOP, "'', '[]', '[top]'");
    }

    private void check_RowInfo_setAlignment(MigRowInfo.Alignment alignment, String expectedLayoutArgs) throws Exception {
        this.check_RowInfo_setAlignment("", alignment, expectedLayoutArgs);
    }

    private void check_RowInfo_setAlignment(String initialArgs, MigRowInfo.Alignment alignment, String expectedArgs) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(" + initialArgs + "));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigRowInfo row = (MigRowInfo)layout.getRows().get(0);
        row.setAlignment(alignment);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(" + expectedArgs + "));", "  }", "}");
    }

    @Test
    public void test_dimensionSize_setCheck() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px]', '[]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        MigLayoutTest.assertNull((Object)column.getMinimumSize());
        MigLayoutTest.assertNotNull((Object)column.getPreferredSize());
        MigLayoutTest.assertNull((Object)column.getMaximumSize());
        column.setMinimumSize("1cm");
        MigLayoutTest.assertNotNull((Object)column.getMinimumSize());
        MigLayoutTest.assertEquals((Object)"1cm", (Object)column.getString(column.getMinimumSize()));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[1cm:100px]', '[]'));", "  }", "}");
        column.setMinimumSize("10%");
        MigLayoutTest.assertNotNull((Object)column.getMinimumSize());
        MigLayoutTest.assertEquals((Object)"10%", (Object)column.getString(column.getMinimumSize()));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10%:100px]', '[]'));", "  }", "}");
        column.setMinimumSize(null);
        MigLayoutTest.assertNull((Object)column.getMinimumSize());
        MigLayoutTest.assertEquals(null, (Object)column.getString(column.getMinimumSize()));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px]', '[]'));", "  }", "}");
        column.setMaximumSize("5cm");
        MigLayoutTest.assertNotNull((Object)column.getMaximumSize());
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[:100px:5cm]', '[]'));", "  }", "}");
        column.setMinimumSize("1cm");
        column.setPreferredSize("20mm");
        column.setMaximumSize("5cm");
        MigLayoutTest.assertNotNull((Object)column.getMinimumSize());
        MigLayoutTest.assertNotNull((Object)column.getPreferredSize());
        MigLayoutTest.assertNotNull((Object)column.getMaximumSize());
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[1cm:20mm:5cm]', '[]'));", "  }", "}");
        column.setSize("1in:2in:3in");
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[1in:2in:3in]', '[]'));", "  }", "}");
        column.setSize(null);
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
    }

    @Disabled
    @Test
    public void test_dimensionSize_toUnitString() throws Exception {
        String expected_sp;
        String expected_sp2;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigColumnInfo column = (MigColumnInfo)layout.getColumns().get(0);
        MigLayoutTest.assertEquals((Object)"2.65cm", (Object)column.toUnitString(100, "cm"));
        MigLayoutTest.assertEquals((Object)"22.22%", (Object)column.toUnitString(100, "%"));
        int displayWidth = Display.getDefault().getBounds().width;
        if (displayWidth == 1920) {
            expected_sp2 = "5.21sp";
        } else if (displayWidth == 1680) {
            expected_sp2 = "5.95sp";
        } else {
            throw new AssertionError((Object)("Unknown display width: " + displayWidth));
        }
        MigLayoutTest.assertEquals((Object)expected_sp2, (Object)column.toUnitString(100, "sp"));
        MigRowInfo row = (MigRowInfo)layout.getRows().get(0);
        MigLayoutTest.assertEquals((Object)"2.65cm", (Object)row.toUnitString(100, "cm"));
        MigLayoutTest.assertEquals((Object)"33.33%", (Object)row.toUnitString(100, "%"));
        int displayHeight = Display.getDefault().getBounds().height;
        if (displayHeight == 1200) {
            expected_sp = "8.33sp";
        } else if (displayHeight == 1050) {
            expected_sp = "9.52sp";
        } else {
            throw new AssertionError((Object)("Unknown display width: " + displayHeight));
        }
        MigLayoutTest.assertEquals((Object)expected_sp, (Object)row.toUnitString(100, "sp"));
    }

    @Test
    public void test_normalizeSpanning_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'cell 0 0');", "    add(new JButton(), 'cell 1 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    add(new JButton(), 'cell 0 0');", "    add(new JButton(), 'cell 1 1');", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10][20]', '[30][40]'));", "    add(new JButton(), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10]', '[30]'));", "    add(new JButton(), 'cell 0 0');", "  }", "}");
    }

    @Test
    public void test_normalizeSpanning_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10][20]', '[30][40]'));", "    add(new JButton(), 'cell 1 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.normalizeSpanning();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[20]', '[40]'));", "    add(new JButton(), 'cell 0 0');", "  }", "}");
    }

    @Test
    public void test_setCells() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    add(new JButton(C_3), 'cell 1 2');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        layout.command_setCells(button_3, new Rectangle(0, 1, 1, 2));
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    add(new JButton(C_3), 'cell 0 1 1 2');", "  }", "}");
        MigLayoutTest.assertCellBounds(button_3, 0, 1, 1, 2);
    }

    @Test
    public void test_CREATE_existingCell() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_CREATE(newButton, 0, false, 0, false);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton();", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        MigLayoutTest.assertCellBounds(newButton, 0, 0, 1, 1);
    }

    @Test
    public void test_CREATE_appendColumnRow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_CREATE(newButton, 1, false, 2, false);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][][]'));", "    {", "      JButton button = new JButton();", "      add(button, 'cell 1 2');", "    }", "  }", "}");
        MigLayoutTest.assertCellBounds(newButton, 1, 2, 1, 1);
    }

    @Test
    public void test_CREATE_insertColumnRow_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_CREATE(newButton, 0, true, 0, true);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][][]'));", "    {", "      JButton button = new JButton();", "      add(button, 'cell 0 0');", "    }", "    add(new JButton(C_1), 'cell 1 2');", "  }", "}");
        MigLayoutTest.assertCellBounds(newButton, 0, 0, 1, 1);
    }

    @Test
    public void test_CREATE_insertColumnRow_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    add(new JButton(C_3), 'cell 0 2 2 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_CREATE(newButton, 1, true, 3, false);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[][][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 2 1');", "    add(new JButton(C_3), 'cell 0 2 3 1');", "    {", "      JButton button = new JButton();", "      add(button, 'cell 1 3');", "    }", "  }", "}");
        MigLayoutTest.assertCellBounds(newButton, 1, 3, 1, 1);
    }

    @Test
    public void test_CREATE_insertColumnRow_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    add(new JButton(C_3), 'cell 2 0 1 2');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_CREATE(newButton, 3, false, 1, true);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][][]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    {", "      JButton button = new JButton();", "      add(button, 'cell 3 1');", "    }", "    add(new JButton(C_2), 'cell 1 2');", "    add(new JButton(C_3), 'cell 2 0 1 3');", "  }", "}");
        MigLayoutTest.assertCellBounds(newButton, 3, 1, 1, 1);
    }

    @Test
    public void test_CREATE_insertColumnRow_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'north');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_CREATE(newButton, 0, true, 0, true);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    add(new JButton(C_1), 'north');", "    {", "      JButton button = new JButton();", "      add(button, 'cell 0 0');", "    }", "    add(new JButton(C_2), 'cell 1 1');", "  }", "}");
        MigLayoutTest.assertCellBounds(newButton, 0, 0, 1, 1);
    }

    @Test
    public void test_MOVE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_MOVE(button, 1, false, 1, false);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 1 1');", "    }", "  }", "}");
        MigLayoutTest.assertCellBounds(button, 1, 1, 1, 1);
    }

    @Test
    public void test_MOVE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 0 2 2 1');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        layout.command_MOVE(button_3, 0, false, 1, false);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 0 1');", "    }", "    add(new JButton(C_2), 'cell 1 1');", "  }", "}");
        MigLayoutTest.assertCellBounds(button_3, 0, 1, 1, 1);
    }

    @Test
    public void test_MOVE_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'wrap');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'skip');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, '');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        MigLayoutTest.assertCellBounds(button_1, 0, 0, 1, 1);
        MigLayoutTest.assertCellBounds(button_2, 1, 1, 1, 1);
        MigLayoutTest.assertCellBounds(button_3, 2, 1, 1, 1);
        layout.command_MOVE(button_2, 1, false, 2, false);
        MigLayoutTest.assertCellBounds(button_1, 0, 0, 1, 1);
        MigLayoutTest.assertCellBounds(button_2, 1, 2, 1, 1);
        MigLayoutTest.assertCellBounds(button_3, 2, 1, 1, 1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[][][]'));", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 2 1');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 1 2');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'north');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 1 1');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        MigLayoutTest.assertSame((Object)CellConstraintsSupport.DockSide.NORTH, (Object)constraints.getDockSide());
        layout.command_MOVE(button, 0, false, 1, false);
        MigLayoutTest.assertSame(null, (Object)constraints.getDockSide());
        MigLayoutTest.assertCellBounds(button, 0, 1, 1, 1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 0 1');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 1 1');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JPanel panel = new JPanel();", "      add(panel, 'cell 0 0');", "      {", "        JButton button = new JButton(C_1);", "        panel.add(button);", "      }", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        layout.command_MOVE(button, 0, true, 0, true);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 0 0');", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel, 'cell 1 1');", "    }", "  }", "}");
        MigLayoutTest.assertCellBounds(button, 0, 0, 1, 1);
    }

    @Test
    public void test_getCellComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "    add(new JButton(C_3), 'cell 1 0');", "    add(new JButton(C_4), 'cell 1 1');", "    add(new JButton(C_5), 'cell 0 2 2 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        ComponentInfo button_4 = (ComponentInfo)panel.getChildrenComponents().get(3);
        ComponentInfo button_5 = (ComponentInfo)panel.getChildrenComponents().get(4);
        MigLayoutTest.assertEquals((Object)layout.getCellComponents(0, 0), List.of(button_1, button_2));
        MigLayoutTest.assertEquals((Object)layout.getCellComponents(1, 0), List.of(button_3));
        MigLayoutTest.assertEquals((Object)layout.getCellComponents(1, 1), List.of(button_4));
        MigLayoutTest.assertEquals((Object)layout.getCellComponents(0, 2), List.of(button_5));
        MigLayoutTest.assertEquals((Object)layout.getCellComponents(1, 2), List.of(button_5));
        Assertions.assertThat((List)layout.getCellComponents(2, 2)).isEmpty();
    }

    @Test
    public void test_isHorizontalSplit_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,flowx');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutTest.assertTrue((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_isHorizontalSplit_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,flowy');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutTest.assertFalse((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_isHorizontalSplit_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutTest.assertTrue((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_isHorizontalSplit_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(new LC().flowY()));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutTest.assertFalse((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_splitCREATE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_splitCREATE(0, 0, true, newButton, button_1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton();", "      add(button, 'flowx,cell 0 0');", "    }", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
    }

    @Test
    public void test_splitCREATE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_splitCREATE(0, 0, false, newButton, null);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'flowy,cell 0 0');", "    {", "      JButton button = new JButton();", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_splitCREATE_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'flowy,cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo newButton = MigLayoutTest.createJButton();
        layout.command_splitCREATE(0, 0, false, newButton, null);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'flowy,cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "    {", "      JButton button = new JButton();", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_splitMOVE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'flowy,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.command_splitMOVE(0, 0, true, button_2, button_1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'flowy,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_splitMOVE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 1 0');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.command_splitMOVE(0, 0, true, button_2, null);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'flowx,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_splitMOVE_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'flowx,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_MOVE(button_1, 1, false, 0, false);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'flowx,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'cell 1 0');", "    }", "  }", "}");
    }

    @Test
    public void test_splitDELETE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'flowx,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        button_1.delete();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'flowx,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_3);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_splitDELETE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_1);", "      add(button, 'flowx,cell 0 0');", "    }", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        button_1.delete();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton(C_2);", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_dock_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'dock north');", "    add(new JButton(C_2), 'west');", "    add(new JButton('long text'), '');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        MigLayoutTest.assertCellBounds(button_3, 0, 0, 1, 1);
        List columns = layout.getColumns();
        MigLayoutTest.assertEquals((int)1, (int)columns.size());
        List rows = layout.getRows();
        MigLayoutTest.assertEquals((int)1, (int)rows.size());
    }

    @Test
    public void test_gaps_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]10px[]20px[]', '[]'));", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        List columns = layout.getColumns();
        MigColumnInfo column_0 = (MigColumnInfo)columns.get(0);
        MigColumnInfo column_1 = (MigColumnInfo)columns.get(1);
        MigColumnInfo column_2 = (MigColumnInfo)columns.get(2);
        MigLayoutTest.assertEquals((Object)"[]", (Object)column_0.getString(true));
        MigLayoutTest.assertEquals(null, (Object)column_0.getString(column_0.getGapBefore()));
        MigLayoutTest.assertEquals((Object)"10px", (Object)column_0.getString(column_0.getGapAfter()));
        MigLayoutTest.assertEquals((Object)"[]", (Object)column_1.getString(true));
        MigLayoutTest.assertEquals((Object)"10px", (Object)column_1.getString(column_1.getGapBefore()));
        MigLayoutTest.assertEquals((Object)"20px", (Object)column_1.getString(column_1.getGapAfter()));
        MigLayoutTest.assertEquals((Object)"[]", (Object)column_2.getString(true));
        MigLayoutTest.assertEquals((Object)"20px", (Object)column_2.getString(column_2.getGapBefore()));
        MigLayoutTest.assertEquals(null, (Object)column_2.getString(column_2.getGapAfter()));
        column_1.setGapBefore("5mm");
        MigLayoutTest.assertEquals((Object)"5mm", (Object)column_1.getString(column_1.getGapBefore()));
        MigLayoutTest.assertEquals((Object)"5mm", (Object)column_0.getString(column_0.getGapAfter()));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]5mm[]20px[]', '[]'));", "  }", "}");
        column_1.setGapAfter("10mm");
        MigLayoutTest.assertEquals((Object)"10mm", (Object)column_1.getString(column_1.getGapAfter()));
        MigLayoutTest.assertEquals((Object)"10mm", (Object)column_2.getString(column_2.getGapBefore()));
        layout.writeDimensions();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]5mm[]10mm[]', '[]'));", "  }", "}");
    }

    @Test
    public void test_column_INSERT() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][200px]', ''));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 2 1');", "    add(new JButton(C_3), 'cell 1 2');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.insertColumn(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][][200px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 3 1');", "    add(new JButton(C_3), 'cell 2 2');", "  }", "}");
    }

    @Test
    public void test_column_DELETE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][150px][200px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 3 1');", "    add(new JButton(C_3), 'cell 2 2');", "    add(new JButton(C_4), 'cell 1 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.deleteColumn(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][200px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 2 1');", "    add(new JButton(C_3), 'cell 1 2');", "  }", "}");
    }

    @Test
    public void test_column_CLEAR() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][150px][200px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 3 1');", "    add(new JButton(C_3), 'cell 2 2');", "    add(new JButton(C_4), 'cell 1 0');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.clearColumn(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][150px][200px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 3 1');", "    add(new JButton(C_3), 'cell 2 2');", "  }", "}");
    }

    @Test
    public void test_column_SPLIT() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][200px][300px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    add(new JButton(C_3), 'cell 2 2');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.splitColumn(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][200px][200px][300px]', '[][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1 2 1');", "    add(new JButton(C_3), 'cell 3 2');", "  }", "}");
    }

    @Test
    public void test_column_MOVE_backward() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10px][20px][30px][40px][50px]', '[][][][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 2 1');", "    add(new JButton(C_3), 'cell 3 2');", "    add(new JButton(C_4), 'cell 2 3 3 1');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.moveColumn(3, 1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10px][40px][20px][30px][50px]', '[][][][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 3 1');", "    add(new JButton(C_3), 'cell 1 2');", "    add(new JButton(C_4), 'cell 3 3 2 1');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
    }

    @Test
    public void test_column_MOVE_forward() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10px][40px][20px][30px][50px]', '[][][][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 3 1');", "    add(new JButton(C_3), 'cell 1 2');", "    add(new JButton(C_4), 'cell 3 3 2 1');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.moveColumn(1, 4);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[10px][20px][30px][40px][50px]', '[][][][][]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1 2 1');", "    add(new JButton(C_3), 'cell 3 2');", "    add(new JButton(C_4), 'cell 2 3 3 1');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
    }

    @Test
    public void test_row_INSERT() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][200px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 2');", "    add(new JButton(C_3), 'cell 2 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.insertRow(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][][200px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 3');", "    add(new JButton(C_3), 'cell 2 2');", "  }", "}");
    }

    @Test
    public void test_row_DELETE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][][200px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 3');", "    add(new JButton(C_3), 'cell 2 2');", "    add(new JButton(C_4), 'cell 2 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.deleteRow(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][200px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 2');", "    add(new JButton(C_3), 'cell 2 1');", "  }", "}");
    }

    @Test
    public void test_row_CLEAR() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][200px][300px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 3');", "    add(new JButton(C_3), 'cell 2 2');", "    add(new JButton(C_4), 'cell 2 1');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.clearRow(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][200px][300px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 3');", "    add(new JButton(C_3), 'cell 2 2');", "  }", "}");
    }

    @Test
    public void test_row_SPLIT() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][200px][300px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "    add(new JButton(C_3), 'cell 2 2');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.splitRow(1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[100px][200px][200px][300px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1 1 2');", "    add(new JButton(C_3), 'cell 2 3');", "  }", "}");
    }

    @Test
    public void test_row_MOVE_backward() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][][][]', '[10px][20px][30px][40px][50px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 2');", "    add(new JButton(C_3), 'cell 2 3');", "    add(new JButton(C_4), 'cell 3 2 1 3');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.moveRow(3, 1);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][][][]', '[10px][40px][20px][30px][50px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 3');", "    add(new JButton(C_3), 'cell 2 1');", "    add(new JButton(C_4), 'cell 3 3 1 2');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
    }

    @Test
    public void test_row_MOVE_forward() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][][][]', '[10px][40px][20px][30px][50px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 3');", "    add(new JButton(C_3), 'cell 2 1');", "    add(new JButton(C_4), 'cell 3 3 1 2');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
        panel.refresh();
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        layout.moveRow(1, 4);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][][][][]', '[10px][20px][30px][40px][50px]'));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 0 1 2');", "    add(new JButton(C_3), 'cell 2 3');", "    add(new JButton(C_4), 'cell 3 2 1 3');", "    add(new JButton(C_5), 'cell 4 4');", "  }", "}");
    }

    @Test
    public void test_canChangeDimensions_constructor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigLayoutTest.assertTrue((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_canChangeDimensions_implicit() throws Exception {
        MigLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new MigLayout());", "  }", "}"));
        MigLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        MigLayoutTest.assertFalse((boolean)layout.canChangeDimensions());
    }

    @Test
    public void test_DimensionsProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[10mm:3cm:3in][left]', '[100px,top][]'));", "  }", "}");
        MigLayoutInfo layout = (MigLayoutInfo)panel.getLayout();
        panel.refresh();
        Property property = layout.getPropertyByTitle("columnSpecs");
        MigLayoutTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        MigLayoutTest.assertTrue((boolean)property.isModified());
        property.setValue((Object)this);
        MigLayoutTest.assertEquals((Object)"[10mm:3cm:3in][left]", (Object)MigLayoutTest.getPropertyText(property));
        property = layout.getPropertyByTitle("rowSpecs");
        MigLayoutTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        MigLayoutTest.assertTrue((boolean)property.isModified());
        property.setValue((Object)this);
        MigLayoutTest.assertEquals((Object)"[100px,top][]", (Object)MigLayoutTest.getPropertyText(property));
    }

    @Test
    public void test_editColumnsRowsActions() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[10mm:3cm:3in][left]', '[100px,top][]'));", "  }", "}");
        MenuManager menuManager = MigLayoutTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(panel), (ObjectInfo)panel, (IMenuManager)menuManager);
        MigLayoutTest.assertNotNull((Object)MigLayoutTest.findChildAction((IContributionManager)menuManager, "Edit c&olumns..."));
        MigLayoutTest.assertNotNull((Object)MigLayoutTest.findChildAction((IContributionManager)menuManager, "Edit &rows..."));
    }
}

