/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeConstantInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormSizeInfo;
import org.eclipse.wb.internal.swing.laf.LafSupport;
import org.eclipse.wb.internal.swing.laf.model.LafInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FormSizeInfoTest
extends AbstractFormLayoutTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        LafSupport.applySelectedLAF((LafInfo)LafSupport.getDefaultLAF());
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Disabled
    @Test
    public void test_FormSizeConstantInfo() throws Exception {
        FormSizeConstantInfo size = new FormSizeConstantInfo(25.0, ConstantSize.PIXEL);
        FormSizeInfoTest.assertEquals((double)25.0, (double)size.getValue(), (double)0.001);
        FormSizeInfoTest.assertEquals((int)25, (int)size.getAsPixels());
        FormSizeInfoTest.assertSame((Object)ConstantSize.PIXEL, (Object)size.getUnit());
        FormSizeInfoTest.assertEquals((Object)"25px", (Object)size.getSource(true, true));
        FormSizeInfoTest.assertEquals((Object)"com.jgoodies.forms.layout.Sizes.constant(\"25px\", true)", (Object)size.getSource(false, true));
        FormSizeInfoTest.assertEquals((Object)"com.jgoodies.forms.layout.Sizes.constant(\"25px\", false)", (Object)size.getSource(false, false));
        Size sizeValue = size.getSize(true);
        FormSizeInfoTest.assertEquals((Object)Sizes.constant((String)"25px", (boolean)true), (Object)sizeValue);
        size.setValue(20.0);
        FormSizeInfoTest.assertEquals((Object)"20px", (Object)size.getSource(true, true));
        size.setValueString("bad string - ignored");
        FormSizeInfoTest.assertEquals((Object)"20px", (Object)size.getSource(true, true));
        size.setValueString("18");
        FormSizeInfoTest.assertEquals((Object)"18px", (Object)size.getSource(true, true));
        size.setAsPixels(40);
        FormSizeInfoTest.assertEquals((Object)"40px", (Object)size.getSource(true, true));
        size.setUnit(ConstantSize.PIXEL);
        FormSizeInfoTest.assertEquals((double)40.0, (double)size.getValue(), (double)0.001);
        size.setUnit(ConstantSize.MILLIMETER);
        FormSizeInfoTest.assertEquals((double)Expectations.get(Double.valueOf(10.7), new Expectations.DblValue("kosta-home", 8.5), new Expectations.DblValue("scheglov-win", 10.7)), (double)size.getValue(), (double)0.001);
    }

    @Test
    public void test_FormSizeConstantInfo_convertSpecial() throws Exception {
        FormSizeConstantInfo size = new FormSizeConstantInfo(1.0, ConstantSize.CENTIMETER);
        size.setUnit(ConstantSize.MILLIMETER);
        FormSizeInfoTest.assertEquals((Object)"10mm", (Object)size.getSource(true, true));
        size = new FormSizeConstantInfo(23.0, ConstantSize.MILLIMETER);
        size.setUnit(ConstantSize.CENTIMETER);
        FormSizeInfoTest.assertEquals((Object)"2.3cm", (Object)size.getSource(true, true));
    }

    @Disabled
    @Test
    public void test_FormSizeConstantInfo_convertFromPixels() throws Exception {
        double expected = 50.0;
        this.check_convertFromPixels(50, ConstantSize.PIXEL, expected);
        expected = Expectations.get(Double.valueOf(39.0), new Expectations.DblValue("kosta-home", 31.0), new Expectations.DblValue("scheglov-win", 38.0));
        this.check_convertFromPixels(50, ConstantSize.POINT, expected);
        expected = Expectations.get(Double.valueOf(34.0), new Expectations.DblValue("kosta-home", 26.0), new Expectations.DblValue("scheglov-win", 34.0));
        this.check_convertFromPixels(50, ConstantSize.DIALOG_UNITS_X, expected);
        expected = Expectations.get(Double.valueOf(34.0), new Expectations.DblValue("kosta-home", 32.0), new Expectations.DblValue("scheglov-win", 34.0));
        this.check_convertFromPixels(50, ConstantSize.DIALOG_UNITS_Y, expected);
        expected = Expectations.get(Double.valueOf(13.4), new Expectations.DblValue("kosta-home", 10.7), new Expectations.DblValue("scheglov-win", 13.4));
        this.check_convertFromPixels(50, ConstantSize.MILLIMETER, expected);
        expected = Expectations.get(Double.valueOf(1.3), new Expectations.DblValue("kosta-home", 1.1), new Expectations.DblValue("scheglov-win", 1.3));
        this.check_convertFromPixels(50, ConstantSize.CENTIMETER, expected);
        expected = Expectations.get(Double.valueOf(0.5), new Expectations.DblValue("kosta-home", 0.4), new Expectations.DblValue("scheglov-win", 0.5));
        this.check_convertFromPixels(50, ConstantSize.INCH, expected);
    }

    private void check_convertFromPixels(int pixels, ConstantSize.Unit unit, double expected) throws Exception {
        FormSizeInfoTest.assertEquals((double)expected, (double)FormSizeConstantInfo.convertFromPixels((int)pixels, (ConstantSize.Unit)unit), (double)0.001);
    }

    @Disabled
    @Test
    public void test_FormSizeConstantInfo_convertToPixels() throws Exception {
        int expected = 10;
        this.check_convertToPixels(10.0, ConstantSize.PIXEL, expected);
        expected = Expectations.get(Integer.valueOf(13), new Expectations.IntValue("kosta-home", 16), new Expectations.IntValue("scheglov-win", 13));
        this.check_convertToPixels(10.0, ConstantSize.POINT, expected);
        expected = Expectations.get(Integer.valueOf(15), new Expectations.IntValue("kosta-home", 20), new Expectations.IntValue("scheglov-win", 15));
        this.check_convertToPixels(10.0, ConstantSize.DIALOG_UNITS_X, expected);
        expected = Expectations.get(Integer.valueOf(15), new Expectations.IntValue("kosta-home", 16), new Expectations.IntValue("scheglov-win", 15));
        this.check_convertToPixels(10.0, ConstantSize.DIALOG_UNITS_Y, expected);
        expected = Expectations.get(Integer.valueOf(38), new Expectations.IntValue("kosta-home", 47), new Expectations.IntValue("scheglov-win", 38));
        this.check_convertToPixels(10.0, ConstantSize.MILLIMETER, expected);
        expected = Expectations.get(Integer.valueOf(378), new Expectations.IntValue("kosta-home", 472), new Expectations.IntValue("scheglov-win", 378));
        this.check_convertToPixels(10.0, ConstantSize.CENTIMETER, expected);
        expected = Expectations.get(Integer.valueOf(960), new Expectations.IntValue("kosta-home", 1200), new Expectations.IntValue("scheglov-win", 960));
        this.check_convertToPixels(10.0, ConstantSize.INCH, expected);
    }

    private void check_convertToPixels(double value, ConstantSize.Unit unit, int expected) throws Exception {
        FormSizeInfoTest.assertEquals((int)expected, (int)FormSizeConstantInfo.convertToPixels((double)value, (ConstantSize.Unit)unit));
    }

    @Test
    public void test_FormSize_constant() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.constant((String)"25px", (boolean)true), true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"25px", (Object)size.getSource());
        FormSizeInfoTest.assertEquals((Object)Sizes.constant((String)"25px", (boolean)true), (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)"25px", (Object)size.getDisplayString());
        FormSizeInfoTest.assertEquals((Object)"25px", (Object)size.toString());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasUpperSize());
        FormSizeInfoTest.assertNull((Object)size.getLowerSize());
        FormSizeInfoTest.assertNull((Object)size.getUpperSize());
        FormSizeConstantInfo constantSize = size.getConstantSize();
        FormSizeInfoTest.assertNotNull((Object)constantSize);
        FormSizeInfoTest.assertEquals((double)25.0, (double)constantSize.getValue(), (double)0.001);
        FormSizeInfoTest.assertSame((Object)ConstantSize.PIXEL, (Object)constantSize.getUnit());
    }

    @Test
    public void test_FormSize_constantSet() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.DEFAULT, true);
        FormSizeInfoTest.assertEquals((Object)"default", (Object)size.getSource());
        FormSizeInfoTest.assertNotNull((Object)size.getComponentSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        size.setConstantSize(new FormSizeConstantInfo(25.0, ConstantSize.PIXEL));
        FormSizeInfoTest.assertNull((Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)"25px", (Object)size.getConstantSize().getSource(true, true));
    }

    @Test
    public void test_FormSize_component_DEFAULT() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.DEFAULT, true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"default", (Object)size.getSource());
        FormSizeInfoTest.assertSame((Object)Sizes.DEFAULT, (Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)Sizes.DEFAULT, (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasUpperSize());
        FormSizeInfoTest.assertNull((Object)size.getLowerSize());
        FormSizeInfoTest.assertNull((Object)size.getUpperSize());
    }

    @Test
    public void test_FormSize_component_PREFERRED() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.PREFERRED, true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"pref", (Object)size.getSource());
        FormSizeInfoTest.assertSame((Object)Sizes.PREFERRED, (Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)Sizes.PREFERRED, (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasUpperSize());
        FormSizeInfoTest.assertNull((Object)size.getLowerSize());
        FormSizeInfoTest.assertNull((Object)size.getUpperSize());
    }

    @Test
    public void test_FormSize_component_MINIMUM() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.MINIMUM, true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"min", (Object)size.getSource());
        FormSizeInfoTest.assertSame((Object)Sizes.MINIMUM, (Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)Sizes.MINIMUM, (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasUpperSize());
        FormSizeInfoTest.assertNull((Object)size.getLowerSize());
        FormSizeInfoTest.assertNull((Object)size.getUpperSize());
    }

    @Test
    public void test_FormSize_setComponentSize() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.DEFAULT, true);
        size.setComponentSize((Size)Sizes.MINIMUM);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"min", (Object)size.getSource());
    }

    @Test
    public void test_FormSize_boundedLower() throws Exception {
        FormSizeInfo size = new FormSizeInfo(ColumnSpec.decode((String)"max(4cm;default)").getSize(), true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"max(4cm;default)", (Object)size.getSource());
        FormSizeInfoTest.assertSame((Object)Sizes.DEFAULT, (Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)Sizes.bounded((Size)Sizes.DEFAULT, (Size)Sizes.constant((String)"4cm", (boolean)true), null), (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        FormSizeInfoTest.assertNull((Object)size.getUpperSize());
        FormSizeConstantInfo lowerSize = size.getLowerSize();
        FormSizeInfoTest.assertNotNull((Object)lowerSize);
        FormSizeInfoTest.assertEquals((double)4.0, (double)lowerSize.getValue(), (double)0.001);
        FormSizeInfoTest.assertSame((Object)ConstantSize.CENTIMETER, (Object)lowerSize.getUnit());
    }

    @Test
    public void test_FormSize_boundedUpper() throws Exception {
        FormSizeInfo size = new FormSizeInfo(ColumnSpec.decode((String)"min(3cm;default)").getSize(), true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"min(3cm;default)", (Object)size.getSource());
        FormSizeInfoTest.assertSame((Object)Sizes.DEFAULT, (Object)size.getComponentSize());
        FormSizeInfoTest.assertEquals((Object)Sizes.bounded((Size)Sizes.DEFAULT, null, (Size)Sizes.constant((String)"3cm", (boolean)true)), (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertNull((Object)size.getLowerSize());
        FormSizeInfoTest.assertTrue((boolean)size.hasUpperSize());
        FormSizeConstantInfo upperSize = size.getUpperSize();
        FormSizeInfoTest.assertNotNull((Object)upperSize);
        FormSizeInfoTest.assertEquals((double)3.0, (double)upperSize.getValue(), (double)0.001);
        FormSizeInfoTest.assertSame((Object)ConstantSize.CENTIMETER, (Object)upperSize.getUnit());
    }

    @Test
    public void test_FormSize_boundedLowerSet() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.DEFAULT, true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"default", (Object)size.getSource());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasUpperSize());
        size.setLowerSize(new FormSizeConstantInfo(5.0, ConstantSize.CM));
        FormSizeInfoTest.assertTrue((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"max(5cm;default)", (Object)size.getSource());
        size.setLowerSize(false);
        FormSizeInfoTest.assertEquals((Object)"default", (Object)size.getSource());
    }

    @Test
    public void test_FormSize_boundedUpperSet() throws Exception {
        FormSizeInfo size = new FormSizeInfo((Size)Sizes.DEFAULT, true);
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"default", (Object)size.getSource());
        FormSizeInfoTest.assertFalse((boolean)size.hasLowerSize());
        FormSizeInfoTest.assertFalse((boolean)size.hasUpperSize());
        size.setUpperSize(new FormSizeConstantInfo(5.0, ConstantSize.CM));
        FormSizeInfoTest.assertTrue((boolean)size.hasUpperSize());
        FormSizeInfoTest.assertTrue((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"min(5cm;default)", (Object)size.getSource());
        size.setUpperSize(false);
        FormSizeInfoTest.assertEquals((Object)"default", (Object)size.getSource());
    }

    @Test
    public void test_FormSize_boundedLowerUpper() throws Exception {
        Size expectedSize = Sizes.bounded((Size)Sizes.DEFAULT, (Size)Sizes.constant((String)"3cm", (boolean)true), (Size)Sizes.constant((String)"40mm", (boolean)true));
        FormSizeInfo size = new FormSizeInfo(expectedSize, true);
        FormSizeInfoTest.assertFalse((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)"com.jgoodies.forms.layout.Sizes.bounded(com.jgoodies.forms.layout.Sizes.DEFAULT, com.jgoodies.forms.layout.Sizes.constant(\"3cm\", true), com.jgoodies.forms.layout.Sizes.constant(\"40mm\", true))", (Object)size.getSource());
        FormSizeInfoTest.assertEquals((Object)expectedSize, (Object)size.getSize());
        FormSizeInfoTest.assertNull((Object)size.getConstantSize());
        FormSizeConstantInfo lowerSize = size.getLowerSize();
        FormSizeInfoTest.assertNotNull((Object)lowerSize);
        FormSizeInfoTest.assertEquals((double)3.0, (double)lowerSize.getValue(), (double)0.001);
        FormSizeInfoTest.assertSame((Object)ConstantSize.CENTIMETER, (Object)lowerSize.getUnit());
        FormSizeConstantInfo upperSize = size.getUpperSize();
        FormSizeInfoTest.assertNotNull((Object)upperSize);
        FormSizeInfoTest.assertEquals((double)40.0, (double)upperSize.getValue(), (double)0.001);
        FormSizeInfoTest.assertSame((Object)ConstantSize.MILLIMETER, (Object)upperSize.getUnit());
    }

    @Test
    public void test_bounded_getDisplayString() throws Exception {
        this.check_bounded_getDisplayString((Size)Sizes.DEFAULT, "DEFAULT", "default");
        this.check_bounded_getDisplayString((Size)Sizes.PREFERRED, "PREFERRED", "preferred");
        this.check_bounded_getDisplayString((Size)Sizes.MINIMUM, "MINIMUM", "minimum");
    }

    private void check_bounded_getDisplayString(Size componentSize, String source, String display) throws Exception {
        Size expectedSize = Sizes.bounded((Size)componentSize, (Size)Sizes.constant((String)"3cm", (boolean)true), (Size)Sizes.constant((String)"40mm", (boolean)true));
        FormSizeInfo size = new FormSizeInfo(expectedSize, true);
        FormSizeInfoTest.assertEquals((Object)expectedSize, (Object)size.getSize());
        FormSizeInfoTest.assertFalse((boolean)size.isString());
        FormSizeInfoTest.assertEquals((Object)("com.jgoodies.forms.layout.Sizes.bounded(com.jgoodies.forms.layout.Sizes." + source + ", com.jgoodies.forms.layout.Sizes.constant(\"3cm\", true), com.jgoodies.forms.layout.Sizes.constant(\"40mm\", true))"), (Object)size.getSource());
        FormSizeInfoTest.assertEquals((Object)("3cm<" + display + "<40mm"), (Object)size.getDisplayString());
    }
}

