/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.eclipse.wb.tests.gef.GraphicalRobot;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FormLayoutGefTest
extends SwingGefTest {
    private static int COLUMN_GAP = 8;
    private static int ROW_GAP = 7;
    private static int V_COLUMN_SIZE = 22;
    private static int V_ROW_SIZE = 22;
    private ContainerInfo panel;
    private FormLayoutInfo layout;
    private GraphicalRobot horizontalRobot;
    private GraphicalRobot verticalRobot;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        AbstractLayoutTest.configureForTest();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        AbstractLayoutTest.configureDefaults();
        super.tearDown();
    }

    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        AbstractFormLayoutTest.do_configureNewProject();
    }

    @Test
    public void test_setLayout_empty() throws Exception {
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        this.loadCreationTool("com.jgoodies.forms.layout.FormLayout");
        this.canvas.moveTo((Object)this.panel, 0.5, 0.5).click();
        this.assertEditor("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {},\n\t\t\tnew RowSpec[] {}));\n\t}\n}");
    }

    @Test
    public void test_setLayout_replaceGridBagLayout() throws Exception {
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        this.canvas.select(this.panel);
        this.loadCreationTool("com.jgoodies.forms.layout.FormLayout");
        this.canvas.moveTo((Object)this.panel, 0.5, 0.5).click();
        String source = this.m_lastEditor.getSource();
        Assertions.assertThat((String)source).contains(new CharSequence[]{"new FormLayout("});
        Assertions.assertThat((String)source).contains(new CharSequence[]{"new ColumnSpec[] {"});
        Assertions.assertThat((String)source).contains(new CharSequence[]{"new RowSpec[] {"});
    }

    @Test
    public void test_CREATE_filled() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\tadd(new JButton(\"Existing JButton\"), \"2, 2\");\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP, ROW_GAP);
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_empty() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP, ROW_GAP);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_virtual_2x2() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout());\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP, ROW_GAP);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_virtual_4x2() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout());\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP + V_COLUMN_SIZE + COLUMN_GAP, ROW_GAP);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_virtual_2x4() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout());\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP, ROW_GAP + V_ROW_SIZE + ROW_GAP);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 4\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendToColumn_2x4() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inX(0.5).outY(ROW_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 4\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendToRow_4x2() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inY(0.5).outX(COLUMN_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_beforeFirstRow() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inX(0.5).outY(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 4\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_beforeFirstColumn() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inY(0.5).outX(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton existing = new JButton(\"Existing JButton\");\n\t\t\tadd(existing, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertRow_endOfComponent_noGapNext() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"2, 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo button_1 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inX(0.5).inY(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"2, 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 3\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 4\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertRow_beginOfComponent_noGapPrev() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"2, 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo button_2 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_2");
        this.loadButtonWithText();
        this.canvas.target(button_2).inX(0.5).inY(2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"2, 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 3\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 4\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertColumn_endOfComponent_noGapNext() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"1, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo button_1 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"1, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"3, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertColumn_beginOfComponent_noGapPrev() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"1, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo button_2 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_2");
        this.loadButtonWithText();
        this.canvas.target(button_2).inY(0.5).inX(2).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"1, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"3, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_whenNoRows() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {}));\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP, ROW_GAP);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_whenNoColumns() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COLUMN_GAP, ROW_GAP);
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_inherited_columnOperations() throws Exception {
        FormLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}"));
        FormLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"1, 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"2, 1\");\n\t\t}\n\t}\n}");
        this.loadButton();
        ComponentInfo button_1 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.assertCommandNull();
        ComponentInfo button_2 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inY(0.5).outX(COLUMN_GAP + 1).move();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_inherited_rowOperations() throws Exception {
        FormLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}"));
        FormLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"JButton 1\");\n\t\t\tadd(button_1, \"1, 1\");\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"JButton 2\");\n\t\t\tadd(button_2, \"1, 2\");\n\t\t}\n\t}\n}");
        this.loadButton();
        ComponentInfo button_1 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inX(0.5).inY(-2).move();
        this.canvas.assertCommandNull();
        ComponentInfo button_2 = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inX(0.5).outY(ROW_GAP + 1).move();
        FormLayoutGefTest.waitEventLoop(5000);
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_PASTE_virtual_4x2() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"My JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo existing = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("existing");
        this.doCopyPaste((JavaInfo)existing);
        this.canvas.target(existing).in(0.5, 0.5).move();
        this.canvas.assertCommandNull();
        this.canvas.target(existing).inY(0.5).outX(ROW_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton existing = new JButton(\"My JButton\");\n\t\t\tadd(existing, \"2, 2\");\n\t\t}\n\t\t{\n\t\t\tJButton existing = new JButton(\"My JButton\");\n\t\t\tadd(existing, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_virtual_4x2() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, \"2, 2\");\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button");
        this.canvas.beginDrag(button);
        this.canvas.target(button).inY(0.5).outX(ROW_GAP + 1).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, \"4, 2\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_ADD_virtual_2x2() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner, BorderLayout.CENTER);\n\t\t\tinner.setLayout(new FormLayout());\n\t\t}\n\t}\n}");
        ComponentInfo button = (ComponentInfo)FormLayoutGefTest.getJavaInfoByName("button");
        this.panel = (ContainerInfo)FormLayoutGefTest.getJavaInfoByName("inner");
        this.canvas.beginDrag(button);
        this.canvas.target(this.panel).in(COLUMN_GAP, ROW_GAP).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner, BorderLayout.CENTER);\n\t\t\tinner.setLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\t\tnew RowSpec[] {\n\t\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"My JButton\");\n\t\t\t\tinner.add(button, \"2, 2\");\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_headerColumn_MOVE_inherited() throws Exception {
        FormLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tColumnSpec.decode(\"150px\"),\n\t\t\t\tColumnSpec.decode(\"100px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}"));
        FormLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        FormColumnInfo sourceColumn = (FormColumnInfo)columns.get(0);
        FormColumnInfo relativeColumn = (FormColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.assertCommandNull();
    }

    @Test
    public void test_headerColumn_MOVE_forward_targetGap() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tnew ColumnSpec(\"150px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tnew ColumnSpec(\"100px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tnew ColumnSpec(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        FormColumnInfo sourceColumn = (FormColumnInfo)columns.get(1);
        FormColumnInfo relativeColumn = (FormColumnInfo)columns.get(3);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tColumnSpec.decode(\"100px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tColumnSpec.decode(\"150px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tColumnSpec.decode(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
    }

    @Test
    public void test_headerColumn_MOVE_forward_targetNotGap() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tnew ColumnSpec(\"150px\"),\n\t\t\t\tnew ColumnSpec(\"100px\"),\n\t\t\t\tnew ColumnSpec(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        FormColumnInfo sourceColumn = (FormColumnInfo)columns.get(0);
        FormColumnInfo relativeColumn = (FormColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tColumnSpec.decode(\"100px\"),\n\t\t\t\tColumnSpec.decode(\"150px\"),\n\t\t\t\tColumnSpec.decode(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
    }

    @Test
    public void test_headerColumn_MOVE_forward_targetBeforeGap() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tnew ColumnSpec(\"150px\"),\n\t\t\t\tnew ColumnSpec(\"100px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tnew ColumnSpec(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        FormColumnInfo sourceColumn = (FormColumnInfo)columns.get(0);
        FormColumnInfo relativeColumn = (FormColumnInfo)columns.get(3);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, 5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tColumnSpec.decode(\"100px\"),\n\t\t\t\tColumnSpec.decode(\"150px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_COLSPEC,\n\t\t\t\tColumnSpec.decode(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
    }

    @Test
    public void test_headerColumn_MOVE_forward_targetLast() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tnew ColumnSpec(\"150px\"),\n\t\t\t\tnew ColumnSpec(\"100px\"),\n\t\t\t\tnew ColumnSpec(\"50px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        FormColumnInfo sourceColumn = (FormColumnInfo)columns.get(0);
        FormColumnInfo relativeColumn = (FormColumnInfo)columns.get(2);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tColumnSpec.decode(\"100px\"),\n\t\t\t\tColumnSpec.decode(\"50px\"),\n\t\t\t\tColumnSpec.decode(\"150px\"),},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_ROWSPEC,}));\n\t}\n}");
    }

    @Test
    public void test_headerRow_MOVE_inherited() throws Exception {
        FormLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tRowSpec.decode(\"100px\"),\n\t\t\t\tRowSpec.decode(\"75px\"),}));\n\t}\n}"));
        FormLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        FormRowInfo sourceRow = (FormRowInfo)rows.get(0);
        FormRowInfo relativeRow = (FormRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.assertCommandNull();
    }

    @Test
    public void test_headerRow_MOVE_forward_targetGap() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tnew RowSpec(\"100px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tnew RowSpec(\"75px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tnew RowSpec(\"50px\"),}));\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        FormRowInfo sourceRow = (FormRowInfo)rows.get(1);
        FormRowInfo relativeRow = (FormRowInfo)rows.get(3);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tRowSpec.decode(\"75px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tRowSpec.decode(\"100px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tRowSpec.decode(\"50px\"),}));\n\t}\n}");
    }

    @Test
    public void test_headerRow_MOVE_forward_targetNotGap() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tnew RowSpec(\"100px\"),\n\t\t\t\tnew RowSpec(\"75px\"),\n\t\t\t\tnew RowSpec(\"50px\"),}));\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        FormRowInfo sourceRow = (FormRowInfo)rows.get(0);
        FormRowInfo relativeRow = (FormRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tRowSpec.decode(\"75px\"),\n\t\t\t\tRowSpec.decode(\"100px\"),\n\t\t\t\tRowSpec.decode(\"50px\"),}));\n\t}\n}");
    }

    @Test
    public void test_headerRow_MOVE_forward_targetBeforeGap() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tnew RowSpec(\"100px\"),\n\t\t\t\tnew RowSpec(\"75px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tnew RowSpec(\"50px\"),}));\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        FormRowInfo sourceRow = (FormRowInfo)rows.get(0);
        FormRowInfo relativeRow = (FormRowInfo)rows.get(3);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, 5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tRowSpec.decode(\"75px\"),\n\t\t\t\tRowSpec.decode(\"100px\"),\n\t\t\t\tFormSpecs.RELATED_GAP_ROWSPEC,\n\t\t\t\tRowSpec.decode(\"50px\"),}));\n\t}\n}");
    }

    @Test
    public void test_headerRow_MOVE_forward_targetLast() throws Exception {
        this.openPanel("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tnew RowSpec(\"100px\"),\n\t\t\t\tnew RowSpec(\"75px\"),\n\t\t\t\tnew RowSpec(\"50px\"),}));\n\t}\n}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        FormRowInfo sourceRow = (FormRowInfo)rows.get(0);
        FormRowInfo relativeRow = (FormRowInfo)rows.get(2);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FormLayout(new ColumnSpec[] {\n\t\t\t\tFormSpecs.DEFAULT_COLSPEC,},\n\t\t\tnew RowSpec[] {\n\t\t\t\tRowSpec.decode(\"75px\"),\n\t\t\t\tRowSpec.decode(\"50px\"),\n\t\t\t\tRowSpec.decode(\"100px\"),}));\n\t}\n}");
    }

    @Override
    public String getTestSource(String code) {
        return super.getTestSource("import com.jgoodies.forms.layout.*;\nimport com.jgoodies.forms.factories.*;\n%s".formatted(code));
    }

    private void openPanel(String lines) throws Exception {
        this.panel = this.openContainer(lines);
        if (this.panel.getLayout() instanceof FormLayoutInfo) {
            this.layout = (FormLayoutInfo)this.panel.getLayout();
            IGridInfo grid = this.layout.getGridInfo();
            V_COLUMN_SIZE = grid.getVirtualColumnSize();
            V_ROW_SIZE = grid.getVirtualRowSize();
            COLUMN_GAP = grid.getVirtualColumnGap();
            ROW_GAP = grid.getVirtualRowGap();
        }
        this.horizontalRobot = new GraphicalRobot(this.m_headerHorizontal);
        this.verticalRobot = new GraphicalRobot(this.m_headerVertical);
    }
}

