/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout;

import java.awt.BorderLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.IJavaInfoInitializationParticipator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.BorderLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.ImplicitLayoutCreationSupport;
import org.eclipse.wb.internal.swing.model.layout.ImplicitLayoutVariableSupport;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutCreationSupport;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class AbsoluteLayoutTest
extends AbstractLayoutTest {
    private static final IPreferenceStore preferences = SwingToolkitDescription.INSTANCE.getPreferences();
    private static final String POINT_ID = "org.eclipse.wb.core.java.javaInfoInitializationParticipators";

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        preferences.setValue("P_CREATION_FLOW", false);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        String buttonText = "The Button";
        ContainerInfo panel = this.parseContainer("class Test {\n\tpublic static void main(String[] args) {\n\t\tJPanel panel = new JPanel();\n\t\tpanel.setLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setText(\"%s\");\n\t\t\tbutton.setBounds(10, 10, 100, 100);\n\t\t\tpanel.add(button);\n\t\t}\n\t}\n}".formatted(buttonText));
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)panel.getLayout();
        Assertions.assertThat((List)panel.getChildren()).contains((Object[])new ObjectInfo[]{layout});
        ComponentDescription description = layout.getDescription();
        AbsoluteLayoutTest.assertSame((Object)ToolkitProvider.DESCRIPTION, (Object)description.getToolkit());
        AbsoluteLayoutTest.assertNotNull((Object)description.getIcon());
        CreationSupport creationSupport = layout.getCreationSupport();
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutCreationSupport.class, (Object)creationSupport);
        AbsoluteLayoutTest.assertEquals((Object)"panel.setLayout(null)", (Object)layout.getCreationSupport().toString());
        AbsoluteLayoutTest.assertSame((Object)panel.getMethodInvocation("setLayout(java.awt.LayoutManager)"), (Object)creationSupport.getNode());
        AbsoluteLayoutTest.assertFalse((boolean)creationSupport.canReorder());
        AbsoluteLayoutTest.assertFalse((boolean)creationSupport.canReparent());
        AbsoluteLayoutTest.assertTrue((boolean)creationSupport.canDelete());
        VariableSupport variableSupport = layout.getVariableSupport();
        AbsoluteLayoutTest.assertEquals((Object)"absolute", (Object)variableSupport.toString());
        AbsoluteLayoutTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.setName("abc");
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getReferenceExpression(null);
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getAccessExpression(null);
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbsoluteLayoutTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbsoluteLayoutTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getStatementTarget();
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getTitle();
            AbsoluteLayoutTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbsoluteLayoutTest.assertInstanceOf(InvocationChildAssociation.class, (Object)layout.getAssociation());
        AbsoluteLayoutTest.assertNotNull((Object)ObjectInfoUtils.getId((ObjectInfo)layout));
        ContainerInfo buttonInfo = (ContainerInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        try {
            JButton button = (JButton)buttonInfo.getComponent();
            AbsoluteLayoutTest.assertEquals((Object)new Rectangle(10, 10, 100, 100), (Object)buttonInfo.getBounds());
            AbsoluteLayoutTest.assertEquals((Object)buttonText, (Object)button.getText());
            AbsoluteLayoutTest.assertTrue((boolean)button.isVisible());
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_parseReplacedContentPane() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {\n\tprivate JPanel m_contentPane;\n\tpublic Test() {\n\t\tm_contentPane = new JPanel();\n\t\tm_contentPane.setLayout(null);\n\t\tsetContentPane(m_contentPane);\n\t}\n}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        AbsoluteLayoutTest.assertEquals((Object)"new JPanel()", (Object)this.m_lastEditor.getSource(contentPane.getCreationSupport().getNode()));
        LayoutInfo layout = contentPane.getLayout();
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)layout);
        Assertions.assertThat((List)contentPane.getChildren()).contains((Object[])new ObjectInfo[]{layout});
    }

    @Test
    public void test_layoutComplexProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t}\n}");
        Property layoutProperty = panel.getPropertyByTitle("Layout");
        AbsoluteLayoutTest.assertTrue((boolean)(layoutProperty instanceof ComplexProperty));
        AbsoluteLayoutTest.assertTrue((boolean)layoutProperty.isModified());
        String actualText = AbsoluteLayoutTest.getPropertyText(layoutProperty);
        AbsoluteLayoutTest.assertEquals((Object)"(absolute)", (Object)actualText);
    }

    @Test
    public void test_implicit() throws Exception {
        AbsoluteLayoutTest.setFileContentSrc("test/AbsolutePanel.java", this.getTestSource("public class AbsolutePanel extends JPanel {\n\tpublic AbsolutePanel() {\n\t\tsetLayout(null);\n\t}\n}"));
        AbsoluteLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends AbsolutePanel {\n\tpublic Test() {\n\t}\n}");
        LayoutInfo layout = panel.getLayout();
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)layout);
        AbsoluteLayoutTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)layout.getVariableSupport());
        AbsoluteLayoutTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
        CreationSupport creationSupport = layout.getCreationSupport();
        AbsoluteLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)creationSupport);
        AbsoluteLayoutTest.assertEquals((Object)"implicit-layout: absolute", (Object)creationSupport.toString());
        AbsoluteLayoutTest.setLayout(panel, BorderLayout.class);
        this.assertEditor("// filler filler filler\npublic class Test extends AbsolutePanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout(0, 0));\n\t}\n}");
        AbsoluteLayoutTest.assertInstanceOf(BorderLayoutInfo.class, (Object)panel.getLayout());
    }

    @Test
    public void test_absoluteOnContentPane() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {\n\tTest() {\n\t\tgetContentPane().setLayout(null);\n\t}\n}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        AbsoluteLayoutTest.assertEquals((Object)"{method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {/getContentPane().setLayout(null)/}", (Object)contentPane.toString());
        LayoutInfo layout = contentPane.getLayout();
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)layout);
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutCreationSupport.class, (Object)layout.getCreationSupport());
    }

    @Test
    public void test_initialize_setLayout() throws Exception {
        AbsoluteLayoutTest.addParticipatorExtension(AbsoluteLayout_Participator.class.getName());
        try {
            ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t}\n}");
            AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)panel.getLayout());
            AbsoluteLayoutTest.assertEquals((int)1, (int)AbsoluteLayout_Participator.m_initializeCount);
        }
        finally {
            AbsoluteLayoutTest.removeParticipatorExtension();
            AbsoluteLayout_Participator.m_initializeCount = 0;
        }
    }

    @Test
    public void test_initialize_implicitLayout() throws Exception {
        AbsoluteLayoutTest.addParticipatorExtension(AbsoluteLayout_Participator.class.getName());
        try {
            AbsoluteLayoutTest.setFileContentSrc("test/NullPanel.java", this.getTestSource("public class NullPanel extends JPanel {\n\tpublic NullPanel() {\n\t\tsetLayout(null);\n\t}\n}"));
            AbsoluteLayoutTest.waitForAutoBuild();
            ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends NullPanel {\n\tpublic Test() {\n\t}\n}");
            AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)panel.getLayout());
            Assertions.assertThat((int)AbsoluteLayout_Participator.m_initializeCount).isPositive();
        }
        finally {
            AbsoluteLayoutTest.removeParticipatorExtension();
            AbsoluteLayout_Participator.m_initializeCount = 0;
        }
    }

    @Test
    public void test_setBounds() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t//\n\t\tJButton button = new JButton();\n\t\tadd(button);\n\t\tbutton.setBounds(10, 20, 100, 50);\n\t}\n}");
        ContainerInfo buttonInfo = (ContainerInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        try {
            AbsoluteLayoutTest.assertEquals((Object)new Rectangle(10, 20, 100, 50), (Object)buttonInfo.getBounds());
            Assertions.assertThat((int)buttonInfo.getPreferredSize().width).isGreaterThanOrEqualTo(33);
            Assertions.assertThat((int)buttonInfo.getPreferredSize().width).isLessThanOrEqualTo(38);
            Assertions.assertThat((int)buttonInfo.getPreferredSize().height).isGreaterThanOrEqualTo(9);
            Assertions.assertThat((int)buttonInfo.getPreferredSize().height).isLessThanOrEqualTo(14);
            JButton button = (JButton)buttonInfo.getComponent();
            AbsoluteLayoutTest.assertEquals((int)10, (int)button.getBounds().x);
            AbsoluteLayoutTest.assertEquals((int)20, (int)button.getBounds().y);
            AbsoluteLayoutTest.assertEquals((int)100, (int)button.getBounds().width);
            AbsoluteLayoutTest.assertEquals((int)50, (int)button.getBounds().height);
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_setLocationSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t//\n\t\tJButton button = new JButton();\n\t\tadd(button);\n\t\tbutton.setLocation(new Point(10, 20));\n\t\tbutton.setSize(new Dimension(100, 50));\n\t}\n}");
        ContainerInfo buttonInfo = (ContainerInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        try {
            AbsoluteLayoutTest.assertEquals((Object)new Rectangle(10, 20, 100, 50), (Object)buttonInfo.getBounds());
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t}\n}");
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)panel.getLayout());
        LayoutInfo borderLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, BorderLayout.class, (CreationSupport)new ConstructorCreationSupport());
        panel.setLayout(borderLayout);
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(new BorderLayout(0, 0));\n\t}\n}");
        AbsoluteLayoutTest.assertSame((Object)borderLayout, (Object)panel.getLayout());
    }

    @Test
    public void test_removeComponentConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setLocation(0, 1);\n\t\t\tbutton.setLocation(new Point(0, 1));\n\t\t\tbutton.setSize(2, 3);\n\t\t\tbutton.setSize(new Dimension(2, 3));\n\t\t\tbutton.setBounds(0, 1, 2, 3);\n\t\t\tbutton.setBounds(new Rectangle(0, 1, 2, 3));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.getLayout().delete();
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_onSet_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutTest.assertNull((Object)button.getPropertyByTitle("Bounds"));
        AbsoluteLayoutInfo absoluteLayoutInfo = AbsoluteLayoutInfo.createExplicit((AstEditor)this.m_lastEditor);
        panel.setLayout((LayoutInfo)absoluteLayoutInfo);
        Dimension preferredSize = button.getPreferredSize();
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetSize(450, 300);\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(208, 5, %d, %d);\n\t\t\tadd(button);\n\t\t}\n\t}\n}".formatted(preferredSize.width, preferredSize.height));
        AbsoluteLayoutTest.assertNotNull((Object)button.getPropertyByTitle("Bounds"));
    }

    @Test
    public void test_onSet_implicit() throws Exception {
        AbsoluteLayoutTest.setFileContentSrc("test/AbsolutePanel.java", this.getTestSource("public class AbsolutePanel extends JPanel {\n\tpublic AbsolutePanel() {\n\t\tsetLayout(null);\n\t}\n}"));
        AbsoluteLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends AbsolutePanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout());\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        try {
            AbsoluteLayoutTest.assertInstanceOf(FlowLayoutInfo.class, (Object)panel.getLayout());
            panel.getLayout().delete();
            AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)panel.getLayout());
            CreationSupport creationSupport = panel.getLayout().getCreationSupport();
            AbsoluteLayoutTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)creationSupport);
            AbsoluteLayoutTest.assertEquals((Object)"implicit-layout: absolute", (Object)creationSupport.toString());
        }
        finally {
            panel.refresh_dispose();
        }
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        this.assertEditor("public class Test extends AbsolutePanel {\n\tpublic Test() {\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(208, 5, %d, %d);\n\t\t\tadd(button);\n\t\t}\n\t}\n}".formatted(preferredSize.width, preferredSize.height));
    }

    @Test
    public void test_moveUsingPoint() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 10, 34, 10);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, new Point(20, 20), null);
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(20, 20, 34, 10);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_moveAddBounds() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, new Point(20, 20), new Dimension(34, 10));
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(20, 20, 34, 10);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_moveChangeBoundsAsRectangle() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(new Rectangle(10, 10, 34, 10));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, new Point(20, 20), null);
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(new Rectangle(20, 20, 34, 10));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_moveUsingSetLocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setLocation(new Point(10, 10));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, new Point(20, 20), null);
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setLocation(new Point(20, 20));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_moveAddSetLocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setSize(new Dimension(10, 10));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, new Point(20, 20), null);
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setLocation(20, 20);\n\t\t\tbutton.setSize(new Dimension(10, 10));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_resizeUsingPoint() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 10, 34, 10);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, null, new Dimension(100, 100));
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 10, 100, 100);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_resizeChangeBoundsAsRectangle() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(new Rectangle(10, 10, 34, 10));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, null, new Dimension(100, 100));
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(new Rectangle(10, 10, 100, 100));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_resizeUsingSetSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setSize(new Dimension(100, 100));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, null, new Dimension(110, 100));
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setSize(new Dimension(110, 100));\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_resizeAddSetSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setLocation(10, 10);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutInfo layoutInfo = (AbsoluteLayoutInfo)panel.getLayout();
        layoutInfo.command_BOUNDS(buttonInfo, null, new Dimension(100, 100));
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\tsetSize(450, 300);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setSize(100, 100);\n\t\t\tbutton.setLocation(10, 10);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_ordering() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tadd(button_0);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t}\n}");
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager orderManager = AbsoluteLayoutTest.createOrderManager(button_0);
        AbsoluteLayoutTest.assertNotNull((Object)orderManager);
        IAction action = AbsoluteLayoutTest.findChildAction((IContributionManager)orderManager, "Send to Back");
        AbsoluteLayoutTest.assertTrue((boolean)action.isEnabled());
        action.run();
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tadd(button_0);\n\t\t}\n\t}\n}");
    }

    private static IMenuManager createOrderManager(ComponentInfo component) throws Exception {
        IMenuManager manager = AbsoluteLayoutTest.getContextMenu(new ObjectInfo[]{component});
        return AbsoluteLayoutTest.findChildMenuManager((IContributionManager)manager, "Order");
    }

    @Test
    public void test_autoSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t\tbutton.setBounds(10, 20, 200, 100);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension buttonPrefSize = button.getPreferredSize();
        MenuManager manager = AbsoluteLayoutTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(Collections.singletonList(button), (ObjectInfo)button, (IMenuManager)manager);
        IAction autoSizeAction = AbsoluteLayoutTest.findChildAction((IContributionManager)manager, "Autosize component");
        AbsoluteLayoutTest.assertNotNull((Object)autoSizeAction);
        autoSizeAction.run();
        this.assertEditor("public class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t\tbutton.setBounds(10, 20, %d, %d);\n\t\t}\n\t}\n}".formatted(buttonPrefSize.width, buttonPrefSize.height));
    }

    private Property prepareBoundsProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 30, 100, 200);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        panel.refresh();
        Property boundsProperty = ((ComponentInfo)panel.getChildrenComponents().get(0)).getPropertyByTitle("Bounds");
        return boundsProperty;
    }

    private Property getBoundsPropertySubProperty(String title) throws Exception {
        ComplexProperty boundsProperty = (ComplexProperty)this.prepareBoundsProperty();
        Property[] subProperties = boundsProperty.getProperties();
        return AbsoluteLayoutTest.getPropertyByTitle(subProperties, title);
    }

    @Test
    public void test_BoundsProperty() throws Exception {
        Property boundsProperty = this.prepareBoundsProperty();
        AbsoluteLayoutTest.assertNotNull((Object)boundsProperty);
        AbsoluteLayoutTest.assertTrue((boolean)(boundsProperty instanceof ComplexProperty));
        AbsoluteLayoutTest.assertTrue((boolean)boundsProperty.isModified());
        ComplexProperty boundsComplexProperty = (ComplexProperty)boundsProperty;
        Property[] subProperties = boundsComplexProperty.getProperties();
        AbsoluteLayoutTest.assertEquals((int)subProperties.length, (int)4);
        String actualText = AbsoluteLayoutTest.getPropertyText(boundsProperty);
        AbsoluteLayoutTest.assertEquals((Object)"(10, 30, 100, 200)", (Object)actualText);
    }

    @Test
    public void test_BoundsProperty_set_x() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("x");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)0);
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(0, 30, 100, 200);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_BoundsProperty_get_x() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("x");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        AbsoluteLayoutTest.assertTrue((boolean)subProperty.isModified());
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)10, (int)((Integer)value));
    }

    @Test
    public void test_BoundsProperty_set_y() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("y");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)5);
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 5, 100, 200);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_BoundsProperty_get_y() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("y");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)30, (int)((Integer)value));
    }

    @Test
    public void test_BoundsProperty_set_width() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("width");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)150);
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 30, 150, 200);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_BoundsProperty_get_width() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("width");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)100, (int)((Integer)value));
    }

    @Test
    public void test_BoundsProperty_set_height() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("height");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        subProperty.setValue((Object)220);
        this.assertEditor("class Test extends JPanel {\n\tTest() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(10, 30, 100, 220);\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_BoundsProperty_get_height() throws Exception {
        Property subProperty = this.getBoundsPropertySubProperty("height");
        AbsoluteLayoutTest.assertNotNull((Object)subProperty);
        Object value = subProperty.getValue();
        AbsoluteLayoutTest.assertInstanceOf(Integer.class, (Object)value);
        AbsoluteLayoutTest.assertEquals((int)200, (int)((Integer)value));
    }

    private static void addParticipatorExtension(String className) throws Exception {
        String contribution = "  <participator class='" + className + "'/>";
        TestUtils.addDynamicExtension(POINT_ID, contribution);
    }

    private static void removeParticipatorExtension() throws Exception {
        TestUtils.removeDynamicExtension(POINT_ID);
    }

    @Test
    public void test_canMove() throws Exception {
        AbsoluteLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {\n\tprivate JButton m_button = new JButton();\n\tpublic MyPanel() {\n\t\tsetLayout(null);\n\t\tadd(m_button);\n\t}\n\tpublic JButton getButton() {\n\t\treturn m_button;\n\t}\n}"));
        AbsoluteLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends MyPanel {\n\tpublic Test() {\n\t}\n}");
        AbsoluteLayoutTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)panel.getLayout());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbsoluteLayoutTest.assertFalse((boolean)button.getCreationSupport().canReorder());
        AbsoluteLayoutTest.assertFalse((boolean)button.getCreationSupport().canReparent());
        AbsoluteLayoutTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        AbsoluteLayoutTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t\tbuttonA.setBounds(10, 20, 100, 50);\n\t\t}\n\t}\n}");
        panel.refresh();
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)panel.getLayout();
        ContainerInfo buttonA = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newButton = AbsoluteLayoutTest.createJButton();
        layout.command_CREATE(newButton, (ComponentInfo)buttonA);
        layout.command_BOUNDS(newButton, new Point(1, 2), new Dimension(3, 4));
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tbutton.setBounds(1, 2, 3, 4);\n\t\t\tadd(button);\n\t\t}\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t\tbuttonA.setBounds(10, 20, 100, 50);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t\tbuttonA.setBounds(10, 20, 100, 50);\n\t\t}\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t\tbuttonB.setBounds(20, 100, 50, 20);\n\t\t}\n\t}\n}");
        panel.refresh();
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)panel.getLayout();
        ContainerInfo buttonA = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo buttonB = (ContainerInfo)panel.getChildrenComponents().get(1);
        layout.command_MOVE((ComponentInfo)buttonB, (ComponentInfo)buttonA);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton buttonB = new JButton();\n\t\t\tadd(buttonB);\n\t\t\tbuttonB.setBounds(20, 100, 50, 20);\n\t\t}\n\t\t{\n\t\t\tJButton buttonA = new JButton();\n\t\t\tadd(buttonA);\n\t\t\tbuttonA.setBounds(10, 20, 100, 50);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_BOUNDS_CreationFlow() throws Exception {
        preferences.setValue("P_CREATION_FLOW", true);
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button1 = new JButton();\n\t\t\tadd(button1);\n\t\t\tbutton1.setBounds(5, 5, 100, 30);\n\t\t\tbutton1.setText(\"Button1\");\n\t\t}\n\t\t{\n\t\t\tJButton button2 = new JButton();\n\t\t\tadd(button2);\n\t\t\tbutton2.setBounds(110, 50, 100, 30);\n\t\t\tbutton2.setText(\"Button2\");\n\t\t}\n\t}\n}");
        panel.refresh();
        AbsoluteLayoutInfo layout = (AbsoluteLayoutInfo)panel.getLayout();
        ContainerInfo button1 = (ContainerInfo)AbsoluteLayoutTest.getJavaInfoByName("button1");
        layout.command_BOUNDS((ComponentInfo)button1, new Point(110, 90), null);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(null);\n\t\t{\n\t\t\tJButton button2 = new JButton();\n\t\t\tadd(button2);\n\t\t\tbutton2.setBounds(110, 50, 100, 30);\n\t\t\tbutton2.setText(\"Button2\");\n\t\t}\n\t\t{\n\t\t\tJButton button1 = new JButton();\n\t\t\tadd(button1);\n\t\t\tbutton1.setBounds(110, 90, 100, 30);\n\t\t\tbutton1.setText(\"Button1\");\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_clipboard() throws Exception {
        String lines1 = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tinner.add(button);\n\t\t\t\tbutton.setBounds(1, 2, 3, 4);\n\t\t\t}\n\t\t}\n\t}\n}";
        final ContainerInfo panel = this.parseContainer(lines1);
        panel.refresh();
        ComponentInfo inner = (ComponentInfo)panel.getChildrenComponents().get(0);
        final JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ContainerInfo copy = (ContainerInfo)memento.create((JavaInfo)panel);
                ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)copy, null);
                memento.apply();
            }
        });
        String lines = "public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tinner.add(button);\n\t\t\t\tbutton.setBounds(1, 2, 3, 4);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tinner.setLayout(null);\n\t\t\tadd(inner);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tbutton.setBounds(1, 2, 3, 4);\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}";
        this.assertEditor(lines);
        AbsoluteLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(inner)/ /add(inner)/}\n\t{implicit-layout: java.awt.FlowLayout} {implicit-layout} {}\n\t{new: javax.swing.JPanel} {local-unique: inner} {/new JPanel()/ /inner.setLayout(null)/ /add(inner)/ /inner.add(button)/}\n\t\t{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /inner.add(button)/ /button.setBounds(1, 2, 3, 4)/}\n\t\t{inner.setLayout(null)} {absolute} {}\n\t{new: javax.swing.JPanel} {local-unique: inner} {/new JPanel()/ /add(inner)/ /inner.setLayout(null)/ /inner.add(button)/}\n\t\t{inner.setLayout(null)} {absolute} {}\n\t\t{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /inner.add(button)/ /button.setBounds(1, 2, 3, 4)/}");
    }

    public static final class AbsoluteLayout_Participator
    implements IJavaInfoInitializationParticipator {
        private static int m_initializeCount;

        public void process(JavaInfo javaInfo) throws Exception {
            if (javaInfo instanceof AbsoluteLayoutInfo) {
                ++m_initializeCount;
            }
        }
    }
}

