/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.awt.Component;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class SwingLiveManagerTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_GlobalState() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        SwingLiveManagerTest.assertSame((Object)panel, (Object)GlobalState.getActiveObject());
        ComponentInfo button = SwingLiveManagerTest.createJButton();
        Component component = button.getComponent();
        SwingLiveManagerTest.assertNotNull((Object)component);
        SwingLiveManagerTest.assertSame((Object)panel, (Object)GlobalState.getActiveObject());
    }

    @Test
    public void test_create() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = SwingLiveManagerTest.createJButton();
        ComponentInfo button_2 = SwingLiveManagerTest.createJButton();
        Component component_1 = button_1.getComponent();
        Component component_2 = button_2.getComponent();
        SwingLiveManagerTest.assertNotNull((Object)component_1);
        SwingLiveManagerTest.assertNotNull((Object)component_2);
        SwingLiveManagerTest.assertSame((Object)component_1, (Object)component_2);
    }

    @Test
    public void test_liveImage_forcedSize() throws Exception {
        SwingLiveManagerTest.setFileContentSrc("test/MyCanvas.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyCanvas extends Canvas {", "}"));
        SwingLiveManagerTest.setFileContentSrc("test/MyCanvas.wbp-component.xml", SwingLiveManagerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='liveComponent.forcedSize.width'>100</parameter>", "    <parameter name='liveComponent.forcedSize.height'>50</parameter>", "  </parameters>", "</component>"));
        SwingLiveManagerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyCanvas"), (CreationSupport)new ConstructorCreationSupport());
        Image image = newComponent.getImage();
        SwingLiveManagerTest.assertNotNull((Object)image);
        SwingLiveManagerTest.assertEquals((int)image.getBounds().width, (int)100);
        SwingLiveManagerTest.assertEquals((int)image.getBounds().height, (int)50);
    }

    @Test
    public void test_whenException() throws Exception {
        Image image;
        ComponentInfo newComponent;
        SwingLiveManagerTest.setFileContentSrc("test/MyCanvas.java", this.getTestSource("public class MyCanvas extends Canvas {", "  public void paint(Graphics g) {", "    throw new IllegalStateException('Problem in constructor');", "  }", "}"));
        SwingLiveManagerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        String originalSource = this.m_lastEditor.getSource();
        ILog log = DesignerPlugin.getDefault().getLog();
        Object logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                SwingLiveManagerTest.assertEquals((int)4, (int)status.getSeverity());
                Throwable exception = status.getException();
                Assertions.assertThat((Throwable)exception).isExactlyInstanceOf(IllegalStateException.class);
                SwingLiveManagerTest.assertEquals((Object)"Problem in constructor", (Object)exception.getMessage());
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyCanvas"), (CreationSupport)new ConstructorCreationSupport());
            image = newComponent.getImage();
            SwingLiveManagerTest.assertNotNull((Object)image);
            SwingLiveManagerTest.assertEquals((int)image.getBounds().width, (int)200);
            SwingLiveManagerTest.assertEquals((int)image.getBounds().height, (int)50);
            SwingLiveManagerTest.assertEditor(originalSource, this.m_lastEditor);
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
        log = DesignerPlugin.getDefault().getLog();
        logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                SwingLiveManagerTest.fail();
            }
        };
        try {
            log.addLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyCanvas"), (CreationSupport)new ConstructorCreationSupport());
            image = newComponent.getImage();
            SwingLiveManagerTest.assertNotNull((Object)image);
            SwingLiveManagerTest.assertEquals((int)image.getBounds().width, (int)200);
            SwingLiveManagerTest.assertEquals((int)image.getBounds().height, (int)50);
        }
        finally {
            log.removeLogListener(logListener);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
    }

    @Test
    public void test_liveBaseline() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ComponentInfo newButton = (ComponentInfo)SwingLiveManagerTest.createJavaInfo("javax.swing.JButton");
        int liveBaseline = newButton.getBaseline();
        SwingLiveManagerTest.assertNotEquals((int)liveBaseline, (int)-1);
        SwingLiveManagerTest.assertTrue((liveBaseline > 0 ? 1 : 0) != 0);
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('New button');", "      add(button);", "    }", "  }", "}");
        int baseline = newButton.getBaseline();
        SwingLiveManagerTest.assertEquals((int)baseline, (int)liveBaseline);
    }
}

