/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.awt.Component;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.rcp.swtawt.palette.SwingCompositeEntryInfo;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SwtAwtTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    protected void configureToolkits() {
        super.configureToolkits();
        SwtAwtTest.configureDefaults(ToolkitProvider.DESCRIPTION);
    }

    @Disabled
    @Test
    public void test_parse() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.awt.Frame;", "import org.eclipse.swt.awt.SWT_AWT;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Composite composite = new Composite(this, SWT.EMBEDDED);", "    SWT_AWT.new_Frame(composite);", "  }", "}");
        SwtAwtTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new Composite(this, SWT.EMBEDDED)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.widgets.Composite} {local-unique: composite} {/new Composite(this, SWT.EMBEDDED)/ /SWT_AWT.new_Frame(composite)/}", "    {implicit-layout: absolute} {implicit-layout} {}", "    {static factory: org.eclipse.swt.awt.SWT_AWT new_Frame(org.eclipse.swt.widgets.Composite)} {empty} {/SWT_AWT.new_Frame(composite)/}", "      {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        ComponentInfo frame = (ComponentInfo)composite.getChildren(ComponentInfo.class).get(0);
        shell.refresh();
        SwtAwtTest.assertNotNull((Object)frame.getImage());
        Rectangle frameBounds = frame.getBounds();
        Rectangle compositeBounds = composite.getBounds();
        SwtAwtTest.assertEquals((int)frameBounds.x, (int)0);
        SwtAwtTest.assertEquals((int)frameBounds.y, (int)0);
        SwtAwtTest.assertEquals((int)frameBounds.width, (int)compositeBounds.width);
        SwtAwtTest.assertEquals((int)frameBounds.height, (int)compositeBounds.height);
        Component frameComponent = frame.getComponent();
        SwtAwtTest.assertTrue((boolean)frameComponent.isVisible());
    }

    @Disabled
    @Test
    public void test_parseWithBorder() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.awt.Frame;", "import org.eclipse.swt.awt.SWT_AWT;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Composite composite = new Composite(this, SWT.BORDER | SWT.EMBEDDED);", "    SWT_AWT.new_Frame(composite);", "  }", "}");
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        ComponentInfo frame = (ComponentInfo)composite.getChildren(ComponentInfo.class).get(0);
        shell.refresh();
        SwtAwtTest.assertNotNull((Object)frame.getImage());
        Rectangle frameBounds = frame.getBounds();
        SwtAwtTest.assertEquals((int)frameBounds.x, (int)2);
        SwtAwtTest.assertEquals((int)frameBounds.y, (int)2);
        SwtAwtTest.assertEquals((int)frameBounds.width, (int)(composite.getBounds().width - 2 - 2));
        SwtAwtTest.assertEquals((int)frameBounds.height, (int)(composite.getBounds().height - 2 - 2));
    }

    @Disabled
    @Test
    public void test_parseWhenZeroSize() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.awt.Frame;", "import org.eclipse.swt.awt.SWT_AWT;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Composite composite = new Composite(this, SWT.EMBEDDED);", "    composite.setLayoutData(new RowData(0,0));", "    Frame frame = SWT_AWT.new_Frame(composite);", "  }", "}");
        ComponentInfo frame = (ComponentInfo)SwtAwtTest.getJavaInfoByName("frame");
        shell.refresh();
        SwtAwtTest.assertNotNull((Object)frame.getImage());
        Rectangle frameBounds = frame.getBounds();
        SwtAwtTest.assertEquals((int)frameBounds.x, (int)0);
        SwtAwtTest.assertEquals((int)frameBounds.y, (int)0);
    }

    @Test
    public void test_SwingComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("import java.awt.Frame;", "import org.eclipse.swt.awt.SWT_AWT;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        SwingCompositeEntryInfo entry = new SwingCompositeEntryInfo();
        SwtAwtTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)shell));
        SwtAwtTest.assertNotNull((Object)entry.getIcon());
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        CompositeInfo composite = (CompositeInfo)creationFactory.getNewObject();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        fillLayout.command_CREATE((ControlInfo)composite, null);
        this.assertEditor("import java.awt.Frame;", "import org.eclipse.swt.awt.SWT_AWT;", "import java.awt.Panel;", "import java.awt.BorderLayout;", "import javax.swing.JRootPane;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.EMBEDDED);", "      {", "        Frame frame = SWT_AWT.new_Frame(composite);", "        {", "          Panel panel = new Panel();", "          frame.add(panel);", "          panel.setLayout(new BorderLayout(0, 0));", "          {", "            JRootPane rootPane = new JRootPane();", "            panel.add(rootPane);", "          }", "        }", "      }", "    }", "  }", "}");
    }
}

