/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import org.apache.commons.lang3.NotImplementedException;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.jface.action.MenuManagerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ToolBarManagerInfo;
import org.eclipse.wb.internal.rcp.model.rcp.ViewCategoryPropertyEditor;
import org.eclipse.wb.internal.rcp.model.rcp.ViewPartInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.rcp.model.rcp.AbstractPdeTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ViewPartTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Disabled
    @Test
    public void test_0() throws Exception {
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "  public void setFocus() {", "  }", "  public void init(IViewSite site) throws PartInitException {", "    super.init(site);", "    createActions();", "    initializeToolBar();", "    initializeMenu();", "  }", "  private void createActions() {", "  }", "  private void initializeToolBar() {", "    IToolBarManager toolbarManager = getViewSite().getActionBars().getToolBarManager();", "  }", "  private void initializeMenu() {", "    IMenuManager menuManager = getViewSite().getActionBars().getMenuManager();", "  }", "}");
        ViewPartTest.assertHierarchy("{this: org.eclipse.ui.part.ViewPart} {this} {/getViewSite().getActionBars()/ /getViewSite().getActionBars()/}", "  {invocationChain: getViewSite().getActionBars().getToolBarManager()} {local-unique: toolbarManager} {/getViewSite().getActionBars().getToolBarManager()/}", "  {invocationChain: getViewSite().getActionBars().getMenuManager()} {local-unique: menuManager} {/getViewSite().getActionBars().getMenuManager()/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        CompositeInfo parentComposite = (CompositeInfo)part.getChildren(CompositeInfo.class).get(0);
        CompositeInfo container = (CompositeInfo)parentComposite.getChildrenControls().get(0);
        part.refresh();
        ViewPartTest.assertNoErrors((JavaInfo)part);
        ViewPartTest.assertEquals((int)part.getBounds().width, (int)600);
        ViewPartTest.assertEquals((int)part.getBounds().height, (int)500);
        Assertions.assertThat((int)parentComposite.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)parentComposite.getBounds().height).isGreaterThan(30);
        Assertions.assertThat((int)container.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)container.getBounds().height).isGreaterThan(300);
        MenuManagerInfo manager = (MenuManagerInfo)part.getChildren(MenuManagerInfo.class).get(0);
        IMenuPopupInfo popupObject = part.getMenuImpl(manager);
        ViewPartTest.assertNotNull((Object)popupObject);
        ViewPartTest.assertSame((Object)manager, (Object)popupObject.getModel());
        ViewPartTest.assertSame((Object)manager, (Object)popupObject.getToolkitModel());
        ViewPartTest.assertNull((Object)popupObject.getImageDescriptor());
        Assertions.assertThat((int)popupObject.getBounds().width).isGreaterThan(10);
        Assertions.assertThat((int)popupObject.getBounds().height).isGreaterThan(10);
        ViewPartTest.assertSame((Object)MenuObjectInfoUtils.getMenuInfo((Object)manager), (Object)popupObject.getMenu());
        ViewPartTest.assertSame((Object)popupObject.getMenu().getPolicy(), (Object)popupObject.getPolicy());
        manager = (ToolBarManagerInfo)part.getChildren(ToolBarManagerInfo.class).get(0);
        Rectangle bounds = manager.getBounds();
        Assertions.assertThat((int)bounds.x).isGreaterThan(200);
        Assertions.assertThat((int)bounds.y).isGreaterThan(0).isLessThan(10);
        Assertions.assertThat((int)bounds.width).isGreaterThan(100).isLessThan(200);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20).isLessThan(30);
    }

    @Test
    public void test_IViewSite() throws Exception {
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public class Test extends ViewPart {", "  public static final String ID = 'some.view.Identifier';", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "  public void setFocus() {", "  }", "}");
        part.refresh();
        ViewPartTest.assertHierarchy("{this: org.eclipse.ui.part.ViewPart} {this} {}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        IViewSite viewSite = (IViewSite)ReflectionUtils.invokeMethod((Object)part.getObject(), (String)"getViewSite()", (Object[])new Object[0]);
        try {
            viewSite.getShell();
            ViewPartTest.fail();
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        ViewPartTest.assertEquals((Object)"IViewSite_stub", (Object)viewSite.toString());
        ViewPartTest.assertEquals((int)0, (int)viewSite.hashCode());
        ViewPartTest.assertEquals((Object)"some.view.Identifier", (Object)viewSite.getId());
        ViewPartTest.assertEquals(null, (Object)viewSite.getSecondaryId());
        IWorkbenchWindow window = viewSite.getWorkbenchWindow();
        ViewPartTest.assertSame((Object)DesignerPlugin.getActiveWorkbenchWindow(), (Object)window);
    }

    @Test
    public void test_noContributionManegers() throws Exception {
        this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "  public void setFocus() {", "  }", "  public void init(IViewSite site) throws PartInitException {", "    super.init(site);", "  }", "}");
        ViewPartTest.assertHierarchy("{this: org.eclipse.ui.part.ViewPart} {this} {}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/}", "      {implicit-layout: absolute} {implicit-layout} {}");
    }

    @Test
    public void test_normalProperties() throws Exception {
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "  public void setFocus() {", "  }", "  public void init(IViewSite site) throws PartInitException {", "    super.init(site);", "    createActions();", "  }", "  private void createActions() {", "  }", "}");
        part.getPropertyByTitle("partName").setValue((Object)"The name");
        part.getPropertyByTitle("contentDescription").setValue((Object)"The description");
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "  public void setFocus() {", "  }", "  public void init(IViewSite site) throws PartInitException {", "    super.init(site);", "    setContentDescription('The description');", "    setPartName('The name');", "    createActions();", "  }", "  private void createActions() {", "  }", "}");
    }

    @Test
    public void test_extensionProperties_notPlugin() throws Exception {
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        ViewPartTest.assertNull((Object)part.getPropertyByTitle("Extension"));
    }

    @Test
    public void test_extensionProperties_noExtension() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' class='C_1'/>", "  </extension>", "</plugin>");
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        ViewPartTest.assertNull((Object)part.getPropertyByTitle("Extension"));
    }

    @Test
    public void test_extensionProperties_hasExtension() throws Exception {
        ViewPartTest.do_projectDispose();
        ViewPartTest.do_projectCreate();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' name='name 1' icon='icons/false.gif' class='test.Test' category='category_1'/>", "  </extension>", "</plugin>");
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.ui.*;", "import org.eclipse.ui.part.*;", "public abstract class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        Property extensionProperty = part.getPropertyByTitle("Extension");
        ViewPartTest.assertNotNull((Object)extensionProperty);
        ViewPartTest.assertTrue((boolean)extensionProperty.getCategory().isSystem());
        Object[] subProperties = ViewPartTest.getSubProperties(extensionProperty);
        Assertions.assertThat((Object[])subProperties).hasSize(3);
        Object nameProperty = subProperties[0];
        ViewPartTest.assertEquals((Object)"name", (Object)nameProperty.getTitle());
        ViewPartTest.assertTrue((boolean)nameProperty.isModified());
        ViewPartTest.assertEquals((Object)"name 1", (Object)nameProperty.getValue());
        Object iconProperty = subProperties[1];
        ViewPartTest.assertEquals((Object)"icon", (Object)iconProperty.getTitle());
        ViewPartTest.assertTrue((boolean)iconProperty.isModified());
        ViewPartTest.assertEquals((Object)"icons/false.gif", (Object)iconProperty.getValue());
        Object categoryProperty = subProperties[2];
        ViewPartTest.assertEquals((Object)"category", (Object)categoryProperty.getTitle());
        ViewPartTest.assertTrue((boolean)categoryProperty.isModified());
        ViewPartTest.assertEquals((Object)"category_1", (Object)categoryProperty.getValue());
        final boolean[] refreshed = new boolean[1];
        part.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                refreshed[0] = true;
            }
        });
        Object nameProperty2 = subProperties[0];
        nameProperty2.setValue((Object)"New name");
        ViewPartTest.assertTrue((boolean)refreshed[0]);
    }

    @Test
    public void test_ViewCategory_PropertyEditor() throws Exception {
        ViewPartTest.do_projectDispose();
        ViewPartTest.do_projectCreate();
        PdeProjectConversionUtils.convertToPDE(m_testProject.getProject(), null, "testplugin.Activator");
        AbstractPdeTest.createPluginXML("<plugin>", "  <extension point='org.eclipse.ui.views'>", "    <view id='id_1' class='test.Test' category='category_1'/>", "  </extension>", "</plugin>");
        ViewPartInfo part = (ViewPartInfo)this.parseJavaInfo("import org.eclipse.ui.part.*;", "public abstract class Test extends ViewPart {", "  public Test() {", "  }", "  public void createPartControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "  }", "}");
        Property extensionProperty = part.getPropertyByTitle("Extension");
        Property categoryProperty = ViewPartTest.getSubProperties(extensionProperty)[2];
        ViewPartTest.assertEquals((Object)"category", (Object)categoryProperty.getTitle());
        ViewPartTest.assertTrue((boolean)categoryProperty.isModified());
        ViewPartTest.assertEquals((Object)"category_1", (Object)categoryProperty.getValue());
        ViewPartTest.assertSame((Object)ViewCategoryPropertyEditor.INSTANCE, (Object)categoryProperty.getEditor());
        ViewPartTest.assertEquals((Object)"category_1", (Object)ViewPartTest.getPropertyText(categoryProperty));
    }
}

