/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.validator;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.mockito.Mockito;

public abstract class AbstractLayoutRequestValidatorTest
extends SwingModelTest {
    protected static void assertTrue(ILayoutRequestValidator validator) {
        AbstractLayoutRequestValidatorTest.assertTrue((boolean)validator.validateCreateRequest(null, null));
        AbstractLayoutRequestValidatorTest.assertTrue((boolean)validator.validatePasteRequest(null, null));
        AbstractLayoutRequestValidatorTest.assertTrue((boolean)validator.validateMoveRequest(null, null));
        AbstractLayoutRequestValidatorTest.assertTrue((boolean)validator.validateAddRequest(null, null));
    }

    protected static void assertFalse(ILayoutRequestValidator validator) {
        AbstractLayoutRequestValidatorTest.assertFalse((boolean)validator.validateCreateRequest(null, null));
        AbstractLayoutRequestValidatorTest.assertFalse((boolean)validator.validatePasteRequest(null, null));
        AbstractLayoutRequestValidatorTest.assertFalse((boolean)validator.validateMoveRequest(null, null));
        AbstractLayoutRequestValidatorTest.assertFalse((boolean)validator.validateAddRequest(null, null));
    }

    protected static void assert_validateCMA(ILayoutRequestValidator validator, boolean expected, Object parent, Object child) throws Exception {
        EditPart host = AbstractLayoutRequestValidatorTest.createHost(parent);
        AbstractLayoutRequestValidatorTest.assert_validateCMA(validator, expected, host, child);
    }

    protected static void assert_validateCMA(ILayoutRequestValidator validator, boolean expected, EditPart host, Object child) throws Exception {
        AbstractLayoutRequestValidatorTest.assert_validateCreateRequest(validator, expected, host, child);
        AbstractLayoutRequestValidatorTest.assert_validateMoveRequest(validator, expected, host, child);
        AbstractLayoutRequestValidatorTest.assert_validateAddRequest(validator, expected, host, child);
    }

    protected static void assert_validateCreateRequest(ILayoutRequestValidator validator, boolean expected, EditPart host, final Object child) {
        AbstractLayoutRequestValidatorTest.assertEquals((Object)expected, (Object)validator.validateCreateRequest((org.eclipse.gef.EditPart)host, new CreateRequest(null){

            public Object getNewObject() {
                return child;
            }
        }));
    }

    protected static void assert_validatePasteRequest(ILayoutRequestValidator validator, boolean expected, Object parent, JavaInfo child) throws Exception {
        EditPart host = AbstractLayoutRequestValidatorTest.createHost(parent);
        AbstractLayoutRequestValidatorTest.assert_validatePasteRequest(validator, expected, host, child);
    }

    protected static void assert_validatePasteRequest(ILayoutRequestValidator validator, boolean expected, EditPart host, JavaInfo child) throws Exception {
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)child);
        PasteRequest request = new PasteRequest(List.of(memento));
        AbstractLayoutRequestValidatorTest.assertEquals((Object)expected, (Object)validator.validatePasteRequest((org.eclipse.gef.EditPart)host, request));
    }

    protected static void assert_validateMoveRequest(ILayoutRequestValidator validator, boolean expected, EditPart host, Object child) throws Exception {
        EditPart editPart = AbstractLayoutRequestValidatorTest.createHost(child);
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        request.setEditParts(List.of(editPart));
        AbstractLayoutRequestValidatorTest.assertEquals((Object)expected, (Object)validator.validateMoveRequest((org.eclipse.gef.EditPart)host, request));
        ((EditPart)Mockito.verify((Object)editPart)).getModel();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{editPart});
    }

    protected static void assert_validateAddRequest(ILayoutRequestValidator validator, boolean expected, EditPart host, Object child) throws Exception {
        EditPart editPart = AbstractLayoutRequestValidatorTest.createHost(child);
        ChangeBoundsRequest request = new ChangeBoundsRequest();
        request.setEditParts(List.of(editPart));
        AbstractLayoutRequestValidatorTest.assertEquals((Object)expected, (Object)validator.validateAddRequest((org.eclipse.gef.EditPart)host, request));
        ((EditPart)Mockito.verify((Object)editPart)).getModel();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{editPart});
    }

    private static EditPart createHost(Object parent) {
        EditPart host = (EditPart)Mockito.mock(EditPart.class);
        Mockito.when((Object)host.getModel()).thenReturn(parent);
        return host;
    }
}

