/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;

public class ExternalFactoriesHelperTest
extends DesignerTestCase {
    private static final String POINT_ID = "org.eclipse.wb.tests.testPoint";

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        ExternalFactoriesHelperTest.waitEventLoop(0);
        super.tearDown();
    }

    @Test
    public void test_addRemoveDynamicExtension_element() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <!-- filler filler filler filler filler filler -->", "  <testObject id='someId'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        List elements = ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject");
        Assertions.assertThat((List)elements).hasSize(1);
        ExternalFactoriesHelperTest.assertEquals((Object)"someId", (Object)((IConfigurationElement)elements.get(0)).getAttribute("id"));
        TestUtils.removeDynamicExtension(POINT_ID);
        elements = ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject");
        Assertions.assertThat((List)elements).isEmpty();
    }

    @Test
    public void test_addRemoveDynamicExtension_noWait() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <!-- filler filler filler filler filler filler -->", "  <testObject id='someId'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        List elements = ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject");
        Assertions.assertThat((List)elements).hasSize(1);
        ExternalFactoriesHelperTest.assertEquals((Object)"someId", (Object)((IConfigurationElement)elements.get(0)).getAttribute("id"));
        TestUtils.removeDynamicExtension_noWait(POINT_ID);
        elements = ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject");
        Assertions.assertThat((List)elements).isEmpty();
        TestUtils.removeDynamicExtension(POINT_ID);
    }

    @Test
    public void test_getElements_withPriority() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <testObject priority='1'/>", "  <testObject priority='2'/>", "  <testObject priority='3'/>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            List elements = ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject");
            Assertions.assertThat((List)elements).hasSize(3);
            ExternalFactoriesHelperTest.assertEquals((Object)"3", (Object)ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)((IConfigurationElement)elements.get(0)), (String)"priority"));
            ExternalFactoriesHelperTest.assertEquals((Object)"2", (Object)ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)((IConfigurationElement)elements.get(1)), (String)"priority"));
            ExternalFactoriesHelperTest.assertEquals((Object)"1", (Object)ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)((IConfigurationElement)elements.get(2)), (String)"priority"));
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getRequiredAttribute() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <!-- filler filler filler filler filler filler -->", "  <testObject id='someId'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            IConfigurationElement element = (IConfigurationElement)ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject").get(0);
            ExternalFactoriesHelperTest.assertEquals((Object)"someId", (Object)ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"id"));
            try {
                ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"noSuchAttribute");
                ExternalFactoriesHelperTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getRequiredAttributeInteger() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <!-- filler filler filler filler filler filler -->", "  <testObject value='555' badValue='notInteger'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            IConfigurationElement element = (IConfigurationElement)ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject").get(0);
            ExternalFactoriesHelperTest.assertEquals((int)555, (int)ExternalFactoriesHelper.getRequiredAttributeInteger((IConfigurationElement)element, (String)"value"));
            try {
                ExternalFactoriesHelper.getRequiredAttributeInteger((IConfigurationElement)element, (String)"badValue");
                ExternalFactoriesHelperTest.fail();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                ExternalFactoriesHelper.getRequiredAttributeInteger((IConfigurationElement)element, (String)"noSuchAttribute");
                ExternalFactoriesHelperTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getElementsInstances_newElement() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <testObject class='" + TestObject_1.class.getName() + "'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        List instances = ExternalFactoriesHelper.getElementsInstances(Object.class, (String)POINT_ID, (String)"testObject");
        Assertions.assertThat((List)instances).hasSize(1);
        Object instance = instances.get(0);
        ExternalFactoriesHelperTest.assertInstanceOf(TestObject_1.class, instance);
        ExternalFactoriesHelperTest.assertEquals((Object)"1", (Object)instance.toString());
        TestUtils.removeDynamicExtension(POINT_ID);
        instances = ExternalFactoriesHelper.getElementsInstances(Object.class, (String)POINT_ID, (String)"testObject");
        Assertions.assertThat((List)instances).isEmpty();
    }

    @Test
    public void test_getElementsInstances_INSTANCE() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <testObject class='" + TestObjectSingleton.class.getName() + "'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            List instances = ExternalFactoriesHelper.getElementsInstances(Object.class, (String)POINT_ID, (String)"testObject");
            Assertions.assertThat((List)instances).hasSize(1);
            ExternalFactoriesHelperTest.assertSame((Object)TestObjectSingleton.INSTANCE, instances.get(0));
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getElementsInstances_withPriority_D1() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <testObject class='" + TestObject_1.class.getName() + "'>", "  </testObject>", "  <testObject class='" + TestObject_2.class.getName() + "' priority='1'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            List instances = ExternalFactoriesHelper.getElementsInstances(Object.class, (String)POINT_ID, (String)"testObject");
            Assertions.assertThat((List)instances).hasSize(2);
            ExternalFactoriesHelperTest.assertEquals((Object)"2", (Object)instances.get(0).toString());
            ExternalFactoriesHelperTest.assertEquals((Object)"1", (Object)instances.get(1).toString());
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getElementsInstances_withPriority_1D() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <testObject class='" + TestObject_2.class.getName() + "' priority='1'>", "  </testObject>", "  <testObject class='" + TestObject_1.class.getName() + "'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            List instances = ExternalFactoriesHelper.getElementsInstances(Object.class, (String)POINT_ID, (String)"testObject");
            Assertions.assertThat((List)instances).hasSize(2);
            ExternalFactoriesHelperTest.assertEquals((Object)"2", (Object)instances.get(0).toString());
            ExternalFactoriesHelperTest.assertEquals((Object)"1", (Object)instances.get(1).toString());
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_getElementsInstances_withPriority_123() throws Exception {
        String contribution = ExternalFactoriesHelperTest.getSourceDQ("  <testObject class='" + TestObject_1.class.getName() + "' priority='1'>", "  </testObject>", "  <testObject class='" + TestObject_2.class.getName() + "' priority='2'>", "  </testObject>", "  <testObject class='" + TestObject_3.class.getName() + "' priority='3'>", "  </testObject>");
        TestUtils.addDynamicExtension(POINT_ID, contribution);
        try {
            List instances = ExternalFactoriesHelper.getElementsInstances(Object.class, (String)POINT_ID, (String)"testObject");
            Assertions.assertThat((List)instances).hasSize(3);
            ExternalFactoriesHelperTest.assertEquals((Object)"3", (Object)instances.get(0).toString());
            ExternalFactoriesHelperTest.assertEquals((Object)"2", (Object)instances.get(1).toString());
            ExternalFactoriesHelperTest.assertEquals((Object)"1", (Object)instances.get(2).toString());
        }
        finally {
            TestUtils.removeDynamicExtension(POINT_ID);
        }
    }

    @Test
    public void test_loadBundleClass() throws Exception {
        Class<TestObject_1> clazz = TestObject_1.class;
        String className = clazz.getName();
        ExternalFactoriesHelperTest.assertSame(clazz, (Object)ExternalFactoriesHelper.loadBundleClass((String)className));
        clazz = TestObject_1[].class;
        className = clazz.getName();
        ExternalFactoriesHelperTest.assertSame(clazz, (Object)ExternalFactoriesHelper.loadBundleClass((String)className));
        ExternalFactoriesHelperTest.assertSame(List.class, (Object)ExternalFactoriesHelper.loadBundleClass((String)"java.util.List"));
    }

    @Test
    public void test_loadBundleClass_whenInvalidExtension() throws Exception {
        String pointId = "org.eclipse.wb.core.classLoadingContributor";
        TestUtils.addDynamicExtension(pointId, "<contributor no-namespace='foo'/>");
        try {
            try {
                ExternalFactoriesHelper.loadBundleClass((String)"java.util.List");
                ExternalFactoriesHelperTest.fail();
            }
            catch (ClassNotFoundException e) {
                ExternalFactoriesHelperTest.assertInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            }
        }
        finally {
            TestUtils.removeDynamicExtension(pointId);
        }
    }

    @Test
    public void test_getRequiredBundle_good() throws Exception {
        String id = "org.eclipse.wb.core";
        Bundle expected = Platform.getBundle((String)id);
        ExternalFactoriesHelperTest.assertEquals((Object)expected, (Object)ExternalFactoriesHelper.getRequiredBundle((String)id));
    }

    @Test
    public void test_getRequiredBundle_noSuchBundle() throws Exception {
        String id = "no.such.bundle";
        try {
            ExternalFactoriesHelper.getRequiredBundle((String)id);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{id});
        }
    }

    @Test
    public void test_getImageDescriptor_noSuchAttribute() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension(POINT_ID, "<testObject/>");
            testBundle.install();
            IConfigurationElement element = (IConfigurationElement)ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject").get(0);
            ImageDescriptor descriptor = ExternalFactoriesHelper.getImageDescriptor((IConfigurationElement)element, (String)"noAttribute");
            ExternalFactoriesHelperTest.assertNull((Object)descriptor);
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_getImageDescriptor_success() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension(POINT_ID, "<testObject icon='res/path/test.png'/>");
            testBundle.setFile("res/path/test.png", TestUtils.createImagePNG(2, 3));
            testBundle.install();
            IConfigurationElement element = (IConfigurationElement)ExternalFactoriesHelper.getElements((String)POINT_ID, (String)"testObject").get(0);
            ImageDescriptor descriptor = ExternalFactoriesHelper.getImageDescriptor((IConfigurationElement)element, (String)"icon");
            ExternalFactoriesHelperTest.assertNotNull((Object)descriptor);
            Image image = descriptor.createImage();
            try {
                ExternalFactoriesHelperTest.assertEquals((int)2, (int)image.getBounds().width);
                ExternalFactoriesHelperTest.assertEquals((int)3, (int)image.getBounds().height);
            }
            finally {
                image.dispose();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    public static class TestObjectSingleton {
        public static final Object INSTANCE = new TestObjectSingleton();

        public String toString() {
            return "singleton";
        }
    }

    public static class TestObject_1 {
        public String toString() {
            return "1";
        }
    }

    public static class TestObject_2 {
        public String toString() {
            return "2";
        }
    }

    public static class TestObject_3 {
        public String toString() {
            return "3";
        }
    }
}

