/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util;

import java.lang.reflect.Field;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.ICoreExceptionConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DesignerExceptionTest
extends Assertions {
    private static final int CODE = 12345;
    private static final String PARAMETER_0 = "a";
    private static final String PARAMETER_1 = "b";

    @Test
    public void test_1() {
        DesignerException designerException = new DesignerException(12345, new Object[]{PARAMETER_0});
        DesignerExceptionTest.assertEquals((int)12345, (int)designerException.getCode());
        Object[] parameters = designerException.getParameters();
        DesignerExceptionTest.assertEquals((int)parameters.length, (int)1);
        DesignerExceptionTest.assertSame((Object)PARAMETER_0, (Object)parameters[0]);
    }

    @Test
    public void test_2() {
        DesignerException designerException = new DesignerException(12345, new Object[]{PARAMETER_0, PARAMETER_1});
        DesignerExceptionTest.assertEquals((int)12345, (int)designerException.getCode());
        Object[] parameters = designerException.getParameters();
        DesignerExceptionTest.assertEquals((int)parameters.length, (int)2);
        DesignerExceptionTest.assertSame((Object)PARAMETER_0, (Object)parameters[0]);
        DesignerExceptionTest.assertSame((Object)PARAMETER_1, (Object)parameters[1]);
    }

    @Test
    public void test_all() {
        Exception cause = new Exception();
        DesignerException designerException = new DesignerException(12345, (Throwable)cause, new Object[]{PARAMETER_0});
        DesignerExceptionTest.assertEquals((int)12345, (int)designerException.getCode());
        DesignerExceptionTest.assertSame((Object)cause, (Object)designerException.getCause());
        Object[] parameters = designerException.getParameters();
        DesignerExceptionTest.assertEquals((int)parameters.length, (int)1);
        DesignerExceptionTest.assertSame((Object)PARAMETER_0, (Object)parameters[0]);
    }

    @Test
    public void test_setSourcePosition() {
        DesignerException designerException = new DesignerException(12345, new Object[0]);
        DesignerExceptionTest.assertEquals((int)-1, (int)designerException.getSourcePosition());
        int expectedPosition = 5;
        designerException.setSourcePosition(expectedPosition);
        DesignerExceptionTest.assertEquals((int)expectedPosition, (int)designerException.getSourcePosition());
    }

    @Test
    public void test_ICoreExceptionConstants() throws Exception {
        Field wrapperField = ICoreExceptionConstants.class.getField("UNEXPECTED");
        DesignerExceptionTest.assertEquals((int)1, (int)wrapperField.getInt(null));
    }

    @Test
    public void test_getMessage_useTitle_knownCode() {
        DesignerException designerException = new DesignerException(1, new Object[0]);
        DesignerExceptionTest.assertEquals((Object)"1 (Internal Error).", (Object)designerException.getMessage());
    }

    @Test
    public void test_getMessage_useTitle_knownCode_withParameters() {
        DesignerException designerException = new DesignerException(1, new Object[]{"A", "BB"});
        DesignerExceptionTest.assertEquals((Object)"1 (Internal Error). A BB", (Object)designerException.getMessage());
    }

    @Test
    public void test_getMessage_useTitle_unknownCode() {
        DesignerException designerException = new DesignerException(-1000, new Object[0]);
        DesignerExceptionTest.assertEquals((Object)"-1000 (No description).", (Object)designerException.getMessage());
    }
}

