/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.util.Lists;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IExposedCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IWrapperControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryContainerInfo;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryRootProcessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.core.model.WrapperInfoTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class JavaInfoUtilsTest
extends SwingModelTest {
    private static final IPreferenceStore PREFERENCES = ToolkitProvider.DESCRIPTION.getPreferences();

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_assertIsNotDeleted() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtils.assertIsNotDeleted((JavaInfo)button);
        button.delete();
        try {
            JavaInfoUtils.assertIsNotDeleted((JavaInfo)button);
            JavaInfoUtilsTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_getTypeDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertSame(this.m_lastEditor.getAstUnit().types().get(0), (Object)JavaInfoUtils.getTypeDeclaration((JavaInfo)panel));
    }

    @Test
    public void test_getMethodDeclaration_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        JavaInfoUtilsTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)JavaInfoUtils.getMethodDeclaration((JavaInfo)panel));
    }

    @Test
    public void test_getMethodDeclaration_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('button');", "    add(button);", "  }", "}");
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        JavaInfoUtilsTest.assertSame((Object)typeDeclaration.getMethods()[0], (Object)JavaInfoUtils.getMethodDeclaration((JavaInfo)((JavaInfo)panel.getChildrenComponents().get(0))));
    }

    @Test
    public void test_EditorState_getState() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertSame((Object)this.m_lastState, (Object)JavaInfoUtils.getState((JavaInfo)panel));
    }

    @Test
    public void test_EditorState_getEditorLoader() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertSame((Object)this.m_lastLoader, (Object)JavaInfoUtils.getClassLoader((JavaInfo)panel));
    }

    @Test
    public void test_isLocalField() throws Exception {
        IType constants_1 = this.createModelType("test", "IConstants_1.java", JavaInfoUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public interface IConstants_1 {", "  int field_1 = 1;", "}"));
        IType constants_2 = this.createModelType("test", "IConstants_2.java", JavaInfoUtilsTest.getSourceDQ("// filler filler filler filler filler", "package test;", "public interface IConstants_2 {", "  int field_2 = 2;", "}"));
        JavaInfo javaInfo = this.parseSource("test", "Test.java", JavaInfoUtilsTest.getSourceDQ("package test;", "public class Test extends javax.swing.JPanel implements IConstants_1 {", "  int field_3 = 3;", "}"));
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.isLocalField((JavaInfo)javaInfo, (IField)constants_1.getField("field_1")));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.isLocalField((JavaInfo)javaInfo, (IField)constants_2.getField("field_2")));
        IType testType = m_testProject.getJavaProject().findType("test.Test");
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.isLocalField((JavaInfo)javaInfo, (IField)testType.getField("field_3")));
    }

    @Test
    public void test_isImplicitlyCreated() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler filler filler", "public class Test extends JFrame {", "  public Test() {", "    getContentPane().add(new JButton());", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.isImplicitlyCreated((JavaInfo)contentPane));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.isImplicitlyCreated((JavaInfo)button));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.isImplicitlyCreated((JavaInfo)frame));
    }

    @Test
    public void test_scheduleSave() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String source = this.m_lastEditor.getSource();
        this.m_lastEditor.getModelUnit().getBuffer().replace(0, 0, "   ");
        JavaInfoUtils.scheduleSave((JavaInfo)panel);
        JavaInfoUtilsTest.assertEquals((Object)source, (Object)JavaInfoUtilsTest.getFileContentSrc("test/Test.java"));
        JavaInfoUtilsTest.waitEventLoop(10);
        JavaInfoUtilsTest.assertEquals((Object)("   " + source), (Object)JavaInfoUtilsTest.getFileContentSrc("test/Test.java"));
    }

    @Test
    public void test_scheduleOpenNode() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        MethodDeclaration constructor = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel).getMethods()[0];
        ArgumentCaptor openSourcePosition = ArgumentCaptor.forClass(Integer.class);
        IDesignPageSite pageSite = (IDesignPageSite)Mockito.mock(IDesignPageSite.class);
        DesignPageSite.Helper.setSite((ObjectInfo)panel, (IDesignPageSite)pageSite);
        JavaInfoUtils.scheduleOpenNode((JavaInfo)panel, (ASTNode)constructor);
        JavaInfoUtilsTest.waitEventLoop(0);
        ((IDesignPageSite)Mockito.verify((Object)pageSite)).openSourcePosition(((Integer)openSourcePosition.capture()).intValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{pageSite});
        JavaInfoUtilsTest.assertTrue(((Integer)openSourcePosition.getValue() != 0 ? 1 : 0) != 0);
        JavaInfoUtilsTest.assertEquals((int)constructor.getStartPosition(), (int)((Integer)openSourcePosition.getValue()));
    }

    @Test
    public void test_getParameter_normalComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertEquals((Object)"false", (Object)JavaInfoUtils.getParameter((JavaInfo)button, (String)"layout.has"));
    }

    @Test
    public void test_getParameter_factoryComponent() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <parameters>", "      <parameter name='parameter.1'>some value</parameter>", "    </parameters>", "  </method>", "</factory>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertEquals((Object)"some value", (Object)JavaInfoUtils.getParameter((JavaInfo)button, (String)"parameter.1"));
        JavaInfoUtilsTest.assertNull((Object)button.getDescription().getParameter("parameter.1"));
    }

    @Test
    public void test_hasTrueParameter() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='trueParameter'>true</parameter>", "    <parameter name='falseParameter'>false</parameter>", "  </parameters>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.hasTrueParameter((JavaInfo)panel, (String)"trueParameter"));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.hasTrueParameter((JavaInfo)panel, (String)"falseParameter"));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.hasTrueParameter((JavaInfo)panel, (String)"noSuchParameter"));
    }

    @Test
    public void test_setParameter() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String parameterName = "noSuchParameter";
        String parameterValue = "the Value";
        JavaInfoUtilsTest.assertNull((Object)JavaInfoUtils.getParameter((JavaInfo)panel, (String)parameterName));
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)parameterName, (String)parameterValue);
        JavaInfoUtilsTest.assertSame((Object)parameterValue, (Object)JavaInfoUtils.getParameter((JavaInfo)panel, (String)parameterName));
    }

    @Test
    public void test_getParameters() throws Exception {
        this.setJavaContentSrc("test", "MyPanel", new String[]{"public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='test.parameter.1'>value_1</parameter>", "    <parameter name='test.parameter.2'>1000</parameter>", "  </parameters>", "</component>"});
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertEquals((Object)JavaInfoUtils.getParameter((JavaInfo)panel, (String)"test.parameter.1"), (Object)"value_1");
        JavaInfoUtilsTest.assertEquals((Object)JavaInfoUtils.getParameter((JavaInfo)panel, (String)"test.parameter.2"), (Object)"1000");
        JavaInfoUtilsTest.assertNull((Object)JavaInfoUtils.getParameter((JavaInfo)panel, (String)"test.parameter.3"));
        Map parameters = JavaInfoUtils.getParameters((JavaInfo)panel);
        JavaInfoUtilsTest.assertEquals(parameters.get("test.parameter.1"), (Object)"value_1");
        JavaInfoUtilsTest.assertEquals(parameters.get("test.parameter.2"), (Object)"1000");
        JavaInfoUtilsTest.assertNull(parameters.get("test.parameter.3"));
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)"test.parameter.3", (String)"true");
        parameters = JavaInfoUtils.getParameters((JavaInfo)panel);
        JavaInfoUtilsTest.assertEquals(parameters.get("test.parameter.1"), (Object)"value_1");
        JavaInfoUtilsTest.assertEquals(parameters.get("test.parameter.2"), (Object)"1000");
        JavaInfoUtilsTest.assertEquals(parameters.get("test.parameter.3"), (Object)"true");
    }

    @Test
    public void test_executeScriptParameter() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        JavaInfoUtilsTest.assertSame(null, (Object)JavaInfoUtils.executeScriptParameter((JavaInfo)panel, (String)"noSuchScript"));
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)"script", (String)"return model;");
        JavaInfoUtilsTest.assertSame((Object)panel, (Object)JavaInfoUtils.executeScriptParameter((JavaInfo)panel, (String)"script"));
        JavaInfoUtils.setParameter((JavaInfo)panel, (String)"script", (String)"return object;");
        JavaInfoUtilsTest.assertSame((Object)panel.getObject(), (Object)JavaInfoUtils.executeScriptParameter((JavaInfo)panel, (String)"script"));
    }

    @Test
    public void test_executeScript() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        JavaInfoUtilsTest.assertSame((Object)panel, (Object)JavaInfoUtils.executeScript((JavaInfo)panel, (String)"return model;"));
        JavaInfoUtilsTest.assertSame((Object)panel.getObject(), (Object)JavaInfoUtils.executeScript((JavaInfo)panel, (String)"return object;"));
    }

    @Test
    public void test_getTarget_before_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    {", "      JButton button = new JButton();", "      button.setText('ABC');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, (JavaInfo)button);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1), true);
    }

    @Test
    public void test_getTarget_before_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    JButton button = new JButton();", "    {", "      button.setText('ABC');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, (JavaInfo)button);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1), true);
    }

    @Test
    public void test_getTarget_before_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    {", "      JButton button = new JButton();", "      int a;", "      button.setText('ABC');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, (JavaInfo)button);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1, 2), true);
    }

    @Test
    public void test_getTarget_before_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setText('ABC');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, (JavaInfo)button);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), true);
    }

    @Test
    public void test_getTarget_last_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      button.setText('ABC');", "      add(button);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getTarget_last_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setText('ABC');", "    add(button);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2), false);
    }

    @Test
    public void test_getTarget_last_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getTarget_last_5() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getTarget_last_parentStatementInBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      setEnabled(true);", "      int foo;", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0, 0), false);
    }

    @Test
    public void test_getTarget_last_6_ignoreNonExecutable() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    this.updateUI();", "    removeNotify();", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getTarget_last_7() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, this.getMethod("<init>()").getBody(), null, true);
    }

    @Test
    public void test_getTarget_last_8() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private void configurePanel() {", "    setEnabled(true);", "  }", "  public Test() {", "    configurePanel();", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, "configurePanel()", 0);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_last_dontUseConfigure_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      button = new JButton();", "      add(button);", "    }", "    configure();", "  }", "  private void configure() {", "    button.setEnabled(true);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getTarget_last_dontUseConfigure_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      button = new JButton();", "      add(button);", "    }", "    configure();", "  }", "  private void configure() {", "    add(new JButton('new'));", "    button.setEnabled(true);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, "configure()", 1), false);
    }

    @Test
    public void test_getTarget_last_dontUseConfigure_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    configure();", "  }", "  private void configure() {", "    add(new JButton('new'));", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, "configure()", 0), false);
    }

    @Test
    public void test_getTarget_last_nonVisual() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  /**", "  * @wbp.nonvisual location=10,20", "  */", "  private JButton m_button = new JButton();", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {NonVisualBeans}", "    {new: javax.swing.JButton} {field-initializer: m_button} {/new JButton()/}");
        Object button = JavaInfoUtilsTest.getJavaInfoByName("m_button");
        StatementTarget target = JavaInfoUtils.getTarget(button, null);
        JavaInfoUtilsTest.assertTarget(target, JavaInfoUtilsTest.getBlock((JavaInfo)panel, new int[0]), null, true);
    }

    @Test
    public void test_getTarget_afterContainer_withChildren() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel2 = new JPanel();", "      add(panel2);", "      {", "        JButton button = new JButton();", "        button.setText('button');", "        panel2.add(button);", "      }", "      panel2.setEnabled(true);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getTarget_afterContainer_withImplicitChild() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      getContentPane().add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      getContentPane().add(button_2);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)frame, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)frame, 1), false);
    }

    @Test
    public void test_getTarget_10() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel2 = new JPanel();", "      add(panel2);", "      panel2.setEnabled(true);", "    }", "  }", "}");
        ComponentInfo panel2 = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel2, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0, 2), false);
    }

    @Test
    public void test_getTarget_11() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(getPanel2());", "  }", "  private JPanel panel2;", "  private JPanel getPanel2() {", "    if (panel2 == null) {", "      panel2 = new JPanel();", "      panel2.setEnabled(true);", "    }", "    return panel2;", "  }", "}");
        ComponentInfo panel2 = (ComponentInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel2, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, "getPanel2()", 0, 1);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_12() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  Test() {", "    add(createInnerPanel());", "  }", "  private JPanel createInnerPanel() {", "    JPanel innerPanel = new JPanel();", "    return innerPanel;", "  }", "}");
        JavaInfoUtilsTest.assertEquals((int)1, (int)panel.getChildrenComponents().size());
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)innerPanel, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, "createInnerPanel()", 0), false);
    }

    @Test
    public void test_getTarget_13() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  private static JPanel panel;", "  public static void main(String args[]) {", "    {", "      panel = new JPanel();", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, "main(java.lang.String[])", 0, 0);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_14() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  private static JPanel panel = new JPanel();", "  public static void main(String args[]) {", "    {", "      panel.setEnabled(true);", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, "main(java.lang.String[])", 0);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_15_broadcast() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JPanel panel2 = new JPanel();", "    add(panel2);", "    panel2.setEnabled(true);", "    {", "      JButton button = new JButton();", "      panel2.add(button);", "    }", "    panel2.setAutoscrolls(true);", "    panel2.setEnabled(false);", "  }", "}");
        final ComponentInfo panel2 = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.addBroadcastListener((Object)new JavaEventListener(){

            public void target_isTerminalStatement(JavaInfo parent, JavaInfo child, Statement statement, boolean[] terminal) {
                JavaInfoUtilsTest.assertSame((Object)panel2, (Object)parent);
                if (JavaInfoUtilsTest.this.m_lastEditor.getSource((ASTNode)statement).contains("setAutoscrolls")) {
                    terminal[0] = true;
                }
            }
        });
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel2, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 3), false);
    }

    @Test
    public void test_getTarget_16_exposed() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)frame, null);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)frame, 0), false);
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        StatementTarget target2 = JavaInfoUtils.getTarget((JavaInfo)contentPane, null);
        JavaInfoUtilsTest.assertTarget(target2, null, JavaInfoUtilsTest.getStatement((JavaInfo)frame, 0), false);
    }

    @Test
    public void test_getTarget_16_invisibleAssociation() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public abstract class MyPanel extends JPanel {", "  private JPanel container = new JPanel();", "  public MyPanel() {", "    add(container);", "    container.add(createClient());", "  }", "  public Container getContainer() {", "    return container;", "  }", "  protected abstract Component createClient();", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    int justSomeStatement;", "  }", "  protected Component createClient() {", "    JButton clientButton = new JButton();", "    return clientButton;", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public java.awt.Container test.MyPanel.getContainer()} {property} {}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: clientButton} {/new JButton()/ /clientButton/}");
        ContainerInfo container = (ContainerInfo)panel.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)container, null);
        Block expectedBlock = ((MethodDeclaration)panel.getCreationSupport().getNode()).getBody();
        JavaInfoUtilsTest.assertTarget(target, expectedBlock, null, true);
    }

    @Test
    public void test_getTarget_forcedMethod_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(PREFERENCES);
        try {
            preferencesRepairer.setValue("codeGeneration.forcedMethod", "init");
            StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
            this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    init();", "  }", "  private void init() {", "  }", "}");
            JavaInfoUtilsTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
        }
        finally {
            preferencesRepairer.restore();
        }
    }

    @Test
    public void test_getTarget_forcedMethod_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super();", "    setBackground(Color.ORANGE);", "  }", "}");
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(PREFERENCES);
        try {
            preferencesRepairer.setValue("codeGeneration.forcedMethod", "init");
            StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
            this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    super();", "    init();", "  }", "  private void init() {", "    setBackground(Color.ORANGE);", "  }", "}");
            JavaInfoUtilsTest.assertTarget(target, this.getMethod("init()").getBody(), null, false);
        }
        finally {
            preferencesRepairer.restore();
        }
    }

    private void prepare_getTarget_last() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled' order='last'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
    }

    @Test
    public void test_getTarget_order_last1() throws Exception {
        this.prepare_getTarget_last();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_order_last2() throws Exception {
        this.prepare_getTarget_last();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        JavaInfoUtilsTest.assertTarget(target, this.getMethod("<init>()").getBody(), null, true);
    }

    @Test
    public void test_getTarget_order_last3() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  // just some method that accepts children", "  public void processChildren(Component[] components) {", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='processChildren' order='last'>", "      <parameter type='java.awt.Component[]'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    processChildren(new Component[]{button});", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_order_last4() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public void setExpanded(boolean expanded) {", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setExpanded' order='last'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyPanel myPanel = new MyPanel();", "    add(myPanel);", "    myPanel.setExpanded(true);", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, null);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, false);
    }

    @Test
    public void test_getTarget_lazy_beforeImplicitFactory() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JButton addButton() {", "    JButton button = new JButton();", "    add(button);", "    return button;", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyBar.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private MyBar bar;", "  private JButton button;", "  Test() {", "    add(getBar());", "  }", "  private MyBar getBar() {", "    if (bar == null) {", "      bar = new MyBar();", "      getButton();", "    }", "    return bar;", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = getBar().addButton();", "    }", "    return button;", "  }", "}");
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo existingButton = (ComponentInfo)bar.getChildrenComponents().get(0);
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)panel, (JavaInfo)existingButton);
        Statement expectedStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, "getBar()", 0, 1);
        JavaInfoUtilsTest.assertTarget(target, null, expectedStatement, true);
    }

    @Test
    public void test_add_target_defaultAfterLastStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        ComponentInfo button = JavaInfoUtilsTest.createJButton();
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.add((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_add_target_afterExposedComponent() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/ComplexPanel.java", this.getTestSource("public class ComplexPanel extends JPanel {", "  private final JButton button = new JButton();", "  public ComplexPanel() {", "    add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      ComplexPanel complexPanel = new ComplexPanel();", "      add(complexPanel);", "      complexPanel.getButton().setText('text');", "    }", "  }", "}");
        ComponentInfo button = JavaInfoUtilsTest.createJButton();
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.add((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      ComplexPanel complexPanel = new ComplexPanel();", "      add(complexPanel);", "      complexPanel.getButton().setText('text');", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_add_target_explicitTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        Statement setFont_statement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        StatementTarget target = new StatementTarget(setFont_statement, false);
        ComponentInfo button = JavaInfoUtilsTest.createJButton();
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.addTarget((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, (StatementTarget)target);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    setEnabled(false);", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_addFirst_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        JavaInfoUtilsTest.assertTrue((boolean)panel.getChildrenComponents().isEmpty());
        ComponentInfo button = JavaInfoUtilsTest.createJButton();
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.addFirst((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        List components = panel.getChildrenComponents();
        JavaInfoUtilsTest.assertEquals((int)1, (int)components.size());
        JavaInfoUtilsTest.assertSame((Object)button, components.get(0));
    }

    @Test
    public void test_addFirst_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    add(new JLabel());", "  }", "}");
        List components = panel.getChildrenComponents();
        JavaInfoUtilsTest.assertEquals((int)1, (int)components.size());
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = JavaInfoUtilsTest.createJButton();
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.addFirst((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    add(new JLabel());", "  }", "}");
        List components2 = panel.getChildrenComponents();
        JavaInfoUtilsTest.assertEquals((int)2, (int)components2.size());
        JavaInfoUtilsTest.assertSame((Object)button, components2.get(0));
        JavaInfoUtilsTest.assertSame((Object)label, components2.get(1));
    }

    @Test
    public void test_create_withTypeParameters() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<T extends java.lang.Number> extends JButton {", "  public MyButton() {", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%T%>()]]></source>", "    <typeParameters>", "      <typeParameter name='T' type='java.lang.Number' title='Generic type &lt;T&gt;'/>", "    </typeParameters>", "  </creation>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertTrue((boolean)panel.getChildrenComponents().isEmpty());
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)JavaInfoUtilsTest.createJavaInfo("test.MyButton");
        layout.add(button, null);
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<Number> myButton = new MyButton<Number>();", "      add(myButton);", "    }", "  }", "}");
        button = (ComponentInfo)JavaInfoUtilsTest.createJavaInfo("test.MyButton");
        button.putTemplateArgument("T", "java.lang.Double");
        layout.add(button, null);
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<Number> myButton = new MyButton<Number>();", "      add(myButton);", "    }", "    {", "      MyButton<Double> myButton = new MyButton<Double>();", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_add_association_noContainerAssociation() throws Exception {
        this.prepareMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        ComponentInfo button = JavaInfoUtilsTest.createComponent("test.MyButton");
        JavaInfoUtils.add((JavaInfo)button, null, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    {", "      MyButton myButton = new MyButton(this);", "    }", "  }", "}");
        JavaInfoUtilsTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_add_association_notRequiredContainerAssociation() throws Exception {
        this.prepareMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        ComponentInfo button = JavaInfoUtilsTest.createComponent("test.MyButton");
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.add((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    {", "      MyButton myButton = new MyButton(this);", "    }", "  }", "}");
        JavaInfoUtilsTest.assertInstanceOf(ConstructorParentAssociation.class, (Object)button.getAssociation());
    }

    @Test
    public void test_add_association_requiredContainerAssociation() throws Exception {
        this.prepareMyButton();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "  }", "}");
        ComponentInfo button = JavaInfoUtilsTest.createComponent("test.MyButton");
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)true);
        JavaInfoUtils.add((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setFont(null);", "    setEnabled(false);", "    {", "      MyButton myButton = new MyButton(this);", "      add(myButton);", "    }", "  }", "}");
        CompoundAssociation compoundAssociation = (CompoundAssociation)button.getAssociation();
        List associations = compoundAssociation.getAssociations();
        Assertions.assertThat((List)associations).hasSize(2);
        JavaInfoUtilsTest.assertEquals((Object)"new MyButton(this)", (Object)((Association)associations.get(0)).getSource());
        JavaInfoUtilsTest.assertEquals((Object)"add(myButton)", (Object)((Association)associations.get(1)).getSource());
    }

    private void prepareMyButton() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CREATION -->", "  <creation>", "    <source><![CDATA[new test.MyButton(%parent%)]]></source>", "  </creation>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
    }

    @Test
    public void test_move_inSameParent_local() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        JavaInfoUtils.move((JavaInfo)button_2, null, (JavaInfo)panel, (JavaInfo)button_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
    }

    @Test
    public void test_move_inSameParent_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getButton_1());", "    add(getButton_2());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton();", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton();", "    }", "    return button_2;", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        JavaInfoUtils.move((JavaInfo)button_2, null, (JavaInfo)panel, (JavaInfo)button_1);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    add(getButton_2());", "    add(getButton_1());", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton();", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton();", "    }", "    return button_2;", "  }", "}");
    }

    @Test
    public void test_move_ignoreBecauseBeforeItself() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtils.move((JavaInfo)button, null, (JavaInfo)panel, (JavaInfo)button);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_move_IMoveTargetProvider() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        final ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        final ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        final StatementTarget target = new StatementTarget(JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), true);
        JavaInfoUtils.IMoveTargetProvider targetProvider = new JavaInfoUtils.IMoveTargetProvider(){

            public void add() throws Exception {
                panel.addChild((ObjectInfo)button_2, (ObjectInfo)button_1);
            }

            public void move() throws Exception {
                panel.moveChild((ObjectInfo)button_2, (ObjectInfo)button_1);
            }

            public StatementTarget getTarget() throws Exception {
                return target;
            }
        };
        JavaInfoUtils.moveProvider((JavaInfo)button_2, null, (JavaInfo)panel, (JavaInfoUtils.IMoveTargetProvider)targetProvider);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    setEnabled(false);", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
        List components = panel.getChildrenComponents();
        JavaInfoUtilsTest.assertSame((Object)button_2, components.get(0));
        JavaInfoUtilsTest.assertSame((Object)button_1, components.get(1));
    }

    @Test
    public void test_move_otherParent_beforeComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, (JavaInfo)innerPanel);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
    }

    @Test
    public void test_move_otherParent_asLast() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_move_otherParent_materialize() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JPanel inner = new JPanel();", "    add(inner);", "    inner.add(new JButton());", "  }", "}");
        ContainerInfo inner = (ContainerInfo)JavaInfoUtilsTest.getJavaInfoByName("inner");
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        flowLayout.move(button, null);
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JPanel inner = new JPanel();", "    add(inner);", "    JButton button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_move_sameParent_alternativeAssociation() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setHeader(Component component) {", "    add(component);", "  }", "  public void setClient(Component component) {", "    add(component);", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setHeader'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "    <method name='setClient'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      setHeader(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.setClient(%child%)", (boolean)true);
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      setClient(button);", "    }", "  }", "}");
    }

    @Test
    public void test_move_sameParent_alternativeAssociation_parentInConstructor() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setHeader(Component component) {", "    add(component);", "  }", "  public void setClient(Component component) {", "    add(component);", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setHeader'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "    <method name='setClient'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton(this);", "      setHeader(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.setClient(%child%)", (boolean)true);
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)panel, null);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton(this);", "      setClient(button);", "    }", "  }", "}");
    }

    @Test
    public void test_move_otherParent_parentInConstructor() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setHeader(Component component) {", "    add(component);", "  }", "  public void setClient(Component component) {", "    add(component);", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setHeader'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "    <method name='setClient'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton(Container container) {", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    {", "      MyButton button = new MyButton(this);", "      setHeader(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        AssociationObject associationObject = AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)false);
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)associationObject, (JavaInfo)innerPanel, null);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        MyButton button = new MyButton(innerPanel);", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_dontMoveStatementsInConfigure() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button_2 = new JButton();", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      button_2.setEnabled(false);", "      add(button_2);", "    }", "    configureButton_2();", "  }", "  public void configureButton_2() {", "    button_2.setText('text');", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)JavaInfoUtilsTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)JavaInfoUtilsTest.getJavaInfoByName("button_2");
        JavaInfoUtils.move((JavaInfo)button_2, null, (JavaInfo)panel, (JavaInfo)button_1);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button_2 = new JButton();", "  public Test() {", "    {", "      button_2.setEnabled(false);", "      add(button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    configureButton_2();", "  }", "  public void configureButton_2() {", "    button_2.setText('text');", "  }", "}");
    }

    @Test
    public void test_move_componentInSeparateMethod() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    createButton();", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "    }", "  }", "  private void createButton() {", "    {", "      JButton button = new JButton();", "      button.setEnabled(true);", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)JavaInfoUtilsTest.getJavaInfoByName("button");
        ContainerInfo inner = (ContainerInfo)JavaInfoUtilsTest.getJavaInfoByName("inner");
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)true), (JavaInfo)inner, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    createButton();", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      {", "        JButton button = new JButton();", "        inner.add(button);", "        button.setEnabled(true);", "      }", "    }", "  }", "  private void createButton() {", "  }", "}");
    }

    @Test
    public void test_move_removeInvocation_whichIsAfterAssociation() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyButton.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setEnabled' order='afterAssociation'>", "      <parameter type='boolean'/>", "    </method>", "  </methods>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  private final MyButton button = new MyButton();", "  public Test() {", "    JPanel panelA = new JPanel();", "    add(panelA);", "    ", "    JPanel panelB = new JPanel();", "    add(panelB);", "    ", "    panelA.add(button);", "    button.setEnabled(false);", "  }", "}");
        final ComponentInfo button = (ComponentInfo)JavaInfoUtilsTest.getJavaInfoByName("button");
        ContainerInfo panelB = (ContainerInfo)JavaInfoUtilsTest.getJavaInfoByName("panelB");
        button.addBroadcastListener((Object)new ObjectEventListener(){

            public void childRemoveBefore(ObjectInfo parent, ObjectInfo child) throws Exception {
                button.removeMethodInvocations("setEnabled(boolean)");
            }
        });
        JavaInfoUtils.move((JavaInfo)button, (AssociationObject)AssociationObjects.invocationChild((String)"%parent%.add(%child%)", (boolean)true), (JavaInfo)panelB, null);
        this.assertEditor("public class Test extends JPanel {", "  private final MyButton button = new MyButton();", "  public Test() {", "    JPanel panelA = new JPanel();", "    add(panelA);", "    ", "    JPanel panelB = new JPanel();", "    add(panelB);", "    panelB.add(button);", "  }", "}");
    }

    @Test
    public void test_sortComponentsByFlow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JLabel());", "    add(new JTextField());", "  }", "}");
        ComponentInfo component_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo component_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        ArrayList components = new ArrayList();
        JavaInfoUtils.sortComponentsByFlow(components);
        Assertions.assertThat(components).isEmpty();
        components = Lists.newArrayList((Object[])new JavaInfo[]{component_0, component_1});
        JavaInfoUtils.sortComponentsByFlow((List)components);
        Assertions.assertThat((List)components).hasSize(2);
        JavaInfoUtilsTest.assertSame((Object)component_0, components.get(0));
        JavaInfoUtilsTest.assertSame((Object)component_1, components.get(1));
        components = Lists.newArrayList((Object[])new JavaInfo[]{component_1, component_0});
        JavaInfoUtils.sortComponentsByFlow((List)components);
        Assertions.assertThat((List)components).hasSize(2);
        JavaInfoUtilsTest.assertSame((Object)component_0, components.get(0));
        JavaInfoUtilsTest.assertSame((Object)component_1, components.get(1));
    }

    @Test
    public void test_sortNodesByFlow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int a;", "    int b;", "  }", "}");
        Statement statementA = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        Statement statementB = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        this.check_sortNodesByFlow2((ASTNode)statementA, (ASTNode)statementB);
    }

    @Test
    public void test_sortNodesByFlow_withBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int a;", "    {", "      int b;", "    }", "  }", "}");
        Statement statementA = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        Statement statementBlock = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        this.check_sortNodesByFlow2((ASTNode)statementA, (ASTNode)statementBlock);
    }

    @Test
    public void test_sortNodesByFlow_nestedBlockStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      int a;", "    }", "  }", "}");
        Statement blockA = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        Statement statementA = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0, 0);
        this.check_sortNodesByFlow((ASTNode)blockA, (ASTNode)statementA, true);
        this.check_sortNodesByFlow((ASTNode)statementA, (ASTNode)blockA, false);
    }

    @Test
    public void test_sortNodesByFlow_nestedBodyDeclarationParts() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private int value;", "  public Test() {", "  }", "}");
        FieldDeclaration fieldDeclaration = (FieldDeclaration)JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 0);
        SimpleName valueName = ((VariableDeclarationFragment)DomGenerics.fragments((FieldDeclaration)fieldDeclaration).get(0)).getName();
        this.check_sortNodesByFlow((ASTNode)fieldDeclaration, (ASTNode)valueName, true);
        this.check_sortNodesByFlow((ASTNode)valueName, (ASTNode)fieldDeclaration, false);
    }

    @Test
    public void test_sortNodesByFlow_nestedStatementParts() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int value;", "  }", "}");
        VariableDeclarationStatement statement = (VariableDeclarationStatement)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        SimpleName valueName = ((VariableDeclarationFragment)DomGenerics.fragments((VariableDeclarationStatement)statement).get(0)).getName();
        this.check_sortNodesByFlow((ASTNode)statement, (ASTNode)valueName, true);
        this.check_sortNodesByFlow((ASTNode)valueName, (ASTNode)statement, false);
    }

    @Test
    public void test_sortNodesByFlow_nodeNotInExecutionFlow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int value;", "  }", "  public void foo() {", "  }", "}");
        Statement statement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        MethodDeclaration fooMethod = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel).getMethods()[1];
        ArrayList nodes = Lists.newArrayList((Object[])new ASTNode[]{statement, fooMethod});
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        JavaInfoUtils.sortNodesByFlow((ExecutionFlowDescription)flowDescription, (boolean)true, (List)nodes);
        ((ListAssert)Assertions.assertThat((List)nodes).hasSize(1)).containsOnly((Object[])new ASTNode[]{statement});
    }

    @Test
    public void test_sortNodesByFlow_withLocalMethodInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    foo();", "  }", "  public void foo() {", "    int a;", "  }", "}");
        Statement statementInv = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        Statement statementVar = JavaInfoUtilsTest.getStatement((JavaInfo)panel, "foo()", 0);
        this.check_sortNodesByFlow((ASTNode)statementInv, (ASTNode)statementVar, true);
        this.check_sortNodesByFlow((ASTNode)statementVar, (ASTNode)statementInv, false);
    }

    @Test
    public void test_sortNodesByFlow_Statement_itsNode() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "  }", "}");
        Statement statement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        ClassInstanceCreation creation = (ClassInstanceCreation)this.m_lastEditor.getEnclosingNode("new JButton");
        this.check_sortNodesByFlow((ASTNode)statement, (ASTNode)creation, true);
        this.check_sortNodesByFlow((ASTNode)creation, (ASTNode)statement, false);
    }

    private void check_sortNodesByFlow2(ASTNode node_1, ASTNode node_2) {
        this.check_sortNodesByFlow(node_1, node_2, true);
        this.check_sortNodesByFlow(node_1, node_2, false);
    }

    private void check_sortNodesByFlow(ASTNode node_1, ASTNode node_2, boolean onEnter) {
        ExecutionFlowDescription flowDescription = this.m_lastState.getFlowDescription();
        ArrayList nodes = Lists.newArrayList((Object[])new ASTNode[]{node_1, node_2});
        JavaInfoUtils.sortNodesByFlow((ExecutionFlowDescription)flowDescription, (boolean)onEnter, (List)nodes);
        JavaInfoUtilsTest.assertEquals((int)2, (int)nodes.size());
        JavaInfoUtilsTest.assertSame((Object)node_1, nodes.get(0));
        JavaInfoUtilsTest.assertSame((Object)node_2, nodes.get(1));
        nodes = Lists.newArrayList((Object[])new ASTNode[]{node_2, node_1});
        JavaInfoUtils.sortNodesByFlow((ExecutionFlowDescription)flowDescription, (boolean)onEnter, (List)nodes);
        JavaInfoUtilsTest.assertEquals((int)2, (int)nodes.size());
        JavaInfoUtilsTest.assertSame((Object)node_1, nodes.get(0));
        JavaInfoUtilsTest.assertSame((Object)node_2, nodes.get(1));
    }

    @Test
    public void test_isCreatedAtTarget_afterStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int foo;", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    int bar;", "    {", "      // empty block", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Statement targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        StatementTarget target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1, 0);
        target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2);
        target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 3);
        target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
    }

    @Test
    public void test_isCreatedAtTarget_afterStatement_blocks() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      {", "        JButton button = new JButton();", "        add(button);", "      }", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Statement targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0, 0);
        StatementTarget target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        target = new StatementTarget(targetStatement, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
    }

    @Test
    public void test_isCreatedAtTarget_beforeStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int foo;", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    int bar;", "    {", "      // empty block", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Statement targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        StatementTarget target = new StatementTarget(targetStatement, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2);
        target = new StatementTarget(targetStatement, true);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        target = new StatementTarget(targetStatement, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 3);
        target = new StatementTarget(targetStatement, true);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
    }

    @Test
    public void test_isCreatedAtTarget_beginOfBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      // before block", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      // after block", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Block targetBlock = (Block)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        StatementTarget target = new StatementTarget(targetBlock, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetBlock = (Block)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        target = new StatementTarget(targetBlock, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetBlock = (Block)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2);
        target = new StatementTarget(targetBlock, true);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
    }

    @Test
    public void test_isCreatedAtTarget_ifNodeIsConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        LayoutInfo implicitLayout = panel.getLayout();
        Block targetBlock = JavaInfoUtilsTest.getBlock((JavaInfo)panel, new int[0]);
        StatementTarget target = new StatementTarget(targetBlock, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)implicitLayout, target));
    }

    @Test
    public void test_isCreatedAtTarget_endOfBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      // before block", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      // after block", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Block targetBlock = (Block)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        StatementTarget target = new StatementTarget(targetBlock, false);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetBlock = (Block)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 1);
        target = new StatementTarget(targetBlock, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
        targetBlock = (Block)JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2);
        target = new StatementTarget(targetBlock, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button, target));
    }

    @Test
    public void test_isCreatedAtTarget_afterBodyDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_0 = new JButton();", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    add(button_0);", "    add(button_1);", "    add(button_2);", "  }", "}");
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        Statement targetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, new int[0]);
        StatementTarget target = new StatementTarget(targetStatement, true);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_0, target));
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        BodyDeclaration targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 0);
        target = new BodyDeclarationTarget(targetBodyDeclaration, false);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, (BodyDeclarationTarget)target));
        button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 2);
        target = new BodyDeclarationTarget(targetBodyDeclaration, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, (BodyDeclarationTarget)target));
        button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 1);
        target = new BodyDeclarationTarget(targetBodyDeclaration, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, (BodyDeclarationTarget)target));
        button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 3);
        target = new BodyDeclarationTarget(targetBodyDeclaration, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, (BodyDeclarationTarget)target));
    }

    @Test
    public void test_isCreatedAtTarget_beforeBodyDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_0 = new JButton();", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    add(button_0);", "    add(button_1);", "    add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        BodyDeclaration targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 0);
        BodyDeclarationTarget target = new BodyDeclarationTarget(targetBodyDeclaration, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, target));
        button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 1);
        target = new BodyDeclarationTarget(targetBodyDeclaration, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, target));
        button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 2);
        target = new BodyDeclarationTarget(targetBodyDeclaration, true);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, target));
        button_1 = (ComponentInfo)panel.getChildrenComponents().get(1);
        targetBodyDeclaration = JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 3);
        target = new BodyDeclarationTarget(targetBodyDeclaration, true);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_1, target));
    }

    @Test
    public void test_isCreatedAtTarget_beginOfTypeDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_0 = new JButton();", "  public Test() {", "    add(button_0);", "  }", "}");
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        TypeDeclaration targetTypeDeclaration = JavaInfoUtilsTest.getTypeDeclaration((JavaInfo)panel);
        BodyDeclarationTarget target = new BodyDeclarationTarget(targetTypeDeclaration, true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_0, target));
    }

    @Test
    public void test_isCreatedAtTarget_endOfTypeDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_0 = new JButton();", "  public Test() {", "    add(button_0);", "  }", "}");
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        TypeDeclaration targetTypeDeclaration = JavaInfoUtilsTest.getTypeDeclaration((JavaInfo)panel);
        BodyDeclarationTarget target = new BodyDeclarationTarget(targetTypeDeclaration, false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtilsTest.isCreatedAtTarget((JavaInfo)button_0, target));
    }

    private static boolean isCreatedAtTarget(JavaInfo javaInfo, StatementTarget statementTarget) {
        NodeTarget target = new NodeTarget(statementTarget);
        return JavaInfoUtils.isCreatedAtTarget((JavaInfo)javaInfo, (NodeTarget)target);
    }

    private static boolean isCreatedAtTarget(JavaInfo javaInfo, BodyDeclarationTarget bodyDeclarationTarget) {
        NodeTarget target = new NodeTarget(bodyDeclarationTarget);
        return JavaInfoUtils.isCreatedAtTarget((JavaInfo)javaInfo, (NodeTarget)target);
    }

    @Test
    public void test_getStatementTarget_whenAllCreated() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        try {
            JavaInfoUtils.getStatementTarget_whenAllCreated(Collections.emptyList());
            JavaInfoUtilsTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
        List<ComponentInfo> components = List.of(button_1, button_2);
        StatementTarget target = JavaInfoUtils.getStatementTarget_whenAllCreated(components);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 2), false);
    }

    @Test
    public void test_getStatementTarget_whenAllCreated_fieldInitializer_this() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  JButton button_1 = new JButton();", "  JButton button_2 = new JButton();", "  public Test() {", "    super();", "    add(button_1);", "    add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        List<ComponentInfo> components = List.of(button_1, button_2);
        StatementTarget target = JavaInfoUtils.getStatementTarget_whenAllCreated(components);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0), false);
    }

    @Test
    public void test_getStatementTarget_whenAllCreated_fieldInitializer_main() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  static JButton button_1 = new JButton();", "  static JButton button_2 = new JButton();", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "    panel.add(button_1);", "    panel.add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        List<ComponentInfo> components = List.of(button_1, button_2);
        StatementTarget target = JavaInfoUtils.getStatementTarget_whenAllCreated(components);
        JavaInfoUtilsTest.assertTarget(target, JavaInfoUtilsTest.getBlock((JavaInfo)panel, new int[0]), null, true);
    }

    @Test
    public void test_getStatementTarget_whenAllCreated_lazy() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton m_button_2;", "  public Test() {", "    JButton button_1 = new JButton();", "    add(button_1);", "    add(getButton_2());", "  }", "  private JButton getButton_2() {", "    if (m_button_2 == null) {", "      m_button_2 = new JButton();", "    }", "    return m_button_2;", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        List<ComponentInfo> components = List.of(button_1, button_2);
        StatementTarget target = JavaInfoUtils.getStatementTarget_whenAllCreated(components);
        JavaInfoUtilsTest.assertTarget(target, null, JavaInfoUtilsTest.getStatement((JavaInfo)button_2, 0), false);
    }

    @Test
    public void test_getNodeTarget_relativeCreation_relatedStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget nodeTarget = JavaInfoUtils.getNodeTarget_beforeCreation((JavaInfo)button);
        StatementTarget statementTarget = nodeTarget.getStatementTarget();
        JavaInfoUtilsTest.assertNotNull((Object)statementTarget);
        Statement expectedTargetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        JavaInfoUtilsTest.assertTarget(statementTarget, null, expectedTargetStatement, true);
        nodeTarget = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)button);
        statementTarget = nodeTarget.getStatementTarget();
        JavaInfoUtilsTest.assertNotNull((Object)statementTarget);
        expectedTargetStatement = JavaInfoUtilsTest.getStatement((JavaInfo)panel, 0);
        JavaInfoUtilsTest.assertTarget(statementTarget, null, expectedTargetStatement, false);
    }

    @Test
    public void test_getNodeTarget_relativeCreation_relativeFieldDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget nodeTarget = JavaInfoUtils.getNodeTarget_beforeCreation((JavaInfo)button);
        BodyDeclarationTarget bodyDeclarationTarget = nodeTarget.getBodyDeclarationTarget();
        JavaInfoUtilsTest.assertNotNull((Object)bodyDeclarationTarget);
        JavaInfoUtilsTest.assertSame((Object)JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 0), (Object)bodyDeclarationTarget.getDeclaration());
        JavaInfoUtilsTest.assertTrue((boolean)bodyDeclarationTarget.isBefore());
        nodeTarget = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)button);
        bodyDeclarationTarget = nodeTarget.getBodyDeclarationTarget();
        JavaInfoUtilsTest.assertNotNull((Object)bodyDeclarationTarget);
        JavaInfoUtilsTest.assertSame((Object)JavaInfoUtilsTest.getBodyDeclaration((JavaInfo)panel, 0), (Object)bodyDeclarationTarget.getDeclaration());
        JavaInfoUtilsTest.assertFalse((boolean)bodyDeclarationTarget.isBefore());
    }

    @Test
    public void test_getNodeTarget_relativeCreation_wrapperVariableExists() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "  }", "}");
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        NodeTarget nodeTarget = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)wrappedComponent);
        JavaInfoUtilsTest.assertEquals((Object)"after JButton button=wrapper.getControl();", (Object)nodeTarget.toString().trim());
    }

    @Test
    public void test_getNodeTarget_relativeCreation_wrapperVariableNoExists() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "  }", "}");
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        NodeTarget nodeTarget = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)wrappedComponent);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    TestWrapper wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "  }", "}");
        JavaInfoUtilsTest.assertEquals((Object)"after JButton button=wrapper.getControl();", (Object)nodeTarget.toString().trim());
    }

    @Test
    public void test_getNodeTarget_relativeCreation_wrapperVariableExistsAsField() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  private TestWrapper wrapper;", "  private JButton button;", "  public Test() {", "    wrapper = new TestWrapper(this);", "    button = wrapper.getControl();", "  }", "}");
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        NodeTarget nodeTarget = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)wrappedComponent);
        JavaInfoUtilsTest.assertEquals((Object)"after button=wrapper.getControl();", (Object)nodeTarget.toString().trim());
    }

    @Test
    public void test_getNodeTarget_relativeCreation_wrapperVariableNoExistsAsField() throws Exception {
        WrapperInfoTest.configureWrapperContents();
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  private TestWrapper wrapper;", "  public Test() {", "    wrapper = new TestWrapper(this);", "  }", "}");
        ContainerInfo wrappedComponent = (ContainerInfo)container.getChildren(ContainerInfo.class).get(0);
        NodeTarget nodeTarget = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)wrappedComponent);
        this.assertEditor("public class Test extends JPanel {", "  private TestWrapper wrapper;", "  public Test() {", "    wrapper = new TestWrapper(this);", "    JButton button = wrapper.getControl();", "  }", "}");
        JavaInfoUtilsTest.assertEquals((Object)"after JButton button=wrapper.getControl();", (Object)nodeTarget.toString().trim());
    }

    @Test
    public void test_addChildExposedByMethod_exposedInstanceFactory() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyFactory.java", this.getTestSource("public class MyFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  private MyFactory m_myFactory = new MyFactory();", "  public MyFactory getFactory() {", "    return m_myFactory;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyContainer());", "  }", "}");
        panel.refresh();
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyContainer())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyContainer} {empty} {/add(new MyContainer())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ContainerInfo myContainer = (ContainerInfo)panel.getChildrenComponents().get(0);
        InstanceFactoryInfo exposedFactory = (InstanceFactoryInfo)JavaInfoUtils.addChildExposedByMethod((JavaInfo)myContainer, (String)"getFactory");
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyContainer())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyContainer} {empty} {/add(new MyContainer())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {method: public test.MyFactory test.MyContainer.getFactory()} {property} {}");
        InstanceFactoryRootProcessor.INSTANCE.process((JavaInfo)panel, List.of(exposedFactory));
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyContainer())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyContainer} {empty} {/add(new MyContainer())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {method: public test.MyFactory test.MyContainer.getFactory()} {property} {}", "  {instance factory container}", "    {method: public test.MyFactory test.MyContainer.getFactory()} {property} {}");
        InstanceFactoryContainerInfo container = InstanceFactoryContainerInfo.get((JavaInfo)panel);
        List factories = container.getChildrenFactory();
        ((ListAssert)Assertions.assertThat((List)factories).hasSize(1)).contains((Object[])new InstanceFactoryInfo[]{exposedFactory});
    }

    @Test
    public void test_addChildredExposedByMethods_exception() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public JButton getFoo() {", "    throw new Error();", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_addChildredExposedByMethods_recursion() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel getFoo() {", "    return this;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_addChildredExposedByMethods_publicMethod_privateClass() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("class MyPanel extends JPanel {", "  private JButton button = new JButton();", "  public MyPanel() {", "    add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyPanel());", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyPanel())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {empty} {/add(new MyPanel())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        panel.refresh();
        JavaInfoUtilsTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_addChildredExposedByMethods_protectedMethod_visibleInSamePackage() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton button = new JButton();", "  public MyPanel() {", "    add(button);", "  }", "  protected JButton getButton() {", "    return button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyPanel());", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyPanel())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {empty} {/add(new MyPanel())/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {method: protected javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        panel.refresh();
        JavaInfoUtilsTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_isIndirectlyExposed_notExposed() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.isIndirectlyExposed((JavaInfo)button));
    }

    @Test
    public void test_isIndirectlyExposed_exposedDirectly() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private final JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.isIndirectlyExposed((JavaInfo)button));
    }

    @Test
    public void test_isIndirectlyExposed_exposedIndirectly() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private final JButton m_button = new JButton();", "  public MyPanel() {", "    JPanel inner = new JPanel();", "    add(inner);", "    inner.add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        JavaInfoUtilsTest.assertHierarchy("{this: test.MyPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.isIndirectlyExposed((JavaInfo)button));
    }

    @Test
    public void test_isIndirectlyExposed_exposedDirectly_Wrapper() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfo wrappedComponent = this.createWrappedComponentMock(true);
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.isIndirectlyExposed((JavaInfo)wrappedComponent));
    }

    @Test
    public void test_isIndirectlyExposed_exposedUndirectly_Wrapper() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        JavaInfo wrappedComponent = this.createWrappedComponentMock(false);
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.isIndirectlyExposed((JavaInfo)wrappedComponent));
    }

    private JavaInfo createWrappedComponentMock(boolean isDirect) throws Exception {
        CreationSupport exposedCreation = (CreationSupport)new ByteBuddy().subclass(CreationSupport.class).implement(new Type[]{IExposedCreationSupport.class}).method((ElementMatcher)ElementMatchers.named((String)"isDirect")).intercept((Implementation)FixedValue.reference((Object)isDirect)).make().load(((Object)((Object)this)).getClass().getClassLoader()).getLoaded().getConstructor(new Class[0]).newInstance(new Object[0]);
        JavaInfo exposedWrapper = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)exposedCreation);
        CreationSupport wrappedCreation = (CreationSupport)new ByteBuddy().subclass(CreationSupport.class).implement(new Type[]{IWrapperControlCreationSupport.class}).method((ElementMatcher)ElementMatchers.named((String)"getWrapperInfo")).intercept((Implementation)FixedValue.reference((Object)exposedWrapper)).make().load(((Object)((Object)this)).getClass().getClassLoader()).getLoaded().getConstructor(new Class[0]).newInstance(new Object[0]);
        return JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)wrappedCreation);
    }

    @Test
    public void test_canMove_FlowLayout() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertFalse((boolean)button.getCreationSupport().canReorder());
        JavaInfoUtilsTest.assertFalse((boolean)button.getCreationSupport().canReparent());
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }

    @Test
    public void test_canMove_forceMoveEnable() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.addBroadcastListener((Object)new JavaEventListener(){

            public void canMove(JavaInfo javaInfo, boolean[] forceMoveEnable, boolean[] forceMoveDisable) throws Exception {
                if (javaInfo == button) {
                    forceMoveEnable[0] = true;
                }
            }
        });
        JavaInfoUtilsTest.assertFalse((boolean)button.getCreationSupport().canReorder());
        JavaInfoUtilsTest.assertFalse((boolean)button.getCreationSupport().canReparent());
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }

    @Test
    public void test_canMove_forceMoveDisable() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertTrue((boolean)button.getCreationSupport().canReorder());
        JavaInfoUtilsTest.assertTrue((boolean)button.getCreationSupport().canReparent());
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
        button.addBroadcastListener((Object)new JavaEventListener(){

            public void canMove(JavaInfo javaInfo, boolean[] forceMoveEnable, boolean[] forceMoveDisable) throws Exception {
                if (javaInfo == button) {
                    forceMoveDisable[0] = true;
                }
            }
        });
        JavaInfoUtilsTest.assertTrue((boolean)button.getCreationSupport().canReorder());
        JavaInfoUtilsTest.assertTrue((boolean)button.getCreationSupport().canReparent());
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }

    @Test
    public void test_canReparent_disabledByAssociation() throws Exception {
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel(Component component, boolean value) {", "  }", "}"));
        JavaInfoUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", JavaInfoUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- CONSTRUCTORS -->", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Component' child='true'/>", "      <parameter type='boolean'/>", "    </constructor>", "  </constructors>", "</component>"));
        JavaInfoUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    MyPanel myPanel = new MyPanel(button, true);", "    add(myPanel);", "  }", "}");
        ContainerInfo myPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)myPanel.getChildrenComponents().get(0);
        JavaInfoUtilsTest.assertTrue((boolean)button.getCreationSupport().canReorder());
        JavaInfoUtilsTest.assertTrue((boolean)button.getCreationSupport().canReparent());
        JavaInfoUtilsTest.assertFalse((boolean)button.getAssociation().canDelete());
        JavaInfoUtilsTest.assertTrue((boolean)JavaInfoUtils.canMove((JavaInfo)button));
        JavaInfoUtilsTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)button));
    }
}

